<?xml version="1.0" encoding="UTF-8"?>
<SCL xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.iec.ch/61850/2003/SCL" xmlns:eComm="http://www.abb.com/61850/2015/SCL_ABBCommunication" xmlns:eIEC61850-6-100="http://www.iec.ch/61850/2019/SCL/6-100" xmlns:sxy="http://www.iec.ch/61850/2003/SCLcoordinates" revision="B" version="2007" release="4">
  <Header id="IEC61850WeekDemo" nameStructure="IEDName" revision="R006" toolID="Helinks STS 3.8.0.0" version="V1">
    <History>
      <Hitem revision="R001" version="V0" what="History file created" when="Fri Oct 14 18:36:53 CEST 2022" who="System" why="History reset"/>
      <Hitem revision="R002" version="V0" what="Line Bay Functions" when="Sun Oct 16 09:25:39 CEST 2022" who="JR" why="Cardiff Demo Lab"/>
      <Hitem revision="R003" version="V0" what="Monitoring added to Line Feeder" when="Sun Oct 16 09:53:48 CEST 2022" who="JR" why="Cardiff Demo"/>
      <Hitem revision="R004" version="V0" what="Sectionizer added" when="Sun Oct 16 22:39:03 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R005" version="V0" what="Transformer" when="Sun Oct 16 22:42:34 CEST 2022" who="JR" why="DEmo Cardiff"/>
      <Hitem revision="R006" version="V0" what="Library Project Created" when="Sun Oct 16 23:02:59 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R007" version="V0" what="SV Application" when="Mon Oct 17 00:00:16 CEST 2022" who="JR" why="Cardiff Demo"/>
      <Hitem revision="R008" version="V0" what="BF Function Added" when="Mon Oct 17 00:06:39 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R009" version="V0" what="Switch Control" when="Mon Oct 17 00:11:39 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R010" version="V0" what="BF Application and Trip added" when="Mon Oct 17 00:26:56 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R000" version="V1" what="IED crafted" when="Mon Oct 17 00:34:31 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R001" version="V1" what="Typical IEDs added" when="Mon Oct 17 02:52:10 CEST 2022" who="JR" why="Cardiff Demo"/>
      <Hitem revision="R002" version="V1" what="Mapping Done" when="Mon Oct 17 03:15:47 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R003" version="V1" what="SwitchControl and Breaker Control to Library" when="Mon Oct 17 03:36:08 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R004" version="V1" what="BreakerFailureLine to Library" when="Mon Oct 17 03:45:55 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R005" version="V1" what="Application Complete - Rules not activated" when="Mon Oct 17 03:52:32 CEST 2022" who="JR" why="Demo Cardiff"/>
      <Hitem revision="R006" version="V1" what="IEDS instantiated" when="Mon Oct 17 04:26:06 CEST 2022" who="JR" why="Demo Cardiff"/>
    </History>
  </Header>
  <Substation sxy:x="14" sxy:y="-5" desc="Library Project" name="Cardiff">
    <PowerTransformer sxy:x="13" name="T1" type="PTR">
      <TransformerWinding name="W1" type="PTW"/>
      <TransformerWinding name="W2" type="PTW">
        <Terminal bayName="Transformer" cNodeName="CN_5c6dcbe7-8fa1-46fd-8e3f-0c14c2893a4f" connectivityNode="Cardiff/E/Transformer/CN_5c6dcbe7-8fa1-46fd-8e3f-0c14c2893a4f" name="TW" substationName="Cardiff" voltageLevelName="E"/>
        <Terminal bayName="02" cNodeName="CN_79280cf8-d195-4c10-85f7-3d5da8b11f75" connectivityNode="Cardiff/E/02/CN_79280cf8-d195-4c10-85f7-3d5da8b11f75" name="TW" substationName="Cardiff" voltageLevelName="E"/>
      </TransformerWinding>
    </PowerTransformer>
    <PowerTransformer sxy:x="35" name="T2" type="PTR">
      <TransformerWinding name="W1" type="PTW"/>
      <TransformerWinding name="W2" type="PTW">
        <Terminal bayName="05" cNodeName="CN_59c39f48-d971-4de6-b1d2-682817f68d39" connectivityNode="Cardiff/E/05/CN_59c39f48-d971-4de6-b1d2-682817f68d39" name="TW" substationName="Cardiff" voltageLevelName="E"/>
      </TransformerWinding>
    </PowerTransformer>
    <VoltageLevel sxy:y="6" name="E">
      <Voltage multiplier="k" unit="V">110</Voltage>
      <Bay sxy:y="9" name="BB">
        <Private source="HELINKS LLC" type="IS_BUSBAR"/>
        <ConnectivityNode name="L1" pathName="Cardiff/E/BB/L1"/>
      </Bay>
      <Bay sxy:x="26" sxy:y="10" name="LineFeeder">
        <ConductingEquipment sxy:x="1" name="QB1" type="DIS">
          <Terminal bayName="01" cNodeName="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" connectivityNode="Cardiff/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" name="T2" substationName="Cardiff" voltageLevelName="E"/>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Cardiff/E/BB/L1" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="3" name="QA0" type="CBR">
          <Terminal bayName="01" cNodeName="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" connectivityNode="Cardiff/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <Terminal bayName="01" cNodeName="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" connectivityNode="Cardiff/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" name="T2" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="6" name="CT" type="CTR">
          <Terminal bayName="01" cNodeName="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" connectivityNode="Cardiff/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Cardiff/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T2" substationName="Cardiff" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A"/>
          <SubEquipment name="L2" phase="B"/>
          <SubEquipment name="L3" phase="C"/>
          <SubEquipment name="L4" phase="N"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:y="8" name="VT" type="VTR">
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Cardiff/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A"/>
          <SubEquipment name="L2" phase="B"/>
          <SubEquipment name="L3" phase="C"/>
          <SubEquipment name="L4" phase="N"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="10" name="Line" type="IFL">
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Cardiff/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T1" substationName="Cardiff" voltageLevelName="E"/>
        </ConductingEquipment>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/01/grounded"/>
        <ConnectivityNode name="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" pathName="Cardiff/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35"/>
        <ConnectivityNode name="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" pathName="Cardiff/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d"/>
        <ConnectivityNode name="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" pathName="Cardiff/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c"/>
        <Function name="Measurement"/>
        <Function name="Distance"/>
        <Function name="Overcurrent"/>
        <Function name="Trip"/>
        <Function name="BreakerFailure"/>
      </Bay>
      <Bay name="01">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E01PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateOpen" service="GOOSE" source="Cardiff/E/01/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateClose" service="GOOSE" source="Cardiff/E/01/QB1/Control/QB1CSWI1.OpCls.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01QB1Interface" sLnClass="XSWI" sLnInst="1" sPrefix="QB1"/>
            </Private>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Cardiff/E/BB/L1" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/01/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01QB1Control" sLnClass="CSWI" sLnInst="1" sPrefix="QB1"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E01PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Open" service="GOOSE" source="Cardiff/E/01/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Close" service="GOOSE" source="Cardiff/E/01/QB1/Control/QB1CSWI1.OpCls.general"/>
                <eIEC61850-6-100:SourceRef input="Operate Internal"/>
                <eIEC61850-6-100:SourceRef desc="" input="OpEx.general[ST]" service="GOOSE" source="Cardiff/E/02/BreakerFailure1/RBRF1.OpEx.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01QA0Interface" sLnClass="XCBR" sLnInst="1" sPrefix="QA0"/>
            </Private>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Position" service="GOOSE" source="Cardiff/E/01/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01QA0Control" sLnClass="CSWI" sLnInst="2" sPrefix="QA0"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01CTCTL1" sLnClass="TCTR" sLnInst="1" sPrefix="A"/>
                <eIEC61850-6-100:DOS name="SmpRte">
                  <eIEC61850-6-100:DAS name="setVal"/>
                </eIEC61850-6-100:DOS>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01CTCTL2" sLnClass="TCTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01CTCTL3" sLnClass="TCTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01CTCTL4" sLnClass="TCTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01VTVTL1" sLnClass="TVTR" sLnInst="1" sPrefix="A"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01VTVTL2" sLnClass="TVTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01VTVTL3" sLnClass="TVTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01VTVTL4" sLnClass="TVTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/01/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="MMXU" sLnInst="1" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="MMXU" sLnInst="2" sPrefix="V"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TVTR" sLnInst="2" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TVTR" sLnInst="12" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TVTR" sLnInst="14" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TVTR" sLnInst="3" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.f[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Measurement" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="PDIS" sLnInst="1" sPrefix="Z1"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="PDIS" sLnInst="2" sPrefix="Z2"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="PDIS" sLnInst="3" sPrefix="Z3"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="PTRC" sLnInst="1" sPrefix="DIS"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TCTR" sLnInst="2" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TCTR" sLnInst="3" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TCTR" sLnInst="7" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TCTR" sLnInst="8" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TVTR" sLnInst="7" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TVTR" sLnInst="8" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TVTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.UNeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Distance" sLnClass="TVTR" sLnInst="1" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Overcurrent" sLnClass="PTOC" sLnInst="1" sPrefix="PH"/>
            </Private>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="OC">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Overcurrent" sLnClass="PTRC" sLnInst="1" sPrefix="OC"/>
            </Private>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Overcurrent" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Overcurrent" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Overcurrent" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Overcurrent" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E01PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Distance Operate" service="GOOSE" source="Cardiff/E/01/Distance/DISPTRC1.Op.general"/>
                <eIEC61850-6-100:SourceRef input="Input for Trip.Operate" service="GOOSE" source="Cardiff/E/01/Overcurrent/OCPTRC1.Op.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01Trip" sLnClass="PTRC" sLnInst="1" sPrefix="Trip"/>
            </Private>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Trip"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE01BreakerFailure" sLnClass="RBRF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
        </Function>
      </Bay>
      <Bay sxy:x="9" sxy:y="1" name="02">
        <ConductingEquipment sxy:x="1" sxy:y="6" name="QB1" type="DIS">
          <LNode iedName="E02PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02QB1Interface" sLnClass="XSWI" sLnInst="1" sPrefix="QB1"/>
            </Private>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Cardiff/E/BB/L1" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef extRefAddr="E02PIUQA0Interface/QA0.XCBR.1.Pos.stVal" input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/02/QA0/QA0XCBR1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02QB1Control" sLnClass="CSWI" sLnInst="1" sPrefix="QB1"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="4" name="QA0" type="CBR">
          <LNode iedName="E02PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Operate External"/>
                <eIEC61850-6-100:SourceRef input="Operate Internal" service="GOOSE" source="Cardiff/E/02/BreakerFailure1/RBRF1.OpIn.general"/>
                <eIEC61850-6-100:SourceRef extRefAddr="E02BCUQB1Control/QB1.CSWI.1.OpOpn.general" input="Input for SwitchControl.OperateOpen" service="GOOSE" source="Cardiff/E/02/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef extRefAddr="E02BCUQB1Control/QB1.CSWI.1.OpCls.general" input="Input for SwitchControl.OperateClose" service="GOOSE" source="Cardiff/E/02/QB1/Control/QB1CSWI1.OpCls.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02QA0Interface" sLnClass="XCBR" sLnInst="1" sPrefix="QA0"/>
            </Private>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef extRefAddr="E02PIUQA0Interface/QA0.XCBR.1.Pos.stVal" input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/02/QA0/QA0XCBR1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02QA0Control" sLnClass="CSWI" sLnInst="2" sPrefix="QA0"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="1" name="CT" type="CTR">
          <Terminal bayName="02" cNodeName="CN_79280cf8-d195-4c10-85f7-3d5da8b11f75" connectivityNode="Cardiff/E/02/CN_79280cf8-d195-4c10-85f7-3d5da8b11f75" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02CTCTL1" sLnClass="TCTR" sLnInst="1" sPrefix="A"/>
                <eIEC61850-6-100:DOS name="SmpRte">
                  <eIEC61850-6-100:DAS name="setVal"/>
                </eIEC61850-6-100:DOS>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02CTCTL2" sLnClass="TCTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02CTCTL3" sLnClass="TCTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02CTCTL4" sLnClass="TCTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <Terminal bayName="02" cNodeName="CN_79280cf8-d195-4c10-85f7-3d5da8b11f75" connectivityNode="Cardiff/E/02/CN_79280cf8-d195-4c10-85f7-3d5da8b11f75" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02VTVTL1" sLnClass="TVTR" sLnInst="1" sPrefix="A"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02VTVTL2" sLnClass="TVTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02VTVTL3" sLnClass="TVTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02VTVTL4" sLnClass="TVTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/02/grounded"/>
        <ConnectivityNode name="CN_79280cf8-d195-4c10-85f7-3d5da8b11f75" pathName="Cardiff/E/02/CN_79280cf8-d195-4c10-85f7-3d5da8b11f75"/>
        <Function name="Measurement">
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="MMXU" sLnInst="1" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="MMXU" sLnInst="2" sPrefix="V"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E02PIUVTVT/A.TVTR.1.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TVTR" sLnInst="2" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E02PIUVTVT/B.TVTR.2.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TVTR" sLnInst="12" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E02PIUVTVT/C.TVTR.3.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TVTR" sLnInst="14" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E02PIUVTVT/N.TVTR.4.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TVTR" sLnInst="3" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/A.TCTR.1.AmpSv.instMag.i" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E02PIUCTCT/B.TCTR.2.AmpSv.instMag.f" input="AmpSv.instMag.f[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E02PIUCTCT/C.TCTR.3.AmpSv.instMag.i" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E02PIUCTCT/N.TCTR.4.AmpSv.instMag.i" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Measurement" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Differential">
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" lnType="pdif_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="PDIF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIFF">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="PTRC" sLnInst="1" sPrefix="DIFF"/>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/A.TCTR.1.AmpSv.instMag.i" input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="8" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/B.TCTR.2.AmpSv.instMag.f" input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="3" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/C.TCTR.3.AmpSv.instMag.i" input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="1" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/N.TCTR.4.AmpSv.instMag.i" input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="2" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="4" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="5" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="7" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Differential" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Overcurrent" sLnClass="PTOC" sLnInst="1" sPrefix="PH"/>
            </Private>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="OC">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Overcurrent" sLnClass="PTRC" sLnInst="1" sPrefix="OC"/>
            </Private>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/A.TCTR.1.AmpSv.instMag.i" input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Overcurrent" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/B.TCTR.2.AmpSv.instMag.f" input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Overcurrent" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/C.TCTR.3.AmpSv.instMag.i" input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Overcurrent" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02PIUCTCT/N.TCTR.4.AmpSv.instMag.i" input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Overcurrent" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E02PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/DIFF.PTRC.1.Op.general" input="Input for Trip.Operate" service="GOOSE" source="Cardiff/E/02/Differential/DIFFPTRC1.Op.general"/>
                <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/OC.PTRC.1.Op.general" input="Input for Trip.Operate_#0001" service="GOOSE" source="Cardiff/E/02/Overcurrent/OCPTRC1.Op.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02Trip" sLnClass="PTRC" sLnInst="1" sPrefix="Trip"/>
            </Private>
          </LNode>
        </Function>
        <Function name="BreakerFailure1">
          <LNode iedName="None" ldInst="CardiffE02BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Trip" service="GOOSE" source="Cardiff/E/02/Trip/TripPTRC1.Tr.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE02BreakerFailure1" sLnClass="RBRF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
        </Function>
      </Bay>
      <Bay name="03">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E03PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateOpen" service="GOOSE" source="Cardiff/E/03/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateClose" service="GOOSE" source="Cardiff/E/03/QB1/Control/QB1CSWI1.OpCls.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03QB1Interface" sLnClass="XSWI" sLnInst="1" sPrefix="QB1"/>
            </Private>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Cardiff/E/BB/L1" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/03/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03QB1Control" sLnClass="CSWI" sLnInst="1" sPrefix="QB1"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E03PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Open" service="GOOSE" source="Cardiff/E/03/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Close" service="GOOSE" source="Cardiff/E/03/QB1/Control/QB1CSWI1.OpCls.general"/>
                <eIEC61850-6-100:SourceRef input="Operate Internal"/>
                <eIEC61850-6-100:SourceRef input="OpEx.general[ST]" service="GOOSE" source="Cardiff/E/01/BreakerFailure/RBRF1.OpEx.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03QA0Interface" sLnClass="XCBR" sLnInst="1" sPrefix="QA0"/>
            </Private>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Position" service="GOOSE" source="Cardiff/E/03/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03QA0Control" sLnClass="CSWI" sLnInst="2" sPrefix="QA0"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03CTCTL1" sLnClass="TCTR" sLnInst="1" sPrefix="A"/>
                <eIEC61850-6-100:DOS name="SmpRte">
                  <eIEC61850-6-100:DAS name="setVal"/>
                </eIEC61850-6-100:DOS>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03CTCTL2" sLnClass="TCTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03CTCTL3" sLnClass="TCTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03CTCTL4" sLnClass="TCTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03VTVTL1" sLnClass="TVTR" sLnInst="1" sPrefix="A"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03VTVTL2" sLnClass="TVTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03VTVTL3" sLnClass="TVTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03VTVTL4" sLnClass="TVTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/03/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="MMXU" sLnInst="1" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="MMXU" sLnInst="2" sPrefix="V"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TVTR" sLnInst="2" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TVTR" sLnInst="12" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TVTR" sLnInst="14" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TVTR" sLnInst="3" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.f[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Measurement" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="PDIS" sLnInst="1" sPrefix="Z1"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="PDIS" sLnInst="2" sPrefix="Z2"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="PDIS" sLnInst="3" sPrefix="Z3"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="PTRC" sLnInst="1" sPrefix="DIS"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TCTR" sLnInst="2" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TCTR" sLnInst="3" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TCTR" sLnInst="7" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TCTR" sLnInst="8" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TVTR" sLnInst="7" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TVTR" sLnInst="8" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TVTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.UNeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Distance" sLnClass="TVTR" sLnInst="1" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Overcurrent" sLnClass="PTOC" sLnInst="1" sPrefix="PH"/>
            </Private>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="OC">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Overcurrent" sLnClass="PTRC" sLnInst="1" sPrefix="OC"/>
            </Private>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Overcurrent" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Overcurrent" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Overcurrent" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Overcurrent" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E03PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Distance Operate" service="GOOSE" source="Cardiff/E/03/Distance/DISPTRC1.Op.general"/>
                <eIEC61850-6-100:SourceRef input="Input for Trip.Operate" service="GOOSE" source="Cardiff/E/03/Overcurrent/OCPTRC1.Op.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03Trip" sLnClass="PTRC" sLnInst="1" sPrefix="Trip"/>
            </Private>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Trip"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE03BreakerFailure" sLnClass="RBRF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
        </Function>
      </Bay>
      <Bay name="04">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E04PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateOpen" service="GOOSE" source="Cardiff/E/04/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateClose" service="GOOSE" source="Cardiff/E/04/QB1/Control/QB1CSWI1.OpCls.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04QB1Interface" sLnClass="XSWI" sLnInst="1" sPrefix="QB1"/>
            </Private>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Cardiff/E/BB/L1" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/04/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04QB1Control" sLnClass="CSWI" sLnInst="1" sPrefix="QB1"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E04PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Open" service="GOOSE" source="Cardiff/E/04/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Close" service="GOOSE" source="Cardiff/E/04/QB1/Control/QB1CSWI1.OpCls.general"/>
                <eIEC61850-6-100:SourceRef input="Operate Internal"/>
                <eIEC61850-6-100:SourceRef input="OpEx.general[ST]" service="GOOSE" source="Cardiff/E/01/BreakerFailure/RBRF1.OpEx.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04QA0Interface" sLnClass="XCBR" sLnInst="1" sPrefix="QA0"/>
            </Private>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Position" service="GOOSE" source="Cardiff/E/04/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04QA0Control" sLnClass="CSWI" sLnInst="2" sPrefix="QA0"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04CTCTL1" sLnClass="TCTR" sLnInst="1" sPrefix="A"/>
                <eIEC61850-6-100:DOS name="SmpRte">
                  <eIEC61850-6-100:DAS name="setVal"/>
                </eIEC61850-6-100:DOS>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04CTCTL2" sLnClass="TCTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04CTCTL3" sLnClass="TCTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04CTCTL4" sLnClass="TCTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04VTVTL1" sLnClass="TVTR" sLnInst="1" sPrefix="A"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04VTVTL2" sLnClass="TVTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04VTVTL3" sLnClass="TVTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04VTVTL4" sLnClass="TVTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/04/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="MMXU" sLnInst="1" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="MMXU" sLnInst="2" sPrefix="V"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TVTR" sLnInst="2" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TVTR" sLnInst="12" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TVTR" sLnInst="14" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TVTR" sLnInst="3" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.f[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Measurement" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="PDIS" sLnInst="1" sPrefix="Z1"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="PDIS" sLnInst="2" sPrefix="Z2"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="PDIS" sLnInst="3" sPrefix="Z3"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="PTRC" sLnInst="1" sPrefix="DIS"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TCTR" sLnInst="2" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TCTR" sLnInst="3" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TCTR" sLnInst="7" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TCTR" sLnInst="8" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TVTR" sLnInst="7" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TVTR" sLnInst="8" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TVTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.UNeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Distance" sLnClass="TVTR" sLnInst="1" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Overcurrent" sLnClass="PTOC" sLnInst="1" sPrefix="PH"/>
            </Private>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="OC">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Overcurrent" sLnClass="PTRC" sLnInst="1" sPrefix="OC"/>
            </Private>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Overcurrent" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Overcurrent" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Overcurrent" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Overcurrent" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E04PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Distance Operate" service="GOOSE" source="Cardiff/E/04/Distance/DISPTRC1.Op.general"/>
                <eIEC61850-6-100:SourceRef input="Input for Trip.Operate" service="GOOSE" source="Cardiff/E/04/Overcurrent/OCPTRC1.Op.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04Trip" sLnClass="PTRC" sLnInst="1" sPrefix="Trip"/>
            </Private>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Trip"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE04BreakerFailure" sLnClass="RBRF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
        </Function>
      </Bay>
      <Bay sxy:x="32" sxy:y="1" name="05">
        <ConductingEquipment sxy:x="2" sxy:y="6" name="QB1" type="DIS">
          <LNode iedName="E05PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05QB1Interface" sLnClass="XSWI" sLnInst="1" sPrefix="QB1"/>
            </Private>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Cardiff/E/BB/L1" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef extRefAddr="E05PIUQA0Interface/QA0.XCBR.1.Pos.stVal" input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/05/QA0/QA0XCBR1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05QB1Control" sLnClass="CSWI" sLnInst="1" sPrefix="QB1"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="2" sxy:y="4" name="QA0" type="CBR">
          <LNode iedName="E05PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Operate External"/>
                <eIEC61850-6-100:SourceRef input="Operate Internal" service="GOOSE" source="Cardiff/E/05/BreakerFailure1/RBRF1.OpIn.general"/>
                <eIEC61850-6-100:SourceRef extRefAddr="E05BCUQB1Control/QB1.CSWI.1.OpOpn.general" input="Input for SwitchControl.OperateOpen" service="GOOSE" source="Cardiff/E/05/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef extRefAddr="E05BCUQB1Control/QB1.CSWI.1.OpCls.general" input="Input for SwitchControl.OperateClose" service="GOOSE" source="Cardiff/E/05/QB1/Control/QB1CSWI1.OpCls.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05QA0Interface" sLnClass="XCBR" sLnInst="1" sPrefix="QA0"/>
            </Private>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef extRefAddr="E05PIUQA0Interface/QA0.XCBR.1.Pos.stVal" input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/05/QA0/QA0XCBR1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05QA0Control" sLnClass="CSWI" sLnInst="2" sPrefix="QA0"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="2" sxy:y="1" name="CT" type="CTR">
          <Terminal bayName="05" cNodeName="CN_59c39f48-d971-4de6-b1d2-682817f68d39" connectivityNode="Cardiff/E/05/CN_59c39f48-d971-4de6-b1d2-682817f68d39" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05CTCTL1" sLnClass="TCTR" sLnInst="1" sPrefix="A"/>
                <eIEC61850-6-100:DOS name="SmpRte">
                  <eIEC61850-6-100:DAS name="setVal"/>
                </eIEC61850-6-100:DOS>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05CTCTL2" sLnClass="TCTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05CTCTL3" sLnClass="TCTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05CTCTL4" sLnClass="TCTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <Terminal bayName="05" cNodeName="CN_59c39f48-d971-4de6-b1d2-682817f68d39" connectivityNode="Cardiff/E/05/CN_59c39f48-d971-4de6-b1d2-682817f68d39" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05VTVTL1" sLnClass="TVTR" sLnInst="1" sPrefix="A"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05VTVTL2" sLnClass="TVTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05VTVTL3" sLnClass="TVTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05VTVTL4" sLnClass="TVTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/05/grounded"/>
        <ConnectivityNode name="CN_59c39f48-d971-4de6-b1d2-682817f68d39" pathName="Cardiff/E/05/CN_59c39f48-d971-4de6-b1d2-682817f68d39"/>
        <Function name="Measurement">
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="MMXU" sLnInst="1" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="MMXU" sLnInst="2" sPrefix="V"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E05PIUVTVT/A.TVTR.1.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TVTR" sLnInst="2" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E05PIUVTVT/B.TVTR.2.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TVTR" sLnInst="12" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E05PIUVTVT/C.TVTR.3.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TVTR" sLnInst="14" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E05PIUVTVT/N.TVTR.4.VolSv.instMag.i" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TVTR" sLnInst="3" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/A.TCTR.1.AmpSv.instMag.i" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E05PIUCTCT/B.TCTR.2.AmpSv.instMag.f" input="AmpSv.instMag.f[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E05PIUCTCT/C.TCTR.3.AmpSv.instMag.i" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" extRefAddr="E05PIUCTCT/N.TCTR.4.AmpSv.instMag.i" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Measurement" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Differential">
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" lnType="pdif_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="PDIF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIFF">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="PTRC" sLnInst="1" sPrefix="DIFF"/>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/A.TCTR.1.AmpSv.instMag.i" input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="8" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/B.TCTR.2.AmpSv.instMag.f" input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="3" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/C.TCTR.3.AmpSv.instMag.i" input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="1" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/N.TCTR.4.AmpSv.instMag.i" input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="2" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="4" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="5" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="7" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Differential" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Overcurrent" sLnClass="PTOC" sLnInst="1" sPrefix="PH"/>
            </Private>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="OC">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Overcurrent" sLnClass="PTRC" sLnInst="1" sPrefix="OC"/>
            </Private>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/A.TCTR.1.AmpSv.instMag.i" input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Overcurrent" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/B.TCTR.2.AmpSv.instMag.f" input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Overcurrent" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/C.TCTR.3.AmpSv.instMag.i" input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Overcurrent" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05PIUCTCT/N.TCTR.4.AmpSv.instMag.i" input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Overcurrent" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E05PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/DIFF.PTRC.1.Op.general" input="Input for Trip.Operate" service="GOOSE" source="Cardiff/E/05/Differential/DIFFPTRC1.Op.general"/>
                <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/OC.PTRC.1.Op.general" input="Input for Trip.Operate_#0001" service="GOOSE" source="Cardiff/E/05/Overcurrent/OCPTRC1.Op.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05Trip" sLnClass="PTRC" sLnInst="1" sPrefix="Trip"/>
            </Private>
          </LNode>
        </Function>
        <Function name="BreakerFailure1">
          <LNode iedName="None" ldInst="CardiffE05BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Trip" service="GOOSE" source="Cardiff/E/05/Trip/TripPTRC1.Tr.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE05BreakerFailure1" sLnClass="RBRF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
        </Function>
      </Bay>
      <Bay name="06">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E06PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateOpen" service="GOOSE" source="Cardiff/E/06/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Input for SwitchControl.OperateClose" service="GOOSE" source="Cardiff/E/06/QB1/Control/QB1CSWI1.OpCls.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06QB1Interface" sLnClass="XSWI" sLnInst="1" sPrefix="QB1"/>
            </Private>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Cardiff/E/BB/L1" name="T1" substationName="Cardiff" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Input for SwitchControl.Position" service="GOOSE" source="Cardiff/E/06/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06QB1Control" sLnClass="CSWI" sLnInst="1" sPrefix="QB1"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E06PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Open" service="GOOSE" source="Cardiff/E/06/QB1/Control/QB1CSWI1.OpOpn.general"/>
                <eIEC61850-6-100:SourceRef input="Close" service="GOOSE" source="Cardiff/E/06/QB1/Control/QB1CSWI1.OpCls.general"/>
                <eIEC61850-6-100:SourceRef input="Operate Internal"/>
                <eIEC61850-6-100:SourceRef input="OpEx.general[ST]" service="GOOSE" source="Cardiff/E/01/BreakerFailure/RBRF1.OpEx.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06QA0Interface" sLnClass="XCBR" sLnInst="1" sPrefix="QA0"/>
            </Private>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeInputs>
                  <eIEC61850-6-100:SourceRef input="Position" service="GOOSE" source="Cardiff/E/06/QB1/QB1XSWI1.Pos.stVal"/>
                </eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06QA0Control" sLnClass="CSWI" sLnInst="2" sPrefix="QA0"/>
              </Private>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06CTCTL1" sLnClass="TCTR" sLnInst="1" sPrefix="A"/>
                <eIEC61850-6-100:DOS name="SmpRte">
                  <eIEC61850-6-100:DAS name="setVal"/>
                </eIEC61850-6-100:DOS>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06CTCTL2" sLnClass="TCTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06CTCTL3" sLnClass="TCTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06CTCTL4" sLnClass="TCTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06VTVTL1" sLnClass="TVTR" sLnInst="1" sPrefix="A"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06VTVTL2" sLnClass="TVTR" sLnInst="2" sPrefix="B"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06VTVTL3" sLnClass="TVTR" sLnInst="3" sPrefix="C"/>
              </Private>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L4" phase="N">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100">
                <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06VTVTL4" sLnClass="TVTR" sLnInst="4" sPrefix="N"/>
              </Private>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/06/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="MMXU" sLnInst="1" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="MMXU" sLnInst="2" sPrefix="V"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TVTR" sLnInst="2" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TVTR" sLnInst="12" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TVTR" sLnInst="14" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="VolSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TVTR" sLnInst="3" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.f[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef desc="" input="AmpSv.instMag.i[MX]" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Measurement" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="PDIS" sLnInst="1" sPrefix="Z1"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="PDIS" sLnInst="2" sPrefix="Z2"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="PDIS" sLnInst="3" sPrefix="Z3"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="PTRC" sLnInst="1" sPrefix="DIS"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TCTR" sLnInst="2" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TCTR" sLnInst="3" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TCTR" sLnInst="7" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TCTR" sLnInst="8" sPrefix="N"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TVTR" sLnInst="7" sPrefix="A"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TVTR" sLnInst="8" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.U3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TVTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.UNeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Distance" sLnClass="TVTR" sLnInst="1" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Overcurrent" sLnClass="PTOC" sLnInst="1" sPrefix="PH"/>
            </Private>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="OC">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Overcurrent" sLnClass="PTRC" sLnInst="1" sPrefix="OC"/>
            </Private>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I1SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Overcurrent" sLnClass="TCTR" sLnInst="5" sPrefix="A"/>
              <eIEC61850-6-100:DOS name="SmpRte">
                <eIEC61850-6-100:DAS name="setVal"/>
              </eIEC61850-6-100:DOS>
            </Private>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I2SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Overcurrent" sLnClass="TCTR" sLnInst="1" sPrefix="B"/>
            </Private>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.I3SV" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Overcurrent" sLnClass="TCTR" sLnInst="4" sPrefix="C"/>
            </Private>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Input for SampledMeasurments.INeut" service="SMV"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Overcurrent" sLnClass="TCTR" sLnInst="6" sPrefix="N"/>
            </Private>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E06PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Distance Operate" service="GOOSE" source="Cardiff/E/06/Distance/DISPTRC1.Op.general"/>
                <eIEC61850-6-100:SourceRef input="Input for Trip.Operate" service="GOOSE" source="Cardiff/E/06/Overcurrent/OCPTRC1.Op.general"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06Trip" sLnClass="PTRC" sLnInst="1" sPrefix="Trip"/>
            </Private>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100">
              <eIEC61850-6-100:LNodeInputs>
                <eIEC61850-6-100:SourceRef input="Trip"/>
              </eIEC61850-6-100:LNodeInputs>
              <eIEC61850-6-100:LNodeSpecNaming sIedName="None" sLdInst="CardiffE06BreakerFailure" sLnClass="RBRF" sLnInst="1" sPrefix=""/>
            </Private>
          </LNode>
        </Function>
      </Bay>
    </VoltageLevel>
    <Function name="HMI">
      <LNode iedName="Zenon" ldInst="HMI" lnClass="ITCI" lnInst="1" lnType="ITCI_ZENON" prefix="">
        <Private type="eIEC61850-6-100"><eIEC61850-6-100:LNodeInputs>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0063" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0064" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0065" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0066" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0067" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0068" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0069" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0070" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0071" service="Report" source="Cardiff/E/01/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0072" service="Report" source="Cardiff/E/01/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0073" service="Report" source="Cardiff/E/01/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0074" service="Report" source="Cardiff/E/01/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0075" service="Report" source="Cardiff/E/01/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0076" service="Report" source="Cardiff/E/01/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0077" service="Report" source="Cardiff/E/01/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0078" service="Report" source="Cardiff/E/01/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0079" service="Report" source="Cardiff/E/01/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0080" service="Report" source="Cardiff/E/01/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0081" service="Report" source="Cardiff/E/01/Trip/TripPTRC1.Tr.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0082" service="Report" source="Cardiff/E/01/QB1/Control/QB1CSWI1.OpOpn.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0083" service="Report" source="Cardiff/E/01/QB1/Control/QB1CSWI1.OpCls.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0084" service="Report" source="Cardiff/E/01/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0085" service="Report" source="Cardiff/E/01/QA0/Control/QA0CSWI2.OpOpn.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0086" service="Report" source="Cardiff/E/01/QA0/Control/QA0CSWI2.OpCls.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0087" service="Report" source="Cardiff/E/01/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0088" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0089" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0090" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0091" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0092" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0093" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0094" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0095" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0096" service="Report" source="Cardiff/E/01/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0097" service="Report" source="Cardiff/E/01/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0098" service="Report" source="Cardiff/E/01/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0099" service="Report" source="Cardiff/E/01/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0100" service="Report" source="Cardiff/E/01/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0101" service="Report" source="Cardiff/E/01/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0102" service="Report" source="Cardiff/E/01/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0103" service="Report" source="Cardiff/E/01/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0104" service="Report" source="Cardiff/E/01/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0105" service="Report" source="Cardiff/E/01/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0106" service="Report" source="Cardiff/E/01/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0107" service="Report" source="Cardiff/E/01/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0108" service="Report" source="Cardiff/E/01/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0109" service="Report" source="Cardiff/E/01/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0110" service="Report" source="Cardiff/E/01/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0111" service="Report" source="Cardiff/E/01/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0112" service="Report" source="Cardiff/E/01/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0113" service="Report" source="Cardiff/E/01/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0114" service="Report" source="Cardiff/E/01/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/A.TVTR.7.VolSv.instMag.i" input="Unnamed_#0115" service="Report" source="Cardiff/E/01/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/B.TVTR.8.VolSv.instMag.i" input="Unnamed_#0116" service="Report" source="Cardiff/E/01/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/C.TVTR.4.VolSv.instMag.i" input="Unnamed_#0117" service="Report" source="Cardiff/E/01/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/N.TVTR.1.VolSv.instMag.i" input="Unnamed_#0118" service="Report" source="Cardiff/E/01/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0119" service="Report" source="Cardiff/E/01/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0120" service="Report" source="Cardiff/E/01/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0121" service="Report" source="Cardiff/E/01/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0122" service="Report" source="Cardiff/E/01/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0123" service="Report" source="Cardiff/E/01/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0124" service="Report" source="Cardiff/E/01/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0125" service="Report" source="Cardiff/E/01/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0126" service="Report" source="Cardiff/E/01/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0127" service="Report" source="Cardiff/E/01/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0128" service="Report" source="Cardiff/E/01/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0129" service="Report" source="Cardiff/E/01/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0130" service="Report" source="Cardiff/E/01/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0131" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0132" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0133" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0134" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0135" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0136" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0137" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0138" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0139" service="Report" source="Cardiff/E/02/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0140" service="Report" source="Cardiff/E/02/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0141" service="Report" source="Cardiff/E/02/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0142" service="Report" source="Cardiff/E/02/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0143" service="Report" source="Cardiff/E/02/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0144" service="Report" source="Cardiff/E/02/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0145" service="Report" source="Cardiff/E/02/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0146" service="Report" source="Cardiff/E/02/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/PDIF.1.Op.general" input="Unnamed_#0147" service="Report" source="Cardiff/E/02/Differential/PDIF1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/DIFF.PTRC.1.Op.general" input="Unnamed_#0148" service="Report" source="Cardiff/E/02/Differential/DIFFPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0149" service="Report" source="Cardiff/E/02/Differential/ATCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0150" service="Report" source="Cardiff/E/02/Differential/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/C.TCTR.1.AmpSv.instMag.i" input="Unnamed_#0151" service="Report" source="Cardiff/E/02/Differential/CTCTR1.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/N.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0152" service="Report" source="Cardiff/E/02/Differential/NTCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0153" service="Report" source="Cardiff/E/02/Differential/ATCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/B.TCTR.6.AmpSv.instMag.f" input="Unnamed_#0154" service="Report" source="Cardiff/E/02/Differential/BTCTR5.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0155" service="Report" source="Cardiff/E/02/Differential/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0156" service="Report" source="Cardiff/E/02/Differential/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0157" service="Report" source="Cardiff/E/02/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0158" service="Report" source="Cardiff/E/02/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0159" service="Report" source="Cardiff/E/02/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0160" service="Report" source="Cardiff/E/02/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0161" service="Report" source="Cardiff/E/02/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0162" service="Report" source="Cardiff/E/02/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0163" service="Report" source="Cardiff/E/02/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0164" service="Report" source="Cardiff/E/02/BreakerFailure1/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0165" service="Report" source="Cardiff/E/02/BreakerFailure1/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0166" service="Report" source="Cardiff/E/02/BreakerFailure1/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0167" service="Report" source="Cardiff/E/02/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0168" service="Report" source="Cardiff/E/02/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0169" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0170" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0171" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0172" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0173" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0174" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0175" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0176" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0177" service="Report" source="Cardiff/E/03/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0178" service="Report" source="Cardiff/E/03/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0179" service="Report" source="Cardiff/E/03/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0180" service="Report" source="Cardiff/E/03/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0181" service="Report" source="Cardiff/E/03/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0182" service="Report" source="Cardiff/E/03/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0183" service="Report" source="Cardiff/E/03/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0184" service="Report" source="Cardiff/E/03/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0185" service="Report" source="Cardiff/E/03/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0186" service="Report" source="Cardiff/E/03/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0187" service="Report" source="Cardiff/E/03/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0188" service="Report" source="Cardiff/E/03/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0189" service="Report" source="Cardiff/E/03/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0190" service="Report" source="Cardiff/E/03/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0191" service="Report" source="Cardiff/E/03/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0192" service="Report" source="Cardiff/E/03/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0193" service="Report" source="Cardiff/E/03/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0194" service="Report" source="Cardiff/E/03/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0195" service="Report" source="Cardiff/E/03/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/A.TVTR.7.VolSv.instMag.i" input="Unnamed_#0196" service="Report" source="Cardiff/E/03/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/B.TVTR.8.VolSv.instMag.i" input="Unnamed_#0197" service="Report" source="Cardiff/E/03/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/C.TVTR.4.VolSv.instMag.i" input="Unnamed_#0198" service="Report" source="Cardiff/E/03/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/N.TVTR.1.VolSv.instMag.i" input="Unnamed_#0199" service="Report" source="Cardiff/E/03/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0200" service="Report" source="Cardiff/E/03/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0201" service="Report" source="Cardiff/E/03/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0202" service="Report" source="Cardiff/E/03/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0203" service="Report" source="Cardiff/E/03/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0204" service="Report" source="Cardiff/E/03/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0205" service="Report" source="Cardiff/E/03/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0206" service="Report" source="Cardiff/E/03/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0207" service="Report" source="Cardiff/E/03/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0208" service="Report" source="Cardiff/E/03/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0209" service="Report" source="Cardiff/E/03/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0210" service="Report" source="Cardiff/E/03/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0211" service="Report" source="Cardiff/E/03/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0212" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0213" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0214" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0215" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0216" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0217" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0218" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0219" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0220" service="Report" source="Cardiff/E/04/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0221" service="Report" source="Cardiff/E/04/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0222" service="Report" source="Cardiff/E/04/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0223" service="Report" source="Cardiff/E/04/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0224" service="Report" source="Cardiff/E/04/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0225" service="Report" source="Cardiff/E/04/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0226" service="Report" source="Cardiff/E/04/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0227" service="Report" source="Cardiff/E/04/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0228" service="Report" source="Cardiff/E/04/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0229" service="Report" source="Cardiff/E/04/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0230" service="Report" source="Cardiff/E/04/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0231" service="Report" source="Cardiff/E/04/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0232" service="Report" source="Cardiff/E/04/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0233" service="Report" source="Cardiff/E/04/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0234" service="Report" source="Cardiff/E/04/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0235" service="Report" source="Cardiff/E/04/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0236" service="Report" source="Cardiff/E/04/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0237" service="Report" source="Cardiff/E/04/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0238" service="Report" source="Cardiff/E/04/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/A.TVTR.7.VolSv.instMag.i" input="Unnamed_#0239" service="Report" source="Cardiff/E/04/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/B.TVTR.8.VolSv.instMag.i" input="Unnamed_#0240" service="Report" source="Cardiff/E/04/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/C.TVTR.4.VolSv.instMag.i" input="Unnamed_#0241" service="Report" source="Cardiff/E/04/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/N.TVTR.1.VolSv.instMag.i" input="Unnamed_#0242" service="Report" source="Cardiff/E/04/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0243" service="Report" source="Cardiff/E/04/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0244" service="Report" source="Cardiff/E/04/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0245" service="Report" source="Cardiff/E/04/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0246" service="Report" source="Cardiff/E/04/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0247" service="Report" source="Cardiff/E/04/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0248" service="Report" source="Cardiff/E/04/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0249" service="Report" source="Cardiff/E/04/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0250" service="Report" source="Cardiff/E/04/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0251" service="Report" source="Cardiff/E/04/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0252" service="Report" source="Cardiff/E/04/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0253" service="Report" source="Cardiff/E/04/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0254" service="Report" source="Cardiff/E/04/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0255" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0256" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0257" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0258" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0259" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0260" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0261" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0262" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0263" service="Report" source="Cardiff/E/05/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0264" service="Report" source="Cardiff/E/05/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0265" service="Report" source="Cardiff/E/05/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0266" service="Report" source="Cardiff/E/05/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0267" service="Report" source="Cardiff/E/05/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0268" service="Report" source="Cardiff/E/05/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0269" service="Report" source="Cardiff/E/05/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0270" service="Report" source="Cardiff/E/05/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/PDIF.1.Op.general" input="Unnamed_#0271" service="Report" source="Cardiff/E/05/Differential/PDIF1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/DIFF.PTRC.1.Op.general" input="Unnamed_#0272" service="Report" source="Cardiff/E/05/Differential/DIFFPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0273" service="Report" source="Cardiff/E/05/Differential/ATCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0274" service="Report" source="Cardiff/E/05/Differential/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/C.TCTR.1.AmpSv.instMag.i" input="Unnamed_#0275" service="Report" source="Cardiff/E/05/Differential/CTCTR1.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/N.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0276" service="Report" source="Cardiff/E/05/Differential/NTCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0277" service="Report" source="Cardiff/E/05/Differential/ATCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/B.TCTR.6.AmpSv.instMag.f" input="Unnamed_#0278" service="Report" source="Cardiff/E/05/Differential/BTCTR5.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0279" service="Report" source="Cardiff/E/05/Differential/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0280" service="Report" source="Cardiff/E/05/Differential/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0281" service="Report" source="Cardiff/E/05/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0282" service="Report" source="Cardiff/E/05/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0283" service="Report" source="Cardiff/E/05/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0284" service="Report" source="Cardiff/E/05/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0285" service="Report" source="Cardiff/E/05/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0286" service="Report" source="Cardiff/E/05/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0287" service="Report" source="Cardiff/E/05/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0288" service="Report" source="Cardiff/E/05/BreakerFailure1/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0289" service="Report" source="Cardiff/E/05/BreakerFailure1/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0290" service="Report" source="Cardiff/E/05/BreakerFailure1/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0291" service="Report" source="Cardiff/E/05/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0292" service="Report" source="Cardiff/E/05/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0293" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0294" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0295" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0296" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0297" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0298" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0299" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0300" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0301" service="Report" source="Cardiff/E/06/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0302" service="Report" source="Cardiff/E/06/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0303" service="Report" source="Cardiff/E/06/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0304" service="Report" source="Cardiff/E/06/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0305" service="Report" source="Cardiff/E/06/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0306" service="Report" source="Cardiff/E/06/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0307" service="Report" source="Cardiff/E/06/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0308" service="Report" source="Cardiff/E/06/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0309" service="Report" source="Cardiff/E/06/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0310" service="Report" source="Cardiff/E/06/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0311" service="Report" source="Cardiff/E/06/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0312" service="Report" source="Cardiff/E/06/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0313" service="Report" source="Cardiff/E/06/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0314" service="Report" source="Cardiff/E/06/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0315" service="Report" source="Cardiff/E/06/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0316" service="Report" source="Cardiff/E/06/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0317" service="Report" source="Cardiff/E/06/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0318" service="Report" source="Cardiff/E/06/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0319" service="Report" source="Cardiff/E/06/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/A.TVTR.7.VolSv.instMag.i" input="Unnamed_#0320" service="Report" source="Cardiff/E/06/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/B.TVTR.8.VolSv.instMag.i" input="Unnamed_#0321" service="Report" source="Cardiff/E/06/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/C.TVTR.4.VolSv.instMag.i" input="Unnamed_#0322" service="Report" source="Cardiff/E/06/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/N.TVTR.1.VolSv.instMag.i" input="Unnamed_#0323" service="Report" source="Cardiff/E/06/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0324" service="Report" source="Cardiff/E/06/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0325" service="Report" source="Cardiff/E/06/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0326" service="Report" source="Cardiff/E/06/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0327" service="Report" source="Cardiff/E/06/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0328" service="Report" source="Cardiff/E/06/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0329" service="Report" source="Cardiff/E/06/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0330" service="Report" source="Cardiff/E/06/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0331" service="Report" source="Cardiff/E/06/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0332" service="Report" source="Cardiff/E/06/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0333" service="Report" source="Cardiff/E/06/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0334" service="Report" source="Cardiff/E/06/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0335" service="Report" source="Cardiff/E/06/QA0/Control/QA0CSWI2.Pos.stVal"/>
          </eIEC61850-6-100:LNodeInputs></Private>
      </LNode>
    </Function>
    <Function name="NCC">
      <LNode iedName="XPG" ldInst="LD0" lnClass="ITCI" lnInst="1" lnType="itci_7_4_B2007" prefix="">
        <Private type="eIEC61850-6-100"><eIEC61850-6-100:LNodeInputs>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0042" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0043" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0044" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0045" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0046" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0047" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0048" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0049" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0050" service="Report" source="Cardiff/E/01/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0051" service="Report" source="Cardiff/E/01/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0052" service="Report" source="Cardiff/E/01/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0053" service="Report" source="Cardiff/E/01/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0054" service="Report" source="Cardiff/E/01/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0055" service="Report" source="Cardiff/E/01/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0056" service="Report" source="Cardiff/E/01/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0057" service="Report" source="Cardiff/E/01/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0058" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0059" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0060" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0061" service="Report" source="Cardiff/E/01/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0062" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0063" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0064" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0065" service="Report" source="Cardiff/E/01/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0066" service="Report" source="Cardiff/E/01/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0067" service="Report" source="Cardiff/E/01/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0068" service="Report" source="Cardiff/E/01/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0069" service="Report" source="Cardiff/E/01/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0070" service="Report" source="Cardiff/E/01/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0071" service="Report" source="Cardiff/E/01/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0072" service="Report" source="Cardiff/E/01/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0073" service="Report" source="Cardiff/E/01/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0074" service="Report" source="Cardiff/E/01/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0075" service="Report" source="Cardiff/E/01/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0076" service="Report" source="Cardiff/E/01/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0077" service="Report" source="Cardiff/E/01/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0078" service="Report" source="Cardiff/E/01/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0079" service="Report" source="Cardiff/E/01/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0080" service="Report" source="Cardiff/E/01/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0081" service="Report" source="Cardiff/E/01/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0082" service="Report" source="Cardiff/E/01/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0083" service="Report" source="Cardiff/E/01/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0084" service="Report" source="Cardiff/E/01/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/A.TVTR.7.VolSv.instMag.i" input="Unnamed_#0085" service="Report" source="Cardiff/E/01/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/B.TVTR.8.VolSv.instMag.i" input="Unnamed_#0086" service="Report" source="Cardiff/E/01/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/C.TVTR.4.VolSv.instMag.i" input="Unnamed_#0087" service="Report" source="Cardiff/E/01/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BPULD0/N.TVTR.1.VolSv.instMag.i" input="Unnamed_#0088" service="Report" source="Cardiff/E/01/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0089" service="Report" source="Cardiff/E/01/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0090" service="Report" source="Cardiff/E/01/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0091" service="Report" source="Cardiff/E/01/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0092" service="Report" source="Cardiff/E/01/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0093" service="Report" source="Cardiff/E/01/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0094" service="Report" source="Cardiff/E/01/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0095" service="Report" source="Cardiff/E/01/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0096" service="Report" source="Cardiff/E/01/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0097" service="Report" source="Cardiff/E/01/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0098" service="Report" source="Cardiff/E/01/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0099" service="Report" source="Cardiff/E/01/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E01BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0100" service="Report" source="Cardiff/E/01/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0101" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0102" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0103" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0104" service="Report" source="Cardiff/E/02/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0105" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0106" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0107" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0108" service="Report" source="Cardiff/E/02/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0109" service="Report" source="Cardiff/E/02/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0110" service="Report" source="Cardiff/E/02/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0111" service="Report" source="Cardiff/E/02/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0112" service="Report" source="Cardiff/E/02/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0113" service="Report" source="Cardiff/E/02/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0114" service="Report" source="Cardiff/E/02/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0115" service="Report" source="Cardiff/E/02/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0116" service="Report" source="Cardiff/E/02/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/PDIF.1.Op.general" input="Unnamed_#0117" service="Report" source="Cardiff/E/02/Differential/PDIF1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/DIFF.PTRC.1.Op.general" input="Unnamed_#0118" service="Report" source="Cardiff/E/02/Differential/DIFFPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0119" service="Report" source="Cardiff/E/02/Differential/ATCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0120" service="Report" source="Cardiff/E/02/Differential/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/C.TCTR.1.AmpSv.instMag.i" input="Unnamed_#0121" service="Report" source="Cardiff/E/02/Differential/CTCTR1.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/N.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0122" service="Report" source="Cardiff/E/02/Differential/NTCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0123" service="Report" source="Cardiff/E/02/Differential/ATCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/B.TCTR.6.AmpSv.instMag.f" input="Unnamed_#0124" service="Report" source="Cardiff/E/02/Differential/BTCTR5.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0125" service="Report" source="Cardiff/E/02/Differential/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BPUDifferential/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0126" service="Report" source="Cardiff/E/02/Differential/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0127" service="Report" source="Cardiff/E/02/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0128" service="Report" source="Cardiff/E/02/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0129" service="Report" source="Cardiff/E/02/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0130" service="Report" source="Cardiff/E/02/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0131" service="Report" source="Cardiff/E/02/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0132" service="Report" source="Cardiff/E/02/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0133" service="Report" source="Cardiff/E/02/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0134" service="Report" source="Cardiff/E/02/BreakerFailure1/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0135" service="Report" source="Cardiff/E/02/BreakerFailure1/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0136" service="Report" source="Cardiff/E/02/BreakerFailure1/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0137" service="Report" source="Cardiff/E/02/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E02BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0138" service="Report" source="Cardiff/E/02/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0139" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0140" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0141" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0142" service="Report" source="Cardiff/E/03/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0143" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0144" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0145" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0146" service="Report" source="Cardiff/E/03/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0147" service="Report" source="Cardiff/E/03/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0148" service="Report" source="Cardiff/E/03/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0149" service="Report" source="Cardiff/E/03/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0150" service="Report" source="Cardiff/E/03/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0151" service="Report" source="Cardiff/E/03/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0152" service="Report" source="Cardiff/E/03/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0153" service="Report" source="Cardiff/E/03/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0154" service="Report" source="Cardiff/E/03/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0155" service="Report" source="Cardiff/E/03/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0156" service="Report" source="Cardiff/E/03/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0157" service="Report" source="Cardiff/E/03/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0158" service="Report" source="Cardiff/E/03/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0159" service="Report" source="Cardiff/E/03/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0160" service="Report" source="Cardiff/E/03/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0161" service="Report" source="Cardiff/E/03/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0162" service="Report" source="Cardiff/E/03/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0163" service="Report" source="Cardiff/E/03/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0164" service="Report" source="Cardiff/E/03/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0165" service="Report" source="Cardiff/E/03/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/A.TVTR.7.VolSv.instMag.i" input="Unnamed_#0166" service="Report" source="Cardiff/E/03/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/B.TVTR.8.VolSv.instMag.i" input="Unnamed_#0167" service="Report" source="Cardiff/E/03/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/C.TVTR.4.VolSv.instMag.i" input="Unnamed_#0168" service="Report" source="Cardiff/E/03/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BPULD0/N.TVTR.1.VolSv.instMag.i" input="Unnamed_#0169" service="Report" source="Cardiff/E/03/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0170" service="Report" source="Cardiff/E/03/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0171" service="Report" source="Cardiff/E/03/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0172" service="Report" source="Cardiff/E/03/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0173" service="Report" source="Cardiff/E/03/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0174" service="Report" source="Cardiff/E/03/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0175" service="Report" source="Cardiff/E/03/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0176" service="Report" source="Cardiff/E/03/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0177" service="Report" source="Cardiff/E/03/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0178" service="Report" source="Cardiff/E/03/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0179" service="Report" source="Cardiff/E/03/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0180" service="Report" source="Cardiff/E/03/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E03BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0181" service="Report" source="Cardiff/E/03/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0182" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0183" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0184" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0185" service="Report" source="Cardiff/E/04/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0186" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0187" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0188" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0189" service="Report" source="Cardiff/E/04/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0190" service="Report" source="Cardiff/E/04/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0191" service="Report" source="Cardiff/E/04/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0192" service="Report" source="Cardiff/E/04/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0193" service="Report" source="Cardiff/E/04/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0194" service="Report" source="Cardiff/E/04/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0195" service="Report" source="Cardiff/E/04/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0196" service="Report" source="Cardiff/E/04/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0197" service="Report" source="Cardiff/E/04/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0198" service="Report" source="Cardiff/E/04/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0199" service="Report" source="Cardiff/E/04/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0200" service="Report" source="Cardiff/E/04/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0201" service="Report" source="Cardiff/E/04/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0202" service="Report" source="Cardiff/E/04/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0203" service="Report" source="Cardiff/E/04/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0204" service="Report" source="Cardiff/E/04/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0205" service="Report" source="Cardiff/E/04/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0206" service="Report" source="Cardiff/E/04/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0207" service="Report" source="Cardiff/E/04/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0208" service="Report" source="Cardiff/E/04/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/A.TVTR.7.VolSv.instMag.i" input="Unnamed_#0209" service="Report" source="Cardiff/E/04/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/B.TVTR.8.VolSv.instMag.i" input="Unnamed_#0210" service="Report" source="Cardiff/E/04/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/C.TVTR.4.VolSv.instMag.i" input="Unnamed_#0211" service="Report" source="Cardiff/E/04/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BPULD0/N.TVTR.1.VolSv.instMag.i" input="Unnamed_#0212" service="Report" source="Cardiff/E/04/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0213" service="Report" source="Cardiff/E/04/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0214" service="Report" source="Cardiff/E/04/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0215" service="Report" source="Cardiff/E/04/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0216" service="Report" source="Cardiff/E/04/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0217" service="Report" source="Cardiff/E/04/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0218" service="Report" source="Cardiff/E/04/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BUPOvercurrent/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0219" service="Report" source="Cardiff/E/04/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0220" service="Report" source="Cardiff/E/04/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0221" service="Report" source="Cardiff/E/04/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0222" service="Report" source="Cardiff/E/04/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0223" service="Report" source="Cardiff/E/04/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E04BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0224" service="Report" source="Cardiff/E/04/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.phsA.cVal.mag.f" input="Unnamed_#0225" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.phsB.cVal.mag.f" input="Unnamed_#0226" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.phsC.cVal.mag.f" input="Unnamed_#0227" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.MMXU.1.A.neut.cVal.mag.f" input="Unnamed_#0228" service="Report" source="Cardiff/E/05/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.phsA.cVal.mag.f" input="Unnamed_#0229" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.phsB.cVal.mag.f" input="Unnamed_#0230" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.phsC.cVal.mag.f" input="Unnamed_#0231" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/V.MMXU.2.PhV.net.cVal.mag.f" input="Unnamed_#0232" service="Report" source="Cardiff/E/05/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.TVTR.2.VolSv.instMag.i" input="Unnamed_#0233" service="Report" source="Cardiff/E/05/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/B.TVTR.12.VolSv.instMag.i" input="Unnamed_#0234" service="Report" source="Cardiff/E/05/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/C.TVTR.14.VolSv.instMag.i" input="Unnamed_#0235" service="Report" source="Cardiff/E/05/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/N.TVTR.3.VolSv.instMag.i" input="Unnamed_#0236" service="Report" source="Cardiff/E/05/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0237" service="Report" source="Cardiff/E/05/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/B.TCTR.1.AmpSv.instMag.f" input="Unnamed_#0238" service="Report" source="Cardiff/E/05/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/C.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0239" service="Report" source="Cardiff/E/05/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUMeasurement/N.TCTR.6.AmpSv.instMag.i" input="Unnamed_#0240" service="Report" source="Cardiff/E/05/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/PDIF.1.Op.general" input="Unnamed_#0241" service="Report" source="Cardiff/E/05/Differential/PDIF1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/DIFF.PTRC.1.Op.general" input="Unnamed_#0242" service="Report" source="Cardiff/E/05/Differential/DIFFPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/A.TCTR.2.AmpSv.instMag.i" input="Unnamed_#0243" service="Report" source="Cardiff/E/05/Differential/ATCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/B.TCTR.3.AmpSv.instMag.f" input="Unnamed_#0244" service="Report" source="Cardiff/E/05/Differential/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/C.TCTR.1.AmpSv.instMag.i" input="Unnamed_#0245" service="Report" source="Cardiff/E/05/Differential/CTCTR1.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/N.TCTR.4.AmpSv.instMag.i" input="Unnamed_#0246" service="Report" source="Cardiff/E/05/Differential/NTCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/A.TCTR.5.AmpSv.instMag.i" input="Unnamed_#0247" service="Report" source="Cardiff/E/05/Differential/ATCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/B.TCTR.6.AmpSv.instMag.f" input="Unnamed_#0248" service="Report" source="Cardiff/E/05/Differential/BTCTR5.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/C.TCTR.7.AmpSv.instMag.i" input="Unnamed_#0249" service="Report" source="Cardiff/E/05/Differential/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BPUDifferential/N.TCTR.8.AmpSv.instMag.i" input="Unnamed_#0250" service="Report" source="Cardiff/E/05/Differential/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0251" service="Report" source="Cardiff/E/05/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0252" service="Report" source="Cardiff/E/05/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0253" service="Report" source="Cardiff/E/05/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0254" service="Report" source="Cardiff/E/05/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0255" service="Report" source="Cardiff/E/05/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0256" service="Report" source="Cardiff/E/05/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0257" service="Report" source="Cardiff/E/05/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0258" service="Report" source="Cardiff/E/05/BreakerFailure1/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0259" service="Report" source="Cardiff/E/05/BreakerFailure1/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0260" service="Report" source="Cardiff/E/05/BreakerFailure1/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0261" service="Report" source="Cardiff/E/05/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E05BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0262" service="Report" source="Cardiff/E/05/QA0/Control/QA0CSWI2.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0263" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0264" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0265" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0266" service="Report" source="Cardiff/E/06/Measurement/AMMXU1.A.neut.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0267" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.phsA.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0268" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.phsB.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0269" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.phsC.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0270" service="Report" source="Cardiff/E/06/Measurement/VMMXU2.PhV.net.cVal.mag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0271" service="Report" source="Cardiff/E/06/Measurement/ATVTR2.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0272" service="Report" source="Cardiff/E/06/Measurement/BTVTR12.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0273" service="Report" source="Cardiff/E/06/Measurement/CTVTR14.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0274" service="Report" source="Cardiff/E/06/Measurement/NTVTR3.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0275" service="Report" source="Cardiff/E/06/Measurement/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0276" service="Report" source="Cardiff/E/06/Measurement/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0277" service="Report" source="Cardiff/E/06/Measurement/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0278" service="Report" source="Cardiff/E/06/Measurement/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z1.PDIS.1.Str.general" input="Unnamed_#0279" service="Report" source="Cardiff/E/06/Distance/Z1PDIS1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z1.PDIS.1.Op.general" input="Unnamed_#0280" service="Report" source="Cardiff/E/06/Distance/Z1PDIS1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z2.PDIS.2.Str.general" input="Unnamed_#0281" service="Report" source="Cardiff/E/06/Distance/Z2PDIS2.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z2.PDIS.2.Op.general" input="Unnamed_#0282" service="Report" source="Cardiff/E/06/Distance/Z2PDIS2.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z3.PDIS.3.Str.general" input="Unnamed_#0283" service="Report" source="Cardiff/E/06/Distance/Z3PDIS3.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/Z3.PDIS.3.Op.general" input="Unnamed_#0284" service="Report" source="Cardiff/E/06/Distance/Z3PDIS3.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BPULD0/DIS.PTRC.1.Op.general" input="Unnamed_#0285" service="Report" source="Cardiff/E/06/Distance/DISPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0286" service="Report" source="Cardiff/E/06/Distance/ATCTR2.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0287" service="Report" source="Cardiff/E/06/Distance/BTCTR3.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0288" service="Report" source="Cardiff/E/06/Distance/CTCTR7.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0289" service="Report" source="Cardiff/E/06/Distance/NTCTR8.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0290" service="Report" source="Cardiff/E/06/Distance/ATVTR7.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0291" service="Report" source="Cardiff/E/06/Distance/BTVTR8.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0292" service="Report" source="Cardiff/E/06/Distance/CTVTR4.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0293" service="Report" source="Cardiff/E/06/Distance/NTVTR1.VolSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/PH.PTOC.1.Str.general" input="Unnamed_#0294" service="Report" source="Cardiff/E/06/Overcurrent/PHPTOC1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/PH.PTOC.1.Op.general" input="Unnamed_#0295" service="Report" source="Cardiff/E/06/Overcurrent/PHPTOC1.Op.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BUPOvercurrent/OC.PTRC.1.Op.general" input="Unnamed_#0296" service="Report" source="Cardiff/E/06/Overcurrent/OCPTRC1.Op.general"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0297" service="Report" source="Cardiff/E/06/Overcurrent/ATCTR5.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0298" service="Report" source="Cardiff/E/06/Overcurrent/BTCTR1.AmpSv.instMag.f"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0299" service="Report" source="Cardiff/E/06/Overcurrent/CTCTR4.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef input="Unnamed_#0300" service="Report" source="Cardiff/E/06/Overcurrent/NTCTR6.AmpSv.instMag.i"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUBreakerFailure1/RBRF.1.Str.general" input="Unnamed_#0301" service="Report" source="Cardiff/E/06/BreakerFailure/RBRF1.Str.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUBreakerFailure1/RBRF.1.OpEx.general" input="Unnamed_#0302" service="Report" source="Cardiff/E/06/BreakerFailure/RBRF1.OpEx.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUBreakerFailure1/RBRF.1.OpIn.general" input="Unnamed_#0303" service="Report" source="Cardiff/E/06/BreakerFailure/RBRF1.OpIn.general"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUQB1Control/QB1.CSWI.1.Pos.stVal" input="Unnamed_#0304" service="Report" source="Cardiff/E/06/QB1/Control/QB1CSWI1.Pos.stVal"/>
            <eIEC61850-6-100:SourceRef extRefAddr="E06BCUQA0Control/QA0.CSWI.2.Pos.stVal" input="Unnamed_#0305" service="Report" source="Cardiff/E/06/QA0/Control/QA0CSWI2.Pos.stVal"/>
          </eIEC61850-6-100:LNodeInputs></Private>
      </LNode>
    </Function>
  </Substation>
  <Communication>
    <SubNetwork name="ProcessBus" type="8-MMS">
      <ConnectedAP apName="F" iedName="E01BCU">
        <Address>
          <P type="IP">10.10.0.2</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02PIU" redProt="prp">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.100.103</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">192.168.100.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Trip">
          <Private source="1670273751792" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Trip">
          <Private source="1670273751831" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Trip">
          <Private source="1670273751832" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="Trip">
          <Private source="1670273752003" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E01BPU">
        <Address>
          <P type="IP">10.10.0.3</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E02BPU">
        <Address>
          <P type="IP">10.10.0.4</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E02BUP">
        <Address>
          <P type="IP">10.10.0.5</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E01BUP">
        <Address>
          <P type="IP">10.10.0.6</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E03BCU">
        <Address>
          <P type="IP">10.10.0.7</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E03BPU">
        <Address>
          <P type="IP">10.10.0.8</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E03BUP">
        <Address>
          <P type="IP">10.10.0.9</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E04BCU">
        <Address>
          <P type="IP">10.10.0.10</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E05BPU">
        <Address>
          <P type="IP">10.10.0.12</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E05BUP">
        <Address>
          <P type="IP">10.10.0.13</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05PIU">
        <Address>
          <P type="IP">10.10.0.14</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Trip">
          <Private source="1670273751863" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Trip">
          <Private source="1670273751863" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Trip">
          <Private source="1670273751865" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="Trip">
          <Private source="1670273752005" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E06PIU">
        <Address>
          <P type="IP">10.10.0.15</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E04PIU">
        <Address>
          <P type="IP">10.10.0.16</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E03PIU">
        <Address>
          <P type="IP">10.10.0.17</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E04BPU">
        <Address>
          <P type="IP">10.10.0.18</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E04BUP">
        <Address>
          <P type="IP">10.10.0.19</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E06BCU">
        <Address>
          <P type="IP">10.10.0.20</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E06BPU">
        <Address>
          <P type="IP">10.10.0.21</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E06BUP">
        <Address>
          <P type="IP">10.10.0.22</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E01PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">00000001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <SMV desc="9-2LE SV Stream (F4000S1I4U4)" cbName="MSVCB01" ldInst="MU01">
          <Address>
            <P xsi:type="tP_VLAN-ID" type="VLAN-ID">000</P>
            <P xsi:type="tP_VLAN-PRIORITY" type="VLAN-PRIORITY">4</P>
            <P xsi:type="tP_MAC-Address" type="MAC-Address">01-0C-CD-04-00-01</P>
            <P xsi:type="tP_APPID" type="APPID">4000</P>
          </Address>
        </SMV>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="S2" iedName="E02BCU">
        <Address>
          <P type="IP">127.0.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,1</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">127.0.0.0</P>
          <P type="OSI-AE-Qualifier">12</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="GoCB01" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB02" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB03" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB04" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB05" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB06" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB07" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB08" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="S2" iedName="E05BCU">
        <Address>
          <P type="IP">10.10.0.11</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="GoCB01" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB02" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB03" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB04" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB05" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB06" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB07" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB08" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
      </ConnectedAP>
    </SubNetwork>
    <SubNetwork name="StationBus" type="8-MMS">
      <ConnectedAP apName="S1" iedName="Zenon">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="XPG">
        <Address>
          <P type="IP">10.10.0.2</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E01BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">172.24.7.111</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">172.24.7.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Measurement">
          <Private source="1670273751858" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1670273751860" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E01BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.254</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">192.168.2.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1670273751872" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.16.60.65</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Differential">
          <Private source="1670273751836" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02BUP">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.16.60.65</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Overcurrent">
          <Private source="1670273751888" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E01BUP">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E03BCU">
        <Address>
          <P type="IP">192.168.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1670273751886" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E03BPU">
        <Address>
          <P type="IP">192.168.0.2</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1670273751882" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E03BUP">
        <Address>
          <P type="IP">192.168.0.3</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05BPU">
        <Address>
          <P type="IP">192.168.0.5</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Differential">
          <Private source="1670273751854" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05BUP">
        <Address>
          <P type="IP">192.168.0.6</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Overcurrent">
          <Private source="1670273751843" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E04BCU">
        <Address>
          <P type="IP">192.168.0.7</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1670273751880" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E04BUP">
        <Address>
          <P type="IP">192.168.0.9</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E06BCU">
        <Address>
          <P type="IP">192.168.0.10</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1670273751850" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E06BPU">
        <Address>
          <P type="IP">192.168.0.11</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1670273751884" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E06BUP">
        <Address>
          <P type="IP">192.168.0.12</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E02BCU">
        <Address>
          <P type="IP">127.0.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,1</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">127.0.0.0</P>
          <P type="OSI-AE-Qualifier">12</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="GoCB01" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB02" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB03" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB04" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB05" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB06" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB07" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB08" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E05BCU">
        <Address>
          <P type="IP">192.168.0.4</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="GoCB01" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB02" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB03" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB04" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB05" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB06" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB07" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
        <GSE cbName="GoCB08" ldInst="Master">
          <Address>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
          </Address>
          <MinTime multiplier="m" unit="s">0</MinTime>
          <MaxTime multiplier="m" unit="s">0</MaxTime>
        </GSE>
      </ConnectedAP>
    </SubNetwork>
  </Communication>
  <IED configVersion="1" manufacturer="no manufacturer" type="gateway" name="XPG">
    <Services nameLength="64">
      <DynAssociation max="10"/>
      <SettingGroups>
        <SGEdit resvTms="false"/>
        <ConfSG resvTms="false"/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <SetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="32" maxAttributes="100" modify="true"/>
      <DynDataSet max="32" maxAttributes="100"/>
      <ReadWrite/>
      <ConfReportControl max="16" bufConf="true" bufMode="both"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Conf" bufTime="Conf" intgPd="Conf" optFields="Conf" owner="true" resvTms="true" rptID="Conf" trgOps="Conf"/>
      <LogSettings cbName="Conf" datSet="Conf" intgPd="Conf" logEna="Conf" trgOps="Conf"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf"/>
      <GSEDir/>
      <GOOSE max="8" fixedOffs="false"/>
      <SMVsc max="12" delivery="both" deliveryConf="true"/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="true" goose="true" gsse="false" maxAttributes="250" maxGOOSE="32" maxReports="32" maxSMV="32" readLog="false" supportsLdName="true" sv="true" unbufReport="true">
        <TimeSyncProt sntp="true" c37_238="false" other="false"/>
      </ClientServices>
      <ConfLdName/>
    </Services>
    <AccessPoint clock="false" router="false" name="AP1">
      <Server>
        <Authentication none="true"/>
        <LDevice inst="LD0">
          <LN lnType="lphd_7_4_B2007" inst="1" lnClass="LPHD"/>
          <LN lnType="itci_7_4_B2007" inst="1" lnClass="ITCI">
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mir.desc" name="Mir">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcExp.desc" name="ClcExp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcStr.desc" name="ClcStr">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMth.desc" name="ClcMth">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMod.desc" name="ClcMod">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvTyp.desc" name="ClcIntvTyp">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvPer.desc" name="ClcIntvPer">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.NumSubIntv.desc" name="NumSubIntv">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfTyp.desc" name="ClcRfTyp">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfPer.desc" name="ClcRfPer">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcSrc.desc" name="ClcSrc">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcNxtTmms.desc" name="ClcNxtTmms">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.InSyn.desc" name="InSyn">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEName.desc" name="EEName">
              <DAI name="vendor" valKind="Set"/>
              <DAI name="hwRev" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="serNum" valKind="Set"/>
              <DAI name="model" valKind="Set"/>
              <DAI name="location" valKind="Set"/>
              <DAI name="name" valKind="Set"/>
              <DAI name="owner" valKind="Set"/>
              <DAI name="ePSName" valKind="Set"/>
              <DAI name="primeOper" valKind="Set"/>
              <DAI name="secondOper" valKind="Set"/>
              <DAI name="latitude" valKind="Set"/>
              <DAI name="longitude" valKind="Set"/>
              <DAI name="altitude" valKind="Set"/>
              <DAI name="mRID" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEHealth.desc" name="EEHealth">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.OpTmh.desc" name="OpTmh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupI::ITCI.Alm.desc" name="Alm">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <Inputs>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" prefix="DIFF" serviceType="Report" srcCBName="brcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E05BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E05BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" prefix="DIFF" serviceType="Report" srcCBName="brcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="6" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbB" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="URCB02" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="6" prefix="B" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="AP1"/>
  </IED>
  <IED desc="ZENON HMI" configVersion="2.1" manufacturer="Copa-Data" originalSclRevision="B" originalSclVersion="2007" owner="" type="ZENON" name="Zenon">
    <AccessPoint clock="true" name="S1">
      <LN lnType="ITCI_ZENON" inst="1" lnClass="ITCI">
        <Inputs>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" prefix="DIFF" serviceType="Report" srcCBName="brcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E05BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E05BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" prefix="DIFF" serviceType="Report" srcCBName="brcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="6" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="URCB01" srcLDInst="Master" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="6" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
        </Inputs>
      </LN>
      <Services nameLength="64">
        <ClientServices bufReport="true" maxAttributes="50000" maxReports="200" supportsLdName="true" unbufReport="true">
          <TimeSyncProt sntp="true"/>
        </ClientServices>
        <TimeSyncProt sntp="true"/>
      </Services>
    </AccessPoint>
    <AccessPoint clock="true" name="S2">
      <LN lnType="ITCI_ZENON" inst="2" lnClass="ITCI"/>
      <Services nameLength="64">
        <ClientServices bufReport="true" maxAttributes="50000" maxReports="200" supportsLdName="true" unbufReport="true">
          <TimeSyncProt sntp="true"/>
        </ClientServices>
        <TimeSyncProt sntp="true"/>
      </Services>
    </AccessPoint>
  </IED>
  <IED desc="SAM600-MU" configVersion="1.0" manufacturer="ABB" originalSclRevision="B" originalSclVersion="2007" type="SAM600" name="E01PIU">
    <Private type="ABB_PCMObjectTypeName">SAM600</Private>
    <Private type="ABBPCMInternalObjRef">5daad46d-3102-4342-bc72-72a3ee953258</Private>
    <Private type="ABB SAM600 Stream Mapping">
      <eSAM:ArrayOfStreamMapping xmlns:eSAM="http://www.abb.com/61850/2016/SAM600Mapping">
        <eSAM:StreamMapping>
          <eSAM:StreamId>Stream01</eSAM:StreamId>
          <eSAM:MappedLds>
            <eSAM:string>MU01</eSAM:string>
          </eSAM:MappedLds>
          <eSAM:SelectedCt>CT1</eSAM:SelectedCt>
          <eSAM:SelectedVt>VT1</eSAM:SelectedVt>
        </eSAM:StreamMapping>
      </eSAM:ArrayOfStreamMapping>
    </Private>
    <Private type="ABB Comm">
      <eComm:CommNode x="-536870912" y="-536870912">
        <eComm:MergingUnit/>
        <eComm:Port id="TS1-X103" xRel="0" yRel="0"/>
        <eComm:Port id="TS1-X104" xRel="0" yRel="0"/>
      </eComm:CommNode>
    </Private>
    <Services nameLength="64">
      <SMVSettings cbName="Fix" datSet="Fix" smpRate="Fix" svID="Fix">
        <SmpRate>80</SmpRate>
      </SMVSettings>
      <SMVsc max="10"/>
      <ClientServices goose="true" gsse="true" supportsLdName="true">
        <TimeSyncProt sntp="false" c37_238="true" other="true"/>
      </ClientServices>
      <TimeSyncProt sntp="false" c37_238="true" other="true"/>
    </Services>
    <AccessPoint name="SAM600ServerModel">
      <Server>
        <Authentication/>
        <LDevice inst="Trip" ldName="CardiffETransformerTrip">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="ptrc_7_4_B2007" inst="1" lnClass="PTRC" prefix="Trip">
            <DOI desc="IEC61850_7_4.LNGroupP::PTRC.Tr.desc" name="Tr">
              <DAI name="general" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QB1Interface" ldName="CardiffETransformerQB1Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xswi_7_4_B2007" inst="1" lnClass="XSWI" prefix="QB1">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QA0Interface" ldName="CardiffETransformerQA0Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xcbr_7_4_B2007" inst="1" lnClass="XCBR" prefix="QA0">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="CTCT" ldName="CardiffETransformerCTCT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="2" lnClass="TCTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="3" lnClass="TCTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="VTVT" ldName="CardiffETransformerVTVT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tvtr_7_4_B2007" inst="1" lnClass="TVTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="2" lnClass="TVTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="3" lnClass="TVTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="4" lnClass="TVTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="S1">
      <ServerAt apName="SAM600ServerModel"/>
      <Services>
        <SMVSettings cbName="Conf" datSet="Conf">
          <SmpRate>80</SmpRate>
        </SMVSettings>
        <SMVsc max="1" deliveryConf="true"/>
      </Services>
    </AccessPoint>
  </IED>
  <IED desc="-W001 Leitung Tamina Ost" configVersion="V07.31.03" manufacturer="SIEMENS" type="6MD86" name="E01BCU">
    <Private type="Siemens-MasterId">ccbaddd5-6978-458d-8717-387707226c37</Private>
    <Private type="Siemens-s7ManagerName">-W001 Leitung Tamina Ost</Private>
    <Private type="Siemens-ICD-Language">de-DE</Private>
    <Private type="Siemens-Siprotec5-Product-Code">6MD86-DAAA-AA0-0AAAA0-AA0112-43111B-BAA000-000AA0-CB3BA1-CG0CG0-CG0</Private>
    <Private type="Siemens-Siprotec5-Application-Template">6MD86_NotConfigured</Private>
    <Private type="Siemens-Siprotec5-Communication-Configuration-Version">73100</Private>
    <Private type="Siemens-Siprotec5-Configuration-Version">V07.31.03</Private>
    <Private type="Siemens-IsSiprotec5IED"/>
    <Services nameLength="64">
      <DynAssociation/>
      <SettingGroups>
        <SGEdit/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="50" maxAttributes="60"/>
      <DynDataSet max="30" maxAttributes="60"/>
      <ReadWrite/>
      <ConfReportControl max="30"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
      <GOOSE max="16"/>
      <FileHandling/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="false" goose="true" supportsLdName="true" sv="true"/>
    </Services>
    <AccessPoint desc="Port E" clock="false" router="false" name="E">
      <Server timeout="0">
        <Private type="Siemens-MasterId">cd2ea416-c82e-4893-8eda-8c1e02c31ce6</Private>
        <Authentication none="true"/>
        <LDevice inst="Measurement" ldName="CardiffETransformerMeasurement">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DataSet name="ds_brcb1">
              <Private source="1670273751543" type="HELINKS_TAG"/>
              <FCDA doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="OpIn" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="Str" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="Pos" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="Pos" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
            </DataSet>
            <DataSet name="ds_brcb2">
              <Private source="1670273751543" type="HELINKS_TAG"/>
              <FCDA doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="OpIn" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="Str" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="Pos" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="Pos" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
            </DataSet>
            <DataSet name="ds_urcb1">
              <Private source="1670273751544" type="HELINKS_TAG"/>
              <FCDA doName="A" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N"/>
              <FCDA doName="PhV" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V"/>
            </DataSet>
            <DataSet name="ds_urcb2">
              <Private source="1670273751544" type="HELINKS_TAG"/>
              <FCDA doName="A" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N"/>
              <FCDA doName="VolSv" fc="MX" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N"/>
              <FCDA doName="PhV" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V"/>
            </DataSet>
            <DataSet name="ds_gcb_f1">
              <Private source="1670273751858" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA daName="q" doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
            </DataSet>
            <DataSet name="ds_gcb_l1">
              <Private source="1670273751860" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="OpCls" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA daName="q" doName="OpCls" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA daName="general" doName="OpOpn" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA daName="q" doName="OpOpn" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
            </DataSet>
            <ReportControl datSet="ds_brcb1" name="brcba" intgPd="100" buffered="true" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.brcba">
              <Private source="1670273751543" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751543" type="HELINKS_TAG"/>
                <ClientLN apRef="S1" iedName="Zenon" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="ds_brcb2" name="brcbb" intgPd="100" buffered="true" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.brcbb">
              <Private source="1670273751543" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751543" type="HELINKS_TAG"/>
                <ClientLN apRef="AP1" iedName="XPG" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="ds_urcb1" name="urcba" intgPd="100" buffered="false" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.urcba">
              <Private source="1670273751544" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751544" type="HELINKS_TAG"/>
                <ClientLN apRef="S1" iedName="Zenon" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="ds_urcb2" name="urcbb" intgPd="100" buffered="false" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.urcbb">
              <Private source="1670273751544" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751544" type="HELINKS_TAG"/>
                <ClientLN apRef="AP1" iedName="XPG" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_f1" name="gcb_f1" confRev="10000" appID="E01BCUMeasurement/LLN0gcb_f1" securityEnable="None">
              <Private source="1670273751858" type="HELINKS_TAG"/>
              <IEDName apRef="SAM600ServerModel" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E03PIU</IEDName>
              <IEDName apRef="SAM600ServerModel" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E04PIU</IEDName>
              <IEDName apRef="SAM600ServerModel" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E06PIU</IEDName>
            </GSEControl>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_l1" name="gcb_l1" confRev="10000" appID="E01BCUMeasurement/LLN0gcb_l1" securityEnable="None">
              <Private source="1670273751860" type="HELINKS_TAG"/>
              <IEDName apRef="SAM600ServerModel" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" prefix="QB1">E01PIU</IEDName>
              <IEDName apRef="SAM600ServerModel" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E01PIU</IEDName>
            </GSEControl>
          </LN0>
          <LN lnType="mmxu_7_4_B2007" inst="1" lnClass="MMXU" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupM::MMXU.A.desc" name="A">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="mmxu_7_4_B2007" inst="2" lnClass="MMXU" prefix="V">
            <DOI desc="IEC61850_7_4.LNGroupM::MMXU.PhV.desc" name="PhV">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="net">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="2" lnClass="TVTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="12" lnClass="TVTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="14" lnClass="TVTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="3" lnClass="TVTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="5" lnClass="TCTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="6" lnClass="TCTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QB1Control" ldName="CardiffETransformerQB1Control">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="cswi_7_4_B2007" inst="1" lnClass="CSWI" prefix="QB1">
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpOpn.desc" name="OpOpn">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpCls.desc" name="OpCls">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QA0Control" ldName="CardiffETransformerQA0Control">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="cswi_7_4_B2007" inst="2" lnClass="CSWI" prefix="QA0">
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpOpn.desc" name="OpOpn">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpCls.desc" name="OpCls">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="BreakerFailure1" ldName="CardiffETransformerBreakerFailure1">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="rbrf_7_4_B2007" inst="1" lnClass="RBRF" prefix="">
            <DOI desc="IEC61850_7_4.LNGroupR::RBRF.Str.desc" name="Str">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupR::RBRF.OpEx.desc" name="OpEx">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupR::RBRF.OpIn.desc" name="OpIn">
              <DAI name="general" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="LD0">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="lphd_7_4_B2007" inst="1" lnClass="LPHD">
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PhyNam.desc" name="PhyNam">
              <DAI name="vendor" valKind="Set"/>
              <DAI name="hwRev" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="serNum" valKind="Set"/>
              <DAI name="model" valKind="Set"/>
              <DAI name="location" valKind="Set"/>
              <DAI name="name" valKind="Set"/>
              <DAI name="owner" valKind="Set"/>
              <DAI name="ePSName" valKind="Set"/>
              <DAI name="primeOper" valKind="Set"/>
              <DAI name="secondOper" valKind="Set"/>
              <DAI name="latitude" valKind="Set"/>
              <DAI name="longitude" valKind="Set"/>
              <DAI name="altitude" valKind="Set"/>
              <DAI name="mRID" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PhyHealth.desc" name="PhyHealth">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.OutOv.desc" name="OutOv">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.Proxy.desc" name="Proxy">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.InOv.desc" name="InOv">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.OpTmh.desc" name="OpTmh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.NumPwrUp.desc" name="NumPwrUp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.WrmStr.desc" name="WrmStr">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.WacTrg.desc" name="WacTrg">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrUp.desc" name="PwrUp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrDn.desc" name="PwrDn">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrSupAlm.desc" name="PwrSupAlm">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.RsStat.desc" name="RsStat">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.Sim.desc" name="Sim">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.MaxDl.desc" name="MaxDl">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="F">
      <ServerAt apName="E"/>
    </AccessPoint>
  </IED>
  <IED desc="Merging Unit" configVersion="V08.01.12" manufacturer="SIEMENS" originalSclRevision="B" originalSclVersion="2007" type="6MU85" name="E02PIU">
    <Private type="Siemens-MasterId">efb81670-505b-4dd5-9560-0ac3ba594480</Private>
    <Private type="Siemens-s7ManagerName">RNB VBS 6MD85</Private>
    <Private type="Siemens-ICD-Language">en-US</Private>
    <Private type="Siemens-Siprotec5-Product-Code">6MD85-DAAA-AA0-0AAAA0-AF0111-23111B-BAA000-000AC0-CB3BA1-CG0CM0-EB0EB0</Private>
    <Private type="Siemens-Siprotec5-Application-Template">6MD85_Standard</Private>
    <Private type="Siemens-Siprotec5-Communication-Configuration-Version">80112</Private>
    <Private type="Siemens-Siprotec5-Configuration-Version">V08.01.12</Private>
    <Private type="Siemens-IsSiprotec5IED"/>
    <Private type="Siemens-IED-Id">efb81670-505b-4dd5-9560-0ac3ba594480</Private>
    <Private type="Siemens-CID-MainIED"/>
    <Services nameLength="64">
      <DynAssociation max="6"/>
      <SettingGroups>
        <SGEdit resvTms="true"/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="50" maxAttributes="100" modify="true"/>
      <DynDataSet max="30" maxAttributes="60"/>
      <ReadWrite/>
      <ConfReportControl max="60" bufConf="true" bufMode="both"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" resvTms="true" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
      <SMVSettings cbName="Conf" datSet="Conf"/>
      <GOOSE max="16" fixedOffs="false"/>
      <SMVsc max="10"/>
      <FileHandling/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="false" goose="true" gsse="false" maxGOOSE="128" readLog="false" supportsLdName="true" sv="false" unbufReport="false">
        <TimeSyncProt/>
      </ClientServices>
      <ConfLdName/>
      <SupSubscription maxGo="128" maxSv="0"/>
      <ValueHandling setToRO="false"/>
      <RedProt hsr="true" prp="true" rstp="true"/>
      <CommProt ipv6="false"/>
    </Services>
    <AccessPoint desc="Port E" clock="false" router="false" name="E">
      <Server timeout="0">
        <Private type="Siemens-MasterId">8998046b-b2a9-4a2a-be7b-532c790e7ba3</Private>
        <Authentication none="true"/>
        <LDevice inst="Trip" ldName="CardiffETransformerTrip">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DataSet name="ds_gcb_f1">
              <Private source="1670273751792" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="Tr" fc="ST" ldInst="Trip" lnClass="PTRC" lnInst="1" prefix="Trip"/>
              <FCDA daName="q" doName="Tr" fc="ST" ldInst="Trip" lnClass="PTRC" lnInst="1" prefix="Trip"/>
            </DataSet>
            <DataSet name="ds_gcb_l1">
              <Private source="1670273751831" type="HELINKS_TAG"/>
              <FCDA daName="stVal" doName="Pos" fc="ST" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0"/>
              <FCDA daName="q" doName="Pos" fc="ST" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0"/>
            </DataSet>
            <DataSet name="ds_gcb_l2">
              <Private source="1670273751832" type="HELINKS_TAG"/>
              <FCDA daName="stVal" doName="Pos" fc="ST" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0"/>
              <FCDA daName="q" doName="Pos" fc="ST" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0"/>
            </DataSet>
            <DataSet name="ds_smvcba">
              <Private source="1670273752003" type="HELINKS_TAG"/>
              <FCDA daName="instMag.i" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="1" prefix="A"/>
              <FCDA daName="instMag.f" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="2" prefix="B"/>
              <FCDA daName="instMag.i" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="3" prefix="C"/>
              <FCDA daName="instMag.i" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="4" prefix="N"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="1" prefix="A"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="2" prefix="B"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="3" prefix="C"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="4" prefix="N"/>
            </DataSet>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_f1" name="gcb_f1" confRev="10000" appID="E02PIUTrip/LLN0gcb_f1" securityEnable="None">
              <Private source="1670273751792" type="HELINKS_TAG"/>
            </GSEControl>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_l1" name="gcb_l1" confRev="10000" appID="E02PIUTrip/LLN0gcb_l1" securityEnable="None">
              <Private source="1670273751830" type="HELINKS_TAG"/>
              <IEDName apRef="S1" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1">E02BCU</IEDName>
            </GSEControl>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_l2" name="gcb_l2" confRev="10000" appID="E02PIUTrip/LLN0gcb_l2" securityEnable="None">
              <Private source="1670273751832" type="HELINKS_TAG"/>
              <IEDName apRef="S1" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0">E02BCU</IEDName>
            </GSEControl>
            <SampledValueControl desc="Helinks default SMV Control Block" datSet="ds_smvcba" name="smvcba" confRev="10000" multicast="true" nofASDU="1" securityEnable="None" smpRate="80" smvID="E02PIUTrip/LLN0smvcba">
              <Private source="1670273752000" type="HELINKS_TAG"/>
              <IEDName apRef="E" ldInst="Differential" lnClass="TCTR" lnInst="2" prefix="A">E02BPU</IEDName>
              <IEDName apRef="E" ldInst="Differential" lnClass="TCTR" lnInst="3" prefix="B">E02BPU</IEDName>
              <IEDName apRef="E" ldInst="Differential" lnClass="TCTR" lnInst="1" prefix="C">E02BPU</IEDName>
              <IEDName apRef="E" ldInst="Differential" lnClass="TCTR" lnInst="4" prefix="N">E02BPU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A">E02BCU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B">E02BCU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C">E02BCU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N">E02BCU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A">E02BCU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B">E02BCU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C">E02BCU</IEDName>
              <IEDName apRef="S1" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N">E02BCU</IEDName>
              <IEDName apRef="E" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A">E02BUP</IEDName>
              <IEDName apRef="E" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B">E02BUP</IEDName>
              <IEDName apRef="E" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C">E02BUP</IEDName>
              <IEDName apRef="E" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N">E02BUP</IEDName>
              <SmvOpts refreshTime="false" sampleRate="false" sampleSynchronized="true" security="false" synchSourceId="false"/>
            </SampledValueControl>
          </LN0>
          <LN lnType="ptrc_7_4_B2007" inst="1" lnClass="PTRC" prefix="Trip">
            <DOI desc="IEC61850_7_4.LNGroupP::PTRC.Tr.desc" name="Tr">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <Inputs>
              <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" prefix="DIFF" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PTRC" lnInst="1" prefix="DIFF" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="OC Operate" doName="Op" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTRC" lnInst="1" prefix="OC" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
        </LDevice>
        <LDevice inst="QB1Interface" ldName="CardiffETransformerQB1Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xswi_7_4_B2007" inst="1" lnClass="XSWI" prefix="QB1">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QA0Interface" ldName="CardiffETransformerQA0Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xcbr_7_4_B2007" inst="1" lnClass="XCBR" prefix="QA0">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <Inputs>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate Open" doName="OpOpn" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Master" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate Close" doName="OpCls" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Master" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
        </LDevice>
        <LDevice inst="CTCT" ldName="CardiffETransformerCTCT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="2" lnClass="TCTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="3" lnClass="TCTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="VTVT" ldName="CardiffETransformerVTVT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tvtr_7_4_B2007" inst="1" lnClass="TVTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="2" lnClass="TVTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="3" lnClass="TVTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="4" lnClass="TVTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="LD0">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="lphd_7_4_B2007" inst="1" lnClass="LPHD">
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PhyNam.desc" name="PhyNam">
              <DAI name="vendor" valKind="Set"/>
              <DAI name="hwRev" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="serNum" valKind="Set"/>
              <DAI name="model" valKind="Set"/>
              <DAI name="location" valKind="Set"/>
              <DAI name="name" valKind="Set"/>
              <DAI name="owner" valKind="Set"/>
              <DAI name="ePSName" valKind="Set"/>
              <DAI name="primeOper" valKind="Set"/>
              <DAI name="secondOper" valKind="Set"/>
              <DAI name="latitude" valKind="Set"/>
              <DAI name="longitude" valKind="Set"/>
              <DAI name="altitude" valKind="Set"/>
              <DAI name="mRID" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PhyHealth.desc" name="PhyHealth">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.OutOv.desc" name="OutOv">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.Proxy.desc" name="Proxy">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.InOv.desc" name="InOv">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.OpTmh.desc" name="OpTmh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.NumPwrUp.desc" name="NumPwrUp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.WrmStr.desc" name="WrmStr">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.WacTrg.desc" name="WacTrg">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrUp.desc" name="PwrUp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrDn.desc" name="PwrDn">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrSupAlm.desc" name="PwrSupAlm">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.RsStat.desc" name="RsStat">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.Sim.desc" name="Sim">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.MaxDl.desc" name="MaxDl">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
  </IED>
  <IED desc="RED615" configVersion="G" manufacturer="ABB" originalSclRevision="B" originalSclVersion="2007" type="RED615" name="E01BPU">
    <Private type="ABB_PCMObjectTypeName">RED615</Private>
    <Private type="ABBPCMInternalObjRef">449185ce-99ee-491e-a2d4-f7a401a0cd87</Private>
    <Private type="ABB_CommonSA_FunctionListDescriptionsXXX">
      <commonSA:SAObjects xmlns:commonSA="commonSA.abb.com">
        <commonSA:Object type="ApplicationFunctions">
          <commonSA:Application>
            <commonSA:Components>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Monitoring#1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Information_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0__EVENTS_</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Information_2</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Information_3</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_4_1#1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_5_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_6</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0__PARAMETERS_</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_7</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_8</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Language</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_2</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="G3">LD0_LLN0_Configuration_3</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="379">
                <commonSA:FBRef fbRevision="H">LD0_GSAL1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="2">
                <commonSA:FBRef fbRevision="D">CTRL_LLN0_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="2">
                <commonSA:FBRef fbRevision="D">CTRL_LLN0_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="3">
                <commonSA:FBRef fbRevision="G">DR_LLN0_Disturbance_records</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="3">
                <commonSA:FBRef fbRevision="G">DR_LLN0_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="3">
                <commonSA:FBRef fbRevision="G">DR_LLN0_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="57">
                <commonSA:FBRef fbRevision="C">CTRL_DCSXSWI1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="57">
                <commonSA:FBRef fbRevision="C">CTRL_DCSXSWI1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="48">
                <commonSA:FBRef fbRevision="C">CTRL_DCSXSWI2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="48">
                <commonSA:FBRef fbRevision="C">CTRL_DCSXSWI2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="49">
                <commonSA:FBRef fbRevision="C">CTRL_DCSXSWI3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="49">
                <commonSA:FBRef fbRevision="C">CTRL_DCSXSWI3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="58">
                <commonSA:FBRef fbRevision="C">CTRL_ESSXSWI1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="58">
                <commonSA:FBRef fbRevision="C">CTRL_ESSXSWI1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="50">
                <commonSA:FBRef fbRevision="D">CTRL_CBCILO1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="50">
                <commonSA:FBRef fbRevision="D">CTRL_CBCILO1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="D">CTRL_CBCILO1_Control</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="252">
                <commonSA:FBRef fbRevision="C">CTRL_ESSXSWI2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="252">
                <commonSA:FBRef fbRevision="C">CTRL_ESSXSWI2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="54">
                <commonSA:FBRef fbRevision="C">CTRL_DCCILO1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="54">
                <commonSA:FBRef fbRevision="C">CTRL_DCCILO1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="C">CTRL_DCCILO1_Control</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="55">
                <commonSA:FBRef fbRevision="C">CTRL_DCCILO2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="55">
                <commonSA:FBRef fbRevision="C">CTRL_DCCILO2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="C">CTRL_DCCILO2_Control</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="56">
                <commonSA:FBRef fbRevision="C">CTRL_ESCILO1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="56">
                <commonSA:FBRef fbRevision="C">CTRL_ESCILO1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="C">CTRL_ESCILO1_Control</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="154">
                <commonSA:FBRef fbRevision="D">LD0_CCSPVC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="154">
                <commonSA:FBRef fbRevision="D">LD0_CCSPVC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="154">
                <commonSA:FBRef fbRevision="D">LD0_CCSPVC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="154">
                <commonSA:FBRef fbRevision="D">LD0_CCSPVC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="151">
                <commonSA:FBRef fbRevision="C">LD0_BSTGGIO1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="151">
                <commonSA:FBRef fbRevision="C">LD0_BSTGGIO1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="152">
                <commonSA:FBRef fbRevision="D">LD0_LNPTRC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="152">
                <commonSA:FBRef fbRevision="D">LD0_LNPTRC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="152">
                <commonSA:FBRef fbRevision="D">LD0_LNPTRC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="1">
                <commonSA:FBRef fbRevision="D">LD0_LNPTRC1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="152">
                <commonSA:FBRef fbRevision="D">LD0_LNPTRC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="153">
                <commonSA:FBRef fbRevision="E">LD0_PCSITPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="153">
                <commonSA:FBRef fbRevision="E">LD0_PCSITPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="153">
                <commonSA:FBRef fbRevision="E">LD0_PCSITPC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="100">
                <commonSA:FBRef fbRevision="C">LD0_INRPHAR1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="100">
                <commonSA:FBRef fbRevision="C">LD0_INRPHAR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="100">
                <commonSA:FBRef fbRevision="C">LD0_INRPHAR1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="100">
                <commonSA:FBRef fbRevision="C">LD0_INRPHAR1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="156">
                <commonSA:FBRef fbRevision="B">LD0_CBPSOF1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="156">
                <commonSA:FBRef fbRevision="B">LD0_CBPSOF1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="156">
                <commonSA:FBRef fbRevision="B">LD0_CBPSOF1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="156">
                <commonSA:FBRef fbRevision="B">LD0_CBPSOF1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="11">
                <commonSA:FBRef fbRevision="D">LD0_XGGIO100_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="11">
                <commonSA:FBRef fbRevision="D">LD0_XGGIO100_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="11">
                <commonSA:FBRef fbRevision="D">LD0_XGGIO100_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="15">
                <commonSA:FBRef fbRevision="F">LD0_LEDGGIO1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="15">
                <commonSA:FBRef fbRevision="F">LD0_LEDGGIO1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="202">
                <commonSA:FBRef fbRevision="D">LD0_GSELPRT1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="201">
                <commonSA:FBRef fbRevision="E">LD0_MMSLPRT1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="201">
                <commonSA:FBRef fbRevision="E">LD0_MMSLPRT1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="40">
                <commonSA:FBRef fbRevision="E">LD0_CMMXU1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="40">
                <commonSA:FBRef fbRevision="E">LD0_CMMXU1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="40">
                <commonSA:FBRef fbRevision="E">LD0_CMMXU1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="40">
                <commonSA:FBRef fbRevision="E">LD0_CMMXU1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="43">
                <commonSA:FBRef fbRevision="C">LD0_CSMSQI1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="43">
                <commonSA:FBRef fbRevision="C">LD0_CSMSQI1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="43">
                <commonSA:FBRef fbRevision="C">LD0_CSMSQI1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="22">
                <commonSA:FBRef fbRevision="E">LD0_PHIPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="22">
                <commonSA:FBRef fbRevision="E">LD0_PHIPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="22">
                <commonSA:FBRef fbRevision="E">LD0_PHIPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="22">
                <commonSA:FBRef fbRevision="E">LD0_PHIPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="51">
                <commonSA:FBRef fbRevision="E">LD0_CCBRBRF1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="51">
                <commonSA:FBRef fbRevision="E">LD0_CCBRBRF1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="51">
                <commonSA:FBRef fbRevision="E">LD0_CCBRBRF1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="51">
                <commonSA:FBRef fbRevision="E">LD0_CCBRBRF1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="510">
                <commonSA:FBRef fbRevision="D">LD0_MDSOPT1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="510">
                <commonSA:FBRef fbRevision="D">LD0_MDSOPT1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="510">
                <commonSA:FBRef fbRevision="D">LD0_MDSOPT1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="510">
                <commonSA:FBRef fbRevision="D">LD0_MDSOPT1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="510">
                <commonSA:FBRef fbRevision="D">LD0_MDSOPT1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="95">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="95">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="95">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="95">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="96">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="96">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="96">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="96">
                <commonSA:FBRef fbRevision="E">LD0_NSPTOC2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="560">
                <commonSA:FBRef fbRevision="C">LD0_MVGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="560">
                <commonSA:FBRef fbRevision="C">LD0_MVGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="561">
                <commonSA:FBRef fbRevision="C">LD0_MVGAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="561">
                <commonSA:FBRef fbRevision="C">LD0_MVGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="550">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="550">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="551">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="551">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="552">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="552">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="553">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="553">
                <commonSA:FBRef fbRevision="B">LD0_SRGAPC4_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="530">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="530">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="531">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="531">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="532">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="532">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="533">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC4_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="533">
                <commonSA:FBRef fbRevision="B">LD0_TONGAPC4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="540">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="540">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="541">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="541">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="542">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="542">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="543">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC4_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="543">
                <commonSA:FBRef fbRevision="B">LD0_TOFGAPC4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="520">
                <commonSA:FBRef fbRevision="C">LD0_PTGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="520">
                <commonSA:FBRef fbRevision="C">LD0_PTGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="521">
                <commonSA:FBRef fbRevision="C">LD0_PTGAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="521">
                <commonSA:FBRef fbRevision="C">LD0_PTGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="730">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="730">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="731">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="731">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="732">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="732">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="733">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC4_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="733">
                <commonSA:FBRef fbRevision="B">LD0_SCA4GAPC4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="740">
                <commonSA:FBRef fbRevision="B">LD0_MVI4GAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="237">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="237">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="237">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="237">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="238">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="238">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC2_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="238">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="238">
                <commonSA:FBRef fbRevision="F">LD0_TRPPTRC2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="110">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="110">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="110">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="110">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="111">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="111">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="111">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="111">
                <commonSA:FBRef fbRevision="C">LD0_TCSSCBR2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="501">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="501">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="502">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="502">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="503">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="503">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="504">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC4_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="504">
                <commonSA:FBRef fbRevision="C">LD0_TPGAPC4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="505">
                <commonSA:FBRef fbRevision="C">LD0_TPSGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="505">
                <commonSA:FBRef fbRevision="C">LD0_TPSGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="506">
                <commonSA:FBRef fbRevision="C">LD0_TPMGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="506">
                <commonSA:FBRef fbRevision="C">LD0_TPMGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="4">
                <commonSA:FBRef fbRevision="H1">LD0_FLTRFRC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="4">
                <commonSA:FBRef fbRevision="H1">LD0_FLTRFRC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="4">
                <commonSA:FBRef fbRevision="H1">LD0_FLTRFRC1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="159">
                <commonSA:FBRef fbRevision="D">LD0_LDPRLRC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="159">
                <commonSA:FBRef fbRevision="D">LD0_LDPRLRC1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="159">
                <commonSA:FBRef fbRevision="D">LD0_LDPRLRC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="125">
                <commonSA:FBRef fbRevision="D">LD0_SPCGAPC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="125">
                <commonSA:FBRef fbRevision="D">LD0_SPCGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="125">
                <commonSA:FBRef fbRevision="D">LD0_SPCGAPC1_Control</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="126">
                <commonSA:FBRef fbRevision="D">LD0_SPCGAPC2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="126">
                <commonSA:FBRef fbRevision="D">LD0_SPCGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="126">
                <commonSA:FBRef fbRevision="D">LD0_SPCGAPC2_Control</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="570">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="570">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="570">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="570">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="571">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="571">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="571">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="571">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="572">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC3_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="572">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="572">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC3_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="572">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC3_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="573">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC4_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="573">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="573">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC4_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="573">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC4_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="574">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC5_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="574">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC5_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="574">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC5_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="574">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC5_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="575">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC6_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="575">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC6_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="575">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC6_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="575">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC6_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="576">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC7_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="576">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC7_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="576">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC7_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="576">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC7_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="577">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC8_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="577">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC8_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="577">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC8_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="577">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC8_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="578">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC9_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="578">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC9_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="578">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC9_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="578">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC9_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="579">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC10_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="579">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC10_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="579">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC10_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="579">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC10_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="680">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC11_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="680">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC11_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="680">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC11_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="680">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC11_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="681">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC12_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="681">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC12_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="681">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC12_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="681">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC12_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="682">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC13_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="682">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC13_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="682">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC13_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="682">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC13_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="683">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC14_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="683">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC14_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="683">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC14_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="683">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC14_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="684">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC15_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="684">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC15_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="684">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC15_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="684">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC15_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="711">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC16_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="711">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC16_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="711">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC16_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="711">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC16_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="712">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC17_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="712">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC17_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="712">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC17_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="712">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC17_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="713">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC18_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="713">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC18_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="713">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC18_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="713">
                <commonSA:FBRef fbRevision="C">LD0_MAPGAPC18_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="30">
                <commonSA:FBRef fbRevision="F">LD0_IL1TCTR1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="30">
                <commonSA:FBRef fbRevision="F">LD0_IL1TCTR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="31">
                <commonSA:FBRef fbRevision="D">LD0_RESTCTR1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="31">
                <commonSA:FBRef fbRevision="D">LD0_RESTCTR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="10">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO120_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="10">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO120_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="10">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO120_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="33">
                <commonSA:FBRef fbRevision="F">LD0_UL1TVTR1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="33">
                <commonSA:FBRef fbRevision="F">LD0_UL1TVTR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="32">
                <commonSA:FBRef fbRevision="E">LD0_RESTVTR1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="32">
                <commonSA:FBRef fbRevision="E">LD0_RESTVTR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="44">
                <commonSA:FBRef fbRevision="D">LD0_VMMXU1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="44">
                <commonSA:FBRef fbRevision="D">LD0_VMMXU1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="44">
                <commonSA:FBRef fbRevision="D">LD0_VMMXU1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="114">
                <commonSA:FBRef fbRevision="C">LD0_VSMSQI1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="114">
                <commonSA:FBRef fbRevision="C">LD0_VSMSQI1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="114">
                <commonSA:FBRef fbRevision="C">LD0_VSMSQI1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="41">
                <commonSA:FBRef fbRevision="E">LD0_RESVMMXU1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="41">
                <commonSA:FBRef fbRevision="E">LD0_RESVMMXU1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="41">
                <commonSA:FBRef fbRevision="E">LD0_RESVMMXU1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="38">
                <commonSA:FBRef fbRevision="F">LD0_UL1TVTR2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="38">
                <commonSA:FBRef fbRevision="F">LD0_UL1TVTR2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="160">
                <commonSA:FBRef fbRevision="C">LD0_XAGGIO130_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="160">
                <commonSA:FBRef fbRevision="C">LD0_XAGGIO130_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="160">
                <commonSA:FBRef fbRevision="C">LD0_XAGGIO130_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="314">
                <commonSA:FBRef fbRevision="C">LD0_XARGGIO130_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="314">
                <commonSA:FBRef fbRevision="C">LD0_XARGGIO130_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="314">
                <commonSA:FBRef fbRevision="C">LD0_XARGGIO130_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="17">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO110_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="17">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO110_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="17">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO110_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="17">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO110_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="17">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO110_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="18">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO130_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="18">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO130_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="18">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO130_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="18">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO130_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="18">
                <commonSA:FBRef fbRevision="E">LD0_XGGIO130_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="16">
                <commonSA:FBRef fbRevision="F">LD0_XGGIO90_Information</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="708">
                <commonSA:FBRef fbRevision="A">LD0_SERLCCH1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="708">
                <commonSA:FBRef fbRevision="A">LD0_SERLCCH1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="709">
                <commonSA:FBRef fbRevision="A">LD0_SERLCCH2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="709">
                <commonSA:FBRef fbRevision="A">LD0_SERLCCH2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="700">
                <commonSA:FBRef fbRevision="A">LD0_RCHLCCH1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="700">
                <commonSA:FBRef fbRevision="A">LD0_RCHLCCH1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="704">
                <commonSA:FBRef fbRevision="A">LD0_SCHLCCH1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="704">
                <commonSA:FBRef fbRevision="A">LD0_SCHLCCH1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="705">
                <commonSA:FBRef fbRevision="A">LD0_SCHLCCH2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="705">
                <commonSA:FBRef fbRevision="A">LD0_SCHLCCH2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="706">
                <commonSA:FBRef fbRevision="A">LD0_SCHLCCH3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="706">
                <commonSA:FBRef fbRevision="A">LD0_SCHLCCH3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="701">
                <commonSA:FBRef fbRevision="A1">MU01_LLN0_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="205">
                <commonSA:FBRef fbRevision="C">LD0_I3CLPRT1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="205">
                <commonSA:FBRef fbRevision="C">LD0_I3CLPRT1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="750">
                <commonSA:FBRef fbRevision="C">LD0_I3CLPRT2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="750">
                <commonSA:FBRef fbRevision="C">LD0_I3CLPRT2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="203">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="203">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="84">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="84">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="85">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="85">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="86">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT4_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="86">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="87">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT5_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="87">
                <commonSA:FBRef fbRevision="D">LD0_DNPLPRT5_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="200">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="200">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="254">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="254">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="255">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT3_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="255">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="256">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT4_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="256">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="257">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT5_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="257">
                <commonSA:FBRef fbRevision="F">LD0_MBSLPRT5_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="137">
                <commonSA:FBRef fbRevision="E">LD0_DPHHPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="137">
                <commonSA:FBRef fbRevision="E">LD0_DPHHPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="137">
                <commonSA:FBRef fbRevision="E">LD0_DPHHPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="137">
                <commonSA:FBRef fbRevision="E">LD0_DPHHPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="135">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="135">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="135">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="135">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="136">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="136">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="136">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="136">
                <commonSA:FBRef fbRevision="E">LD0_DPHLPTOC2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="79">
                <commonSA:FBRef fbRevision="E">LD0_INTRPTEF1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="79">
                <commonSA:FBRef fbRevision="E">LD0_INTRPTEF1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="79">
                <commonSA:FBRef fbRevision="E">LD0_INTRPTEF1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="79">
                <commonSA:FBRef fbRevision="E">LD0_INTRPTEF1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="8">
                <commonSA:FBRef fbRevision="F">LD0_EFHPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="8">
                <commonSA:FBRef fbRevision="F">LD0_EFHPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="8">
                <commonSA:FBRef fbRevision="F">LD0_EFHPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="8">
                <commonSA:FBRef fbRevision="F">LD0_EFHPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="80">
                <commonSA:FBRef fbRevision="D">LD0_PDNSPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="80">
                <commonSA:FBRef fbRevision="D">LD0_PDNSPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="80">
                <commonSA:FBRef fbRevision="D">LD0_PDNSPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="80">
                <commonSA:FBRef fbRevision="D">LD0_PDNSPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="90">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="90">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="90">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="90">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="91">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="91">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="91">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="91">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="92">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV3_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="92">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="92">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV3_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="92">
                <commonSA:FBRef fbRevision="D">LD0_ROVPTOV3_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="144">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="144">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="144">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="144">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="145">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="145">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="145">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="145">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="146">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV3_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="146">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="146">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV3_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="146">
                <commonSA:FBRef fbRevision="D">LD0_PHPTUV3_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="140">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="140">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="140">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="140">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="141">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="141">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="141">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="141">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="142">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV3_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="142">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="142">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV3_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="142">
                <commonSA:FBRef fbRevision="D">LD0_PHPTOV3_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="73">
                <commonSA:FBRef fbRevision="D">LD0_PSPTUV1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="73">
                <commonSA:FBRef fbRevision="D">LD0_PSPTUV1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="73">
                <commonSA:FBRef fbRevision="D">LD0_PSPTUV1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="73">
                <commonSA:FBRef fbRevision="D">LD0_PSPTUV1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="72">
                <commonSA:FBRef fbRevision="D">LD0_NSPTOV1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="72">
                <commonSA:FBRef fbRevision="D">LD0_NSPTOV1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="72">
                <commonSA:FBRef fbRevision="D">LD0_NSPTOV1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="72">
                <commonSA:FBRef fbRevision="D">LD0_NSPTOV1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="180">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="180">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="180">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="180">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="181">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="181">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="181">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="181">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="182">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC3_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="182">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="182">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC3_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="182">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC3_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="183">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC4_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="183">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC4_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="183">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC4_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="183">
                <commonSA:FBRef fbRevision="D">LD0_FRPTRC4_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="14">
                <commonSA:FBRef fbRevision="F">LD0_T1PTTR1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="14">
                <commonSA:FBRef fbRevision="F">LD0_T1PTTR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="14">
                <commonSA:FBRef fbRevision="F">LD0_T1PTTR1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="14">
                <commonSA:FBRef fbRevision="F">LD0_T1PTTR1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="14">
                <commonSA:FBRef fbRevision="F">LD0_T1PTTR1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="133">
                <commonSA:FBRef fbRevision="D">LD0_T2PTTR1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="133">
                <commonSA:FBRef fbRevision="D">LD0_T2PTTR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="133">
                <commonSA:FBRef fbRevision="D">LD0_T2PTTR1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="133">
                <commonSA:FBRef fbRevision="D">LD0_T2PTTR1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="133">
                <commonSA:FBRef fbRevision="D">LD0_T2PTTR1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="52">
                <commonSA:FBRef fbRevision="F">LD0_SSCBR1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="52">
                <commonSA:FBRef fbRevision="F">LD0_SSCBR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="52">
                <commonSA:FBRef fbRevision="F">LD0_SSCBR1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="52">
                <commonSA:FBRef fbRevision="F">LD0_SSCBR1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="52">
                <commonSA:FBRef fbRevision="F">LD0_SSCBR1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="155">
                <commonSA:FBRef fbRevision="D">LD0_SEQSPVC1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="155">
                <commonSA:FBRef fbRevision="D">LD0_SEQSPVC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="155">
                <commonSA:FBRef fbRevision="D">LD0_SEQSPVC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="155">
                <commonSA:FBRef fbRevision="D">LD0_SEQSPVC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="42">
                <commonSA:FBRef fbRevision="E">LD0_RESCMMXU1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="42">
                <commonSA:FBRef fbRevision="E">LD0_RESCMMXU1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="42">
                <commonSA:FBRef fbRevision="E">LD0_RESCMMXU1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="42">
                <commonSA:FBRef fbRevision="E">LD0_RESCMMXU1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="116">
                <commonSA:FBRef fbRevision="D">LD0_PEMMXU1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="116">
                <commonSA:FBRef fbRevision="D">LD0_PEMMXU1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="116">
                <commonSA:FBRef fbRevision="D">LD0_PEMMXU1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="116">
                <commonSA:FBRef fbRevision="D">LD0_PEMMXU1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="116">
                <commonSA:FBRef fbRevision="D">LD0_PEMMXU1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="45">
                <commonSA:FBRef fbRevision="B">LD0_FMMXU1_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="45">
                <commonSA:FBRef fbRevision="B">LD0_FMMXU1_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="45">
                <commonSA:FBRef fbRevision="B">LD0_FMMXU1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="120">
                <commonSA:FBRef fbRevision="C">LD0_PHIZ1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="120">
                <commonSA:FBRef fbRevision="C">LD0_PHIZ1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="120">
                <commonSA:FBRef fbRevision="C">LD0_PHIZ1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="120">
                <commonSA:FBRef fbRevision="C">LD0_PHIZ1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="192">
                <commonSA:FBRef fbRevision="C">LD0_SECRSYN1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="192">
                <commonSA:FBRef fbRevision="C">LD0_SECRSYN1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="192">
                <commonSA:FBRef fbRevision="C">LD0_SECRSYN1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="192">
                <commonSA:FBRef fbRevision="C">LD0_SECRSYN1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="39">
                <commonSA:FBRef fbRevision="D">LD0_VMMXU2_Measurements</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="39">
                <commonSA:FBRef fbRevision="D">LD0_VMMXU2_Configuration</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="39">
                <commonSA:FBRef fbRevision="D">LD0_VMMXU2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="53">
                <commonSA:FBRef fbRevision="F">LD0_DARREC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="53">
                <commonSA:FBRef fbRevision="F">LD0_DARREC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="53">
                <commonSA:FBRef fbRevision="F">LD0_DARREC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="53">
                <commonSA:FBRef fbRevision="F">LD0_DARREC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="53">
                <commonSA:FBRef fbRevision="F">LD0_DARREC1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="197">
                <commonSA:FBRef fbRevision="D">LD0_CMHAI1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="197">
                <commonSA:FBRef fbRevision="D">LD0_CMHAI1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="197">
                <commonSA:FBRef fbRevision="D">LD0_CMHAI1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="198">
                <commonSA:FBRef fbRevision="C">LD0_VMHAI1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="198">
                <commonSA:FBRef fbRevision="C">LD0_VMHAI1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="198">
                <commonSA:FBRef fbRevision="C">LD0_VMHAI1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="195">
                <commonSA:FBRef fbRevision="D">LD0_PH1QVVR1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="195">
                <commonSA:FBRef fbRevision="D">LD0_PH1QVVR1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="195">
                <commonSA:FBRef fbRevision="D">LD0_PH1QVVR1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="195">
                <commonSA:FBRef fbRevision="D">LD0_PH1QVVR1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="195">
                <commonSA:FBRef fbRevision="D">LD0_PH1QVVR1__EVENTS_</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="195">
                <commonSA:FBRef fbRevision="D">LD0_PH1QVVR1_Monitoring_1_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="196">
                <commonSA:FBRef fbRevision="C">LD0_VSQVUB1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="196">
                <commonSA:FBRef fbRevision="C">LD0_VSQVUB1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="196">
                <commonSA:FBRef fbRevision="C">LD0_VSQVUB1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="196">
                <commonSA:FBRef fbRevision="C">LD0_VSQVUB1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="196">
                <commonSA:FBRef fbRevision="C">LD0_VSQVUB1_Monitoring_1_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="88">
                <commonSA:FBRef fbRevision="B">LD0_SCEFRFLO1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="88">
                <commonSA:FBRef fbRevision="B">LD0_SCEFRFLO1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="88">
                <commonSA:FBRef fbRevision="B">LD0_SCEFRFLO1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="88">
                <commonSA:FBRef fbRevision="B">LD0_SCEFRFLO1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="88">
                <commonSA:FBRef fbRevision="B">LD0_SCEFRFLO1__EVENTS_</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="88">
                <commonSA:FBRef fbRevision="B">LD0_SCEFRFLO1_Monitoring_1_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="88">
                <commonSA:FBRef fbRevision="B">LD0_SCEFRFLO1_Clear</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="89">
                <commonSA:FBRef fbRevision="C">LD0_HAEFPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="89">
                <commonSA:FBRef fbRevision="C">LD0_HAEFPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="89">
                <commonSA:FBRef fbRevision="C">LD0_HAEFPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="89">
                <commonSA:FBRef fbRevision="C">LD0_HAEFPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="6">
                <commonSA:FBRef fbRevision="F">LD0_DEFHPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="6">
                <commonSA:FBRef fbRevision="F">LD0_DEFHPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="6">
                <commonSA:FBRef fbRevision="F">LD0_DEFHPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="6">
                <commonSA:FBRef fbRevision="F">LD0_DEFHPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="5">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="5">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="5">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="5">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="27">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="27">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="27">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="27">
                <commonSA:FBRef fbRevision="F">LD0_DEFLPTOC2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="74">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="74">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="74">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="74">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="75">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="75">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="75">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="75">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="76">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM3_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="76">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="76">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM3_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="76">
                <commonSA:FBRef fbRevision="E">LD0_EFPADM3_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="77">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE1_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="77">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE1_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="77">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE1_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="77">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE1_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="78">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE2_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="78">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE2_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="78">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE2_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="78">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE2_Tests</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="251">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE3_Settings</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="251">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE3_Monitoring</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="251">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE3_Monitoring_1</commonSA:FBRef>
              </commonSA:Component>
              <commonSA:Component id="251">
                <commonSA:FBRef fbRevision="C">LD0_WPSDE3_Tests</commonSA:FBRef>
              </commonSA:Component>
            </commonSA:Components>
          </commonSA:Application>
        </commonSA:Object>
      </commonSA:SAObjects>
    </Private>
    <Services>
      <DynAssociation max="5"/>
      <SettingGroups>
        <SGEdit/>
        <ConfSG/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="14" maxAttributes="80"/>
      <ReadWrite/>
      <ConfReportControl max="50" bufConf="true" bufMode="both"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Conf" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf"/>
      <SMVSettings>
        <SmpRate>80</SmpRate>
      </SMVSettings>
      <GOOSE max="4"/>
      <SMVsc max="1"/>
      <FileHandling ftp="true" ftps="true"/>
      <ConfLNs fixLnInst="true" fixPrefix="true"/>
      <ClientServices goose="true" sv="true">
        <TimeSyncProt c37_238="true"/>
      </ClientServices>
      <RedProt hsr="true" prp="true"/>
      <CommProt/>
    </Services>
    <AccessPoint name="AP1">
      <Server>
        <Authentication/>
        <LDevice desc="Protection" inst="LD0">
          <LN0 desc="Protection LLN0" lnType="LLN0_REX61X_ED2_G3_6" inst="" lnClass="LLN0">
            <Private type="ABB_CommonSA_FunctionInstanceRef">1</Private>
            <Private type="ABB_FunctionRefs">d4c9d90d-bff5-4a4e-b68c-145d48211195,38463429-0190-4d69-9df5-0d4221a0b68f,b1418c11-d66b-4b13-9192-f4489f50c19b,1cf9e975-711e-4922-964f-d78370ffc159,1fe6ce73-d312-40b5-ae0f-1ec920f2e34b,b5195d72-f44e-4806-ac19-8ad652138028</Private>
            <DataSet name="StatUrg">
              <Private source="1670266533596" type="HELINKS_TAG"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N"/>
            </DataSet>
            <DataSet name="StatIed">
              <Private source="1670273751557" type="HELINKS_TAG"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1"/>
              <FCDA doName="Str" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2"/>
              <FCDA doName="Str" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3"/>
              <FCDA doName="Str" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3"/>
            </DataSet>
            <DataSet name="StatIo">
              <Private source="1670273751557" type="HELINKS_TAG"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1"/>
              <FCDA doName="Str" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2"/>
              <FCDA doName="Str" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2"/>
              <FCDA doName="Op" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3"/>
              <FCDA doName="Str" fc="ST" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3"/>
            </DataSet>
            <DataSet name="StatNrml">
              <Private source="1670273751558" type="HELINKS_TAG"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N"/>
              <FCDA doName="VolSv" fc="MX" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N"/>
            </DataSet>
            <DataSet name="ds_gcb_f1">
              <Private source="1670273751872" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="Op" fc="ST" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS"/>
              <FCDA daName="q" doName="Op" fc="ST" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS"/>
            </DataSet>
            <ReportControl datSet="StatIed" name="brcba" intgPd="100" buffered="true" bufTime="100" confRev="10000" indexed="false" rptID="E01BPULD0/LLN0.brcba">
              <Private source="1670273751557" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751557" type="HELINKS_TAG"/>
                <ClientLN apRef="S1" iedName="Zenon" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="StatIo" name="brcbb" intgPd="100" buffered="true" bufTime="100" confRev="10000" indexed="false" rptID="E01BPULD0/LLN0.brcbb">
              <Private source="1670273751557" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751557" type="HELINKS_TAG"/>
                <ClientLN apRef="AP1" iedName="XPG" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="StatUrg" name="urcba" intgPd="100" buffered="false" bufTime="100" confRev="10000" indexed="false" rptID="E01BPULD0/LLN0.urcba">
              <Private source="1670273751558" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751558" type="HELINKS_TAG"/>
                <ClientLN apRef="S1" iedName="Zenon" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="StatNrml" name="urcbb" intgPd="100" buffered="false" bufTime="100" confRev="10000" indexed="false" rptID="E01BPULD0/LLN0.urcbb">
              <Private source="1670273751558" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1670273751558" type="HELINKS_TAG"/>
                <ClientLN apRef="AP1" iedName="XPG" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <DOI desc="Test mode" name="Mod">
              <DAI name="stVal" sAddr="MBS02,DA00,DA00,1,128,1,2,129,1,3,130,1,4,131,1,5,132,1,6,133,1,10,9001,120,11,9201,1,12,9211,1,13,9251,1,14,9401,1,15,8001,1;MBS01,DA00,DA00,1,128,1,2,129,1,3,130,1,4,131,1,5,132,1,6,133,1,10,9001,120,11,9201,1,12,9211,1,13,9251,1,14,9401,1,15,8001,1;I3C,DA00,DA00,DEV,DEV,10,236,10,237,-1,-1"/>
            </DOI>
            <DOI desc="Behaviour" name="Beh">
              <DAI name="stVal" sAddr="I3C,DA02,DA02,1,0,21,1,0,21,-1,0,1,0,TestMode,1,2,3,4,-1,-1"/>
            </DOI>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="vendor">
                <Val>ABB</Val>
              </DAI>
              <DAI name="swRev">
                <Val>G</Val>
              </DAI>
              <DAI name="d">
                <Val>Protection LLN0 Name plate</Val>
              </DAI>
              <DAI desc="ABB PCM600: Checksum for the logical device instance and the logical node names and types" name="configRev">
                <Val>16233407</Val>
              </DAI>
              <DAI name="ldNs">
                <Val>IEC 61850-7-4:2007</Val>
              </DAI>
            </DOI>
            <DOI desc="Indications and LEDs" name="IndLEDRs">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,2060,0,2,0,,0,0,0;MBS01,DA10,DA10,0,2060,0,2,0,,0,0,0;I3C,DA02,DA02,1,0,19,20,0,19,-1,0,20,0,,9,1,0,1,-1;DNP02,10,-1,0,0,0,BO-SP,0,1,0;DNP01,10,-1,0,0,0,BO-SP,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>Protection LLN0 Indications and LEDs</Val>
              </DAI>
            </DOI>
            <DOI desc="Programmable LEDs" name="ProgLEDRs">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,2061,0,2,1,,0,0,0;MBS01,DA10,DA10,0,2061,0,2,1,,0,0,0;I3C,DA02,DA02,1,10,21,20,10,21,-1,0,20,0,,9,1,0,1,-1;DNP02,10,-1,0,0,0,BO-SP,0,1,0;DNP01,10,-1,0,0,0,BO-SP,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>Protection LLN0 Programmable LEDs</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset minimum and maximum demands" name="MeasStatRs">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,0,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-SP,0,1,0;DNP01,10,-1,0,0,0,BO-SP,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>Protection LLN0 Reset minimum and maximum demands</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset all power quality data" name="PQRs">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,0,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-SP,0,1,0;DNP01,10,-1,0,0,0,BO-SP,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>Protection LLN0 Reset all power quality data</Val>
              </DAI>
            </DOI>
            <DOI desc="Operation mode for setting group change" name="OpModSetGr"/>
            <DOI desc="Active setting group" name="ActSetGr">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA11,DA11,8,1,0,10,2301,,0;MBS01,DA11,DA11,8,1,0,10,2301,,0;DNP02,40,-1,0,16,0,0,0,0,1,1,6,1,6,AO SGroup;DNP01,40,-1,0,16,0,0,0,0,1,1,6,1,6,AO SGroup"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,2301,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,2301,,-1,0,0,0,0,0,0,0,0;I3C,DA02,DA02,1,0,23,23,0,23,-1,0,23,0,SG1,1,1,1,1,-1;I3C,DA02,DA02,1,0,24,23,0,24,-1,0,23,0,SG2,1,1,2,2,-1;I3C,DA02,DA02,1,0,25,23,0,25,-1,0,23,0,SG3,1,1,3,3,-1;I3C,DA02,DA02,1,0,26,23,0,26,-1,0,23,0,SG4,1,1,4,4,-1;I3C,DA02,DA02,1,0,27,23,0,27,-1,0,23,0,SG5,1,1,5,5,-1;I3C,DA02,DA02,1,0,28,23,0,28,-1,0,23,0,SG6,1,1,6,6,-1;DNP02,30,-1,0,5,0,0,0,0,1,0,10,0,10,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,10,0,10,AI-EvUpd,0"/>
              <DAI name="minVal">
                <Val>1</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>6</Val>
              </DAI>
              <DAI name="d">
                <Val>Protection LLN0 Active setting group</Val>
              </DAI>
            </DOI>
            <DOI desc="Active setting group 1" name="Act1SetGr">
              <DAI name="d">
                <Val>Protection LLN0 Active setting group 1</Val>
              </DAI>
            </DOI>
            <DOI desc="Active setting group 2" name="Act2SetGr">
              <DAI name="d">
                <Val>Protection LLN0 Active setting group 2</Val>
              </DAI>
            </DOI>
            <DOI desc="Active setting group 3" name="Act3SetGr">
              <DAI name="d">
                <Val>Protection LLN0 Active setting group 3</Val>
              </DAI>
            </DOI>
            <DOI desc="Active setting group 4" name="Act4SetGr">
              <DAI name="d">
                <Val>Protection LLN0 Active setting group 4</Val>
              </DAI>
            </DOI>
            <DOI desc="Active setting group 5" name="Act5SetGr">
              <DAI name="d">
                <Val>Protection LLN0 Active setting group 5</Val>
              </DAI>
            </DOI>
            <DOI desc="Active setting group 6" name="Act6SetGr">
              <DAI name="d">
                <Val>Protection LLN0 Active setting group 6</Val>
              </DAI>
            </DOI>
            <DOI desc="Logic selection for setting group" name="LgcSelSetGr">
              <DAI name="d">
                <Val>Protection LLN0 Logic selection for setting group</Val>
              </DAI>
            </DOI>
            <DOI desc="SMV Max Delay" name="SetSvMaxDl"/>
            <DOI desc="Max Delay" name="SvMaxDl">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>s</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>m</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>Protection LLN0 Max Delay</Val>
              </DAI>
            </DOI>
            <DOI desc="Average delay" name="SvAvDl">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>s</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>m</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>Protection LLN0 Average delay</Val>
              </DAI>
            </DOI>
            <DOI desc="Number of setting changes" name="ParChgCnt">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,65535,0,65535,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,65535,0,65535,AI-Static,0"/>
            </DOI>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_f1" name="gcb_f1" confRev="10000" appID="E01BPULD0/LLN0gcb_f1" securityEnable="None">
              <Private source="1670273751872" type="HELINKS_TAG"/>
              <IEDName apRef="SAM600ServerModel" ldInst="Trip" lnClass="PTRC" lnInst="1" prefix="Trip">E01PIU</IEDName>
            </GSEControl>
            <SettingControl desc="Setting groups are centrally managed" numOfSGs="6"/>
          </LN0>
          <LN desc="Physical device" lnType="LPHD_REX61X_ED2_G3_6" inst="1" lnClass="LPHD">
            <Private type="ABB_CommonSA_FunctionInstanceRef">1</Private>
            <Private type="ABB_FunctionRefs">b5195d72-f44e-4806-ac19-8ad652138028</Private>
            <DOI desc="General info" name="PhyNam">
              <DAI name="vendor">
                <Val>ABB</Val>
              </DAI>
              <DAI name="model">
                <Val>RED615</Val>
              </DAI>
            </DOI>
            <DOI desc="General state" name="PhyHealth">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,10,0,10,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,10,0,10,AI-EvUpd,0"/>
            </DOI>
            <DOI desc="Proxy" name="Proxy">
              <DAI name="d">
                <Val>Physical device Proxy</Val>
              </DAI>
            </DOI>
            <DOI desc="Number of Power ups" name="NumPwrUp">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,2054,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,2054,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0"/>
            </DOI>
            <DOI desc="Number of Warm starts" name="WrmStr">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,2055,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,2055,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0"/>
            </DOI>
            <DOI desc="Number of watchdog device resets detected" name="WacTrg">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,2056,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,2056,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0"/>
            </DOI>
            <DOI desc="Power up detected" name="PwrUp">
              <DAI name="d">
                <Val>Physical device Power up detected</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Customer information" lnType="LINF_REX61X_ED2_G3_6" inst="1" lnClass="LINF">
            <Private type="ABB_CommonSA_FunctionInstanceRef">1</Private>
            <Private type="ABB_FunctionRefs">b5195d72-f44e-4806-ac19-8ad652138028</Private>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="swRev">
                <Val>G</Val>
              </DAI>
              <DAI name="d">
                <Val>Customer information Name plate</Val>
              </DAI>
            </DOI>
            <DOI desc="Name of the bay" name="BayNam"/>
            <DOI desc="IED configuration name" name="CfgNam"/>
            <DOI desc="Product version number" name="DevRev"/>
            <DOI desc="Name of the customer" name="CstNam"/>
            <DOI desc="Name of the state" name="CstStNam"/>
            <DOI desc="Name of the street" name="CstStreNam"/>
            <DOI desc="Number of the house" name="CstHouNum"/>
            <DOI desc="ZIP/Postal code" name="CstZip"/>
            <DOI desc="City/Province" name="CstCityNam"/>
            <DOI desc="Name of the country" name="CstCntyNam"/>
            <DOI desc="Card information" name="CardNam">
              <DAI name="vendor">
                <Val>ABB</Val>
              </DAI>
            </DOI>
            <DOI desc="Testing" name="TestStaId"/>
            <DOI desc="HW module" name="HwId"/>
          </LN>
          <LN desc="Device" lnType="LDEV_REX61X_ED2_G3_6" inst="1" lnClass="LDEV">
            <Private type="ABB_CommonSA_FunctionInstanceRef">1</Private>
            <Private type="ABB_FunctionRefs">b5195d72-f44e-4806-ac19-8ad652138028</Private>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="swRev">
                <Val>G</Val>
              </DAI>
              <DAI name="d">
                <Val>Device Name plate</Val>
              </DAI>
            </DOI>
            <DOI desc="IP address for rear port(s)" name="IPAddr"/>
            <DOI desc="Subnet mask for rear port(s)" name="IPAddrSubNtw"/>
            <DOI desc="Default gateway for rear port(s)" name="IPAddrGtw"/>
            <DOI desc="IP address for front port (fixed)" name="IPAddrFrt"/>
            <DOI desc="Mac address for rear port(s)" name="Mac1"/>
            <DOI desc="Mac address for front port" name="Mac2"/>
            <DOI desc="SW" name="SwrNum"/>
            <DOI desc="Order number" name="OrdrNum"/>
            <DOI desc="Warm start detected" name="WrmStrDet">
              <DAI name="d">
                <Val>Device Warm start detected</Val>
              </DAI>
            </DOI>
            <DOI desc="Watchdog reset detected" name="WacTrgDet">
              <DAI name="d">
                <Val>Device Watchdog reset detected</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning" name="DevWrn">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,2050,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,2050,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0"/>
              <DAI name="d">
                <Val>Device Warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Internal Fault" name="DevFail">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,2051,,-1,0,0,0,0,0,0,0,0;MBS02,DA02,DA02,0,1B,-5,IRF,0,0,1,1,1;MBS01,DA07,DA07,0,16,0,8,1,0,18,2051,,-1,0,0,0,0,0,0,0,0;MBS01,DA02,DA02,0,1B,-5,IRF,0,0,1,1,1;I3C,DA02,DA02,1,10,100,1,10,100,-1,0,1,0,IRF,2,1,1,-1,-1;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,IRF-signal BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,IRF-signal BI-EvUpd,1,1,1"/>
            </DOI>
            <DOI desc="Status overflow" name="StLstOv">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Device Status overflow</Val>
              </DAI>
            </DOI>
            <DOI desc="Meas overflow" name="MeasLstOv">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Device Meas overflow</Val>
              </DAI>
            </DOI>
            <DOI desc="Number of composition changes" name="ChgAckCnt">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,2057,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,2057,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0"/>
            </DOI>
            <DOI desc="Composition has changed" name="ChgFlg">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="maxVal">
                <Val>15</Val>
              </DAI>
              <DAI name="d">
                <Val>Device Composition has changed</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset device" name="WrmStrCmd">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,2080,0,3,0,,0,0,0;MBS01,DA10,DA10,0,2080,0,3,0,,0,0,0;DNP02,10,-1,0,0,0,BO-SP,0,1,0;DNP01,10,-1,0,0,0,BO-SP,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>Device Reset device</Val>
              </DAI>
            </DOI>
            <DOI desc="Internal fault test" name="FailTest">
              <DAI name="d">
                <Val>Device Internal fault test</Val>
              </DAI>
            </DOI>
            <DOI desc="Global blocking mode selection" name="BlkMod"/>
            <DOI desc="Rated frequency" name="HzSetSel"/>
            <DOI desc="Phase rotation order" name="PhRotSet"/>
            <DOI desc="Threshold voltage" name="DiVThres">
              <DAI name="minVal">
                <Val>16</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>176</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>2</Val>
              </DAI>
            </DOI>
            <DOI desc="Input osc. level" name="DiOscThres">
              <DAI name="minVal">
                <Val>2</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>50</Val>
              </DAI>
            </DOI>
            <DOI desc="Input osc. hyst" name="DiOscHys">
              <DAI name="minVal">
                <Val>2</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>50</Val>
              </DAI>
            </DOI>
            <DOI desc="Settings reservation" name="SetSeld">
              <DAI name="d">
                <Val>Device Settings reservation</Val>
              </DAI>
            </DOI>
            <DOI desc="Settings change" name="SetChg">
              <DAI name="d">
                <Val>Device Settings change</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase connection order" name="PhOrdMod"/>
            <DOI desc="Overcurrent IDMT saturation point" name="ACrvSatPnt">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>50</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="A demand Av mode" name="ADmdAvMod"/>
            <DOI desc="Demand interval" name="MtrDmdItrv"/>
            <DOI desc="Frequency adaptivity" name="HzAdpEna"/>
            <DOI desc="Authority for remote activation of test mode" name="ModRemCtl"/>
            <DOI desc="Language selection" name="LangSel"/>
            <DOI desc="Contrast selection" name="Contr">
              <DAI name="minVal">
                <Val>1</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>255</Val>
              </DAI>
            </DOI>
            <DOI desc="NUMf" name="NumFrm">
              <DAI name="setVal">
                <Val>1</Val>
              </DAI>
              <DAI name="minVal">
                <Val>1</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>2</Val>
              </DAI>
            </DOI>
            <DOI desc="Backligth timeout" name="LgtLivTm">
              <DAI name="minVal">
                <Val>1</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60</Val>
              </DAI>
            </DOI>
            <DOI desc="Time format" name="TmFrm"/>
            <DOI desc="Date format" name="DateFrm"/>
            <DOI desc="FB naming convention" name="NamConvn"/>
            <DOI desc="Default view" name="DftVw"/>
            <DOI desc="Web HMI mode" name="AcsMod"/>
            <DOI desc="Web HMI timeout" name="ConnExpTm">
              <DAI name="minVal">
                <Val>1</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60</Val>
              </DAI>
            </DOI>
            <DOI desc="Event clear" name="EvtLstClr">
              <DAI name="d">
                <Val>Device Event clear</Val>
              </DAI>
            </DOI>
            <DOI desc="SLD symbol format" name="SLDSymFrm"/>
            <DOI desc="Autoscroll delay" name="ScrDlTms">
              <DAI name="maxVal">
                <Val>30</Val>
              </DAI>
            </DOI>
            <DOI desc="CB close delay mode" name="ClsDlMod"/>
            <DOI desc="CB close delay" name="ClsDlTms">
              <DAI name="minVal">
                <Val>5</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>900</Val>
              </DAI>
            </DOI>
            <DOI desc="Setting visibility" name="SetVsb"/>
            <DOI desc="Frequency adaptivity status" name="HzAdpFail">
              <DAI name="d">
                <Val>Device Frequency adaptivity status</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Security application" lnType="GSAL_REX61X_ED2_H_9" inst="1" lnClass="GSAL">
            <Private type="ABB_CommonSA_FunctionInstanceRef">379</Private>
            <Private type="ABB_FunctionRefs">57a392eb-2bbd-4081-aef8-ebd377647742</Private>
            <DOI desc="Resetable Security Violations counter" name="OpCntRs">
              <DAI name="d">
                <Val>Security application Resetable Security Violations counter</Val>
              </DAI>
            </DOI>
            <DOI desc="Number of counter resets" name="NumCntRs"/>
            <DOI desc="Remote authorization" name="AuthRem"/>
            <DOI desc="Viewer access" name="AuthAcsVw">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0"/>
              <DAI name="d">
                <Val>VIEWER</Val>
              </DAI>
            </DOI>
            <DOI desc="Operator access" name="AuthAcsOpr">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0"/>
              <DAI name="d">
                <Val>OPERATOR</Val>
              </DAI>
            </DOI>
            <DOI desc="Engineer access" name="AuthAcsEng">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0"/>
              <DAI name="d">
                <Val>ENGINEER</Val>
              </DAI>
            </DOI>
            <DOI desc="Administrator access" name="AuthAcsAdm">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0"/>
              <DAI name="d">
                <Val>ADMINISTRATOR</Val>
              </DAI>
            </DOI>
            <DOI desc="Logging level" name="AuthAcsLev"/>
            <DOI desc="Remote Update Enable" name="RemUpdEna"/>
            <DOI desc="Remote authorization (administrator)" name="AuthRemAdm"/>
            <DOI desc="Remote authorization (engineer)" name="AuthRemEng"/>
            <DOI desc="Remote authorization (operator)" name="AuthRemOpr"/>
            <DOI desc="Remote authorization (viewer)" name="AuthRemVw"/>
          </LN>
          <LN desc="Device" lnType="IHMI_REX61X_ED2_H_3" inst="1" lnClass="IHMI">
            <Private type="ABB_CommonSA_FunctionInstanceRef">380</Private>
            <Private type="ABB_FunctionRefs">41185bcd-af60-4a0a-9f5e-c2ef66e65ed1</Private>
            <DOI desc="Card information" name="CardNam">
              <DAI name="vendor">
                <Val>ABB</Val>
              </DAI>
            </DOI>
            <DOI desc="Testing" name="TestStaId"/>
            <DOI desc="HW module" name="HwId"/>
          </LN>
          <LN desc="CCSPVC1" lnType="CCSPVC1_ED2_D_9" inst="1" lnClass="SPVC" prefix="CC">
            <Private type="ABB_CommonSA_FunctionInstanceRef">154</Private>
            <Private type="ABB_FunctionRefs">4c74ae3a-11c2-4bbb-bd5b-481c74305e1d</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="swRev">
                <Val>D</Val>
              </DAI>
              <DAI name="d">
                <Val>CCSPVC1 Name plate</Val>
              </DAI>
            </DOI>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Minimum operate current differential level" name="StrVal">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>0.2</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Block of the function at high phase current" name="MaxOpA">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>5</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Detection of current circuit failure" name="FailACirc">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2866,,0,0;MBS01,DA03,DA03,0,0,0,FB,2866,,0,0;I3C,DA03,DA03,1,71,21,1,71,21,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CCSPVC1 Detection of current circuit failure</Val>
              </DAI>
            </DOI>
            <DOI desc="Alarm" name="SigFailAlm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2864,,0,0;MBS01,DA03,DA03,0,0,0,FB,2864,,0,0;I3C,DA03,DA03,1,71,22,1,71,22,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CCSPVC1 Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Test control for outputs" name="TestSpvn"/>
            <DOI desc="IDIFF" name="DifAClc">
              <DAI name="d">
                <Val>CCSPVC1 IDIFF</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="BSTGGIO1" lnType="BSTGGIO1_ED2_C_3" inst="1" lnClass="GGIO" prefix="BST">
            <Private type="ABB_CommonSA_FunctionInstanceRef">151</Private>
            <Private type="ABB_FunctionRefs">eaccf526-ff2d-4b8a-8679-d0b0a8bb04bf</Private>
            <DOI desc="RECV_SIG_1" name="SPCSO1">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,51,20,80,51,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_1</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_2" name="SPCSO2">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,52,20,80,52,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_2</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_3" name="SPCSO3">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,53,20,80,53,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_3</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_4" name="SPCSO4">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,54,20,80,54,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_4</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_5" name="SPCSO5">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,55,20,80,55,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_5</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_6" name="SPCSO6">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,56,20,80,56,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_6</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_7" name="SPCSO7">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,57,20,80,57,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_7</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_8" name="SPCSO8">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,1,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,1,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,58,20,80,58,-1,0,20,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_8</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_A" name="Alm1">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2784,,0,0;MBS01,DA03,DA03,0,0,0,FB,2784,,0,0;I3C,DA03,DA03,1,80,1,1,80,1,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_A</Val>
              </DAI>
            </DOI>
            <DOI desc="RECV_SIG_A" name="Alm2">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2786,,0,0;MBS01,DA03,DA03,0,0,0,FB,2786,,0,0;I3C,DA03,DA03,1,80,2,1,80,2,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 RECV_SIG_A</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_1" name="Ind1">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,11,0,80,11,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_1</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_2" name="Ind2">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,12,0,80,12,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_2</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_3" name="Ind3">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,13,0,80,13,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_3</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_4" name="Ind4">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,14,0,80,14,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_4</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_5" name="Ind5">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,15,0,80,15,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_5</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_6" name="Ind6">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,16,0,80,16,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_6</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_7" name="Ind7">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,17,0,80,17,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_7</Val>
              </DAI>
            </DOI>
            <DOI desc="SEND_SIG_8" name="Ind8">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,80,18,0,80,18,-1,0,0,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>BSTGGIO1 SEND_SIG_8</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 1" name="PlsTmms1">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 2" name="PlsTmms2">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 3" name="PlsTmms3">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 4" name="PlsTmms4">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 5" name="PlsTmms5">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 6" name="PlsTmms6">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 7" name="PlsTmms7">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time for received signal 8" name="PlsTmms8">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Alarm mode" name="AlmMod"/>
            <DOI desc="Signal 1 mode" name="SigMod1"/>
            <DOI desc="Signal 2 mode" name="SigMod2"/>
            <DOI desc="Signal 3 mode" name="SigMod3"/>
            <DOI desc="Signal 4 mode" name="SigMod4"/>
            <DOI desc="Signal 5 mode" name="SigMod5"/>
            <DOI desc="Signal 6 mode" name="SigMod6"/>
            <DOI desc="Signal 7 mode" name="SigMod7"/>
            <DOI desc="Signal 8 mode" name="SigMod8"/>
          </LN>
          <LN desc="LNPLDF1" lnType="LNPTRC1_ED2_D_35" inst="1" lnClass="PTRC" prefix="LN">
            <Private type="ABB_CommonSA_FunctionInstanceRef">152</Private>
            <Private type="ABB_FunctionRefs">43f94b25-09d3-4842-9be4-745635ce0771</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Operate" name="Op">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,1,193,68,10,193,68,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsA" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,193,65,10,193,65,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsB" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,193,66,10,193,66,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsC" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,193,67,10,193,67,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>LNPLDF1 Operate</Val>
              </DAI>
            </DOI>
            <DOI desc="Start" name="Str">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,1,193,84,11,193,84,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsA" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,193,61,11,193,61,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsB" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,193,62,11,193,62,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsC" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,193,63,11,193,63,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>LNPLDF1 Start</Val>
              </DAI>
            </DOI>
            <DOI desc="Protection active" name="ProAct">
              <DAI name="d">
                <Val>LNPLDF1 Protection active</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="LNPLDF1" lnType="LNLPDIF1_ED2_D_35" inst="1" lnClass="PDIF" prefix="LNL">
            <Private type="ABB_CommonSA_FunctionInstanceRef">152</Private>
            <Private type="ABB_FunctionRefs">43f94b25-09d3-4842-9be4-745635ce0771</Private>
            <DOI desc="Start" name="Str">
              <DAI name="d">
                <Val>LNPLDF1 Start</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate" name="Op">
              <DAI name="d">
                <Val>LNPLDF1 Operate</Val>
              </DAI>
            </DOI>
            <DOI desc="Differential Current" name="DifAClc">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,8,1,0,218,2040,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,8,1,0,218,2040,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,1.2,0,0,0,0,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,8,1,0,218,2041,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,8,1,0,218,2041,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,1.2,0,0,0,0,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,8,1,0,218,2042,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,8,1,0,218,2042,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,1.2,0,0,0,0,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <DAI name="d">
                <Val>LNPLDF1 Differential Current</Val>
              </DAI>
            </DOI>
            <DOI desc="Restraint Current" name="RstA">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,8,1,0,218,2043,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,8,1,0,218,2043,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,1.2,0,0,0,0,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,8,1,0,218,2044,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,8,1,0,218,2044,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,1.2,0,0,0,0,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,8,1,0,218,2045,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,8,1,0,218,2045,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,1.2,0,0,0,0,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <DAI name="d">
                <Val>LNPLDF1 Restraint Current</Val>
              </DAI>
            </DOI>
            <DOI desc="Low operate value" name="LoSet">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>200</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Minimum Operate Time" name="MinOpTmms">
              <DAI name="minVal">
                <Val>45</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Restraint mode" name="RstMod"/>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Operating Curve Type" name="TmACrv"/>
            <DOI desc="Operate Delay Time" name="OpDlTmms">
              <DAI name="minVal">
                <Val>45</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>200000</Val>
              </DAI>
            </DOI>
            <DOI desc="Time Dial Multiplier" name="TmMult">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>15</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Start stab. stage remote" name="StrRem">
              <DAI name="d">
                <Val>LNPLDF1 Start stab. stage remote</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate stab. stage remote" name="OpRem">
              <DAI name="d">
                <Val>LNPLDF1 Operate stab. stage remote</Val>
              </DAI>
            </DOI>
            <DOI desc="Restrainted due 2nd harm. detected remote" name="Blk2HRemSt">
              <DAI name="d">
                <Val>LNPLDF1 Restrainted due 2nd harm. detected remote</Val>
              </DAI>
            </DOI>
            <DOI desc="Restrainted due 2nd harm. detected local" name="Blk2HLocSt">
              <DAI name="d">
                <Val>LNPLDF1 Restrainted due 2nd harm. detected local</Val>
              </DAI>
            </DOI>
            <DOI desc="End section 1" name="EndScn1">
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>200</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Slope section 2" name="SpeScn2">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>50</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="End section 2" name="EndScn2">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>200</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>2000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Slope section 3" name="SpeScn3">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>200</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Blocks stab. stage" name="Blk"/>
            <DOI desc="Local and remote phase A angle difference" name="AngLocRemA">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>LNPLDF1 Local and remote phase A angle difference</Val>
              </DAI>
            </DOI>
            <DOI desc="Local and remote phase B angle difference" name="AngLocRemB">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>LNPLDF1 Local and remote phase B angle difference</Val>
              </DAI>
            </DOI>
            <DOI desc="Local and remote phase C angle difference" name="AngLocRemC">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>LNPLDF1 Local and remote phase C angle difference</Val>
              </DAI>
            </DOI>
            <DOI desc="Ratio of start time / operate time, local" name="StrDur"/>
            <DOI desc="Test control for outputs" name="TestPro"/>
            <DOI desc="CT connection type. Determined by the directions of the connected current transformers." name="CTConnTyp"/>
            <DOI desc="Winding selection, HV or LV side of transformer" name="WndSel"/>
            <DOI desc="Winding 1 type" name="Wnd1Typ"/>
            <DOI desc="Winding 2 type" name="Wnd2Typ"/>
            <DOI desc="Phase shift" name="ClkNum"/>
            <DOI desc="Zro A elimination" name="ZroAElm"/>
          </LN>
          <LN desc="LNPLDF1" lnType="LNHPDIF1_ED2_D_35" inst="1" lnClass="PDIF" prefix="LNH">
            <Private type="ABB_CommonSA_FunctionInstanceRef">152</Private>
            <Private type="ABB_FunctionRefs">43f94b25-09d3-4842-9be4-745635ce0771</Private>
            <DOI desc="Operate inst. stage local" name="Op">
              <DAI name="d">
                <Val>LNPLDF1 Operate inst. stage local</Val>
              </DAI>
            </DOI>
            <DOI desc="High operate value" name="HiSet">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>200</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>4000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="High Op value Mult" name="HiSetMult">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.5</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Enables the high stage multiplier" name="InEnaMltHi"/>
            <DOI desc="Operate inst. stage remote" name="OpRem">
              <DAI name="d">
                <Val>LNPLDF1 Operate inst. stage remote</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="LNPLDF1" lnType="LNPHAR1_ED2_D_35" inst="1" lnClass="PHAR" prefix="LN">
            <Private type="ABB_CommonSA_FunctionInstanceRef">152</Private>
            <Private type="ABB_FunctionRefs">43f94b25-09d3-4842-9be4-745635ce0771</Private>
            <DOI desc="2nd harm. start" name="Str">
              <DAI name="d">
                <Val>LNPLDF1 2nd harm. start</Val>
              </DAI>
            </DOI>
            <DOI desc="Start value 2.H" name="PhStr">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>50</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="LNPLDF1" lnType="LNRMXU1_ED2_D_35" inst="1" lnClass="RMXU" prefix="LN">
            <Private type="ABB_CommonSA_FunctionInstanceRef">152</Private>
            <Private type="ABB_FunctionRefs">43f94b25-09d3-4842-9be4-745635ce0771</Private>
            <DOI desc="Operate Current of the remote current measurement" name="ARem">
              <DAI name="d">
                <Val>LNPLDF1 Operate Current of the remote current measurement</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate Current of the local current measurement" name="ALoc">
              <DAI name="d">
                <Val>LNPLDF1 Operate Current of the local current measurement</Val>
              </DAI>
            </DOI>
            <DOI desc="Current transformer ratio difference correction" name="CTRatCor">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.2</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>5</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.001</Val>
                </DAI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="PCSITPC1" lnType="PCSITPC1_ED2_E_10" inst="1" lnClass="ITPC" prefix="PCS">
            <Private type="ABB_CommonSA_FunctionInstanceRef">153</Private>
            <Private type="ABB_FunctionRefs">9d0065da-8b8f-4731-8771-3e0b926dd969</Private>
            <DOI desc="Health" name="EEHealth"/>
            <DOI desc="Time measured at last loop test" name="LoopTestTm">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>s</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>m</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>PCSITPC1 Time measured at last loop test</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="minVal">
                <Val>100</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>300000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning" name="HealthWrn">
              <DAI name="d">
                <Val>PCSITPC1 Warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Ok" name="HealthOk">
              <DAI name="d">
                <Val>PCSITPC1 Ok</Val>
              </DAI>
            </DOI>
            <DOI desc="Alarm" name="HealthAlm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,1,80,10,1,80,10,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>PCSITPC1 Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Comm" name="Comm">
              <DAI name="d">
                <Val>PCSITPC1 Comm</Val>
              </DAI>
            </DOI>
            <DOI desc="Rx error generate" name="RxErrGen">
              <DAI name="maxVal">
                <Val>10000</Val>
              </DAI>
              <DAI name="d">
                <Val>PCSITPC1 Rx error generate</Val>
              </DAI>
            </DOI>
            <DOI desc="Measured sample latency" name="SmplLty">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>s</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>m</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>PCSITPC1 Measured sample latency</Val>
              </DAI>
            </DOI>
            <DOI desc="Alarm count" name="AlmCntRs">
              <DAI name="maxVal">
                <Val>99999</Val>
              </DAI>
              <DAI name="d">
                <Val>PCSITPC1 Alarm count</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning count" name="WrnCntRs">
              <DAI name="maxVal">
                <Val>99999</Val>
              </DAI>
              <DAI name="d">
                <Val>PCSITPC1 Warning count</Val>
              </DAI>
            </DOI>
            <DOI desc="Measured propagation delay" name="PropDl">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>s</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>m</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>PCSITPC1 Measured propagation delay</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="INRPHAR1" lnType="INRPHAR1_ED2_C_2" inst="1" lnClass="PHAR" prefix="INR">
            <Private type="ABB_CommonSA_FunctionInstanceRef">100</Private>
            <Private type="ABB_FunctionRefs">6f95626b-ce14-48ca-9923-22c799602700</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Start" name="Str">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2964,,0,0;MBS01,DA03,DA03,0,0,0,FB,2964,,0,0;I3C,DA03,DA03,0,167,84,11,167,84,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsA" sAddr="MBS02,DA03,DA03,0,0,0,FB,2966,,0,0;MBS01,DA03,DA03,0,0,0,FB,2966,,0,0;I3C,DA03,DA03,0,167,64,11,167,64,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsB" sAddr="MBS02,DA03,DA03,0,0,0,FB,2968,,0,0;MBS01,DA03,DA03,0,0,0,FB,2968,,0,0;I3C,DA03,DA03,0,167,65,11,167,65,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsC" sAddr="MBS02,DA03,DA03,0,0,0,FB,2970,,0,0;MBS01,DA03,DA03,0,0,0,FB,2970,,0,0;I3C,DA03,DA03,0,167,66,11,167,66,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>INRPHAR1 Start</Val>
              </DAI>
            </DOI>
            <DOI desc="Start value" name="PhStr">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>5</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>100</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Operate Delay Time" name="OpDlTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Test control for outputs" name="TstOutCmd"/>
          </LN>
          <LN desc="X100 (PSM)" lnType="XGGIO100_ED2_D_1" inst="100" lnClass="GGIO" prefix="X">
            <Private type="ABB_CommonSA_FunctionInstanceRef">11</Private>
            <Private type="ABB_FunctionRefs">4f70bdd7-fb03-4755-940a-71ee0cf6733e</Private>
            <DOI desc="X100-Output 1" name="SPCSO1">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3248,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3248,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,53,101,1,53,101,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X100 (PSM) X100-Output 1</Val>
              </DAI>
            </DOI>
            <DOI desc="X100-Output 2" name="SPCSO2">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3250,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3250,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,53,102,1,53,102,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X100 (PSM) X100-Output 2</Val>
              </DAI>
            </DOI>
            <DOI desc="X100-Output 3" name="SPCSO3">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3252,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3252,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,53,103,1,53,103,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X100 (PSM) X100-Output 3</Val>
              </DAI>
            </DOI>
            <DOI desc="X100-Output 4" name="SPCSO4">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3254,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3254,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,53,104,1,53,104,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X100 (PSM) X100-Output 4</Val>
              </DAI>
            </DOI>
            <DOI desc="X100-Output 5" name="SPCSO5">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3256,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3256,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,53,105,1,53,105,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X100 (PSM) X100-Output 5</Val>
              </DAI>
            </DOI>
            <DOI desc="X100-Output 6" name="SPCSO6">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3258,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3258,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,53,106,1,53,106,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X100 (PSM) X100-Output 6</Val>
              </DAI>
            </DOI>
            <DOI desc="Card information" name="CardNam"/>
            <DOI desc="HW module" name="HwId"/>
            <DOI desc="Testing" name="TestStaId"/>
          </LN>
          <LN desc="Programmable LEDs" lnType="LEDGGIO1_ED2_F_26" inst="1" lnClass="GGIO" prefix="LED">
            <Private type="ABB_CommonSA_FunctionInstanceRef">15</Private>
            <Private type="ABB_FunctionRefs">c1053e85-9882-4354-b7c7-c810f65712a5,d76a2642-2d01-4cab-95ea-e6f3b0fd628e,f14180cd-b07b-4ef6-af5b-5d4aea79c92b,c51db530-7d0f-4eac-bbf7-0a763b1ac382,b9449551-2dc7-44ba-b775-f6f26835fed1,638e901f-3bc4-4ffc-902d-b76e59c4ea45,12d17fee-c524-4db9-a140-2b0f10bccbe4,c17f3e4f-037d-40f6-8b38-7c1a4a9705ee,86a2c663-de68-4d47-add6-d08db91ebc6d,824639aa-6e46-493c-b5e1-18624d4404b1,e738e109-0ece-45c4-9a3e-404b2ccb182c</Private>
            <DOI desc="Alarm input for LED 1" name="Alm1"/>
            <DOI desc="Alarm input for LED 2" name="Alm2"/>
            <DOI desc="Alarm input for LED 3" name="Alm3"/>
            <DOI desc="Alarm input for LED 4" name="Alm4"/>
            <DOI desc="Alarm input for LED 5" name="Alm5"/>
            <DOI desc="Alarm input for LED 6" name="Alm6"/>
            <DOI desc="Alarm input for LED 7" name="Alm7"/>
            <DOI desc="Alarm input for LED 8" name="Alm8"/>
            <DOI desc="Alarm input for LED 9" name="Alm9"/>
            <DOI desc="Alarm input for LED 10" name="Alm10"/>
            <DOI desc="Alarm input for LED 11" name="Alm11"/>
            <DOI desc="Ok input for LED 1" name="Ind1"/>
            <DOI desc="Ok input for LED 2" name="Ind2"/>
            <DOI desc="Ok input for LED 3" name="Ind3"/>
            <DOI desc="Ok input for LED 4" name="Ind4"/>
            <DOI desc="Ok input for LED 5" name="Ind5"/>
            <DOI desc="Ok input for LED 6" name="Ind6"/>
            <DOI desc="Ok input for LED 7" name="Ind7"/>
            <DOI desc="Ok input for LED 8" name="Ind8"/>
            <DOI desc="Ok input for LED 9" name="Ind9"/>
            <DOI desc="Ok input for LED 10" name="Ind10"/>
            <DOI desc="Ok input for LED 11" name="Ind11"/>
            <DOI desc="LED 1" name="LEDSt1">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2768,LED01 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3520,LED01 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2768,LED01 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3520,LED01 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,89,1,253,89,-1,0,1,0,LED01-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,119,0D,253,119,-1,0,0D,0,LED01-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 1</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 1</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 2" name="LEDSt2">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2769,LED02 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3521,LED02 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2769,LED02 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3521,LED02 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,90,1,253,90,-1,0,1,0,LED02-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,120,0D,253,120,-1,0,0D,0,LED02-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 2</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 2</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 3" name="LEDSt3">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2770,LED03 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3522,LED03 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2770,LED03 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3522,LED03 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,91,1,253,91,-1,0,1,0,LED03-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,121,0D,253,121,-1,0,0D,0,LED03-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 3</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 3</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 4" name="LEDSt4">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2771,LED04 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3523,LED04 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2771,LED04 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3523,LED04 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,92,1,253,92,-1,0,1,0,LED04-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,122,0D,253,122,-1,0,0D,0,LED04-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 4</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 4</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 5" name="LEDSt5">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2772,LED05 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3524,LED05 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2772,LED05 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3524,LED05 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,93,1,253,93,-1,0,1,0,LED05-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,123,0D,253,123,-1,0,0D,0,LED05-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 5</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 5</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 6" name="LEDSt6">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2773,LED06 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3525,LED06 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2773,LED06 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3525,LED06 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,94,1,253,94,-1,0,1,0,LED06-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,124,0D,253,124,-1,0,0D,0,LED06-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 6</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 6</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 7" name="LEDSt7">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2774,LED07 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3526,LED07 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2774,LED07 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3526,LED07 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,95,1,253,95,-1,0,1,0,LED07-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,125,0D,253,125,-1,0,0D,0,LED07-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 7</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 7</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 8" name="LEDSt8">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2775,LED08 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3527,LED08 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2775,LED08 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3527,LED08 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,96,1,253,96,-1,0,1,0,LED08-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,126,0D,253,126,-1,0,0D,0,LED08-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 8</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 8</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 9" name="LEDSt9">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2776,LED09 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3528,LED09 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2776,LED09 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3528,LED09 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,97,1,253,97,-1,0,1,0,LED09-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,127,0D,253,127,-1,0,0D,0,LED09-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 9</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 9</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 10" name="LEDSt10">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2777,LED10 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3529,LED10 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2777,LED10 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3529,LED10 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,98,1,253,98,-1,0,1,0,LED10-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,128,0D,253,128,-1,0,0D,0,LED10-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 10</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 10</Val>
              </DAI>
            </DOI>
            <DOI desc="LED 11" name="LEDSt11">
              <DAI name="stVal" sAddr="MBS02,DA02,DA02,0,DB,2778,LED11 Off-Color,0,0,0,2,1,3;MBS02,DA02,DA02,0,DB,3530,LED11 ColorX-ColorY,0,0,0,3,0,2,3;MBS01,DA02,DA02,0,DB,2778,LED11 Off-Color,0,0,0,2,1,3;MBS01,DA02,DA02,0,DB,3530,LED11 ColorX-ColorY,0,0,0,3,0,2,3;I3C,DA02,DA02,1,253,99,1,253,99,-1,0,1,0,LED11-Type1,1,2,1,3,-1,-1;I3C,DA03,DA03,0,253,129,0D,253,129,-1,0,0D,0,LED11-Type2,0,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP02,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP02,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1;DNP01,30,-1,0,5,0,0,0,0,1,0,3,0,3,AI-EvUpd,0;DNP01,1,-2,0,3,0,0,Off-Color BI-EvUpd,1,1,0;DNP01,1,-2,0,3,0,0,ColorX-ColorY BI-EvUpd,1,1,1"/>
              <DAI name="d">
                <Val>Programmable LEDs LED 11</Val>
              </DAI>
              <DAI name="dU">
                <Val>Programmable LEDs LED 11</Val>
              </DAI>
            </DOI>
            <DOI desc="Alarm mode" name="LEDSeq1"/>
            <DOI desc="Alarm mode" name="LEDSeq2"/>
            <DOI desc="Alarm mode" name="LEDSeq3"/>
            <DOI desc="Alarm mode" name="LEDSeq4"/>
            <DOI desc="Alarm mode" name="LEDSeq5"/>
            <DOI desc="Alarm mode" name="LEDSeq6"/>
            <DOI desc="Alarm mode" name="LEDSeq7"/>
            <DOI desc="Alarm mode" name="LEDSeq8"/>
            <DOI desc="Alarm mode" name="LEDSeq9"/>
            <DOI desc="Alarm mode" name="LEDSeq10"/>
            <DOI desc="Alarm mode" name="LEDSeq11"/>
            <DOI desc="Reset input for LED 1" name="InRsLED1"/>
            <DOI desc="Reset input for LED 2" name="InRsLED2"/>
            <DOI desc="Reset input for LED 3" name="InRsLED3"/>
            <DOI desc="Reset input for LED 4" name="InRsLED4"/>
            <DOI desc="Reset input for LED 5" name="InRsLED5"/>
            <DOI desc="Reset input for LED 6" name="InRsLED6"/>
            <DOI desc="Reset input for LED 7" name="InRsLED7"/>
            <DOI desc="Reset input for LED 8" name="InRsLED8"/>
            <DOI desc="Reset input for LED 9" name="InRsLED9"/>
            <DOI desc="Reset input for LED 10" name="InRsLED10"/>
            <DOI desc="Reset input for LED 11" name="InRsLED11"/>
            <DOI desc="Alarm colour" name="AlmColr"/>
          </LN>
          <LN desc="GSELPRT1" lnType="GSELPRT1_ED2_D_21" inst="1" lnClass="LPRT" prefix="GSE">
            <Private type="ABB_CommonSA_FunctionInstanceRef">202</Private>
            <Private type="ABB_FunctionRefs">8c4595a8-5665-409f-9b05-1cacc521fa36</Private>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="swRev">
                <Val>D</Val>
              </DAI>
            </DOI>
            <DOI desc="Received msgs" name="FrRxCnt"/>
            <DOI desc="Transmitted Messages" name="FrTxCnt"/>
            <DOI desc="Received State Changes" name="RxStCnt"/>
            <DOI desc="Received Sequence Number" name="RxSeqCnt"/>
            <DOI desc="Received frames with Test bit" name="RxTestCnt"/>
            <DOI desc="State warnings" name="StWrnCnt"/>
            <DOI desc="Sequence warnings" name="SeqWrnCnt"/>
            <DOI desc="Receiver Timeouts" name="RxTmOutCnt"/>
            <DOI desc="Received ConfRev mismatches" name="ConfErrCnt"/>
            <DOI desc="Received frames with NeedsCommissioning bit" name="NdsComCnt"/>
            <DOI desc="Errors in received dataset" name="DSErrCnt"/>
            <DOI desc="Alarm" name="Alm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,1,10,88,1,10,88,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>GSELPRT1 Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Goose counters reset" name="CntRs">
              <DAI name="d">
                <Val>GSELPRT1 Goose counters reset</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="61850-8-1 MMS" lnType="MMSLPRT1_ED2_E_26" inst="1" lnClass="LPRT" prefix="MMS">
            <Private type="ABB_CommonSA_FunctionInstanceRef">201</Private>
            <Private type="ABB_FunctionRefs">b39fac54-7d14-4f85-bf37-102ee7ad3a75</Private>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="swRev">
                <Val>E</Val>
              </DAI>
            </DOI>
            <DOI desc="Successful Connections" name="SucConn"/>
            <DOI desc="Failed Connections" name="FailConn"/>
            <DOI desc="Concludes" name="ConcCnt"/>
            <DOI desc="Sent Aborts" name="TxAbtCnt"/>
            <DOI desc="Received Aborts" name="RxAbtCnt"/>
            <DOI desc="Sent Rejects" name="TxRejCnt"/>
            <DOI desc="Received Request" name="RxRqCnt"/>
            <DOI desc="Failed Requests" name="FailRqCnt"/>
            <DOI desc="Successful Reads" name="SucReaCnt"/>
            <DOI desc="Failed Reads" name="FailReaCnt"/>
            <DOI desc="Successful Writes" name="SucWrCnt"/>
            <DOI desc="Failed Writes" name="FailWrCnt"/>
            <DOI desc="Information Reports" name="InfRpCnt"/>
            <DOI desc="Active Connections" name="ActConnCnt"/>
            <DOI desc="Unit mode" name="UnitMod"/>
            <DOI desc="Communication status" name="CntRs">
              <DAI name="d">
                <Val>61850-8-1 MMS Communication status</Val>
              </DAI>
            </DOI>
            <DOI desc="MMS Communication status" name="ChLiv">
              <DAI name="d">
                <Val>61850-8-1 MMS MMS Communication status</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="GNRLLTMS1" lnType="GNRLLTMS1_ED2_C_15" inst="1" lnClass="LTMS" prefix="GNRL">
            <Private type="ABB_CommonSA_FunctionInstanceRef">234</Private>
            <Private type="ABB_FunctionRefs">5291af3e-b6fa-46f8-aca7-57b8a186b71b</Private>
            <DOI desc="Number of significant bits in the Fraction Of Second in the time accuracy part of the time stamp." name="TmAcc"/>
            <DOI desc="Time synchronized according to IEC 61850-9-2" name="TmSyn">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0"/>
            </DOI>
            <DOI desc="Time channel status (up/down)" name="TmChSt1">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,1,10,85,1,10,85,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>GNRLLTMS1 Time channel status (up/down)</Val>
              </DAI>
            </DOI>
            <DOI desc="Time source setting (“1588” in case the time source is a IEEE 1588 source or dotted IP-address)" name="TmSrcSel1"/>
            <DOI desc="Current time source" name="TmSrcSt">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,0,16,0,8,1,0,18,-5,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,65535,0,65535,AI-EvUpd,0"/>
            </DOI>
            <DOI desc="The domain is identified by an integer, the domainNumber, in the range of 0 to 255." name="DomId"/>
            <DOI desc="Alarm" name="Alm">
              <DAI name="d">
                <Val>GNRLLTMS1 Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning" name="Wrn">
              <DAI name="d">
                <Val>GNRLLTMS1 Warning</Val>
              </DAI>
            </DOI>
            <DOI desc="GrandMaster timeSource enum according to PTPv2" name="PTPTmSrc"/>
            <DOI desc="Grandmaster clockAccuracy enum according to PTPv2" name="PTPClkAcc"/>
            <DOI desc="Local clock accuracy (master + IED synch accuracy)[us]" name="LocClkAcc"/>
            <DOI desc="Maximum deviation of the Local synch accuracy [us]" name="MaxDevAcc"/>
            <DOI desc="PTP priority 1, in the range of 0 to 255." name="PTPPrio1"/>
            <DOI desc="PTP priority 2, in the range of 0 to 255." name="PTPPrio2"/>
            <DOI desc="Grandmaster Identity octet string according to PTPv2" name="MstrId"/>
            <DOI desc="IP address for SNTP primary server" name="IPAddrSNTP1"/>
            <DOI desc="IP address for SNTP secondary server" name="IPAddrSNTP2"/>
            <DOI desc="PTP Announce Mode" name="PTPAnncMod"/>
          </LN>
          <LN desc="GNRLLTIM1" lnType="GNRLLTIM1_ED2_C_15" inst="1" lnClass="LTIM" prefix="GNRL">
            <Private type="ABB_CommonSA_FunctionInstanceRef">234</Private>
            <Private type="ABB_FunctionRefs">5291af3e-b6fa-46f8-aca7-57b8a186b71b</Private>
            <DOI desc="Indicating if DST is in effect" name="TmDT">
              <DAI name="d">
                <Val>GNRLLTIM1 Indicating if DST is in effect</Val>
              </DAI>
            </DOI>
            <DOI desc="Offset of local time from UTC in minutes" name="TmOfsTmm">
              <DAI name="minVal">
                <Val>-840</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>840</Val>
              </DAI>
            </DOI>
            <DOI desc="DST in use setting" name="TmUseDT"/>
            <DOI desc="Local time of next change to daylight saving time" name="TmChgDT">
              <SDI name="setCal">
                <DAI name="occPer">
                  <Val>Year</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Local time of next change to standard time" name="TmChgST">
              <SDI name="setCal">
                <DAI name="occPer">
                  <Val>Year</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="System time" name="TmSys"/>
            <DOI desc="System date" name="DateSys"/>
            <DOI desc="Daylight saving time offset" name="TmOfsDT">
              <DAI name="minVal">
                <Val>-720</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>720</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="CMMXU1" lnType="CMMXU1_ED2_E_12" inst="1" lnClass="MMXU" prefix="C">
            <Private type="ABB_CommonSA_FunctionInstanceRef">40</Private>
            <Private type="ABB_FunctionRefs">50048eca-6f7c-41c4-9ef8-fdcc0ddba525</Private>
            <DOI desc="Operation" name="Mod"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Phase currents" name="A">
              <SDI name="phsA">
                <SDI name="instCVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,18,138,Filt,-1,0,0,0,0,0,0,0,0;MBS02,DA08,DA08,0,C,1000,0,218,-5,Inst,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,18,138,Filt,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,-5,Inst,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,2.4,0,0,0,0,0,7,0,0,0,0,1,1,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0"/>
                  </SDI>
                </SDI>
                <DAI name="zeroDb">
                  <Val>25</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="max">
                    <DAI name="f">
                      <Val>40</Val>
                    </DAI>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="instCVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,18,139,Filt,-1,0,0,0,0,0,0,0,0;MBS02,DA08,DA08,0,C,1000,0,218,-5,Inst,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,18,139,Filt,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,-5,Inst,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,2.4,0,0,0,0,0,7,1,1,1,0,2,2,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="instCVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,18,140,Filt,-1,0,0,0,0,0,0,0,0;MBS02,DA08,DA08,0,C,1000,0,218,-5,Inst,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,18,140,Filt,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,-5,Inst,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,2.4,0,0,0,0,0,7,0,0,0,0,3,3,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <DAI name="d">
                <Val>CMMXU1 Phase currents</Val>
              </DAI>
            </DOI>
            <DOI desc="Selects used measurement mode" name="AMeasMod"/>
            <DOI desc="Number of phases required by limit supervision" name="NumPh"/>
            <DOI desc="High alarm" name="HiAlm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2752,,0,0;MBS01,DA03,DA03,0,0,0,FB,2752,,0,0;I3C,DA03,DA03,1,210,1,1,210,1,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CMMXU1 High alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="High warning" name="HiWrn">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2754,,0,0;MBS01,DA03,DA03,0,0,0,FB,2754,,0,0;I3C,DA03,DA03,1,210,2,1,210,2,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CMMXU1 High warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Low warning" name="LoWrn">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2756,,0,0;MBS01,DA03,DA03,0,0,0,FB,2756,,0,0;I3C,DA03,DA03,1,210,3,1,210,3,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CMMXU1 Low warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Low alarm" name="LoAlm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2758,,0,0;MBS01,DA03,DA03,0,0,0,FB,2758,,0,0;I3C,DA03,DA03,1,210,4,1,210,4,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CMMXU1 Low alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="CMMXU1 demands" name="RcdRs">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,2069,0,2,9,,0,0,0;MBS01,DA10,DA10,0,2069,0,2,9,,0,0,0;I3C,DA02,DA02,1,10,45,20,10,45,-1,0,20,0,,9,1,0,1,-1;DNP02,10,-1,0,0,0,BO-Reset,0,1,0;DNP01,10,-1,0,0,0,BO-Reset,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>CMMXU1 CMMXU1 demands</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="CMMXU1" lnType="CAVMMXU1_ED2_E_12" inst="1" lnClass="MMXU" prefix="CAV">
            <Private type="ABB_CommonSA_FunctionInstanceRef">40</Private>
            <Private type="ABB_FunctionRefs">50048eca-6f7c-41c4-9ef8-fdcc0ddba525</Private>
            <DOI desc="Phase current" name="A">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,2001,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,2001,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,181,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,2002,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,2002,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,182,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,2003,,2004,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,2003,,2004,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,183,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <DAI name="d">
                <Val>CMMXU1 Phase current</Val>
              </DAI>
            </DOI>
            <DOI desc="Calculation method of statistical data objects" name="ClcMth">
              <DAI name="setVal">
                <Val>AVG</Val>
              </DAI>
            </DOI>
            <DOI desc="Calculation mode" name="ClcMod"/>
            <DOI desc="Object reference to source logical node" name="ClcSrc">
              <DAI name="setSrcRef">
                <Val>CMMXU1</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="CMMXU1" lnType="CMAMMXU1_ED2_E_12" inst="1" lnClass="MMXU" prefix="CMA">
            <Private type="ABB_CommonSA_FunctionInstanceRef">40</Private>
            <Private type="ABB_FunctionRefs">50048eca-6f7c-41c4-9ef8-fdcc0ddba525</Private>
            <DOI desc="Phase current" name="A">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,2009,,2010,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,2009,,2010,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,150,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,2015,,2016,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,2015,,2016,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,151,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,2021,,2022,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,2021,,2022,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,152,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <DAI name="d">
                <Val>CMMXU1 Phase current</Val>
              </DAI>
            </DOI>
            <DOI desc="Calculation method of statistical data objects" name="ClcMth">
              <DAI name="setVal">
                <Val>MAX</Val>
              </DAI>
            </DOI>
            <DOI desc="Calculation mode" name="ClcMod"/>
            <DOI desc="Object reference to source logical node" name="ClcSrc">
              <DAI name="setSrcRef">
                <Val>CMMXU1</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="CMMXU1" lnType="CMIMMXU1_ED2_E_12" inst="1" lnClass="MMXU" prefix="CMI">
            <Private type="ABB_CommonSA_FunctionInstanceRef">40</Private>
            <Private type="ABB_FunctionRefs">50048eca-6f7c-41c4-9ef8-fdcc0ddba525</Private>
            <DOI desc="Phase current" name="A">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,-5,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,153,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,-5,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,154,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,218,-5,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,218,-5,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,155,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,AI-Static,0"/>
                  </SDI>
                </SDI>
              </SDI>
              <DAI name="d">
                <Val>CMMXU1 Phase current</Val>
              </DAI>
            </DOI>
            <DOI desc="Calculation method of statistical data objects" name="ClcMth">
              <DAI name="setVal">
                <Val>MIN</Val>
              </DAI>
            </DOI>
            <DOI desc="Calculation mode" name="ClcMod"/>
            <DOI desc="Object reference to source logical node" name="ClcSrc">
              <DAI name="setSrcRef">
                <Val>CMMXU1</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="CSMSQI1" lnType="CSMSQI1_ED2_C_0" inst="1" lnClass="MSQI" prefix="CS">
            <Private type="ABB_CommonSA_FunctionInstanceRef">43</Private>
            <Private type="ABB_FunctionRefs">a464aebe-0591-443e-9995-6b887e41a06d</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Positive, Negative and Zero Sequence Current" name="SeqA">
              <SDI name="c1">
                <SDI name="instCVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,18,143,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,18,143,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,2.4,0,0,0,0,0,7,0,0,0,0,0,16,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0"/>
                  </SDI>
                </SDI>
                <DAI name="zeroDb">
                  <Val>25</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="max">
                    <DAI name="f">
                      <Val>40</Val>
                    </DAI>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="instCVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,18,144,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,18,144,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,2.4,0,0,0,0,0,7,0,0,0,0,0,17,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0"/>
                  </SDI>
                </SDI>
                <DAI name="zeroDb">
                  <Val>25</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="max">
                    <DAI name="f">
                      <Val>40</Val>
                    </DAI>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="instCVal">
                  <SDI name="mag">
                    <DAI name="f" sAddr="MBS02,DA08,DA08,0,C,1000,0,18,145,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,0,C,1000,0,18,145,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,1,2.4,0,0,0,0,0,7,0,0,0,0,0,18,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,AI-EvUpd,0"/>
                  </SDI>
                </SDI>
                <DAI name="zeroDb">
                  <Val>25</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="max">
                    <DAI name="f">
                      <Val>40</Val>
                    </DAI>
                  </SDI>
                </SDI>
              </SDI>
              <DAI name="d">
                <Val>CSMSQI1 Positive, Negative and Zero Sequence Current</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="PHIPTOC1" lnType="PHIPTOC1_ED2_E_2" inst="1" lnClass="PTOC" prefix="PHI">
            <Private type="ABB_CommonSA_FunctionInstanceRef">22</Private>
            <Private type="ABB_FunctionRefs">b95c4f9b-aff3-4abc-a91b-0c311e28f79c</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Start" name="Str">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2910,,0,0;MBS01,DA03,DA03,0,0,0,FB,2910,,0,0;I3C,DA03,DA03,1,162,97,11,162,97,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsA" sAddr="MBS02,DA03,DA03,0,0,0,FB,2912,,0,0;MBS01,DA03,DA03,0,0,0,FB,2912,,0,0;I3C,DA03,DA03,0,162,34,11,162,34,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsB" sAddr="MBS02,DA03,DA03,0,0,0,FB,2914,,0,0;MBS01,DA03,DA03,0,0,0,FB,2914,,0,0;I3C,DA03,DA03,0,162,35,11,162,35,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsC" sAddr="MBS02,DA03,DA03,0,0,0,FB,2916,,0,0;MBS01,DA03,DA03,0,0,0,FB,2916,,0,0;I3C,DA03,DA03,0,162,36,11,162,36,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>PHIPTOC1 Start</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate" name="Op">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2918,,0,0;MBS01,DA03,DA03,0,0,0,FB,2918,,0,0;I3C,DA03,DA03,1,162,99,10,162,99,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsA" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsB" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsC" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>PHIPTOC1 Operate</Val>
              </DAI>
            </DOI>
            <DOI desc="Start value" name="StrVal">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>40</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Operate Delay Time" name="OpDlTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>200000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Enable signal for current multiplier " name="InEnaMult">
              <DAI name="d">
                <Val>PHIPTOC1 Enable signal for current multiplier </Val>
              </DAI>
            </DOI>
            <DOI desc="Number of phases required for operate activation" name="NumPh"/>
            <DOI desc="Multiplier for scaling the start value" name="StrValMult">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.8</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Ratio of start time / operate time" name="StrDur"/>
            <DOI desc="Test control for outputs" name="TstOutCmd"/>
          </LN>
          <LN desc="CCBRBRF1" lnType="CCBRBRF1_ED2_E_6" inst="1" lnClass="RBRF" prefix="CCB">
            <Private type="ABB_CommonSA_FunctionInstanceRef">51</Private>
            <Private type="ABB_FunctionRefs">460cbb62-983b-4fa2-bbe8-7159582e2dc8</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Delayed CB failure alarm" name="Str">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2828,,0,0;MBS01,DA03,DA03,0,0,0,FB,2828,,0,0;I3C,DA03,DA03,0,240,101,11,240,101,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CCBRBRF1 Delayed CB failure alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Breaker failure trip (external trip)" name="OpEx">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2830,,0,0;MBS01,DA03,DA03,0,0,0,FB,2830,,0,0;I3C,DA03,DA03,0,240,102,10,240,102,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CCBRBRF1 Breaker failure trip (external trip)</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate, retrip (internal trip)" name="OpIn">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2832,,0,0;MBS01,DA03,DA03,0,0,0,FB,2832,,0,0;I3C,DA03,DA03,0,240,103,10,240,103,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>CCBRBRF1 Operate, retrip (internal trip)</Val>
              </DAI>
            </DOI>
            <DOI desc="Breaker Failure Detection Mode (current, breaker status, both, other)" name="FailMod"/>
            <DOI desc="Breaker Failure Time Delay for bus bar trip" name="FailTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Three Pole Retrip Time Delay" name="TPTrTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Current Detector Value" name="DetValA">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>2</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Retrip Mode" name="ReTrMod"/>
            <DOI desc="Trip pulse time" name="TrPlsTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Current Detector Value for residual current" name="DetValARes">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>2</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Measurement mode selection (current): 2= DFT; 3= Peak-to-Peak" name="AMeasMod"/>
            <DOI desc="Circuit breaker faulty alarm delay" name="CBAlmTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Select type of backup trip logic" name="OpExMod"/>
            <DOI desc="CBFP start command" name="InStr">
              <DAI name="d">
                <Val>CCBRBRF1 CBFP start command</Val>
              </DAI>
            </DOI>
            <DOI desc="CB in closed poisition" name="InPosCls">
              <DAI name="d">
                <Val>CCBRBRF1 CB in closed poisition</Val>
              </DAI>
            </DOI>
            <DOI desc="CB faulty and unable to trip" name="InCBFlt">
              <DAI name="d">
                <Val>CCBRBRF1 CB faulty and unable to trip</Val>
              </DAI>
            </DOI>
            <DOI desc="Test control for outputs" name="TstOutCmd"/>
            <DOI desc="Start reset delayed or immediately" name="StrLtcMod"/>
          </LN>
          <LN desc="NSPTOC1" lnType="NSPTOC1_ED2_E_3" inst="1" lnClass="PTOC" prefix="NS">
            <Private type="ABB_CommonSA_FunctionInstanceRef">95</Private>
            <Private type="ABB_FunctionRefs">b00c6e32-7d6f-41b3-9852-aed10e365b7d</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Start" name="Str">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2956,,0,0;MBS01,DA03,DA03,0,0,0,FB,2956,,0,0;I3C,DA03,DA03,1,21,84,11,21,84,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>NSPTOC1 Start</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate" name="Op">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2958,,0,0;MBS01,DA03,DA03,0,0,0,FB,2958,,0,0;I3C,DA03,DA03,1,21,90,10,21,90,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>NSPTOC1 Operate</Val>
              </DAI>
            </DOI>
            <DOI desc="Operating Curve Type" name="TmACrv"/>
            <DOI desc="Start value" name="StrVal">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>5</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Time Dial Multiplier" name="TmMult">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>15</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Minimum Operate Time" name="MinOpTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate Delay Time" name="OpDlTmms">
              <DAI name="minVal">
                <Val>40</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>200000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Type of Reset Curve" name="TypRsCrv"/>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Enable signal for current multiplier " name="InEnaMult">
              <DAI name="d">
                <Val>NSPTOC1 Enable signal for current multiplier </Val>
              </DAI>
            </DOI>
            <DOI desc="Multiplier for scaling the start value" name="StrValMult">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.8</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Ratio of start time / operate time" name="StrDur"/>
            <DOI desc="Test control for outputs" name="TstOutCmd"/>
          </LN>
          <LN desc="NSPTOC2" lnType="NSPTOC2_ED2_E_3" inst="2" lnClass="PTOC" prefix="NS">
            <Private type="ABB_CommonSA_FunctionInstanceRef">96</Private>
            <Private type="ABB_FunctionRefs">c66a39ab-b47d-46e6-bf11-40908e887b63</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Start" name="Str">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2960,,0,0;MBS01,DA03,DA03,0,0,0,FB,2960,,0,0;I3C,DA03,DA03,1,21,94,11,21,94,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>NSPTOC2 Start</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate" name="Op">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2962,,0,0;MBS01,DA03,DA03,0,0,0,FB,2962,,0,0;I3C,DA03,DA03,1,21,91,10,21,91,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>NSPTOC2 Operate</Val>
              </DAI>
            </DOI>
            <DOI desc="Operating Curve Type" name="TmACrv"/>
            <DOI desc="Start value" name="StrVal">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>5</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Time Dial Multiplier" name="TmMult">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.05</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>15</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.01</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Minimum Operate Time" name="MinOpTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate Delay Time" name="OpDlTmms">
              <DAI name="minVal">
                <Val>40</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>200000</Val>
              </DAI>
              <DAI name="stepSize">
                <Val>10</Val>
              </DAI>
            </DOI>
            <DOI desc="Type of Reset Curve" name="TypRsCrv"/>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Enable signal for current multiplier " name="InEnaMult">
              <DAI name="d">
                <Val>NSPTOC2 Enable signal for current multiplier </Val>
              </DAI>
            </DOI>
            <DOI desc="Multiplier for scaling the start value" name="StrValMult">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.8</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>10</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Ratio of start time / operate time" name="StrDur"/>
            <DOI desc="Test control for outputs" name="TstOutCmd"/>
          </LN>
          <LN desc="TRPPTRC1" lnType="TRPPTRC1_ED2_F_1" inst="1" lnClass="PTRC" prefix="TRP">
            <Private type="ABB_CommonSA_FunctionInstanceRef">237</Private>
            <Private type="ABB_FunctionRefs">c3d99528-7a7e-422d-b895-f64803a12129</Private>
            <DOI desc="BLOCK" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="General trip output signal" name="Tr">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2742,,0,0;MBS01,DA03,DA03,0,0,0,FB,2742,,0,0;I3C,DA03,DA03,1,10,2,10,10,2,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>TRPPTRC1 General trip output signal</Val>
              </DAI>
              <DAI name="dU">
                <Val>TRPPTRC1 General trip output signal</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate input signal" name="Op">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2740,,0,0;MBS01,DA03,DA03,0,0,0,FB,2740,,0,0;I3C,DA03,DA03,1,10,1,10,10,1,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>TRPPTRC1 Operate input signal</Val>
              </DAI>
              <DAI name="dU">
                <Val>TRPPTRC1 Operate input signal</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum duration of trip output signal " name="TrPlsTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Trip output mode" name="TrOutMod"/>
            <DOI desc="RST_LKOUT" name="LORs">
              <DAI name="d">
                <Val>TRPPTRC1 RST_LKOUT</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset latched trip" name="TrRs">
              <DAI name="d">
                <Val>TRPPTRC1 Reset latched trip</Val>
              </DAI>
            </DOI>
            <DOI desc="Circuit breaker lockout output (set until reset) " name="ClsLO">
              <DAI name="d">
                <Val>TRPPTRC1 Circuit breaker lockout output (set until reset) </Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="TRPPTRC2" lnType="TRPPTRC2_ED2_F_1" inst="2" lnClass="PTRC" prefix="TRP">
            <Private type="ABB_CommonSA_FunctionInstanceRef">238</Private>
            <Private type="ABB_FunctionRefs">7cd64a1c-fac6-498b-b9f9-5c34ed3e8a94</Private>
            <DOI desc="BLOCK" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="General trip output signal" name="Tr">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2746,,0,0;MBS01,DA03,DA03,0,0,0,FB,2746,,0,0;I3C,DA03,DA03,1,10,4,10,10,4,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>TRPPTRC2 General trip output signal</Val>
              </DAI>
              <DAI name="dU">
                <Val>TRPPTRC2 General trip output signal</Val>
              </DAI>
            </DOI>
            <DOI desc="Operate input signal" name="Op">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2744,,0,0;MBS01,DA03,DA03,0,0,0,FB,2744,,0,0;I3C,DA03,DA03,1,10,3,10,10,3,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>TRPPTRC2 Operate input signal</Val>
              </DAI>
              <DAI name="dU">
                <Val>TRPPTRC2 Operate input signal</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum duration of trip output signal " name="TrPlsTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Trip output mode" name="TrOutMod"/>
            <DOI desc="RST_LKOUT" name="LORs">
              <DAI name="d">
                <Val>TRPPTRC2 RST_LKOUT</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset latched trip" name="TrRs">
              <DAI name="d">
                <Val>TRPPTRC2 Reset latched trip</Val>
              </DAI>
            </DOI>
            <DOI desc="Circuit breaker lockout output (set until reset) " name="ClsLO">
              <DAI name="d">
                <Val>TRPPTRC2 Circuit breaker lockout output (set until reset) </Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Global conditioning" lnType="LEDPTRC_ED2_G_7" inst="1" lnClass="PTRC" prefix="LED">
            <Private type="ABB_FunctionRefs">8d8b5980-61d0-406b-9468-70d4f686c3c0</Private>
            <DOI desc="Operate" name="Op">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2738,,0,0;MBS01,DA03,DA03,0,0,0,FB,2738,,0,0;I3C,DA03,DA03,1,0,68,11,0,68,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsA" sAddr="MBS02,DA03,DA03,0,0,0,FB,2986,,0,0;MBS01,DA03,DA03,0,0,0,FB,2986,,0,0;I3C,DA03,DA03,0,10,65,10,10,65,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsB" sAddr="MBS02,DA03,DA03,0,0,0,FB,2988,,0,0;MBS01,DA03,DA03,0,0,0,FB,2988,,0,0;I3C,DA03,DA03,0,10,66,10,10,66,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsC" sAddr="MBS02,DA03,DA03,0,0,0,FB,2990,,0,0;MBS01,DA03,DA03,0,0,0,FB,2990,,0,0;I3C,DA03,DA03,0,10,67,10,10,67,-1,0,10,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Global conditioning Operate</Val>
              </DAI>
            </DOI>
            <DOI desc="Start" name="Str">
              <DAI name="general" sAddr="MBS02,DA03,DA03,0,0,0,FB,2736,,0,0;MBS01,DA03,DA03,0,0,0,FB,2736,,0,0;I3C,DA03,DA03,1,0,84,11,0,84,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsA" sAddr="MBS02,DA03,DA03,0,0,0,FB,2980,,0,0;MBS01,DA03,DA03,0,0,0,FB,2980,,0,0;I3C,DA03,DA03,0,10,61,11,10,61,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsB" sAddr="MBS02,DA03,DA03,0,0,0,FB,2982,,0,0;MBS01,DA03,DA03,0,0,0,FB,2982,,0,0;I3C,DA03,DA03,0,10,62,11,10,62,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="phsC" sAddr="MBS02,DA03,DA03,0,0,0,FB,2984,,0,0;MBS01,DA03,DA03,0,0,0,FB,2984,,0,0;I3C,DA03,DA03,0,10,63,11,10,63,-1,0,11,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Global conditioning Start</Val>
              </DAI>
            </DOI>
            <DOI desc="Input operate" name="InOp">
              <DAI name="d">
                <Val>Global conditioning Input operate</Val>
              </DAI>
              <DAI name="dU">
                <Val>Global conditioning Input operate</Val>
              </DAI>
            </DOI>
            <DOI desc="Input start" name="InStr">
              <DAI name="d">
                <Val>Global conditioning Input start</Val>
              </DAI>
              <DAI name="dU">
                <Val>Global conditioning Input start</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="TCSSCBR1" lnType="TCSSCBR1_ED2_C_4" inst="1" lnClass="SCBR" prefix="TCS">
            <Private type="ABB_CommonSA_FunctionInstanceRef">110</Private>
            <Private type="ABB_FunctionRefs">25a5c9ad-6089-4343-aa97-83b053a9fd71</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Operate Delay Time" name="OpDlTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>300000</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Alarm" name="CircAlm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2780,,0,0;MBS01,DA03,DA03,0,0,0,FB,2780,,0,0;I3C,DA03,DA03,1,0,36,1,0,36,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>TCSSCBR1 Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Test control for outputs" name="TstOutCmd"/>
          </LN>
          <LN desc="TCSSCBR2" lnType="TCSSCBR2_ED2_C_4" inst="2" lnClass="SCBR" prefix="TCS">
            <Private type="ABB_CommonSA_FunctionInstanceRef">111</Private>
            <Private type="ABB_FunctionRefs">acc5d458-2f34-4d44-9537-9975d099f282</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Behaviour" name="Beh"/>
            <DOI desc="Block signal for all binary outputs" name="Blk"/>
            <DOI desc="Operate Delay Time" name="OpDlTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>300000</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset Delay Time" name="RsDlTmms">
              <DAI name="minVal">
                <Val>20</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
            <DOI desc="Alarm" name="CircAlm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,2782,,0,0;MBS01,DA03,DA03,0,0,0,FB,2782,,0,0;I3C,DA03,DA03,1,10,36,1,10,36,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>TCSSCBR2 Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Test control for outputs" name="TstOutCmd"/>
          </LN>
          <LN desc="TPGAPC1" lnType="TPGAPC1_ED2_C_6" inst="1" lnClass="GAPC" prefix="TP">
            <Private type="ABB_CommonSA_FunctionInstanceRef">501</Private>
            <Private type="ABB_FunctionRefs">83561d9d-a4e7-4b8c-adee-84a96964a11d</Private>
            <DOI desc="IN1" name="Ind1">
              <DAI name="d">
                <Val>TPGAPC1 IN1</Val>
              </DAI>
            </DOI>
            <DOI desc="IN2" name="Ind2">
              <DAI name="d">
                <Val>TPGAPC1 IN2</Val>
              </DAI>
            </DOI>
            <DOI desc="Q1" name="SPCSO1">
              <DAI name="d">
                <Val>TPGAPC1 Q1</Val>
              </DAI>
            </DOI>
            <DOI desc="Q2" name="SPCSO2">
              <DAI name="d">
                <Val>TPGAPC1 Q2</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time" name="PlsTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="TPGAPC2" lnType="TPGAPC2_ED2_C_6" inst="2" lnClass="GAPC" prefix="TP">
            <Private type="ABB_CommonSA_FunctionInstanceRef">502</Private>
            <Private type="ABB_FunctionRefs">5b123831-2951-4144-b79b-bc3cfb69a318</Private>
            <DOI desc="IN1" name="Ind1">
              <DAI name="d">
                <Val>TPGAPC2 IN1</Val>
              </DAI>
            </DOI>
            <DOI desc="IN2" name="Ind2">
              <DAI name="d">
                <Val>TPGAPC2 IN2</Val>
              </DAI>
            </DOI>
            <DOI desc="Q1" name="SPCSO1">
              <DAI name="d">
                <Val>TPGAPC2 Q1</Val>
              </DAI>
            </DOI>
            <DOI desc="Q2" name="SPCSO2">
              <DAI name="d">
                <Val>TPGAPC2 Q2</Val>
              </DAI>
            </DOI>
            <DOI desc="Minimum pulse time" name="PlsTmms">
              <DAI name="maxVal">
                <Val>60000</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="FLTRFRC1" lnType="FLTRFRC0_ED2_H1_108" inst="1" lnClass="RFRC" prefix="FLT">
            <Private type="ABB_CommonSA_FunctionInstanceRef">4</Private>
            <Private type="ABB_FunctionRefs">76b194f9-baf1-47a9-8300-5061715a548c</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="swRev">
                <Val>H1</Val>
              </DAI>
              <DAI name="d">
                <Val>FLTRFRC1 Name plate</Val>
              </DAI>
            </DOI>
            <DOI desc="Frequency" name="Hz">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,8,100,0,10,4,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,8,100,0,10,4,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,86,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,30,80,3000,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,30,80,3000,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,30,80,3000,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,30,80,3000,8000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>Hz</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Frequency</Val>
              </DAI>
            </DOI>
            <DOI desc="Fault resistance" name="FltPtR">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,D,100,0,10,8,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,D,100,0,10,8,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,1,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,1000000,0,100000000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,1000000,0,100000000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,1000000,0,100000000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,1000000,0,100000000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>ohm</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Fault resistance</Val>
              </DAI>
            </DOI>
            <DOI desc="Distance to fault measured in pu" name="FltDiskm">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,D,100,0,10,10,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,D,100,0,10,10,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,2,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,10000,0,1000000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,10000,0,1000000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,10000,0,1000000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,10000,0,1000000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Distance to fault measured in pu</Val>
              </DAI>
            </DOI>
            <DOI desc="time" name="OpCnt">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,100,32,0,9,1,0,10,1,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,100,32,0,9,1,0,10,1,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,999999,0,999999,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,999999,0,999999,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,999999,0,999999,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,999999,0,999999,Ev-Upd,0"/>
              <DAI name="t" sAddr="DNP02,30,-1,0,16,0,0,0,0,1,0,3000,0,3000,Year Record,1;DNP02,30,-1,0,16,0,0,0,0,1,1,12,1,12,Month Record,2;DNP02,30,-1,0,16,0,0,0,0,1,1,31,1,31,Day Record,3;DNP02,30,-1,0,16,0,0,0,0,1,0,23,0,23,Hour Record,4;DNP02,30,-1,0,16,0,0,0,0,1,0,59,0,59,Minute Record,5;DNP02,30,-1,0,16,0,0,0,0,1,0,59,0,59,Second Record,6;DNP02,30,-1,0,16,0,0,0,0,1,0,999,0,999,MSec Record,7;DNP01,30,-1,0,16,0,0,0,0,1,0,3000,0,3000,Year Record,1;DNP01,30,-1,0,16,0,0,0,0,1,1,12,1,12,Month Record,2;DNP01,30,-1,0,16,0,0,0,0,1,1,31,1,31,Day Record,3;DNP01,30,-1,0,16,0,0,0,0,1,0,23,0,23,Hour Record,4;DNP01,30,-1,0,16,0,0,0,0,1,0,59,0,59,Minute Record,5;DNP01,30,-1,0,16,0,0,0,0,1,0,59,0,59,Second Record,6;DNP01,30,-1,0,16,0,0,0,0,1,0,999,0,999,MSec Record,7"/>
            </DOI>
            <DOI desc="Operate input for triggering" name="InOp">
              <DAI name="d">
                <Val>FLTRFRC1 Operate input for triggering</Val>
              </DAI>
            </DOI>
            <DOI desc="Start input for triggering" name="InStr">
              <DAI name="d">
                <Val>FLTRFRC1 Start input for triggering</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset fault records" name="RcdRs">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,0,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Reset,0,1,0;DNP01,10,-1,0,0,0,BO-Reset,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Reset fault records</Val>
              </DAI>
            </DOI>
            <DOI desc="Select recording" name="SelRow">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="DNP02,40,-1,0,16,0,0,0,0,1,0,1000,0,1000,AO SelectRec;DNP01,40,-1,0,16,0,0,0,0,1,0,1000,0,1000,AO SelectRec"/>
              </SDI>
              <DAI name="minVal">
                <Val>1</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>128</Val>
              </DAI>
              <DAI name="d">
                <Val>FLTRFRC1 Select recording</Val>
              </DAI>
            </DOI>
            <DOI desc="Triggering mode" name="TrgSet"/>
            <DOI desc="A measurement mode" name="AMeasMod"/>
            <DOI desc="Protection function" name="ProFcn">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,100,16,0,A,1,0,10,3,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,100,16,0,A,1,0,10,3,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,-32768,32767,-32768,32767,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,-32768,32767,-32768,32767,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,-32768,32767,-32768,32767,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,-32768,32767,-32768,32767,Ev-Upd,0"/>
            </DOI>
            <DOI desc="Maximum start duration of all stages during the fault" name="StrDur">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,8,100,0,10,5,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,8,100,0,10,5,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,100,0,10000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,100,0,10000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,100,0,10000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,100,0,10000,Ev-Upd,0"/>
              </SDI>
            </DOI>
            <DOI desc="Operate time" name="StrOpTm">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,D,1000,0,10,6,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,D,1000,0,10,6,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,10000000,0,10000000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,10000000,0,10000000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,10000000,0,10000000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,10000000,0,10000000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>s</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Operate time</Val>
              </DAI>
            </DOI>
            <DOI desc="Active setting group" name="ActSetGr">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,100,16,0,8,1,0,10,12,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,100,16,0,8,1,0,10,12,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,1,6,1,6,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,1,6,1,6,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,1,6,1,6,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,1,6,1,6,Ev-Upd,0"/>
              <DAI name="d">
                <Val>FLTRFRC1 Active setting group</Val>
              </DAI>
            </DOI>
            <DOI desc="Shot pointer" name="ShotPntr">
              <DAI name="stVal" sAddr="MBS02,DA07,DA07,100,16,0,8,1,0,10,13,,-1,0,0,0,0,0,0,0,0;MBS01,DA07,DA07,100,16,0,8,1,0,10,13,,-1,0,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,1,7,1,7,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,1,7,1,7,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,1,7,1,7,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,1,7,1,7,Ev-Upd,0"/>
              <DAI name="d">
                <Val>FLTRFRC1 Shot pointer</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum differential current phase A" name="Max50DifAA">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,14,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,14,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,3,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum differential current phase A</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum differential current phase B" name="Max50DifAB">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,15,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,15,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,4,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum differential current phase B</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum differential current phase C" name="Max50DifAC">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,16,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,16,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,5,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum differential current phase C</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum bias current phase A" name="Max50RstAA">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,17,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,17,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,6,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum bias current phase A</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum bias current phase B" name="Max50RstAB">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,18,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,18,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,7,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum bias current phase B</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum bias current phase C" name="Max50RstAC">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,19,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,19,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,8,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum bias current phase C</Val>
              </DAI>
            </DOI>
            <DOI desc="Differential current phase A" name="DifAPhsA">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,20,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,20,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,9,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Differential current phase A</Val>
              </DAI>
            </DOI>
            <DOI desc="Differential current phase B" name="DifAPhsB">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,21,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,21,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,10,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Differential current phase B</Val>
              </DAI>
            </DOI>
            <DOI desc="Differential current phase C" name="DifAPhsC">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,22,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,22,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,11,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Differential current phase C</Val>
              </DAI>
            </DOI>
            <DOI desc="Bias current phase A" name="RstAPhsA">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,23,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,23,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,12,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Bias current phase A</Val>
              </DAI>
            </DOI>
            <DOI desc="Bias current phase B" name="RstAPhsB">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,24,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,24,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,13,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Bias current phase B</Val>
              </DAI>
            </DOI>
            <DOI desc="Bias current phase C" name="RstAPhsC">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,25,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,25,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,14,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,80,0,8000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,80,0,8000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Bias current phase C</Val>
              </DAI>
            </DOI>
            <DOI desc="Differential current residual" name="DifARes"/>
            <DOI desc="Bias current residual" name="RstARes"/>
            <DOI desc="Maximum phase A current" name="Max50APhsA1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,28,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,28,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,17,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum phase A current</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum phase B current" name="Max50APhsB1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,29,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,29,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,18,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum phase B current</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum phase C current" name="Max50APhsC1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,30,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,30,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,19,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum phase C current</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum residual current" name="Max50ARes1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,31,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,31,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,20,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Maximum residual current</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase A current" name="APhsA1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,32,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,32,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,21,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase A current</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase B current" name="APhsB1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,33,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,33,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,22,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase B current</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase C current" name="APhsC1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,34,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,34,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,23,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase C current</Val>
              </DAI>
            </DOI>
            <DOI desc="Residual current" name="ARes1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,35,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,35,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,24,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Residual current</Val>
              </DAI>
            </DOI>
            <DOI desc="Calculated residual current" name="AResClc1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,36,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,36,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,25,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Calculated residual current</Val>
              </DAI>
            </DOI>
            <DOI desc="Positive sequence current" name="APsSeq1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,37,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,37,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,26,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Positive sequence current</Val>
              </DAI>
            </DOI>
            <DOI desc="Negative sequence current" name="ANgSeq1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,38,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,38,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,27,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,50,0,5000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,50,0,5000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Negative sequence current</Val>
              </DAI>
            </DOI>
            <DOI desc="Maximum phase A current (b)" name="Max50APhsA2"/>
            <DOI desc="Maximum phase B current (b)" name="Max50APhsB2"/>
            <DOI desc="Maximum phase C current (b)" name="Max50APhsC2"/>
            <DOI desc="Maximum residual current (b)" name="Max50ARes2"/>
            <DOI desc="Phase A current (b)" name="APhsA2"/>
            <DOI desc="Phase B current (b)" name="APhsB2"/>
            <DOI desc="Phase C current (b)" name="APhsC2"/>
            <DOI desc="Residual current (b)" name="ARes2"/>
            <DOI desc="Calculated residual current (b)" name="AResClc2"/>
            <DOI desc="Positive sequence current (b)" name="APsSeq2"/>
            <DOI desc="Negative sequence current (b)" name="ANgSeq2"/>
            <DOI desc="Maximum phase A current (c)" name="Max50APhsA3"/>
            <DOI desc="Maximum phase B current (c)" name="Max50APhsB3"/>
            <DOI desc="Maximum phase C current (c)" name="Max50APhsC3"/>
            <DOI desc="Maximum residual current (c)" name="Max50ARes3"/>
            <DOI desc="Phase A current (c)" name="APhsA3"/>
            <DOI desc="Phase B current (c)" name="APhsB3"/>
            <DOI desc="Phase C current (c)" name="APhsC3"/>
            <DOI desc="Residual current (c)" name="ARes3"/>
            <DOI desc="Calculated residual current (c)" name="AResClc3"/>
            <DOI desc="Positive sequence current (c)" name="APsSeq3"/>
            <DOI desc="Negative sequence current (c)" name="ANgSeq3"/>
            <DOI desc="Phase A voltage" name="PhVPhsA1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,39,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,39,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,50,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase A voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase B voltage" name="PhVPhsB1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,40,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,40,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,51,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase B voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase C voltage" name="PhVPhsC1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,41,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,41,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,52,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase C voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase A to phase B voltage" name="PPVPhsAB1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,42,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,42,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,53,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase A to phase B voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase B to phase C voltage" name="PPVPhsBC1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,43,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,43,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,54,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase B to phase C voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase C to phase A voltage" name="PPVPhsCA1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,44,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,44,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,55,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase C to phase A voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Residual voltage" name="VRes1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,45,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,45,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,56,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Residual voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Zero sequence voltage" name="VZro1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,46,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,46,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,57,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Zero sequence voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Positive sequence voltage" name="VPsSeq1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,47,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,47,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,58,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Positive sequence voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Negative sequence voltage" name="VNgSeq1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,48,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,48,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,59,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Negative sequence voltage</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase A voltage (b)" name="PhVPhsA2">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,70,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,70,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,60,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase A voltage (b)</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase B voltage (b)" name="PhVPhsB2"/>
            <DOI desc="Phase C voltage (b)" name="PhVPhsC2"/>
            <DOI desc="Phase A to phase B voltage (b)" name="PPVPhsAB2">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,C,1000,0,10,73,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,C,1000,0,10,73,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,63,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,4,0,4000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,4,0,4000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Phase A to phase B voltage (b)</Val>
              </DAI>
            </DOI>
            <DOI desc="Phase B to phase C voltage (b)" name="PPVPhsBC2"/>
            <DOI desc="Phase C to phase A voltage (b)" name="PPVPhsCA2"/>
            <DOI desc="Residual voltage (b)" name="VRes2"/>
            <DOI desc="Zero sequence voltage (b)" name="VZro2"/>
            <DOI desc="Positive sequence voltage (b)" name="VPsSeq2"/>
            <DOI desc="Negative sequence voltage (b)" name="VNgSeq2"/>
            <DOI desc="PTTR thermal level" name="MaxTmpRl">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,8,100,0,10,49,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,8,100,0,10,49,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,70,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,99.99,0,9999,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,99.99,0,9999,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,99.99,0,9999,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,99.99,0,9999,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 PTTR thermal level</Val>
              </DAI>
            </DOI>
            <DOI desc="PDNSPTOC1 rat. I2/I1" name="AMaxNgPs">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,8,100,0,10,50,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,8,100,0,10,50,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,71,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,999.99,0,99999,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,999.99,0,99999,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,999.99,0,99999,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,999.99,0,99999,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 PDNSPTOC1 rat. I2/I1</Val>
              </DAI>
            </DOI>
            <DOI desc="Angle residual voltage - residual current" name="DifANAngVN1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,A,100,0,10,80,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,A,100,0,10,80,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,72,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Angle residual voltage - residual current</Val>
              </DAI>
            </DOI>
            <DOI desc="Angle phase B to phase C voltage - phase A current" name="DifAAAngVBC1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,A,100,0,10,81,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,A,100,0,10,81,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,73,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Angle phase B to phase C voltage - phase A current</Val>
              </DAI>
            </DOI>
            <DOI desc="Angle phase C to phase A voltage - phase B current" name="DifABAngVCA1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,A,100,0,10,82,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,A,100,0,10,82,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,74,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Angle phase C to phase A voltage - phase B current</Val>
              </DAI>
            </DOI>
            <DOI desc="Angle phase A to phase B voltage - phase C current" name="DifACAngVAB1">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,A,100,0,10,83,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,A,100,0,10,83,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,75,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,-180.00,180.00,-18000,18000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,-180.00,180.00,-18000,18000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Angle phase A to phase B voltage - phase C current</Val>
              </DAI>
            </DOI>
            <DOI desc="Angle residual voltage - residual current (b)" name="DifANAngVN2"/>
            <DOI desc="Angle phase B to phase C voltage - phase A current (b)" name="DifAAAngVBC2"/>
            <DOI desc="Angle phase C to phase A voltage - phase B current (b)" name="DifABAngVCA2"/>
            <DOI desc="Angle phase A to phase B voltage - phase C current (b)" name="DifACAngVAB2"/>
            <DOI desc="Frequency gradient" name="HzRteChg">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,A,100,0,10,51,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,A,100,0,10,51,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,80,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,-10.00,10.00,-1000,1000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,-10.00,10.00,-1000,1000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,-10.00,10.00,-1000,1000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,-10.00,10.00,-1000,1000,Ev-Upd,0"/>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Frequency gradient</Val>
              </DAI>
            </DOI>
            <DOI desc="Conductance Yo" name="CondNeut">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>S</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>m</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Conductance Yo</Val>
              </DAI>
            </DOI>
            <DOI desc="Susceptance Yo" name="SusNeut">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>S</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>m</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Susceptance Yo</Val>
              </DAI>
            </DOI>
            <DOI desc="Fault loop resistance" name="PPLoopRis"/>
            <DOI desc="Fault loop reactance" name="PPLoopReact"/>
            <DOI desc="Breaker open status" name="InCBClr">
              <DAI name="d">
                <Val>FLTRFRC1 Breaker open status</Val>
              </DAI>
            </DOI>
            <DOI desc="Breaker clear time" name="CBClrTm">
              <SDI name="mag">
                <DAI name="f" sAddr="MBS02,DA08,DA08,100,8,1000,0,10,58,,-1,0,0,0,0,0,0,0,0;MBS01,DA08,DA08,100,8,1000,0,10,58,,-1,0,0,0,0,0,0,0,0;I3C,DA07,DA07,0,1,2,66,85,1,0,7,0,0,0,0,0,0,0;DNP02,30,-1,0,16,0,0,0,0,1,0,3.000,0,3000,Record,0;DNP02,30,-1,0,5,0,0,0,0,1,0,3.000,0,3000,Ev-Upd,0;DNP01,30,-1,0,16,0,0,0,0,1,0,3.000,0,3000,Record,0;DNP01,30,-1,0,5,0,0,0,0,1,0,3.000,0,3000,Ev-Upd,0"/>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>s</Val>
                </DAI>
              </SDI>
              <DAI name="d">
                <Val>FLTRFRC1 Breaker clear time</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="LDPRLRC1" lnType="LDPRLRC1_ED2_D_11" inst="1" lnClass="RLRC" prefix="LDP">
            <Private type="ABB_CommonSA_FunctionInstanceRef">159</Private>
            <Private type="ABB_FunctionRefs">1a47d733-a644-45c3-ad36-5acbd9aa7129</Private>
            <DOI desc="Mode" name="Mod"/>
            <DOI desc="Name plate" name="NamPlt">
              <DAI name="swRev">
                <Val>D</Val>
              </DAI>
            </DOI>
            <DOI desc="Reset load profile rec." name="RcdRs">
              <SDI name="Oper">
                <DAI name="ctlVal" sAddr="MBS02,DA10,DA10,0,-5,0,0,0,,0,0,0;MBS01,DA10,DA10,0,-5,0,0,0,,0,0,0;DNP02,10,-1,0,0,0,BO-Single,0,1,0;DNP01,10,-1,0,0,0,BO-Single,0,1,0"/>
              </SDI>
              <DAI name="d">
                <Val>LDPRLRC1 Reset load profile rec.</Val>
              </DAI>
            </DOI>
            <DOI desc="Quantity selection 1" name="QtySel1"/>
            <DOI desc="Quantity selection 2" name="QtySel2"/>
            <DOI desc="Quantity selection 3" name="QtySel3"/>
            <DOI desc="Quantity selection 4" name="QtySel4"/>
            <DOI desc="Quantity selection 5" name="QtySel5"/>
            <DOI desc="Quantity selection 6" name="QtySel6"/>
            <DOI desc="Quantity selection 7" name="QtySel7"/>
            <DOI desc="Quantity selection 8" name="QtySel8"/>
            <DOI desc="Quantity selection 9" name="QtySel9"/>
            <DOI desc="Quantity selection 10" name="QtySel10"/>
            <DOI desc="Quantity selection 11" name="QtySel11"/>
            <DOI desc="Quantity selection 12" name="QtySel12"/>
            <DOI desc="Rec. memory used" name="MemUsed"/>
            <DOI desc="Memory warning" name="MemWrn">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,10,198,1,10,198,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
            </DOI>
            <DOI desc="Memory alarm" name="MemAlm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,FB,-5,,0,0;MBS01,DA03,DA03,0,0,0,FB,-5,,0,0;I3C,DA03,DA03,0,10,199,1,10,199,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
            </DOI>
            <DOI desc="Mem. warning level" name="MemWrnLev">
              <DAI name="maxVal">
                <Val>100</Val>
              </DAI>
            </DOI>
            <DOI desc="Mem. alarn level" name="MemAlmLev">
              <DAI name="maxVal">
                <Val>100</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Current (3I,CT)" lnType="ILTCTR1_ED2_F_25" inst="1" lnClass="TCTR" prefix="IL1">
            <Private type="ABB_CommonSA_FunctionInstanceRef">30</Private>
            <Private type="ABB_FunctionRefs">d4ee4608-b4f2-48ae-8e5f-d0f962b31102</Private>
            <DOI desc="Current (Sampled value) phase A" name="AmpSv">
              <SDI name="sVC">
                <DAI name="scaleFactor">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Primary rated current" name="ARtg">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>A</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>6000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Phase A Current phasor magnitude correction of an external current transformer" name="Cor">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.9</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>1.1</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Phase A Current phasor angle correction of an external current transformer" name="AngCor">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>-20</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>20</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Alarm" name="Alm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,-5,,0,0;MBS01,DA03,DA03,0,0,0,7B,-5,,0,0;I3C,DA03,DA03,0,81,102,1,81,102,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Current (3I,CT) Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning" name="Wrn">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,-5,,0,0;MBS01,DA03,DA03,0,0,0,7B,-5,,0,0;I3C,DA03,DA03,0,81,101,1,81,101,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Current (3I,CT) Warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Secondary rated current" name="ARtgScy"/>
            <DOI desc="Network Nominal Current" name="ARtgNom"/>
            <DOI desc="Rated Secondary Value" name="VRtgScyRat"/>
            <DOI desc="Reverse polarity" name="RevPol"/>
          </LN>
          <LN desc="Current (3I,CT)" lnType="ILTCTR1_ED2_F_25" inst="1" lnClass="TCTR" prefix="IL2">
            <Private type="ABB_CommonSA_FunctionInstanceRef">30</Private>
            <Private type="ABB_FunctionRefs">d4ee4608-b4f2-48ae-8e5f-d0f962b31102</Private>
            <DOI desc="Current (Sampled value) phase B" name="AmpSv">
              <SDI name="sVC">
                <DAI name="scaleFactor">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Primary rated current" name="ARtg">
              <SDI name="setMag">
                <DAI name="f">
                  <Val>100</Val>
                </DAI>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>A</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>6000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Amplitude corr. B" name="Cor">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.9</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>1.1</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Phase B Current phasor angle correction of an external current transformer" name="AngCor">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>-20</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>20</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Alarm" name="Alm">
              <DAI name="d">
                <Val>Current (3I,CT) Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning" name="Wrn">
              <DAI name="d">
                <Val>Current (3I,CT) Warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Secondary rated current" name="ARtgScy">
              <DAI name="setVal">
                <Val>1A</Val>
              </DAI>
            </DOI>
            <DOI desc="Network Nominal Current" name="ARtgNom">
              <SDI name="setMag">
                <DAI name="f">
                  <Val>1300</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>39</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>4000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Rated Secondary Value" name="VRtgScyRat">
              <SDI name="setMag">
                <DAI name="f">
                  <Val>3</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>150</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Reverse polarity" name="RevPol"/>
          </LN>
          <LN desc="Current (3I,CT)" lnType="ILTCTR1_ED2_F_25" inst="1" lnClass="TCTR" prefix="IL3">
            <Private type="ABB_CommonSA_FunctionInstanceRef">30</Private>
            <Private type="ABB_FunctionRefs">d4ee4608-b4f2-48ae-8e5f-d0f962b31102</Private>
            <DOI desc="Current (Sampled value) phase C" name="AmpSv">
              <SDI name="sVC">
                <DAI name="scaleFactor">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Primary rated current" name="ARtg">
              <SDI name="setMag">
                <DAI name="f">
                  <Val>100</Val>
                </DAI>
              </SDI>
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>A</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>6000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Amplitude corr. C" name="Cor">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.9</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>1.1</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Phase C Current phasor angle correction of an external current transformer" name="AngCor">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>-20</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>20</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Alarm" name="Alm">
              <DAI name="d">
                <Val>Current (3I,CT) Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning" name="Wrn">
              <DAI name="d">
                <Val>Current (3I,CT) Warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Secondary rated current" name="ARtgScy">
              <DAI name="setVal">
                <Val>1A</Val>
              </DAI>
            </DOI>
            <DOI desc="Network Nominal Current" name="ARtgNom">
              <SDI name="setMag">
                <DAI name="f">
                  <Val>1300</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>39</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>4000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Rated Secondary Value" name="VRtgScyRat">
              <SDI name="setMag">
                <DAI name="f">
                  <Val>3</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>150</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Reverse polarity" name="RevPol"/>
          </LN>
          <LN desc="Current (Io,CT)" lnType="RESTCTR1_ED2_D_13" inst="1" lnClass="TCTR" prefix="RES">
            <Private type="ABB_CommonSA_FunctionInstanceRef">31</Private>
            <Private type="ABB_FunctionRefs">0df15e46-f100-419b-8ea5-572373fdbc4a</Private>
            <DOI desc="Current (Sampled value)" name="AmpSv">
              <SDI name="sVC">
                <DAI name="scaleFactor">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Primary rated current" name="ARtg">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>A</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>6000</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Current phasor magnitude correction of an external current transformer" name="Cor">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.9</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>1.1</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Residual Current phasor angle correction of an external current transformer" name="AngCor">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>-20</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>20</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Alarm" name="Alm">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,-5,,0,0;MBS01,DA03,DA03,0,0,0,7B,-5,,0,0;I3C,DA03,DA03,0,81,106,1,81,106,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Current (Io,CT) Alarm</Val>
              </DAI>
            </DOI>
            <DOI desc="Warning" name="Wrn">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,-5,,0,0;MBS01,DA03,DA03,0,0,0,7B,-5,,0,0;I3C,DA03,DA03,0,81,105,1,81,105,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>Current (Io,CT) Warning</Val>
              </DAI>
            </DOI>
            <DOI desc="Secondary rated current" name="ARtgScy"/>
            <DOI desc="Reverse polarity" name="RevPol"/>
          </LN>
          <LN desc="X120 (AIM)" lnType="XGGIO120_ED2_E_18" inst="120" lnClass="GGIO" prefix="X">
            <Private type="ABB_CommonSA_FunctionInstanceRef">10</Private>
            <Private type="ABB_FunctionRefs">84f19971-0b36-4f31-b038-16df4f148b86</Private>
            <DOI desc="X120-Input 1" name="Ind1">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3200,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3200,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,51,1,1,51,1,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X120 (AIM) X120-Input 1</Val>
              </DAI>
            </DOI>
            <DOI desc="X120-Input 2" name="Ind2">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3202,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3202,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,51,2,1,51,2,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X120 (AIM) X120-Input 2</Val>
              </DAI>
            </DOI>
            <DOI desc="X120-Input 3" name="Ind3">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3204,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3204,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,51,3,1,51,3,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X120 (AIM) X120-Input 3</Val>
              </DAI>
            </DOI>
            <DOI desc="X120-Input 4" name="Ind4">
              <DAI name="stVal" sAddr="MBS02,DA03,DA03,0,0,0,7B,3206,,0,0;MBS02,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;MBS01,DA03,DA03,0,0,0,7B,3206,,0,0;MBS01,DA03,DA03,0,0,0,5B,-5,MomOnly,0,0;I3C,DA03,DA03,0,51,4,1,51,4,-1,0,1,0,,0,1,0;DNP02,1,-1,0,3,0,0,BI-EvUpd,0;DNP01,1,-1,0,3,0,0,BI-EvUpd,0"/>
              <DAI name="d">
                <Val>X120 (AIM) X120-Input 4</Val>
              </DAI>
            </DOI>
            <DOI desc="Input 1 filter time" name="FilTmms1">
              <DAI name="minVal">
                <Val>5</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI desc="Input 2 filter time" name="FilTmms2">
              <DAI name="minVal">
                <Val>5</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI desc="Input 3 filter time" name="FilTmms3">
              <DAI name="minVal">
                <Val>5</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI desc="Input 4 filter time" name="FilTmms4">
              <DAI name="minVal">
                <Val>5</Val>
              </DAI>
              <DAI name="maxVal">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI desc="Input 1 inversion" name="DigInInv1"/>
            <DOI desc="Input 2 inversion" name="DigInInv2"/>
            <DOI desc="Input 3 inversion" name="DigInInv3"/>
            <DOI desc="Input 4 inversion" name="DigInInv4"/>
            <DOI desc="Card information" name="CardNam"/>
            <DOI desc="HW module" name="HwId"/>
            <DOI desc="Testing" name="TestStaId"/>
          </LN>
          <LN desc="Voltage (3U,VT)" lnType="ULTVTR1_ED2_F_26" inst="1" lnClass="TVTR" prefix="UL1">
            <Private type="ABB_CommonSA_FunctionInstanceRef">33</Private>
            <Private type="ABB_FunctionRefs">42b1f50c-bb38-4c93-af87-fd6e425b3247</Private>
            <DOI desc="Voltage (sampled value) phase A" name="VolSv">
              <SDI name="sVC">
                <DAI name="scaleFactor">
                  <Val>1</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="TVTR fuse failure" name="FuFail">
              <DAI name="d">
                <Val>Voltage (3U,VT) TVTR fuse failure</Val>
              </DAI>
            </DOI>
            <DOI desc="Primary rated voltage" name="VRtg">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>V</Val>
                </DAI>
                <DAI name="multiplier">
                  <Val>k</Val>
                </DAI>
              </SDI>
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.1</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>440</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Division ratio" name="Rat"/>
            <DOI desc="Amplitude corr. A" name="Cor">
              <SDI name="minVal">
                <DAI name="f">
                  <Val>0.9</Val>
                </DAI>
              </SDI>
              <SDI name="maxVal">
                <DAI name="f">
                  <Val>1.1</Val>
                </DAI>
              </SDI>
              <SDI name="stepSize">
                <DAI name="f">
                  <Val>0.0001</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI desc="Angle corr. A" name="AngCor">
              <SDI name="units">
                <DAI name="SIUnit">
                  <Val>deg</Val>
                </DAI>
              </SDI>
         