<?xml version="1.0" encoding="UTF-8"?>
<SCL xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.iec.ch/61850/2003/SCL" xmlns:eComm="http://www.abb.com/61850/2015/SCL_ABBCommunication" xmlns:sxy="http://www.iec.ch/61850/2003/SCLcoordinates" revision="B" version="2007">
  <Header id="IEC61850WeekDemo" nameStructure="IEDName" revision="R000" toolID="Helinks STS 3.8.0.0" version="V1">
    <History>
      <Hitem revision="R000" version="V1" what="Starting Point" when="Tue Mar 07 12:46:42 CET 2023" who="JR" why="Helinks STS Top Down Demo"/>
    </History>
  </Header>
  <Substation sxy:x="3" desc="Library Project" name="Berlin">
    <PowerTransformer sxy:x="6" name="T1" type="PTR">
      <TransformerWinding name="W1" type="PTW"/>
      <TransformerWinding name="W2" type="PTW">
        <Terminal bayName="02" cNodeName="CN_5c6dcbe7-8fa1-46fd-8e3f-0c14c2893a4f" connectivityNode="Berlin/E/02/CN_5c6dcbe7-8fa1-46fd-8e3f-0c14c2893a4f" name="TW" substationName="Berlin" voltageLevelName="E"/>
      </TransformerWinding>
    </PowerTransformer>
    <PowerTransformer sxy:x="29" sxy:y="1" name="T2" type="PTR">
      <TransformerWinding name="W1" type="PTW"/>
      <TransformerWinding name="W2" type="PTW"/>
    </PowerTransformer>
    <VoltageLevel sxy:y="10" name="E">
      <Voltage multiplier="k" unit="V">110</Voltage>
      <Bay name="BB">
        <Private source="HELINKS LLC" type="IS_BUSBAR"/>
        <ConnectivityNode name="L1" pathName="Berlin/E/BB/L1"/>
      </Bay>
      <Bay sxy:x="37" sxy:y="1" name="LineFeeder">
        <ConductingEquipment sxy:x="1" name="QB1" type="DIS">
          <Terminal bayName="01" cNodeName="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" connectivityNode="Berlin/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" name="T2" substationName="Berlin" voltageLevelName="E"/>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Berlin/E/BB/L1" name="T1" substationName="Berlin" voltageLevelName="E"/>
          <EqFunction name="Control"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="3" name="QA0" type="CBR">
          <Terminal bayName="01" cNodeName="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" connectivityNode="Berlin/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" name="T1" substationName="Berlin" voltageLevelName="E"/>
          <Terminal bayName="01" cNodeName="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" connectivityNode="Berlin/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" name="T2" substationName="Berlin" voltageLevelName="E"/>
          <EqFunction name="Control"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="6" name="CT" type="CTR">
          <Terminal bayName="01" cNodeName="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" connectivityNode="Berlin/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" name="T1" substationName="Berlin" voltageLevelName="E"/>
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Berlin/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T2" substationName="Berlin" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A"/>
          <SubEquipment name="L2" phase="B"/>
          <SubEquipment name="L3" phase="C"/>
          <SubEquipment name="L4" phase="N"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:y="8" name="VT" type="VTR">
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Berlin/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T1" substationName="Berlin" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A"/>
          <SubEquipment name="L2" phase="B"/>
          <SubEquipment name="L3" phase="C"/>
          <SubEquipment name="L4" phase="N"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="10" name="Line" type="IFL">
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Berlin/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T1" substationName="Berlin" voltageLevelName="E"/>
        </ConductingEquipment>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/01/grounded"/>
        <ConnectivityNode name="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" pathName="Cardiff/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35"/>
        <ConnectivityNode name="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" pathName="Cardiff/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d"/>
        <ConnectivityNode name="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" pathName="Cardiff/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c"/>
        <Function name="Measurement"/>
        <Function name="Distance"/>
        <Function name="Overcurrent"/>
        <Function name="Trip"/>
        <Function name="BreakerFailure"/>
      </Bay>
    </VoltageLevel>
    <Function name="HMI">
      <LNode iedName="Zenon" ldInst="HMI" lnClass="ITCI" lnInst="1" lnType="ITCI_ZENON" prefix="">
        <Private type="eIEC61850-6-100"/>
      </LNode>
    </Function>
    <Function name="NCC">
      <LNode iedName="XPG" ldInst="LD0" lnClass="ITCI" lnInst="1" lnType="itci_7_4_B2007" prefix="">
        <Private type="eIEC61850-6-100"/>
      </LNode>
    </Function>
  </Substation>
  <Communication>
    <SubNetwork name="StationBus" type="8-MMS">
      <ConnectedAP apName="S1" iedName="Zenon">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="XPG">
        <Address>
          <P type="IP">10.10.0.2</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E04BCU">
        <Address>
          <P type="IP">192.168.0.7</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E01BUP">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E01BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">172.24.7.111</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">172.24.7.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E02BCU">
        <Address>
          <P type="IP">127.0.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,1</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">127.0.0.0</P>
          <P type="OSI-AE-Qualifier">12</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E01BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.254</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">192.168.2.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.16.60.65</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02BUP">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.16.60.65</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E03BUP">
        <Address>
          <P type="IP">192.168.0.3</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E03BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E04BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.8</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E04BUP">
        <Address>
          <P type="IP">192.168.0.9</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.5</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05BUP">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.6</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E05BCU">
        <Address>
          <P type="IP">192.168.0.4</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E06BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.11</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E06BUP">
        <Address>
          <P type="IP">192.168.0.12</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E06BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.10</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
    </SubNetwork>
    <SubNetwork name="ProcessBus" type="8-MMS">
      <ConnectedAP apName="F" iedName="E01BCU">
        <Address>
          <P type="IP">10.10.0.2</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E01BPU">
        <Address>
          <P type="IP">10.10.0.3</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E02BPU">
        <Address>
          <P type="IP">10.10.0.4</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E02BUP">
        <Address>
          <P type="IP">10.10.0.5</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E01BUP">
        <Address>
          <P type="IP">10.10.0.6</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E03BCU">
        <Address>
          <P type="IP">10.10.0.7</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E03BUP">
        <Address>
          <P type="IP">10.10.0.9</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E05BPU">
        <Address>
          <P type="IP">10.10.0.12</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E05BUP">
        <Address>
          <P type="IP">10.10.0.13</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E04BPU">
        <Address>
          <P type="IP">10.10.0.18</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E04BUP">
        <Address>
          <P type="IP">10.10.0.19</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E06BCU">
        <Address>
          <P type="IP">10.10.0.20</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E06BPU">
        <Address>
          <P type="IP">10.10.0.21</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E06BUP">
        <Address>
          <P type="IP">10.10.0.22</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E01PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">00000001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="S2" iedName="E02BCU">
        <Address>
          <P type="IP">127.0.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,1</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">127.0.0.0</P>
          <P type="OSI-AE-Qualifier">12</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02PIU" redProt="prp">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.100.103</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">192.168.100.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E03PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.17</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">Connection Port TS1-X103 Type RJ45RedConn Port TS1-X104 Type RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E04PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.16</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">Connection Port TS1-X103 Type RJ45RedConn Port TS1-X104 Type RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E04BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.10.0.10</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05PIU" redProt="prp">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.10.0.14</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S2" iedName="E05BCU">
        <Address>
          <P type="IP">10.10.0.11</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E06PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.15</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">Connection Port TS1-X103 Type RJ45RedConn Port TS1-X104 Type RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
    </SubNetwork>
  </Communication>
  <IED configVersion="1" manufacturer="no manufacturer" type="gateway" name="XPG">
    <Services nameLength="64">
      <DynAssociation max="10"/>
      <SettingGroups>
        <SGEdit resvTms="false"/>
        <ConfSG resvTms="false"/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <SetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="32" maxAttributes="100" modify="true"/>
      <DynDataSet max="32" maxAttributes="100"/>
      <ReadWrite/>
      <ConfReportControl max="16" bufConf="true" bufMode="both"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Conf" bufTime="Conf" intgPd="Conf" optFields="Conf" owner="true" resvTms="true" rptID="Conf" trgOps="Conf"/>
      <LogSettings cbName="Conf" datSet="Conf" intgPd="Conf" logEna="Conf" trgOps="Conf"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf"/>
      <GSEDir/>
      <GOOSE max="8" fixedOffs="false"/>
      <SMVsc max="12" delivery="both" deliveryConf="true"/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="true" goose="true" gsse="false" maxAttributes="250" maxGOOSE="32" maxReports="32" maxSMV="32" readLog="false" supportsLdName="true" sv="true" unbufReport="true">
        <TimeSyncProt sntp="true" c37_238="false" other="false"/>
      </ClientServices>
      <ConfLdName/>
    </Services>
    <AccessPoint clock="false" router="false" name="AP1">
      <Server>
        <Authentication none="true"/>
        <LDevice inst="LD0">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="lphd_7_4_B2007" inst="1" lnClass="LPHD"/>
          <LN lnType="itci_7_4_B2007" inst="1" lnClass="ITCI">
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mir.desc" name="Mir">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcExp.desc" name="ClcExp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcStr.desc" name="ClcStr">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMth.desc" name="ClcMth">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMod.desc" name="ClcMod">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvTyp.desc" name="ClcIntvTyp">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvPer.desc" name="ClcIntvPer">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.NumSubIntv.desc" name="NumSubIntv">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfTyp.desc" name="ClcRfTyp">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfPer.desc" name="ClcRfPer">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcSrc.desc" name="ClcSrc">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcNxtTmms.desc" name="ClcNxtTmms">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.InSyn.desc" name="InSyn">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEName.desc" name="EEName">
              <DAI name="vendor" valKind="Set"/>
              <DAI name="hwRev" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="serNum" valKind="Set"/>
              <DAI name="model" valKind="Set"/>
              <DAI name="location" valKind="Set"/>
              <DAI name="name" valKind="Set"/>
              <DAI name="owner" valKind="Set"/>
              <DAI name="ePSName" valKind="Set"/>
              <DAI name="primeOper" valKind="Set"/>
              <DAI name="secondOper" valKind="Set"/>
              <DAI name="latitude" valKind="Set"/>
              <DAI name="longitude" valKind="Set"/>
              <DAI name="altitude" valKind="Set"/>
              <DAI name="mRID" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEHealth.desc" name="EEHealth">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.OpTmh.desc" name="OpTmh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupI::ITCI.Alm.desc" name="Alm">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
  </IED>
  <IED desc="ZENON HMI" configVersion="2.1" manufacturer="Copa-Data" originalSclRevision="B" originalSclVersion="2007" owner="" type="ZENON" name="Zenon">
    <AccessPoint clock="true" name="S1">
      <LN lnType="ITCI_ZENON" inst="1" lnClass="ITCI"/>
      <Services nameLength="64">
        <ClientServices bufReport="true" maxAttributes="50000" maxReports="200" supportsLdName="true" unbufReport="true">
          <TimeSyncProt sntp="true"/>
        </ClientServices>
        <TimeSyncProt sntp="true"/>
      </Services>
    </AccessPoint>
    <AccessPoint clock="true" name="S2">
      <LN lnType="ITCI_ZENON" inst="2" lnClass="ITCI"/>
      <Services nameLength="64">
        <ClientServices bufReport="true" maxAttributes="50000" maxReports="200" supportsLdName="true" unbufReport="true">
          <TimeSyncProt sntp="true"/>
        </ClientServices>
        <TimeSyncProt sntp="true"/>
      </Services>
    </AccessPoint>
  </IED>
  <IED desc="SAM600-MU" configVersion="1.0" manufacturer="ABB" originalSclRevision="B" originalSclVersion="2007" type="SAM600" name="E01PIU">
    <Private type="ABB_PCMObjectTypeName">SAM600</Private>
    <Private type="ABBPCMInternalObjRef">5daad46d-3102-4342-bc72-72a3ee953258</Private>
    <Private type="ABB SAM600 Stream Mapping">
      <eSAM:ArrayOfStreamMapping xmlns:eSAM="http://www.abb.com/61850/2016/SAM600Mapping">
        <eSAM:StreamMapping>
          <eSAM:StreamId>Stream01</eSAM:StreamId>
          <eSAM:MappedLds>
            <eSAM:string>MU01</eSAM:string>
          </eSAM:MappedLds>
          <eSAM:SelectedCt>CT1</eSAM:SelectedCt>
          <eSAM:SelectedVt>VT1</eSAM:SelectedVt>
        </eSAM:StreamMapping>
      </eSAM:ArrayOfStreamMapping>
    </Private>
    <Private type="ABB Comm">
      <eComm:CommNode x="-536870912" y="-536870912">
        <eComm:MergingUnit/>
        <eComm:Port id="TS1-X103" xRel="0" yRel="0"/>
        <eComm:Port id="TS1-X104" xRel="0" yRel="0"/>
      </eComm:CommNode>
    </Private>
    <Services nameLength="64">
      <DynAssociation max="6"/>
      <SettingGroups>
        <SGEdit resvTms="true"/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="50" maxAttributes="100" modify="true"/>
      <DynDataSet max="30" maxAttributes="60"/>
      <ReadWrite/>
      <ConfReportControl max="60" bufConf="true" bufMode="both"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" resvTms="true" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
      <SMVSettings cbName="Conf" datSet="Conf">
        <SmpRate>80</SmpRate>
      </SMVSettings>
      <GOOSE max="16" fixedOffs="false"/>
      <SMVsc max="10"/>
      <FileHandling/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="false" goose="true" gsse="false" maxAttributes="1000" maxGOOSE="128" readLog="false" supportsLdName="true" sv="false" unbufReport="false">
        <TimeSyncProt/>
      </ClientServices>
      <ConfLdName/>
      <SupSubscription maxGo="128" maxSv="0"/>
      <ValueHandling setToRO="false"/>
      <RedProt hsr="true" prp="true" rstp="true"/>
      <CommProt ipv6="false"/>
    </Services>
    <AccessPoint name="SAM600ServerModel">
      <Server>
        <Authentication/>
        <LDevice inst="LD0" ldName="CardiffETransformerTrip">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="ptrc_7_4_B2007" inst="1" lnClass="PTRC" prefix="Trip">
            <DOI desc="IEC61850_7_4.LNGroupP::PTRC.Tr.desc" name="Tr">
              <DAI name="general" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QB1Interface" ldName="CardiffETransformerQB1Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xswi_7_4_B2007" inst="1" lnClass="XSWI" prefix="QB1">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QA0Interface" ldName="CardiffETransformerQA0Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xcbr_7_4_B2007" inst="1" lnClass="XCBR" prefix="QA0">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="CTCT" ldName="CardiffETransformerCTCT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="2" lnClass="TCTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="3" lnClass="TCTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="VTVT" ldName="CardiffETransformerVTVT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tvtr_7_4_B2007" inst="1" lnClass="TVTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="2" lnClass="TVTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="3" lnClass="TVTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="4" lnClass="TVTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="S1">
      <ServerAt apName="SAM600ServerModel"/>
      <Services nameLength="64">
        <DynAssociation max="6"/>
        <SettingGroups>
          <SGEdit resvTms="true"/>
        </SettingGroups>
        <GetDirectory/>
        <GetDataObjectDefinition/>
        <DataObjectDirectory/>
        <GetDataSetValue/>
        <DataSetDirectory/>
        <ConfDataSet max="50" maxAttributes="100" modify="true"/>
        <DynDataSet max="30" maxAttributes="60"/>
        <ReadWrite/>
        <ConfReportControl max="60" bufConf="true" bufMode="both"/>
        <GetCBValues/>
        <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" resvTms="true" rptID="Dyn" trgOps="Dyn"/>
        <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
        <SMVSettings cbName="Conf" datSet="Conf">
          <SmpRate>80</SmpRate>
        </SMVSettings>
        <GOOSE max="16" fixedOffs="false"/>
        <SMVsc max="10"/>
        <FileHandling/>
        <ConfLNs fixLnInst="false" fixPrefix="false"/>
        <ClientServices bufReport="false" goose="true" gsse="false" maxGOOSE="128" readLog="false" supportsLdName="true" sv="false" unbufReport="false">
          <TimeSyncProt/>
        </ClientServices>
        <ConfLdName/>
        <SupSubscription maxGo="128" maxSv="0"/>
        <ValueHandling setToRO="false"/>
        <RedProt hsr="true" prp="true" rstp="true"/>
        <CommProt ipv6="false"/>
      </Services>
    </AccessPoint>
  </IED>
  <IED desc="BEV2-P545" configVersion="P545v71I" manufacturer="ALSTOM" originalSclRevision="B" originalSclVersion="2007" type="P545" name="E01BUP">
    <Private type="MiCOM-ModellingToolID">ALSTOM IEC61850 Px40 Modelling Tool</Private>
    <Private type="MiCOM-ModellingToolVersion">2.34</Private>
    <Private type="MiCOM-ModelNumber">P545???????710* (I)</Private>
    <Private type="MiCOM-SNTPServers">2</Private>
    <Private type="MiCOM-TimeServer"/>
    <Private type="MiCOM-MCLVersion">V2.0</Private>
    <Private type="MiCOM-UniqueID">33727749-529753443.9-6509</Private>
    <Services>
      <DynAssociation/>
      <SettingGroups/>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="100" modify="true"/>
      <ReadWrite/>
      <ConfReportControl max="24"/>
      <GetCBValues/>
      <ReportSettings cbName="Fix" datSet="Conf" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Fix" datSet="Conf" appID="Conf"/>
      <GOOSE max="8"/>
      <FileHandling/>
      <ConfLNs fixLnInst="true" fixPrefix="true"/>
      <ClientServices sv="true"/>
    </Services>
    <AccessPoint desc="IEC61850 Interface" clock="false" router="false" name="AP1">
      <Server desc="IEC61850 Compliant data model" timeout="900">
        <Authentication none="true"/>
        <LDevice inst="Overcurrent">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="ptoc_7_4_B2007" inst="1" lnClass="PTOC" prefix="PH"/>
          <LN lnType="ptrc_7_4_B2007" inst="1" lnClass="PTRC" prefix="OC"/>
          <LN lnType="tctr_7_4_B2007" inst="5" lnClass="TCTR" prefix="A"/>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="B"/>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="C"/>
          <LN lnType="tctr_7_4_B2007" inst="6" lnClass="TCTR" prefix="N"/>
        </LDevice>
        <LDevice desc="Controls Domain" inst="Control">
          <LN0 desc="Controls Logical Device" lnType="LLN0_CONTROL$_0669a0bf-605c-44e1-aa70-e1a4ba7df2ce" inst="" lnClass="LLN0">
            <Private type="MiCOM-ConfigurableAttributes">AscMod.ctlModel,ArcMod.ctlModel,PsbMod.ctlModel,</Private>
            <DOI name="ArcBeh">
              <DAI desc="[09 24] - Auto-Reclose" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 24] - Auto-Reclose" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ArcMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 24] - Auto-Reclose" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 24] - Auto-Reclose" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="AscBeh">
              <DAI desc="[09 23] - System Checks" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 23] - System Checks" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="AscMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 23] - System Checks" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 23] - System Checks" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Controls Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PsbBeh">
              <DAI desc="[09 18] - PowerSwing Block" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 18] - PowerSwing Block" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PsbMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 18] - PowerSwing Block" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 18] - PowerSwing Block" name="stVal" valKind="RO"/>
            </DOI>
          </LN0>
          <LN desc="Auto Reclose" lnType="RREC_NO_SEG" inst="1" lnClass="RREC" prefix="Arc">
            <DOI name="AutoRecSt">
              <DAI desc="Reads the Autoreclose (CB1) Status with respect to the 'AutoRecSt' Attribute in the RREC Logical Node." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 64] - ArcRREC1.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 24] - Auto-Reclose" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[09 24] - Auto-Reclose" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 854" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="System Checks - Check Sync 1" lnType="RSYN_DIFCLC_ENH" inst="1" lnClass="RSYN" prefix="Asc">
            <Private type="MiCOM-ConfigurableAttributes">DifHzClc.units.multiplier,DifHzClc.db,DifHzClc.rangeC.min.f,DifHzClc.rangeC.max.f,DifAngClc.units.multiplier,DifAngClc.db,DifAngClc.rangeC.min.f,DifAngClc.rangeC.max.f,</Private>
            <DOI name="AngInd">
              <DAI desc="Returns Status of Angle Difference Indicator for Circuit Breaker 1 Check Sync Threshold 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 05] - AscRSYN1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAngClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>360</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="DifHzClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 31] - Slip Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 31] - Slip Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="HzInd">
              <DAI desc="Returns Status of Frequency Difference Indicator for Circuit Breaker 1 Check Sync Threshold 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[48 8F] - CS1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[48 8F] - CS1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Rel">
              <DAI desc="DDB Ordinal: 883" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VInd">
              <DAI desc="Returns Status of Voltage Difference Indicator for Circuit Breaker 1 Check Sync Threshold 1" name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="System Checks - Check Sync 2" lnType="RSYN_DIFCLC_ENH" inst="2" lnClass="RSYN" prefix="Asc">
            <Private type="MiCOM-ConfigurableAttributes">DifHzClc.units.multiplier,DifHzClc.db,DifHzClc.rangeC.min.f,DifHzClc.rangeC.max.f,DifAngClc.units.multiplier,DifAngClc.db,DifAngClc.rangeC.min.f,DifAngClc.rangeC.max.f,</Private>
            <DOI name="AngInd">
              <DAI desc="Returns Status of Angle Difference Indicator for Circuit Breaker 1 Check Sync Threshold 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 06] - AscRSYN2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAngClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>360</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="DifHzClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 31] - Slip Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 31] - Slip Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="HzInd">
              <DAI desc="Returns Status of Frequency Difference Indicator for Circuit Breaker 1 Check Sync Threshold 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[48 94] - CS2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[48 94] - CS2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Rel">
              <DAI desc="DDB Ordinal: 884" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VInd">
              <DAI desc="Returns Status of Voltage Difference Indicator for Circuit Breaker 1 Check Sync Threshold 2" name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Interlocking (Pole 1)" lnType="CILO_INTERLOCK" inst="1" lnClass="CILO">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaCls">
              <DAI desc="DDB Ordinal: 1717" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaOpn">
              <DAI desc="DDB Ordinal: 1718" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>direct-with-normal-security</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>CB (1) Condition (Pole 1)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Interlocking (Pole 2)" lnType="CILO_INTERLOCK" inst="2" lnClass="CILO">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaCls">
              <DAI desc="DDB Ordinal: 1717" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaOpn">
              <DAI desc="DDB Ordinal: 1718" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>direct-with-normal-security</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>CB (1) Condition (Pole 2)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Interlocking (Pole 3)" lnType="CILO_INTERLOCK" inst="3" lnClass="CILO">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaCls">
              <DAI desc="DDB Ordinal: 1717" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaOpn">
              <DAI desc="DDB Ordinal: 1718" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>direct-with-normal-security</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>CB (1) Condition (Pole 3)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Out of Step Tripping (main trip)" lnType="RPSB_OST" inst="1" lnClass="RPSB" prefix="Ost">
            <DOI name="Beh">
              <DAI desc="[FE 35] - OstRPSB1.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 23] - OST Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Out of Step tripping (Main)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 553" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Out of Step Tripping (predictive trip)" lnType="RPSB_OST" inst="2" lnClass="RPSB" prefix="Ost">
            <DOI name="Beh">
              <DAI desc="[FE 36] - OstRPSB2.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 23] - OST Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Out of Step tripping (Predictive)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 551" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 1 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="1" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1349" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 1 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 2 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="2" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1350" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 2 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 3 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="3" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1351" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 3 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 4 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="4" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1353" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 4 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 5 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="5" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1352" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone P Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Monitoring (Pole 1)" lnType="XCBR_BASIC$_7ed30635-2b13-4154-b523-acd4e7f6f2c4" inst="1" lnClass="XCBR">
            <Private type="MiCOM-ConfigurableAttributes">Lock.ctlModel,Lock.sboTimeout,Pos.ctlModel,Pos.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkCls">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="BlkOpn">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="CBOpCap">
              <DAI desc="Returns circuit breaker 1 Pole &quot;A&quot; operating capability." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EEHealth">
              <DAI desc="Returns the Health of the CB with respect to XCBR.EEHealth." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Loc">
              <DAI desc="[07 01] - CB Control by" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Lock">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Pole 1 Circuit Breaker (Phase A)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpCnt">
              <DAI desc="[06 02] - CB A Operations" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Pos">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="Returns the Status of A-Phase CB with respect to XCBR.Pos." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Monitoring (Pole 2)" lnType="XCBR_BASIC$_7ed30635-2b13-4154-b523-acd4e7f6f2c4" inst="2" lnClass="XCBR">
            <Private type="MiCOM-ConfigurableAttributes">Lock.ctlModel,Lock.sboTimeout,Pos.ctlModel,Pos.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkCls">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="BlkOpn">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="CBOpCap">
              <DAI desc="Returns circuit breaker 1 Pole &quot;B&quot; operating capability" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EEHealth">
              <DAI desc="Returns the Health of the CB with respect to XCBR.EEHealth." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Loc">
              <DAI desc="[07 01] - CB Control by" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Lock">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Pole 2 Circuit Breaker (Phase B)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpCnt">
              <DAI desc="[06 03] - CB B Operations" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Pos">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="Returns the Status of B-Phase CB with respect to XCBR.Pos." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Monitoring (Pole 3)" lnType="XCBR_BASIC$_7ed30635-2b13-4154-b523-acd4e7f6f2c4" inst="3" lnClass="XCBR">
            <Private type="MiCOM-ConfigurableAttributes">Lock.ctlModel,Lock.sboTimeout,Pos.ctlModel,Pos.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkCls">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="BlkOpn">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="CBOpCap">
              <DAI desc="Returns circuit breaker 1 Pole &quot;C&quot; operating capability." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EEHealth">
              <DAI desc="Returns the Health of the CB with respect to XCBR.EEHealth." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Loc">
              <DAI desc="[07 01] - CB Control by" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Lock">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Pole 3 Circuit Breaker (Phase C)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpCnt">
              <DAI desc="[06 04] - CB C Operations" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Pos">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="Returns the Status of C-Phase CB with respect to XCBR.Pos." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="Measurements Domain" inst="Measurements">
          <LN0 desc="Measurements Logical Device" lnType="LLN0_STANDARD" inst="" lnClass="LLN0">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Measurements Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN0>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Current Differential Measurements" lnType="MMXU_INDIFF" inst="1" lnClass="MMXU" prefix="PriDif">
            <Private type="MiCOM-ConfigurableAttributes">A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.phsA.units.multiplier,A2.phsA.db,A2.phsA.rangeC.min.f,A2.phsA.rangeC.max.f,A2.phsB.units.multiplier,A2.phsB.db,A2.phsB.rangeC.min.f,A2.phsB.rangeC.max.f,A2.phsC.units.multiplier,A2.phsC.db,A2.phsC.rangeC.min.f,A2.phsC.rangeC.max.f,A2.neut.units.multiplier,A2.neut.db,A2.neut.rangeC.min.f,A2.neut.rangeC.max.f,A3.phsA.units.multiplier,A3.phsA.db,A3.phsA.rangeC.min.f,A3.phsA.rangeC.max.f,A3.phsB.units.multiplier,A3.phsB.db,A3.phsB.rangeC.min.f,A3.phsB.rangeC.max.f,A3.phsC.units.multiplier,A3.phsC.db,A3.phsC.rangeC.min.f,A3.phsC.rangeC.max.f,A3.neut.units.multiplier,A3.neut.db,A3.neut.rangeC.min.f,A3.neut.rangeC.max.f,A4.phsA.units.multiplier,A4.phsA.db,A4.phsA.rangeC.min.f,A4.phsA.rangeC.max.f,A4.phsB.units.multiplier,A4.phsB.db,A4.phsB.rangeC.min.f,A4.phsB.rangeC.max.f,A4.phsC.units.multiplier,A4.phsC.db,A4.phsC.rangeC.min.f,A4.phsC.rangeC.max.f,A4.neut.units.multiplier,A4.neut.db,A4.neut.rangeC.min.f,A4.neut.rangeC.max.f,A5.phsA.units.multiplier,A5.phsA.db,A5.phsA.rangeC.min.f,A5.phsA.rangeC.max.f,A5.phsB.units.multiplier,A5.phsB.db,A5.phsB.rangeC.min.f,A5.phsB.rangeC.max.f,A5.phsC.units.multiplier,A5.phsC.db,A5.phsC.rangeC.min.f,A5.phsC.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Local Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 07] - IN local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 07] - IN local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 02] - IA Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 01] - IA local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 01] - IA local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 04] - IB Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 03] - IB local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 03] - IB local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 06] - IC Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 05] - IC local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 05] - IC local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>Remote CH1 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 0F] - IN remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0F] - IN remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0A] - IA Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 09] - IA remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 09] - IA remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0C] - IB Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0B] - IB remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0B] - IB remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0E] - IC Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0D] - IC remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0D] - IC remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Remote CH2 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 17] - IN remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 17] - IN remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 12] - IA Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 11] - IA remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 11] - IA remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 14] - IB Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 13] - IB remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 13] - IB remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 16] - IC Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 15] - IC remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 15] - IC remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A4">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1C] - IN Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1C] - IN Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 19] - IA Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 19] - IA Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1A] - IB Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1A] - IB Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1B] - IC Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1B] - IC Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A5">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Current Differential Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Fourier Measurements" lnType="MMXU_FOURIER" inst="1" lnClass="MMXU" prefix="PriFou">
            <Private type="MiCOM-ConfigurableAttributes">TotW.units.multiplier,TotW.db,TotW.rangeC.min.f,TotW.rangeC.max.f,TotVAr.units.multiplier,TotVAr.db,TotVAr.rangeC.min.f,TotVAr.rangeC.max.f,TotVA.units.multiplier,TotVA.db,TotVA.rangeC.min.f,TotVA.rangeC.max.f,TotPF.units.multiplier,TotPF.db,TotPF.rangeC.min.f,TotPF.rangeC.max.f,Hz.units.multiplier,Hz.db,Hz.rangeC.min.f,Hz.rangeC.max.f,PPV.phsAB.units.multiplier,PPV.phsAB.db,PPV.phsAB.rangeC.min.f,PPV.phsAB.rangeC.max.f,PPV.phsBC.units.multiplier,PPV.phsBC.db,PPV.phsBC.rangeC.min.f,PPV.phsBC.rangeC.max.f,PPV.phsCA.units.multiplier,PPV.phsCA.db,PPV.phsCA.rangeC.min.f,PPV.phsCA.rangeC.max.f,PhV.phsA.units.multiplier,PhV.phsA.db,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,PhV.phsB.units.multiplier,PhV.phsB.db,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.units.multiplier,PhV.phsC.db,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.res.units.multiplier,A2.res.db,A2.res.rangeC.min.f,A2.res.rangeC.max.f,A3.res.units.multiplier,A3.res.db,A3.res.rangeC.min.f,A3.res.rangeC.max.f,W.phsA.units.multiplier,W.phsA.db,W.phsA.rangeC.min.f,W.phsA.rangeC.max.f,W.phsB.units.multiplier,W.phsB.db,W.phsB.rangeC.min.f,W.phsB.rangeC.max.f,W.phsC.units.multiplier,W.phsC.db,W.phsC.rangeC.min.f,W.phsC.rangeC.max.f,VAr.phsA.units.multiplier,VAr.phsA.db,VAr.phsA.rangeC.min.f,VAr.phsA.rangeC.max.f,VAr.phsB.units.multiplier,VAr.phsB.db,VAr.phsB.rangeC.min.f,VAr.phsB.rangeC.max.f,VAr.phsC.units.multiplier,VAr.phsC.db,VAr.phsC.rangeC.min.f,VAr.phsC.rangeC.max.f,VA.phsA.units.multiplier,VA.phsA.db,VA.phsA.rangeC.min.f,VA.phsA.rangeC.max.f,VA.phsB.units.multiplier,VA.phsB.db,VA.phsB.rangeC.min.f,VA.phsB.rangeC.max.f,VA.phsC.units.multiplier,VA.phsC.db,VA.phsC.rangeC.min.f,VA.phsC.rangeC.max.f,PF.phsA.units.multiplier,PF.phsA.db,PF.phsA.rangeC.min.f,PF.phsA.rangeC.max.f,PF.phsB.units.multiplier,PF.phsB.db,PF.phsB.rangeC.min.f,PF.phsB.rangeC.max.f,PF.phsC.units.multiplier,PF.phsC.db,PF.phsC.rangeC.min.f,PF.phsC.rangeC.max.f,V1.neut.units.multiplier,V1.neut.db,V1.neut.rangeC.min.f,V1.neut.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0A] - IN Derived Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 09] - IN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 09] - IN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 02] - IA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 01] - IA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 01] - IA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 04] - IB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 03] - IB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 03] - IB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 06] - IC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 05] - IC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 05] - IC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>ISEF Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0C] - ISEF Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 0B] - ISEF Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 0B] - ISEF Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Mutual Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 33] - IM Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 32] - IM Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 32] - IM Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Hz">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 2D] - Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 2D] - Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PF">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 0F] - APh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 0F] - APh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 10] - BPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 10] - BPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 11] - CPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 11] - CPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>Derived Voltage Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1B] - VAN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1A] - VAN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1A] - VAN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1D] - VBN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1C] - VBN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1C] - VBN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1F] - VCN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1E] - VCN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1E] - VCN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PPV">
              <SDI name="phsAB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 15] - VAB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 14] - VAB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 14] - VAB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsBC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 17] - VBC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 16] - VBC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 16] - VBC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsCA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 19] - VCA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 18] - VCA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 18] - VCA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="TotPF">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0E] - 3Ph Power Factor" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI name="SIUnit" valKind="RO">
                  <Val>cos(phi)</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI name="TotVA">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0C] - 3 Phase VA" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0C] - 3 Phase VA" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotVAr">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0B] - 3 Phase VArs" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0B] - 3 Phase VArs" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotW">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0A] - 3 Phase Watts" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0A] - 3 Phase Watts" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="V1">
              <DAI desc="[02 22] - VN Derived Mag" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 23] - VN Derived Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 22] - VN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 22] - VN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VA">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 07] - A Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 07] - A Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 08] - B Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 08] - B Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 09] - C Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 09] - C Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VAr">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 04] - A Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 04] - A Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 05] - B Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 05] - B Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 06] - C Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 06] - C Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="W">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 01] - A Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 01] - A Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 02] - B Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 02] - B Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 03] - C Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 03] - C Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Primary based metering quantities" lnType="MMTR_PRIV$_44ae7d31-7456-4aba-9519-736349426bea" inst="1" lnClass="MMTR" prefix="Pri">
            <Private type="MiCOM-ConfigurableAttributes">MTRRs.ctlModel,MTRRs.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DmdVArh">
              <DAI desc="[03 15] - 3Ph VArHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="DmdWh">
              <DAI desc="[03 13] - 3Ph WHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="MTRRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[03 25] - Reset Demand" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SupVArh">
              <DAI desc="[03 14] - 3Ph VArHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="SupWh">
              <DAI desc="[03 12] - 3Ph WHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotVArh">
              <DAI desc="[FE D5] - 3 Phase Vars" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotWh">
              <DAI desc="[FE D4] - 3 Phase Watts" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Sequence Measurements" lnType="MSQI_ALL" inst="1" lnClass="MSQI" prefix="Pri">
            <Private type="MiCOM-ConfigurableAttributes">SeqA.c1.db,SeqA.c2.db,SeqA.c3.db,SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqA.c1.units.multiplier,SeqA.c2.units.multiplier,SeqA.c3.units.multiplier,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqA.c1.rangeC.min.f,SeqA.c1.rangeC.max.f,SeqA.c2.rangeC.min.f,SeqA.c2.rangeC.max.f,SeqA.c3.rangeC.min.f,SeqA.c3.rangeC.max.f,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Sequence and Imbalance Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqA">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 41] - I1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 40] - I1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 40] - I1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 43] - I2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 42] - I2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 42] - I2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 45] - I0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 44] - I0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 44] - I0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 47] - V1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 46] - V1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 46] - V1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 49] - V2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 48] - V2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 48] - V2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 4B] - V0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 4A] - V0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 4A] - V0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Metering Statistics" lnType="MSTA_I_W_VAR" inst="1" lnClass="MSTA" prefix="Pri">
            <Private type="MiCOM-ConfigurableAttributes">AvAmps1.db,AvAmps2.db,AvAmps3.db,AvAmps4.db,AvAmps5.db,AvAmps6.db,MaxAmps1.db,MaxAmps2.db,MaxAmps3.db,AvW1.db,AvW2.db,MaxW.db,AvVAr1.db,AvVAr2.db,MaxVAr.db,AvAmps1.rangeC.min.f,AvAmps1.rangeC.max.f,AvAmps2.rangeC.min.f,AvAmps2.rangeC.max.f,AvAmps3.rangeC.min.f,AvAmps3.rangeC.max.f,AvAmps4.rangeC.min.f,AvAmps4.rangeC.max.f,AvAmps5.rangeC.min.f,AvAmps5.rangeC.max.f,AvAmps6.rangeC.min.f,AvAmps6.rangeC.max.f,MaxAmps1.rangeC.min.f,MaxAmps1.rangeC.max.f,MaxAmps2.rangeC.min.f,MaxAmps2.rangeC.max.f,MaxAmps3.rangeC.min.f,MaxAmps3.rangeC.max.f,AvW1.rangeC.min.f,AvW1.rangeC.max.f,AvW2.rangeC.min.f,AvW2.rangeC.max.f,MaxW.rangeC.min.f,MaxW.rangeC.max.f,AvVAr1.rangeC.min.f,AvVAr1.rangeC.max.f,AvVAr2.rangeC.min.f,AvVAr2.rangeC.max.f,MaxVAr.rangeC.min.f,MaxVAr.rangeC.max.f,AvAmps1.units.multiplier,AvAmps2.units.multiplier,AvAmps3.units.multiplier,AvAmps4.units.multiplier,AvAmps5.units.multiplier,AvAmps6.units.multiplier,MaxAmps1.units.multiplier,MaxAmps2.units.multiplier,MaxAmps3.units.multiplier,AvW1.units.multiplier,AvW2.units.multiplier,MaxW.units.multiplier,AvVAr1.units.multiplier,AvVAr2.units.multiplier,MaxVAr.units.multiplier,</Private>
            <DOI name="AvAmps1">
              <DAI desc="[03 18] - IA Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 18] - IA Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 18] - IA Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps2">
              <DAI desc="[03 19] - IB Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 19] - IB Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 19] - IB Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps3">
              <DAI desc="[03 1A] - IC Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1A] - IC Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1A] - IC Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps4">
              <DAI desc="[03 1D] - IA Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1D] - IA Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1D] - IA Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps5">
              <DAI desc="[03 1E] - IB Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1E] - IB Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1E] - IB Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps6">
              <DAI desc="[03 1F] - IC Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1F] - IC Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1F] - IC Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr1">
              <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr2">
              <DAI desc="[03 1C] - 3Ph VArs RollDem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW1">
              <DAI desc="[03 16] - 3Ph W Fix Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW2">
              <DAI desc="[03 1B] - 3Ph W Roll Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="MaxAmps1">
              <DAI desc="[03 22] - IA Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 22] - IA Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 22] - IA Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps2">
              <DAI desc="[03 23] - IB Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 23] - IB Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 23] - IB Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps3">
              <DAI desc="[03 24] - IC Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 24] - IC Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 24] - IC Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxVAr">
              <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxW">
              <DAI desc="[03 20] - 3Ph W Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Metering Statistics</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary RMS Measurements" lnType="MMXU_RMS" inst="1" lnClass="MMXU" prefix="PriRms">
            <Private type="MiCOM-ConfigurableAttributes">PhV.phsA.db,PhV.phsB.db,PhV.phsC.db,A.phsA.db,A.phsB.db,A.phsC.db,PhV.phsB.units.multiplier,PhV.phsC.units.multiplier,A.phsA.units.multiplier,A.phsB.units.multiplier,A.phsC.units.multiplier,PhV.phsA.units.multiplier,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A.phsA.rangeC.min.f,A.phsA.rangeC.max.f,A.phsB.rangeC.min.f,A.phsB.rangeC.max.f,A.phsC.rangeC.min.f,A.phsC.rangeC.max.f,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,</Private>
            <DOI name="A">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 10] - IA RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 10] - IA RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 11] - IB RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 11] - IB RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 12] - IC RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 12] - IC RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 27] - VAN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 27] - VAN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 28] - VBN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 28] - VBN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 29] - VCN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 29] - VCN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Primary Compensated Overvoltage Measurements" lnType="MSQI_VOLTAGE" inst="1" lnClass="MSQI" prefix="PriVcp">
            <Private type="MiCOM-ConfigurableAttributes">SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Compensated Overvoltage Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 51] - V1 Rem Phase Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 50] - V1 Rem Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 50] - V1 Rem Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Current Differential Measurements" lnType="MMXU_INDIFF" inst="1" lnClass="MMXU" prefix="SecDif">
            <Private type="MiCOM-ConfigurableAttributes">A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.phsA.units.multiplier,A2.phsA.db,A2.phsA.rangeC.min.f,A2.phsA.rangeC.max.f,A2.phsB.units.multiplier,A2.phsB.db,A2.phsB.rangeC.min.f,A2.phsB.rangeC.max.f,A2.phsC.units.multiplier,A2.phsC.db,A2.phsC.rangeC.min.f,A2.phsC.rangeC.max.f,A2.neut.units.multiplier,A2.neut.db,A2.neut.rangeC.min.f,A2.neut.rangeC.max.f,A3.phsA.units.multiplier,A3.phsA.db,A3.phsA.rangeC.min.f,A3.phsA.rangeC.max.f,A3.phsB.units.multiplier,A3.phsB.db,A3.phsB.rangeC.min.f,A3.phsB.rangeC.max.f,A3.phsC.units.multiplier,A3.phsC.db,A3.phsC.rangeC.min.f,A3.phsC.rangeC.max.f,A3.neut.units.multiplier,A3.neut.db,A3.neut.rangeC.min.f,A3.neut.rangeC.max.f,A4.phsA.units.multiplier,A4.phsA.db,A4.phsA.rangeC.min.f,A4.phsA.rangeC.max.f,A4.phsB.units.multiplier,A4.phsB.db,A4.phsB.rangeC.min.f,A4.phsB.rangeC.max.f,A4.phsC.units.multiplier,A4.phsC.db,A4.phsC.rangeC.min.f,A4.phsC.rangeC.max.f,A4.neut.units.multiplier,A4.neut.db,A4.neut.rangeC.min.f,A4.neut.rangeC.max.f,A5.phsA.units.multiplier,A5.phsA.db,A5.phsA.rangeC.min.f,A5.phsA.rangeC.max.f,A5.phsB.units.multiplier,A5.phsB.db,A5.phsB.rangeC.min.f,A5.phsB.rangeC.max.f,A5.phsC.units.multiplier,A5.phsC.db,A5.phsC.rangeC.min.f,A5.phsC.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Local Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 07] - IN local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 07] - IN local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 02] - IA Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 01] - IA local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 01] - IA local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 04] - IB Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 03] - IB local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 03] - IB local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 06] - IC Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 05] - IC local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 05] - IC local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>Remote CH1 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 0F] - IN remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0F] - IN remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0A] - IA Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 09] - IA remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 09] - IA remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0C] - IB Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0B] - IB remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0B] - IB remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0E] - IC Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0D] - IC remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0D] - IC remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Remote CH2 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 17] - IN remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 17] - IN remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 12] - IA Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 11] - IA remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 11] - IA remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 14] - IB Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 13] - IB remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 13] - IB remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 16] - IC Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 15] - IC remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 15] - IC remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A4">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1C] - IN Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1C] - IN Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 19] - IA Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 19] - IA Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1A] - IB Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1A] - IB Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1B] - IC Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1B] - IC Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A5">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Current Differential Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Fourier Measurements" lnType="MMXU_FOURIER" inst="1" lnClass="MMXU" prefix="SecFou">
            <Private type="MiCOM-ConfigurableAttributes">TotW.units.multiplier,TotW.db,TotW.rangeC.min.f,TotW.rangeC.max.f,TotVAr.units.multiplier,TotVAr.db,TotVAr.rangeC.min.f,TotVAr.rangeC.max.f,TotVA.units.multiplier,TotVA.db,TotVA.rangeC.min.f,TotVA.rangeC.max.f,TotPF.units.multiplier,TotPF.db,TotPF.rangeC.min.f,TotPF.rangeC.max.f,Hz.units.multiplier,Hz.db,Hz.rangeC.min.f,Hz.rangeC.max.f,PPV.phsAB.units.multiplier,PPV.phsAB.db,PPV.phsAB.rangeC.min.f,PPV.phsAB.rangeC.max.f,PPV.phsBC.units.multiplier,PPV.phsBC.db,PPV.phsBC.rangeC.min.f,PPV.phsBC.rangeC.max.f,PPV.phsCA.units.multiplier,PPV.phsCA.db,PPV.phsCA.rangeC.min.f,PPV.phsCA.rangeC.max.f,PhV.phsA.units.multiplier,PhV.phsA.db,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,PhV.phsB.units.multiplier,PhV.phsB.db,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.units.multiplier,PhV.phsC.db,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.res.units.multiplier,A2.res.db,A2.res.rangeC.min.f,A2.res.rangeC.max.f,A3.res.units.multiplier,A3.res.db,A3.res.rangeC.min.f,A3.res.rangeC.max.f,W.phsA.units.multiplier,W.phsA.db,W.phsA.rangeC.min.f,W.phsA.rangeC.max.f,W.phsB.units.multiplier,W.phsB.db,W.phsB.rangeC.min.f,W.phsB.rangeC.max.f,W.phsC.units.multiplier,W.phsC.db,W.phsC.rangeC.min.f,W.phsC.rangeC.max.f,VAr.phsA.units.multiplier,VAr.phsA.db,VAr.phsA.rangeC.min.f,VAr.phsA.rangeC.max.f,VAr.phsB.units.multiplier,VAr.phsB.db,VAr.phsB.rangeC.min.f,VAr.phsB.rangeC.max.f,VAr.phsC.units.multiplier,VAr.phsC.db,VAr.phsC.rangeC.min.f,VAr.phsC.rangeC.max.f,VA.phsA.units.multiplier,VA.phsA.db,VA.phsA.rangeC.min.f,VA.phsA.rangeC.max.f,VA.phsB.units.multiplier,VA.phsB.db,VA.phsB.rangeC.min.f,VA.phsB.rangeC.max.f,VA.phsC.units.multiplier,VA.phsC.db,VA.phsC.rangeC.min.f,VA.phsC.rangeC.max.f,PF.phsA.units.multiplier,PF.phsA.db,PF.phsA.rangeC.min.f,PF.phsA.rangeC.max.f,PF.phsB.units.multiplier,PF.phsB.db,PF.phsB.rangeC.min.f,PF.phsB.rangeC.max.f,PF.phsC.units.multiplier,PF.phsC.db,PF.phsC.rangeC.min.f,PF.phsC.rangeC.max.f,V1.neut.units.multiplier,V1.neut.db,V1.neut.rangeC.min.f,V1.neut.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0A] - IN Derived Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 09] - IN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 09] - IN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 02] - IA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 01] - IA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 01] - IA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 04] - IB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 03] - IB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 03] - IB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 06] - IC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 05] - IC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 05] - IC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>ISEF Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0C] - ISEF Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 0B] - ISEF Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 0B] - ISEF Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Mutual Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 33] - IM Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 32] - IM Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 32] - IM Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Hz">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 2D] - Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 2D] - Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PF">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 0F] - APh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 0F] - APh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 10] - BPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 10] - BPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 11] - CPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 11] - CPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>Derived Voltage Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1B] - VAN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1A] - VAN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1A] - VAN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1D] - VBN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1C] - VBN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1C] - VBN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1F] - VCN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1E] - VCN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1E] - VCN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PPV">
              <SDI name="phsAB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 15] - VAB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 14] - VAB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 14] - VAB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsBC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 17] - VBC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 16] - VBC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 16] - VBC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsCA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 19] - VCA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 18] - VCA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 18] - VCA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="TotPF">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0E] - 3Ph Power Factor" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI name="SIUnit" valKind="RO">
                  <Val>cos(phi)</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI name="TotVA">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0C] - 3 Phase VA" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0C] - 3 Phase VA" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotVAr">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0B] - 3 Phase VArs" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0B] - 3 Phase VArs" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotW">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0A] - 3 Phase Watts" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0A] - 3 Phase Watts" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="V1">
              <DAI desc="[02 22] - VN Derived Mag" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 23] - VN Derived Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 22] - VN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 22] - VN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VA">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 07] - A Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 07] - A Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 08] - B Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 08] - B Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 09] - C Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 09] - C Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VAr">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 04] - A Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 04] - A Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 05] - B Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 05] - B Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 06] - C Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 06] - C Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="W">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 01] - A Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 01] - A Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 02] - B Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 02] - B Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 03] - C Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 03] - C Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Secondary based metering quantities" lnType="MMTR_PRIV$_44ae7d31-7456-4aba-9519-736349426bea" inst="1" lnClass="MMTR" prefix="Sec">
            <Private type="MiCOM-ConfigurableAttributes">MTRRs.ctlModel,MTRRs.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DmdVArh">
              <DAI desc="[03 15] - 3Ph VArHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="DmdWh">
              <DAI desc="[03 13] - 3Ph WHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="MTRRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[03 25] - Reset Demand" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SupVArh">
              <DAI desc="[03 14] - 3Ph VArHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="SupWh">
              <DAI desc="[03 12] - 3Ph WHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotVArh">
              <DAI desc="[FE D7] - 3 Phase Vars" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotWh">
              <DAI desc="[FE D6] - 3 Phase Watts" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Sequence Measurements" lnType="MSQI_ALL" inst="1" lnClass="MSQI" prefix="Sec">
            <Private type="MiCOM-ConfigurableAttributes">SeqA.c1.db,SeqA.c2.db,SeqA.c3.db,SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqA.c2.units.multiplier,SeqA.c3.units.multiplier,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqA.c1.units.multiplier,SeqA.c2.rangeC.min.f,SeqA.c2.rangeC.max.f,SeqA.c3.rangeC.min.f,SeqA.c3.rangeC.max.f,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,SeqA.c1.rangeC.min.f,SeqA.c1.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Sequence and Imbalance Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqA">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 41] - I1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 40] - I1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 40] - I1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 43] - I2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 42] - I2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 42] - I2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 45] - I0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 44] - I0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 44] - I0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 47] - V1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 46] - V1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 46] - V1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 49] - V2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 48] - V2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 48] - V2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 4B] - V0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 4A] - V0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 4A] - V0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Metering Statistics" lnType="MSTA_I_W_VAR" inst="1" lnClass="MSTA" prefix="Sec">
            <Private type="MiCOM-ConfigurableAttributes">AvAmps1.db,AvAmps2.db,AvAmps3.db,AvAmps4.db,AvAmps5.db,AvAmps6.db,MaxAmps1.db,MaxAmps2.db,MaxAmps3.db,AvW1.db,AvW2.db,MaxW.db,AvVAr1.db,AvVAr2.db,MaxVAr.db,AvAmps1.rangeC.min.f,AvAmps1.rangeC.max.f,AvAmps2.rangeC.min.f,AvAmps2.rangeC.max.f,AvAmps3.rangeC.min.f,AvAmps3.rangeC.max.f,AvAmps4.rangeC.min.f,AvAmps4.rangeC.max.f,AvAmps5.rangeC.min.f,AvAmps5.rangeC.max.f,AvAmps6.rangeC.min.f,AvAmps6.rangeC.max.f,MaxAmps1.rangeC.min.f,MaxAmps1.rangeC.max.f,MaxAmps2.rangeC.min.f,MaxAmps2.rangeC.max.f,MaxAmps3.rangeC.min.f,MaxAmps3.rangeC.max.f,AvW1.rangeC.min.f,AvW1.rangeC.max.f,AvW2.rangeC.min.f,AvW2.rangeC.max.f,MaxW.rangeC.min.f,MaxW.rangeC.max.f,AvVAr1.rangeC.min.f,AvVAr1.rangeC.max.f,AvVAr2.rangeC.min.f,AvVAr2.rangeC.max.f,MaxVAr.rangeC.min.f,MaxVAr.rangeC.max.f,AvAmps1.units.multiplier,AvAmps2.units.multiplier,AvAmps3.units.multiplier,AvAmps4.units.multiplier,AvAmps5.units.multiplier,AvAmps6.units.multiplier,MaxAmps1.units.multiplier,MaxAmps2.units.multiplier,MaxAmps3.units.multiplier,AvW1.units.multiplier,AvW2.units.multiplier,MaxW.units.multiplier,AvVAr1.units.multiplier,AvVAr2.units.multiplier,MaxVAr.units.multiplier,</Private>
            <DOI name="AvAmps1">
              <DAI desc="[03 18] - IA Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 18] - IA Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 18] - IA Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps2">
              <DAI desc="[03 19] - IB Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 19] - IB Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 19] - IB Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps3">
              <DAI desc="[03 1A] - IC Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1A] - IC Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1A] - IC Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps4">
              <DAI desc="[03 1D] - IA Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1D] - IA Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1D] - IA Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps5">
              <DAI desc="[03 1E] - IB Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1E] - IB Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1E] - IB Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps6">
              <DAI desc="[03 1F] - IC Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1F] - IC Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1F] - IC Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr1">
              <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr2">
              <DAI desc="[03 1C] - 3Ph VArs RollDem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW1">
              <DAI desc="[03 16] - 3Ph W Fix Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW2">
              <DAI desc="[03 1B] - 3Ph W Roll Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="MaxAmps1">
              <DAI desc="[03 22] - IA Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 22] - IA Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 22] - IA Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps2">
              <DAI desc="[03 23] - IB Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 23] - IB Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 23] - IB Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps3">
              <DAI desc="[03 24] - IC Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 24] - IC Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 24] - IC Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxVAr">
              <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxW">
              <DAI desc="[03 20] - 3Ph W Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Metering Statistics</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary RMS Measurements" lnType="MMXU_RMS" inst="1" lnClass="MMXU" prefix="SecRms">
            <Private type="MiCOM-ConfigurableAttributes">PhV.phsA.db,PhV.phsB.db,PhV.phsC.db,A.phsA.db,A.phsB.db,A.phsC.db,PhV.phsA.units.multiplier,PhV.phsB.units.multiplier,PhV.phsC.units.multiplier,A.phsA.units.multiplier,A.phsB.units.multiplier,A.phsC.units.multiplier,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A.phsA.rangeC.min.f,A.phsA.rangeC.max.f,A.phsB.rangeC.min.f,A.phsB.rangeC.max.f,A.phsC.rangeC.min.f,A.phsC.rangeC.max.f,</Private>
            <DOI name="A">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 10] - IA RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 10] - IA RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 11] - IB RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 11] - IB RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 12] - IC RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 12] - IC RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 27] - VAN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 27] - VAN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 28] - VBN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 28] - VBN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 29] - VCN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 29] - VCN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Secondary Compensated Overvoltage Measurements" lnType="MSQI_VOLTAGE" inst="1" lnClass="MSQI" prefix="SecVcp">
            <Private type="MiCOM-ConfigurableAttributes">SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Compensated Overvoltage Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 51] - V1 Rem Phase Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 50] - V1 Rem Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 50] - V1 Rem Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="Protection Domain" inst="Protection">
          <LN0 desc="Protection Logical Device" lnType="LLN0_PROT$_0dcd529d-5792-4714-82ca-596f8c048fa4" inst="" lnClass="LLN0">
            <Private type="MiCOM-ConfigurableAttributes">DisMod.ctlModel,DifMod.ctlModel,OcpMod.ctlModel,NgcMod.ctlModel,EfdMod.ctlModel,SefMod.ctlModel,VtpMod.ctlModel,NvdMod.ctlModel,FrqMod.ctlModel,DfpMod.ctlModel,ThmMod.ctlModel,CbfMod.ctlModel,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CbfBeh">
              <DAI desc="[09 20] - CB Fail" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 20] - CB Fail" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CbfMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 20] - CB Fail" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 20] - CB Fail" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DfpBeh">
              <DAI desc="[09 1F] - df/dt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 1F] - df/dt Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DfpMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 1F] - df/dt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 1F] - df/dt Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifBeh">
              <DAI desc="[09 0F] - Phase Diff" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 0F] - Phase Diff" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 0F] - Phase Diff" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 0F] - Phase Diff" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DisBeh">
              <DAI desc="[09 0B] - Distance" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 0B] - Distance" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DisMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 0B] - Distance" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 0B] - Distance" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EfdBeh">
              <DAI desc="[09 13] - Earth Fault" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 13] - Earth Fault" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EfdMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 13] - Earth Fault" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 13] - Earth Fault" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FrqBeh">
              <DAI desc="[09 1E] - Freq Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 1E] - Freq Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FrqMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 1E] - Freq Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 1E] - Freq Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Protection Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="NgcBeh">
              <DAI desc="[09 11] - Neg Sequence O/C" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 11] - Neg Sequence O/C" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NgcMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 11] - Neg Sequence O/C" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 11] - Neg Sequence O/C" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NvdBeh">
              <DAI desc="[09 16] - Residual O/V NVD" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 16] - Residual O/V NVD" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NvdMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 16] - Residual O/V NVD" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 16] - Residual O/V NVD" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="OcpBeh">
              <DAI desc="[09 10] - Overcurrent" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 10] - Overcurrent" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="OcpMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 10] - Overcurrent" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 10] - Overcurrent" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SefBeh">
              <DAI desc="[09 15] - SEF/REF Prot'n" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 15] - SEF/REF Prot'n" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SefMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 15] - SEF/REF Prot'n" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 15] - SEF/REF Prot'n" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ThmBeh">
              <DAI desc="[09 17] - Thermal Overload" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 17] - Thermal Overload" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ThmMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 17] - Thermal Overload" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 17] - Thermal Overload" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VtpBeh">
              <DAI desc="[09 1D] - Volt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 1D] - Volt Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VtpMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 1D] - Volt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 1D] - Volt Protection" name="stVal" valKind="RO"/>
            </DOI>
          </LN0>
          <LN desc="Circuit Breaker 1 Failure Stage 1" lnType="RBRF_EXTTRP_SEG" inst="1" lnClass="RBRF" prefix="Cbf">
            <DOI name="Beh">
              <DAI desc="[FE 09] - CbfRBRF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[45 02] - CB Fail 1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[45 02] - CB Fail 1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpEx">
              <DAI desc="DDB Ordinal: 834" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1672" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1673" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1674" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker 1 Failure Stage 2" lnType="RBRF_EXTTRP_SEG" inst="2" lnClass="RBRF" prefix="Cbf">
            <DOI name="Beh">
              <DAI desc="[FE 0A] - CbfRBRF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[45 04] - CB Fail 2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[45 04] - CB Fail 2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpEx">
              <DAI desc="DDB Ordinal: 835" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1675" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1676" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1677" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 1 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="1" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 50] - DfpPFRC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 04] - df/dt>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 04] - df/dt>1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 601" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 597" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 2 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="2" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 51] - DfpPFRC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 0B] - df/dt>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 0B] - df/dt>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 602" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 598" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 3 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="3" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 52] - DfpPFRC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 12] - df/dt>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 12] - df/dt>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 603" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 599" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 4 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="4" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 53] - DfpPFRC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 19] - df/dt>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 19] - df/dt>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 604" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 600" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Current Differential" lnType="PDIF_BASIC" inst="1" lnClass="PDIF" prefix="Dif">
            <Private type="MiCOM-ConfigurableAttributes">DifAClc.phsA.db,DifAClc.phsB.db,DifAClc.phsC.db,RstA.phsA.db,RstA.phsB.db,RstA.phsC.db,DifAClc.phsA.units.multiplier,DifAClc.phsB.units.multiplier,DifAClc.phsC.units.multiplier,RstA.phsA.units.multiplier,RstA.phsB.units.multiplier,RstA.phsC.units.multiplier,DifAClc.phsA.rangeC.min.f,DifAClc.phsA.rangeC.max.f,DifAClc.phsB.rangeC.min.f,DifAClc.phsB.rangeC.max.f,DifAClc.phsC.rangeC.min.f,DifAClc.phsC.rangeC.max.f,RstA.phsA.rangeC.min.f,RstA.phsA.rangeC.max.f,RstA.phsB.rangeC.min.f,RstA.phsB.rangeC.max.f,RstA.phsC.rangeC.min.f,RstA.phsC.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="[FE 1A] - DifPDIF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAClc">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 19] - IA Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 19] - IA Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1A] - IB Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1A] - IB Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1B] - IC Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1B] - IC Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[33 01] - Phase Diff" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[33 01] - Phase Diff" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 582" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 583" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 584" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 585" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="RstA">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 737" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 738" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 739" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 740" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Neutral Current Differential" lnType="PDIF_NEUT_DIFF" inst="2" lnClass="PDIF" prefix="Dif">
            <Private type="MiCOM-ConfigurableAttributes">DifAClc.neut.units.multiplier,DifAClc.neut.db,DifAClc.neut.rangeC.min.f,DifAClc.neut.rangeC.max.f,RstA.phsA.units.multiplier,RstA.phsA.db,RstA.phsA.rangeC.min.f,RstA.phsA.rangeC.max.f,RstA.phsB.units.multiplier,RstA.phsB.db,RstA.phsB.rangeC.min.f,RstA.phsB.rangeC.max.f,RstA.phsC.units.multiplier,RstA.phsC.db,RstA.phsC.rangeC.min.f,RstA.phsC.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="[FE 37] - DifPDIF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAClc">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1C] - IN Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1C] - IN Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[33 40] - In Diff Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[33 3F] - NEUTRAL DIFF" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1694" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1694" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="RstA">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 1692" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1692" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1692" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 1693" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1693" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1693" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 1 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="1" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 1C] - DisPDIS1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 1B] - DisPDIS1.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 1 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 608" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 612" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 609" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 610" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 611" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="Returns the Distance Zone 1 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 744" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 741" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 742" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 743" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 2 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="2" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 1E] - DisPDIS2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 1D] - DisPDIS2.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 2 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 613" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 617" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 614" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 615" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 616" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="Returns the Distance Zone 2 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 748" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 745" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 746" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 747" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 3 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="3" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 20] - DisPDIS3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 1F] - DisPDIS3.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 3 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 618" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 622" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 619" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 620" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 621" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirGeneral" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirNeut" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirPhsA" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirPhsB" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirPhsC" valKind="RO"/>
              <DAI desc="Returns the Distance Zone 3 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 752" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 749" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 750" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 751" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 4 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="4" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 22] - DisPDIS4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 21] - DisPDIS4.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 4 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 628" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 632" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 629" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 630" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 631" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI desc="Returns the Distance Zone 4 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 760" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 757" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 758" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 759" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone P Ph/Gnd Distance" lnType="PDIS_BASIC" inst="5" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 24] - DisPDIS5.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 23] - DisPDIS5.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone P Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 623" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 627" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 624" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 625" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 626" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirGeneral" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirNeut" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirPhsA" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirPhsB" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirPhsC" valKind="RO"/>
              <DAI desc="Returns the Distance Zone P Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 756" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 753" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 754" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 755" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Distance Protection Scheme 1" lnType="PSCH_BASIC" inst="1" lnClass="PSCH" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[34 41] - Aid. 1 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CarRx">
              <DAI desc="DDB Ordinal: 494" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="LosOfGrd">
              <DAI desc="DDB Ordinal: 492" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 41] - Aid. 1 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 40] - AIDED SCHEME 1" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="Returns the Trip Status of Scheme 1." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 636" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 633" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 634" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 635" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="ProRx">
              <DAI desc="DDB Ordinal: 493" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ProTx">
              <DAI desc="DDB Ordinal: 498" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 498" name="general" valKind="RO"/>
            </DOI>
            <DOI name="WeiOp">
              <DAI desc="Returns the Trip of all 3 Phases for the Weak End Infeed Function for Scheme 1." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 637" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 638" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 639" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Distance Protection Scheme 2" lnType="PSCH_BASIC" inst="2" lnClass="PSCH" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[34 61] - Aid. 2 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CarRx">
              <DAI desc="DDB Ordinal: 508" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="LosOfGrd">
              <DAI desc="DDB Ordinal: 506" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 61] - Aid. 2 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 60] - AIDED SCHEME 2" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="Returns the Trip Status of Scheme 2." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 646" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 643" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 644" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 645" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="ProRx">
              <DAI desc="DDB Ordinal: 507" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ProTx">
              <DAI desc="DDB Ordinal: 514" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 514" name="general" valKind="RO"/>
            </DOI>
            <DOI name="WeiOp">
              <DAI desc="Returns the Trip of all 3 Phases for the Weak End Infeed Function for Scheme 2." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 647" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 648" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 649" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 1 Earth Fault (Derived)" lnType="PTOC_NEU" inst="1" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0B] - EfdPTOC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 01] - IN>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 25] - IN>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 671" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 671" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 26] - IN>1 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 26] - IN>1 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 777" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 777" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 2 Earth Fault (Derived)" lnType="PTOC_NEU" inst="2" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0C] - EfdPTOC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 35] - IN>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 36] - IN>2 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 672" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 672" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 37] - IN>2 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 37] - IN>2 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 778" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 778" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 3 Earth Fault (Derived)" lnType="PTOC_NEU" inst="3" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0D] - EfdPTOC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 46] - IN>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 46] - IN>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 673" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 673" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 47] - IN>3 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 47] - IN>3 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 779" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 779" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 4 Earth Fault (Derived)" lnType="PTOC_NEU" inst="4" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0E] - EfdPTOC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 4D] - IN>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 4D] - IN>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 674" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 674" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 4E] - IN>4 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 4E] - IN>4 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 780" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 780" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F> 1 Overfrequency" lnType="PTOF_NO_SEG" inst="1" lnClass="PTOF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 54] - FrqPTOF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 10] - F>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 10] - F>1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1165" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1159" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F> 2 Overfrequency" lnType="PTOF_NO_SEG" inst="2" lnClass="PTOF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 55] - FrqPTOF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 13] - F>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 13] - F>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1166" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1160" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 1 Underfrequency" lnType="PTUF_NO_SEG" inst="1" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 56] - FrqPTUF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 02] - F&lt;1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 02] - F&lt;1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1161" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1155" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 2 Underfrequency" lnType="PTUF_NO_SEG" inst="2" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 57] - FrqPTUF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 05] - F&lt;2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 05] - F&lt;2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1162" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1156" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 3 Underfrequency" lnType="PTUF_NO_SEG" inst="3" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 58] - FrqPTUF3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 08] - F&lt;3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 08] - F&lt;3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1163" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1157" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 4 Underfrequency" lnType="PTUF_NO_SEG" inst="4" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 59] - FrqPTUF4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 0B] - F&lt;4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 0B] - F&lt;4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1164" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1158" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="I2> 1 Negative Sequence" lnType="PTOC_NO_SEG" inst="1" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 0F] - NgcPTOC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 10] - I2>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 10] - I2>1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 571" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 12] - I2>1 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 567" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I2> 2 Negative Sequence" lnType="PTOC_NO_SEG" inst="2" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 32] - NgcPTOC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 20] - I2>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 20] - I2>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 572" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 22] - I2>2 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 568" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I2> 3 Negative Sequence" lnType="PTOC_NO_SEG" inst="3" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 33] - NgcPTOC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 30] - I2>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 30] - I2>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 573" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 32] - I2>3 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 569" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I2> 4 Negative Sequence" lnType="PTOC_NO_SEG" inst="4" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 34] - NgcPTOC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 40] - I2>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 40] - I2>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 574" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 42] - I2>4 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 570" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 1 Overcurrent" lnType="PTOC_SEG" inst="1" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 01] - OcpPTOC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 01] - I>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 02] - I>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 655" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 656" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 657" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 658" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 03] - I>1 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 03] - I>1 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 03] - I>1 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 03] - I>1 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 761" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 762" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 763" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 764" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 2 Overcurrent" lnType="PTOC_SEG" inst="2" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 02] - OcpPTOC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 0A] - I>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 0B] - I>2 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 659" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 660" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 661" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 662" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 0C] - I>2 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 0C] - I>2 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 0C] - I>2 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 0C] - I>2 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 765" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 766" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 767" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 768" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 3 Overcurrent" lnType="PTOC_SEG" inst="3" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 03] - OcpPTOC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 13] - I>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 13] - I>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 663" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 664" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 665" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 666" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 14] - I>3 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 14] - I>3 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 14] - I>3 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 14] - I>3 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 769" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 770" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 771" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 772" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 4 Overcurrent" lnType="PTOC_SEG" inst="4" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 04] - OcpPTOC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 18] - I>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 18] - I>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 667" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 668" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 669" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 670" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 19] - I>4 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 19] - I>4 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 19] - I>4 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 19] - I>4 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 773" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 774" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 775" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 776" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Protection Trip Conditioning" lnType="PTRC_NO_SEG" inst="1" lnClass="PTRC">
            <DOI name="Beh">
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Protection Trip Conditioning</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 736" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Tr">
              <DAI desc="DDB Ordinal: 522" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 1 Sensitive Earth Fault" lnType="PTOC_NEU" inst="1" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 16] - SefPTOC1.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 2A] - ISEF>1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 2A] - ISEF>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 675" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 675" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 2B] - ISEF>1 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 2B] - ISEF>1 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 781" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 781" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 2 Sensitive Earth Fault" lnType="PTOC_NEU" inst="2" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 17] - SefPTOC2.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 3A] - ISEF>2 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 3A] - ISEF>2 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 676" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 676" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 3B] - ISEF>2 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 3B] - ISEF>2 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 782" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 782" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 3 Sensitive Earth Fault" lnType="PTOC_NEU" inst="3" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 18] - SefPTOC3.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 49] - ISEF>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 49] - ISEF>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 677" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 677" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 4A] - ISEF>3 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 4A] - ISEF>3 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 783" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 783" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 4 Sensitive Earth Fault" lnType="PTOC_NEU" inst="4" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 19] - SefPTOC4.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 50] - ISEF>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 50] - ISEF>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 678" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 678" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 51] - ISEF>4 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 51] - ISEF>4 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 784" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 784" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IREF> 1 Restricted Earth Fault" lnType="PDIF_NEU" inst="1" lnClass="PDIF" prefix="SenRef">
            <DOI name="Beh">
              <DAI desc="[FE 30] - SenRefPDIF1.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 01] - SEF/REF Options" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 60] - RESTRICTED E/F" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 682" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 682" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Switch onto Fault protection" lnType="PSOF_MULTI_OP" inst="1" lnClass="PSOF" prefix="Sof">
            <DOI name="Beh">
              <DAI desc="[FE 29] - SofPSOF.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 81] - SOTF Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 81] - SOTF Status" name="d" valKind="RO"/>
              <DAI name="lnNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op1">
              <DAI desc="DDB Ordinal: 709" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 709" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op2">
              <DAI desc="DDB Ordinal: 710" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 710" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op3">
              <DAI desc="DDB Ordinal: 711" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 711" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op4">
              <DAI desc="DDB Ordinal: 712" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 712" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op5">
              <DAI desc="DDB Ordinal: 713" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 713" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op6">
              <DAI desc="DDB Ordinal: 558" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 558" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 879" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Thermal Overload" lnType="PTTR_NO_SEG$_b4615a36-b1bb-4f89-8100-6d4b2263553a" inst="1" lnClass="PTTR" prefix="Thm">
            <Private type="MiCOM-ConfigurableAttributes">MTRRs.ctlModel,MTRRs.sboTimeout,Amp.units.multiplier,Amp.db,Amp.rangeC.min.f,Amp.rangeC.max.f,TmpRl.units.multiplier,TmpRl.db,TmpRl.rangeC.min.f,TmpRl.rangeC.max.f,</Private>
            <DOI name="AlmThm">
              <DAI desc="DDB Ordinal: 785" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Amp">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[FE 08] - ThmPTTR1.MX.Amp.f" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 0D] - I1 Magnitude" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 07] - ThmPTTR1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3C 01] - Characteristic" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="MTRRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[03 27] - Reset Thermal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[09 17] - Thermal Overload" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 680" name="general" valKind="RO"/>
            </DOI>
            <DOI name="TmpRl">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 26] - Thermal State" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>100</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 26] - Thermal State" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Trip on reclose protection" lnType="PSOF_MULTI_OP" inst="1" lnClass="PSOF" prefix="Tor">
            <DOI name="Beh">
              <DAI desc="[FE 27] - TorPSOF.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 84] - TOR Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 84] - TOR Status" name="d" valKind="RO"/>
              <DAI name="lnNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op1">
              <DAI desc="DDB Ordinal: 704" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 704" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op2">
              <DAI desc="DDB Ordinal: 705" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 705" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op3">
              <DAI desc="DDB Ordinal: 706" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 706" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op4">
              <DAI desc="DDB Ordinal: 707" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 707" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op5">
              <DAI desc="DDB Ordinal: 708" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 708" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op6">
              <DAI desc="DDB Ordinal: 557" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 557" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 878" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Compensated V1> 1 Overvoltage" lnType="PTOV_NO_SEG" inst="1" lnClass="PTOV" prefix="VtpCmp">
            <DOI name="Beh">
              <DAI desc="[FE 5A] - VtpCmpPTOV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 23] - V1>1 Cmp Funct" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 23] - V1>1 Cmp Funct" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 925" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 923" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Compensated V1> 2 Overvoltage" lnType="PTOV_NO_SEG" inst="2" lnClass="PTOV" prefix="VtpCmp">
            <DOI name="Beh">
              <DAI desc="[FE 5B] - VtpCmpPTOV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 27] - V1>2 Cmp Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 27] - V1>2 Cmp Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 926" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 924" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V> 1 Overvoltage" lnType="PTOV_SEG" inst="1" lnClass="PTOV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 10] - VtpPTOV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 10] - V>1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 10] - V>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 691" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 692" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 693" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 694" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 796" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 797" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 798" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 799" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V> 2 Overvoltage" lnType="PTOV_SEG" inst="2" lnClass="PTOV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 11] - VtpPTOV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 14] - V>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 14] - V>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 695" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 696" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 697" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 698" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 800" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 801" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 802" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 803" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V&lt; 1 Undervoltage" lnType="PTUV_SEG" inst="1" lnClass="PTUV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 12] - VtpPTUV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 04] - V&lt;1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 04] - V&lt;1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 683" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 684" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 685" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 686" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 788" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 789" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 790" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 791" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V&lt; 2 Undervoltage" lnType="PTUV_SEG" inst="2" lnClass="PTUV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 13] - VtpPTUV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 09] - V&lt;2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 09] - V&lt;2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 687" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 688" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 689" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 690" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 792" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 793" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 794" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 795" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="VN> 1 Residual Overvoltage" lnType="PTOV_NEU" inst="1" lnClass="PTOV" prefix="VtpRes">
            <DOI name="Beh">
              <DAI desc="[FE 14] - NvdPTOV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3B 02] - VN>1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3B 02] - VN>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 700" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 700" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 804" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 804" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="VN> 2 Residual Overvoltage" lnType="PTOV_NEU" inst="2" lnClass="PTOV" prefix="VtpRes">
            <DOI name="Beh">
              <DAI desc="[FE 15] - NvdPTOV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3B 07] - VN>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3B 07] - VN>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 701" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 701" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 805" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 805" name="neut" valKind="RO"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="Records Domain" inst="Records">
          <LN0 desc="Records Logical Device" lnType="LLN0_STANDARD" inst="" lnClass="LLN0">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Records Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN0>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Disturbance Recorder" lnType="RDRE_BASIC" inst="1" lnClass="RDRE">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FltNum">
              <DAI name="stVal" valKind="RO">
                <Val>0</Val>
              </DAI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Disturbance Recorder Function</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="RcdMade">
              <DAI desc="Returns if a Disturbance Record is available for Extraction." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Fault Locator" lnType="RFLO_BASIC" inst="1" lnClass="RFLO">
            <Private type="MiCOM-ConfigurableAttributes">FltZ.db,FltZ.units.multiplier,FltZ.rangeC.min.f,FltZ.rangeC.max.f,FltDiskm.db,FltDiskm.rangeC.min.f,FltDiskm.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FltDiskm">
              <DAI name="db" valKind="Set">
                <Val>10</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[01 13] - Fault Location (metres)" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1000</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="RO">
                  <Val>k</Val>
                </DAI>
                <DAI desc="[01 13] - Fault Location (metres)" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="FltZ">
              <SDI name="cVal">
                <SDI name="mag">
                  <DAI desc="[01 15] - Fault Location (impedance)" name="f" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1000</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[01 15] - Fault Location (impedance)" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fault Locator Function</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="System Domain" inst="System">
          <LN0 desc="System Logical Device" lnType="LLN0_SYSTEM$_b0106a33-fe12-4478-a126-452a9b390db5" inst="" lnClass="LLN0">
            <Private type="MiCOM-ConfigurableAttributes">LEDRs.ctlModel,LEDRs.sboTimeout,</Private>
            <ReportControl name="urcbA" intgPd="100" buffered="false" bufTime="100" confRev="0" indexed="false" rptID="E01BUPSystem/LLN0.urcbA">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl name="urcbB" intgPd="100" buffered="false" bufTime="100" confRev="0" indexed="false" rptID="E01BUPSystem/LLN0.urcbB">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="urcbC" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbC">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="urcbD" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbD">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbE" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbE">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbF" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbF">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbG" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbG">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbH" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbH">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbI" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbI">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbJ" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbJ">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbK" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbK">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbL" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbL">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbM" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbM">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbN" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbN">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbO" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbO">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbP" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbP">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl name="brcbA" intgPd="100" buffered="true" bufTime="100" confRev="0" indexed="false" rptID="E01BUPSystem/LLN0.brcbA">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="brcbB" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbB">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="brcbC" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbC">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="brcbD" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbD">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbE" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbE">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbF" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbF">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbG" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbG">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbH" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbH">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="LEDRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[01 FF] - Reset Indication" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>System Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OrdRun">
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="Order Running indication" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SyncSt">
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="IED time synchronisation state" name="stVal" valKind="RO"/>
            </DOI>
            <GSEControl name="gcb01" confRev="0" appID="E01BUPSystem/LLN0gcb01" securityEnable="None"/>
            <GSEControl name="gcb02" confRev="0" appID="E01BUPSystem/LLN0gcb02" securityEnable="None"/>
            <GSEControl name="gcb03" confRev="0" appID="E01BUPSystem/LLN0gcb03" securityEnable="None"/>
            <GSEControl name="gcb04" confRev="0" appID="E01BUPSystem/LLN0gcb04" securityEnable="None"/>
            <GSEControl name="gcb05" confRev="0" appID="E01BUPSystem/LLN0gcb05" securityEnable="None"/>
            <GSEControl name="gcb06" confRev="0" appID="E01BUPSystem/LLN0gcb06" securityEnable="None"/>
            <GSEControl name="gcb07" confRev="0" appID="E01BUPSystem/LLN0gcb07" securityEnable="None"/>
            <GSEControl name="gcb08" confRev="0" appID="E01BUPSystem/LLN0gcb08" securityEnable="None"/>
            <SettingControl actSG="1" numOfSGs="4"/>
          </LN0>
          <LN desc="Alarms" lnType="GGIO_ALM_96" inst="1" lnClass="GGIO" prefix="Alm">
            <DOI name="Alm1">
              <DAI desc="DDB Ordinal: 288" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 288" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm10">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 297" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm11">
              <DAI desc="DDB Ordinal: 298" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 298" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm12">
              <DAI desc="DDB Ordinal: 299" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 299" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm13">
              <DAI desc="DDB Ordinal: 300" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 300" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm14">
              <DAI desc="DDB Ordinal: 301" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 301" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm15">
              <DAI desc="DDB Ordinal: 302" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 302" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm16">
              <DAI desc="DDB Ordinal: 303" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 303" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm17">
              <DAI desc="DDB Ordinal: 304" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 304" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm18">
              <DAI desc="DDB Ordinal: 305" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 305" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm19">
              <DAI desc="DDB Ordinal: 306" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 306" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm2">
              <DAI desc="DDB Ordinal: 289" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 289" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm20">
              <DAI desc="DDB Ordinal: 307" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 307" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm21">
              <DAI desc="DDB Ordinal: 308" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 308" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm22">
              <DAI desc="DDB Ordinal: 309" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 309" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm23">
              <DAI desc="DDB Ordinal: 310" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 310" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm24">
              <DAI desc="DDB Ordinal: 311" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 311" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm25">
              <DAI desc="DDB Ordinal: 312" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 312" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm26">
              <DAI desc="DDB Ordinal: 313" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 313" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm27">
              <DAI desc="DDB Ordinal: 314" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 314" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm28">
              <DAI desc="DDB Ordinal: 315" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 315" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm29">
              <DAI desc="DDB Ordinal: 316" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 316" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm3">
              <DAI desc="DDB Ordinal: 290" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 290" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm30">
              <DAI desc="DDB Ordinal: 317" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 317" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm31">
              <DAI desc="DDB Ordinal: 318" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 318" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm32">
              <DAI desc="DDB Ordinal: 319" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 319" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm33">
              <DAI desc="DDB Ordinal: 320" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 320" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm34">
              <DAI desc="DDB Ordinal: 321" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 321" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm35">
              <DAI desc="DDB Ordinal: 322" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 322" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm36">
              <DAI desc="DDB Ordinal: 323" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 323" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm37">
              <DAI desc="DDB Ordinal: 324" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 324" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm38">
              <DAI desc="DDB Ordinal: 325" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 325" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm39">
              <DAI desc="DDB Ordinal: 326" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 326" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm4">
              <DAI desc="DDB Ordinal: 291" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 291" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm40">
              <DAI desc="DDB Ordinal: 327" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 327" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm41">
              <DAI desc="DDB Ordinal: 328" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 328" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm42">
              <DAI desc="DDB Ordinal: 329" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 329" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm43">
              <DAI desc="DDB Ordinal: 330" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 330" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm44">
              <DAI desc="DDB Ordinal: 331" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 331" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm45">
              <DAI desc="DDB Ordinal: 332" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 332" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm46">
              <DAI desc="DDB Ordinal: 333" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 333" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm47">
              <DAI desc="DDB Ordinal: 334" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 334" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm48">
              <DAI desc="DDB Ordinal: 335" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 335" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm49">
              <DAI desc="DDB Ordinal: 336" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 336" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm5">
              <DAI desc="DDB Ordinal: 292" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 292" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm50">
              <DAI desc="DDB Ordinal: 337" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 337" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm51">
              <DAI desc="DDB Ordinal: 338" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 338" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm52">
              <DAI desc="DDB Ordinal: 339" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 339" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm53">
              <DAI desc="DDB Ordinal: 340" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 340" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm54">
              <DAI desc="DDB Ordinal: 341" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 341" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm55">
              <DAI desc="DDB Ordinal: 342" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 342" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm56">
              <DAI desc="DDB Ordinal: 343" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 343" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm57">
              <DAI desc="DDB Ordinal: 344" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 344" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm58">
              <DAI desc="DDB Ordinal: 345" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 345" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm59">
              <DAI desc="DDB Ordinal: 346" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 346" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm6">
              <DAI desc="DDB Ordinal: 293" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 293" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm60">
              <DAI desc="DDB Ordinal: 347" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 347" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm61">
              <DAI desc="DDB Ordinal: 348" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 348" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm62">
              <DAI desc="DDB Ordinal: 349" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 349" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm63">
              <DAI desc="DDB Ordinal: 350" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 350" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm64">
              <DAI desc="DDB Ordinal: 351" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 351" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm65">
              <DAI desc="DDB Ordinal: 352" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 352" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm66">
              <DAI desc="DDB Ordinal: 353" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 353" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm67">
              <DAI desc="DDB Ordinal: 354" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 354" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm68">
              <DAI desc="DDB Ordinal: 355" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 355" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm69">
              <DAI desc="DDB Ordinal: 356" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 356" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm7">
              <DAI desc="DDB Ordinal: 294" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 294" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm70">
              <DAI desc="DDB Ordinal: 357" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 357" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm71">
              <DAI desc="DDB Ordinal: 358" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 358" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm72">
              <DAI desc="DDB Ordinal: 359" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 359" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm73">
              <DAI desc="DDB Ordinal: 360" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 360" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm74">
              <DAI desc="DDB Ordinal: 361" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 361" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm75">
              <DAI desc="DDB Ordinal: 362" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 362" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm76">
              <DAI desc="DDB Ordinal: 363" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 363" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm77">
              <DAI desc="DDB Ordinal: 364" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 364" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm78">
              <DAI desc="DDB Ordinal: 365" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 365" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm79">
              <DAI desc="DDB Ordinal: 366" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 366" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm8">
              <DAI desc="DDB Ordinal: 295" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 295" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm80">
              <DAI desc="DDB Ordinal: 367" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 367" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm81">
              <DAI desc="DDB Ordinal: 368" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 368" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm82">
              <DAI desc="DDB Ordinal: 369" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 369" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm83">
              <DAI desc="DDB Ordinal: 370" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 370" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm84">
              <DAI desc="DDB Ordinal: 371" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 371" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm85">
              <DAI desc="DDB Ordinal: 372" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 372" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm86">
              <DAI desc="DDB Ordinal: 373" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 373" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm87">
              <DAI desc="DDB Ordinal: 374" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 374" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm88">
              <DAI desc="DDB Ordinal: 375" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 375" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm89">
              <DAI desc="DDB Ordinal: 376" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 376" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm9">
              <DAI desc="DDB Ordinal: 296" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 296" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm90">
              <DAI desc="DDB Ordinal: 377" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 377" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm91">
              <DAI desc="DDB Ordinal: 378" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 378" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm92">
              <DAI desc="DDB Ordinal: 379" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 379" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm93">
              <DAI desc="DDB Ordinal: 380" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 380" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm94">
              <DAI desc="DDB Ordinal: 381" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 381" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm95">
              <DAI desc="DDB Ordinal: 382" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 382" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm96">
              <DAI desc="DDB Ordinal: 383" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 383" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Alarm Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Function Keys" lnType="GGIO_IND_10" inst="1" lnClass="GGIO" prefix="Fnk">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="[17 04] - Fn Key 1 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1096" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="[17 1F] - Fn Key 10 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1105" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="[17 07] - Fn Key 2 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1097" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="[17 0A] - Fn Key 3 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1098" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="[17 0D] - Fn Key 4 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1099" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="[17 10] - Fn Key 5 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1100" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="[17 13] - Fn Key 6 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1101" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="[17 16] - Fn Key 7 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1102" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="[17 19] - Fn Key 8 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1103" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="[17 1C] - Fn Key 9 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1104" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[17 01] - Fn Key Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="GOOSE Input Signals" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="Gos">
            <Private type="MiCOM-BindableType">VI</Private>
            <Private type="MiCOM-BindableSignals">
									Ind1.stVal,
									Ind2.stVal,
									Ind3.stVal,
									Ind4.stVal,
									Ind5.stVal,
									Ind6.stVal,
									Ind7.stVal,
									Ind8.stVal,
									Ind9.stVal,
									Ind10.stVal,
									Ind11.stVal,
									Ind12.stVal,
									Ind13.stVal,
									Ind14.stVal,
									Ind15.stVal,
									Ind16.stVal,
									Ind17.stVal,
									Ind18.stVal,
									Ind19.stVal,
									Ind20.stVal,
									Ind21.stVal,
									Ind22.stVal,
									Ind23.stVal,
									Ind24.stVal,
									Ind25.stVal,
									Ind26.stVal,
									Ind27.stVal,
									Ind28.stVal,
									Ind29.stVal,
									Ind30.stVal,
									Ind31.stVal,
									Ind32.stVal,
						</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 224" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 224" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 233" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 233" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 234" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 234" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 235" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 235" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 236" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 236" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 237" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 237" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 238" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 238" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 239" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 239" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 240" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 240" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 241" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 241" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="DDB Ordinal: 242" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 242" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 225" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 225" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="DDB Ordinal: 243" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 243" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="DDB Ordinal: 244" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 244" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="DDB Ordinal: 245" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 245" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="DDB Ordinal: 246" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 246" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="DDB Ordinal: 247" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 247" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="DDB Ordinal: 248" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 248" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="DDB Ordinal: 249" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 249" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="DDB Ordinal: 250" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 250" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="DDB Ordinal: 251" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 251" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="DDB Ordinal: 252" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 252" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 226" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 226" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="DDB Ordinal: 253" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 253" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="DDB Ordinal: 254" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 254" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="DDB Ordinal: 255" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 255" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 227" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 227" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 228" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 228" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 229" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 229" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 230" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 230" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 231" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 231" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 232" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 232" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>GOOSE Input Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="GOOSE Output Signals" lnType="GGIO_IND_32" inst="2" lnClass="GGIO" prefix="Gos">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 256" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 256" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 265" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 265" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 266" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 266" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 267" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 267" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 268" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 268" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 269" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 269" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 270" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 270" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 271" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 271" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 272" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 272" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 273" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 273" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="DDB Ordinal: 274" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 274" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 257" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 257" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="DDB Ordinal: 275" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 275" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="DDB Ordinal: 276" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 276" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="DDB Ordinal: 277" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 277" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="DDB Ordinal: 278" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 278" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="DDB Ordinal: 279" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 279" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="DDB Ordinal: 280" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 280" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="DDB Ordinal: 281" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 281" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="DDB Ordinal: 282" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 282" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="DDB Ordinal: 283" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 283" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="DDB Ordinal: 284" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 284" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 258" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 258" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="DDB Ordinal: 285" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 285" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="DDB Ordinal: 286" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 286" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="DDB Ordinal: 287" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 287" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 259" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 259" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 260" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 260" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 261" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 261" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 262" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 262" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 263" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 263" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 264" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 264" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>GOOSE Output Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Inputs Status (CH1)" lnType="GGIO_IND_8" inst="1" lnClass="GGIO" prefix="ImfInp">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 96" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 96" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 97" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 97" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 98" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 98" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 99" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 99" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 100" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 100" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 101" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 101" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 102" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 102" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 103" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 103" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 1 Fibre InterMiCOM Inputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Inputs Status (CH2)" lnType="GGIO_IND_8" inst="2" lnClass="GGIO" prefix="ImfInp">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 104" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 104" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 105" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 105" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 106" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 106" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 107" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 107" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 108" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 108" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 109" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 109" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 110" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 110" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 111" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 111" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 2 Fibre InterMiCOM Inputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Outputs Status (CH1)" lnType="GGIO_IND_8" inst="1" lnClass="GGIO" prefix="ImfOut">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 112" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 112" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 113" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 113" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 114" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 114" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 115" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 115" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 116" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 116" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 117" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 117" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 118" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 118" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 119" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 119" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 1 Fibre InterMiCOM Outputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Outputs Status (CH2)" lnType="GGIO_IND_8" inst="2" lnClass="GGIO" prefix="ImfOut">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 120" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 120" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 121" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 121" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 122" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 122" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 123" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 123" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 124" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 124" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 125" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 125" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 126" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 126" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 127" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 127" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 2 Fibre InterMiCOM Outputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Red LED Signals" lnType="GGIO_IND_18" inst="1" lnClass="GGIO" prefix="Led">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 1024" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1024" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 1042" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1042" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 1044" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1044" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 1046" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1046" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 1048" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1048" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 1050" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1050" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 1052" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1052" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 1054" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1054" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 1056" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1056" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 1058" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1058" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 1026" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1026" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 1028" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1028" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 1030" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1030" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 1032" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1032" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 1034" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1034" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 1036" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1036" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 1038" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1038" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 1040" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1040" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Red LED Signals</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Green LED Signals" lnType="GGIO_IND_18" inst="2" lnClass="GGIO" prefix="Led">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 1025" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1025" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 1043" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1043" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 1045" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1045" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 1047" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1047" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 1049" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1049" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 1051" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1051" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 1053" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1053" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 1055" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1055" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 1057" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1057" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 1059" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1059" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 1027" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1027" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 1029" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1029" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 1031" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1031" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 1033" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1033" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 1035" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1035" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 1037" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1037" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 1039" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1039" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 1041" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1041" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Green LED Signals</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Opto (32) Inputs" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="Opt">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="[4A 01] - Opto Input 1" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 32" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="[4A 0A] - Opto Input 10" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 41" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="[4A 0B] - Opto Input 11" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 42" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="[4A 0C] - Opto Input 12" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 43" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="[4A 0D] - Opto Input 13" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 44" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="[4A 0E] - Opto Input 14" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 45" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="[4A 0F] - Opto Input 15" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 46" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="[4A 10] - Opto Input 16" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 47" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="[4A 11] - Opto Input 17" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 48" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="[4A 12] - Opto Input 18" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 49" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="[4A 13] - Opto Input 19" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 50" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="[4A 02] - Opto Input 2" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 33" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="[4A 14] - Opto Input 20" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 51" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="[4A 15] - Opto Input 21" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 52" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="[4A 16] - Opto Input 22" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 53" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="[4A 17] - Opto Input 23" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 54" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="[4A 18] - Opto Input 24" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 55" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="[4A 19] - Opto Input 25" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 56" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="[4A 1A] - Opto Input 26" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 57" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="[4A 1B] - Opto Input 27" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 58" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="[4A 1C] - Opto Input 28" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 59" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="[4A 1D] - Opto Input 29" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 60" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="[4A 03] - Opto Input 3" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 34" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="[4A 1E] - Opto Input 30" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 61" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="[4A 1F] - Opto Input 31" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 62" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="[4A 20] - Opto Input 32" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 63" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="[4A 04] - Opto Input 4" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 35" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="[4A 05] - Opto Input 5" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 36" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="[4A 06] - Opto Input 6" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 37" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="[4A 07] - Opto Input 7" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 38" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="[4A 08] - Opto Input 8" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 39" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="[4A 09] - Opto Input 9" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 40" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[0F 01] - Opto I/P Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Uniqueness of control &quot;Order Running&quot; indications for Control operations" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="OrdRun">
            <Private type="MiCOM-BindableType">OrdRun</Private>
            <Private type="MiCOM-BindableSignals">
									Ind1.stVal,
									Ind2.stVal,
									Ind3.stVal,
									Ind4.stVal,
									Ind5.stVal,
									Ind6.stVal,
									Ind7.stVal,
									Ind8.stVal,
									Ind9.stVal,
									Ind10.stVal,
									Ind11.stVal,
									Ind12.stVal,
									Ind13.stVal,
									Ind14.stVal,
									Ind15.stVal,
									Ind16.stVal,
									Ind17.stVal,
									Ind18.stVal,
									Ind19.stVal,
									Ind20.stVal,
									Ind21.stVal,
									Ind22.stVal,
									Ind23.stVal,
									Ind24.stVal,
									Ind25.stVal,
									Ind26.stVal,
									Ind27.stVal,
									Ind28.stVal,
									Ind29.stVal,
									Ind30.stVal,
									Ind31.stVal,
									Ind32.stVal,
						</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind10">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind11">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind12">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind13">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind14">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind15">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind16">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind17">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind18">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind19">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind2">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind20">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind21">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind22">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind23">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind24">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind25">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind26">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind27">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind28">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind29">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind3">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind30">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind31">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind32">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind4">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind5">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind6">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind7">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind8">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind9">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>GOOSE Input Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Controllable Inputs" lnType="GGIO_IND_32_CTRL$_0e905083-6669-49f3-9a2f-73b59cb0dd7f" inst="1" lnClass="GGIO" prefix="Plo">
            <Private type="MiCOM-ConfigurableAttributes">SPCSO1.ctlModel,SPCSO1.sboTimeout,SPCSO2.ctlModel,SPCSO2.sboTimeout,SPCSO3.ctlModel,SPCSO3.sboTimeout,SPCSO4.ctlModel,SPCSO4.sboTimeout,SPCSO5.ctlModel,SPCSO5.sboTimeout,SPCSO6.ctlModel,SPCSO6.sboTimeout,SPCSO7.ctlModel,SPCSO7.sboTimeout,SPCSO8.ctlModel,SPCSO8.sboTimeout,SPCSO9.ctlModel,SPCSO9.sboTimeout,SPCSO10.ctlModel,SPCSO10.sboTimeout,SPCSO11.ctlModel,SPCSO11.sboTimeout,SPCSO12.ctlModel,SPCSO12.sboTimeout,SPCSO13.ctlModel,SPCSO13.sboTimeout,SPCSO14.ctlModel,SPCSO14.sboTimeout,SPCSO15.ctlModel,SPCSO15.sboTimeout,SPCSO16.ctlModel,SPCSO16.sboTimeout,SPCSO17.ctlModel,SPCSO17.sboTimeout,SPCSO18.ctlModel,SPCSO18.sboTimeout,SPCSO19.ctlModel,SPCSO19.sboTimeout,SPCSO20.ctlModel,SPCSO20.sboTimeout,SPCSO21.ctlModel,SPCSO21.sboTimeout,SPCSO22.ctlModel,SPCSO22.sboTimeout,SPCSO23.ctlModel,SPCSO23.sboTimeout,SPCSO24.ctlModel,SPCSO24.sboTimeout,SPCSO25.ctlModel,SPCSO25.sboTimeout,SPCSO26.ctlModel,SPCSO26.sboTimeout,SPCSO27.ctlModel,SPCSO27.sboTimeout,SPCSO28.ctlModel,SPCSO28.sboTimeout,SPCSO29.ctlModel,SPCSO29.sboTimeout,SPCSO30.ctlModel,SPCSO30.sboTimeout,SPCSO31.ctlModel,SPCSO31.sboTimeout,SPCSO32.ctlModel,SPCSO32.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[12 01] - Ctrl I/P Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SPCSO1">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 192" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO10">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 201" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO11">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 202" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO12">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 203" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO13">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 204" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO14">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 205" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO15">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 206" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO16">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 207" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO17">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 208" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO18">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 209" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO19">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 210" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO2">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 193" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO20">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 211" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO21">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 212" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO22">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 213" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO23">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 214" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO24">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 215" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO25">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 216" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO26">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 217" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO27">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 218" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO28">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 219" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO29">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 220" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO3">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 194" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO30">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 221" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO31">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 222" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO32">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 223" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO4">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 195" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO5">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 196" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO6">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 197" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO7">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 198" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO8">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 199" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO9">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 200" name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Output Contacts" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="Rly">
            <DOI name="Beh">
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="[4B 01] - Relay 1" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 0" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="[4B 0A] - Relay 10" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 9" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="[4B 0B] - Relay 11" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 10" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="[4B 0C] - Relay 12" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 11" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="[4B 0D] - Relay 13" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 12" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="[4B 0E] - Relay 14" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 13" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="[4B 0F] - Relay 15" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 14" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="[4B 10] - Relay 16" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 15" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="[4B 11] - Relay 17" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 16" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="[4B 12] - Relay 18" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 17" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="[4B 13] - Relay 19" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 18" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="[4B 02] - Relay 2" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="[4B 14] - Relay 20" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 19" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="[4B 15] - Relay 21" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 20" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="[4B 16] - Relay 22" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 21" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="[4B 17] - Relay 23" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 22" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="[4B 18] - Relay 24" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 23" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="[4B 19] - Relay 25" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 24" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="[4B 1A] - Relay 26" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 25" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="[4B 1B] - Relay 27" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 26" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="[4B 1C] - Relay 28" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 27" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="[4B 1D] - Relay 29" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 28" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="[4B 03] - Relay 3" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="[4B 1E] - Relay 30" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 29" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="[4B 1F] - Relay 31" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 30" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="[4B 20] - Relay 32" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 31" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="[4B 04] - Relay 4" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 3" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="[4B 05] - Relay 5" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 4" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="[4B 06] - Relay 6" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 5" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="[4B 07] - Relay 7" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 6" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="[4B 08] - Relay 8" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 7" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="[4B 09] - Relay 9" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 8" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[0F 02] - Relay O/P Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="User Mapped (PSL) Double Point Status Indications" lnType="GGIO_IND_DPS_8" inst="1" lnClass="GGIO" prefix="Usr">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO1">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 1</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO2">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 2</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO3">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 3</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 3" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO4">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 4</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 4" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO5">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 5</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 5" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO6">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 6</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 6" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO7">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 7</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 7" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO8">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 8</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 8" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="AP2"/>
  </IED>
  <IED desc="-W001 Leitung Tamina Ost" configVersion="V07.31.03" manufacturer="SIEMENS" type="6MD86" name="E01BCU">
    <Private type="Siemens-MasterId">ccbaddd5-6978-458d-8717-387707226c37</Private>
    <Private type="Siemens-s7ManagerName">-W001 Leitung Tamina Ost</Private>
    <Private type="Siemens-ICD-Language">de-DE</Private>
    <Private type="Siemens-Siprotec5-Product-Code">6MD86-DAAA-AA0-0AAAA0-AA0112-43111B-BAA000-000AA0-CB3BA1-CG0CG0-CG0</Private>
    <Private type="Siemens-Siprotec5-Application-Template">6MD86_NotConfigured</Private>
    <Private type="Siemens-Siprotec5-Communication-Configuration-Version">73100</Private>
    <Private type="Siemens-Siprotec5-Configuration-Version">V07.31.03</Private>
    <Private type="Siemens-IsSiprotec5IED"/>
    <Services nameLength="64">
      <DynAssociation/>
      <SettingGroups>
        <SGEdit/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="50" maxAttributes="60"/>
      <DynDataSet max="30" maxAttributes="60"/>
      <ReadWrite/>
      <ConfReportControl max="30"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
      <GOOSE max="16"/>
      <FileHandling/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="false" goose="true" supportsLdName="true" sv="true"/>
    </Services>
    <AccessPoint desc="Port E" clock="false" router="false" name="E">
      <Server timeout="0">
        <Private type="Siemens-MasterId">cd2ea416-c82e-4893-8eda-8c1e02c31ce6</Private>
        <Authentication none="true"/>
        <LDevice inst="Measurement" ldName="CardiffETransformerMeasurement">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="mmxu_7_4_B2007" inst="1" lnClass="MMXU" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupM::MMXU.A.desc" name="A">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="mmxu_7_4_B2007" inst="2" lnClass="MMXU" prefix="V">
            <DOI desc="IEC61850_7_4.LNGroupM::MMXU.PhV.desc" name="PhV">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="net">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="2" lnClass="TVTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="12" lnClass="TVTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="14" lnClass="TVTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="3" lnClass="TVTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="5" lnClass="TCTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="6" lnClass="TCTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QB1Control" ldName="CardiffETransformerQB1Control">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="cswi_7_4_B2007" inst="1" lnClass="CSWI" prefix="QB1">
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpOpn.desc" name="OpOpn">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpCls.desc" name="OpCls">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QA0Control" ldName="CardiffETransformerQA0Control">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="cswi_7_4_B2007" inst="2" lnClass="CSWI" prefix="QA0">
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpOpn.desc" name="OpOpn">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.OpCls.desc" name="OpCls">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupC::CSWI.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="BreakerFailure1" ldName="CardiffETransformerBreakerFailure1">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="rbrf_7_4_B2007" inst="1" lnClass="RBRF" prefix="">
            <DOI desc="IEC61850_7_4.LNGroupR::RBRF.Str.desc" name="Str">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupR::RBRF.OpEx.desc" name="OpEx">
              <DAI name="general" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupR::RBRF.OpIn.desc" name="OpIn">
              <DAI name="general" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="LD0">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="lphd_7_4_B2007" inst="1" lnClass="LPHD">
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PhyNam.desc" name="PhyNam">
              <DAI name="vendor" valKind="Set"/>
              <DAI name="hwRev" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="serNum" valKind="Set"/>
              <DAI name="model" valKind="Set"/>
              <DAI name="location" valKind="Set"/>
              <DAI name="name" valKind="Set"/>
              <DAI name="owner" valKind="Set"/>
              <DAI name="ePSName" valKind="Set"/>
              <DAI name="primeOper" valKind="Set"/>
              <DAI name="secondOper" valKind="Set"/>
              <DAI name="latitude" valKind="Set"/>
              <DAI name="longitude" valKind="Set"/>
              <DAI name="altitude" valKind="Set"/>
              <DAI name="mRID" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PhyHealth.desc" name="PhyHealth">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.OutOv.desc" name="OutOv">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.Proxy.desc" name="Proxy">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.InOv.desc" name="InOv">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.OpTmh.desc" name="OpTmh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.NumPwrUp.desc" name="NumPwrUp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.WrmStr.desc" name="WrmStr">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.WacTrg.desc" name="WacTrg">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrUp.desc" name="PwrUp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrDn.desc" name="PwrDn">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.PwrSupAlm.desc" name="PwrSupAlm">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.RsStat.desc" name="RsStat">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.Sim.desc" name="Sim">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LPHD.MaxDl.desc" name="MaxDl">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="F">
      <ServerAt apName="E"/>
    </AccessPoint>
  </IED>
  <IED desc="UR" configVersion="0.00" manufacturer="GE Multilin" originalSclRevision="B" originalSclVersion="2007" type="C60" name="E02BCU">
    <Private type="GE_Digital_Energy_UR C60-TB3-HLH-H81-P4B-U4D_0.00">
			41115,1,1,1,0
			41115,1,2,1,0
			41115,1,3,1,0
			41115,1,4,1,0
			41116,1,1,1,0.100
			41116,1,2,1,0.100
			41116,1,3,1,0.100
			41116,1,4,1,0.100
			41117,1,1,1, 1.000
			41117,1,2,1, 1.000
			41117,1,3,1, 1.000
			41117,1,4,1, 1.000
			41114,1,1,1,0
			41114,1,2,1,0
			41114,1,3,1,0
			41114,1,4,1,0
			49456,1,1,1,Virt Op 1
			49456,1,2,1,Virt Op 2
			49456,1,3,1,Virt Op 3
			49456,1,4,1,Virt Op 4
			49456,1,5,1,Virt Op 5
			49456,1,6,1,Virt Op 6
			49456,1,7,1,Virt Op 7
			49456,1,8,1,Virt Op 8
			49456,1,9,1,Virt Op 9
			49456,1,10,1,Virt Op 10
			49456,1,11,1,Virt Op 11
			49456,1,12,1,Virt Op 12
			49456,1,13,1,Virt Op 13
			49456,1,14,1,Virt Op 14
			49456,1,15,1,Virt Op 15
			49456,1,16,1,Virt Op 16
			49456,1,17,1,Virt Op 17
			49456,1,18,1,Virt Op 18
			49456,1,19,1,Virt Op 19
			49456,1,20,1,Virt Op 20
			49456,1,21,1,Virt Op 21
			49456,1,22,1,Virt Op 22
			49456,1,23,1,Virt Op 23
			49456,1,24,1,Virt Op 24
			49456,1,25,1,Virt Op 25
			49456,1,26,1,Virt Op 26
			49456,1,27,1,Virt Op 27
			49456,1,28,1,Virt Op 28
			49456,1,29,1,Virt Op 29
			49456,1,30,1,Virt Op 30
			49456,1,31,1,Virt Op 31
			49456,1,32,1,Virt Op 32
			49456,1,33,1,Virt Op 33
			49456,1,34,1,Virt Op 34
			49456,1,35,1,Virt Op 35
			49456,1,36,1,Virt Op 36
			49456,1,37,1,Virt Op 37
			49456,1,38,1,Virt Op 38
			49456,1,39,1,Virt Op 39
			49456,1,40,1,Virt Op 40
			49456,1,41,1,Virt Op 41
			49456,1,42,1,Virt Op 42
			49456,1,43,1,Virt Op 43
			49456,1,44,1,Virt Op 44
			49456,1,45,1,Virt Op 45
			49456,1,46,1,Virt Op 46
			49456,1,47,1,Virt Op 47
			49456,1,48,1,Virt Op 48
			49456,1,49,1,Virt Op 49
			49456,1,50,1,Virt Op 50
			49456,1,51,1,Virt Op 51
			49456,1,52,1,Virt Op 52
			49456,1,53,1,Virt Op 53
			49456,1,54,1,Virt Op 54
			49456,1,55,1,Virt Op 55
			49456,1,56,1,Virt Op 56
			49456,1,57,1,Virt Op 57
			49456,1,58,1,Virt Op 58
			49456,1,59,1,Virt Op 59
			49456,1,60,1,Virt Op 60
			49456,1,61,1,Virt Op 61
			49456,1,62,1,Virt Op 62
			49456,1,63,1,Virt Op 63
			49456,1,64,1,Virt Op 64
			49456,1,65,1,Virt Op 65
			49456,1,66,1,Virt Op 66
			49456,1,67,1,Virt Op 67
			49456,1,68,1,Virt Op 68
			49456,1,69,1,Virt Op 69
			49456,1,70,1,Virt Op 70
			49456,1,71,1,Virt Op 71
			49456,1,72,1,Virt Op 72
			49456,1,73,1,Virt Op 73
			49456,1,74,1,Virt Op 74
			49456,1,75,1,Virt Op 75
			49456,1,76,1,Virt Op 76
			49456,1,77,1,Virt Op 77
			49456,1,78,1,Virt Op 78
			49456,1,79,1,Virt Op 79
			49456,1,80,1,Virt Op 80
			49456,1,81,1,Virt Op 81
			49456,1,82,1,Virt Op 82
			49456,1,83,1,Virt Op 83
			49456,1,84,1,Virt Op 84
			49456,1,85,1,Virt Op 85
			49456,1,86,1,Virt Op 86
			49456,1,87,1,Virt Op 87
			49456,1,88,1,Virt Op 88
			49456,1,89,1,Virt Op 89
			49456,1,90,1,Virt Op 90
			49456,1,91,1,Virt Op 91
			49456,1,92,1,Virt Op 92
			49456,1,93,1,Virt Op 93
			49456,1,94,1,Virt Op 94
			49456,1,95,1,Virt Op 95
			49456,1,96,1,Virt Op 96
			49462,1,1,1,0
			49462,1,2,1,0
			49462,1,3,1,0
			49462,1,4,1,0
			49462,1,5,1,0
			49462,1,6,1,0
			49462,1,7,1,0
			49462,1,8,1,0
			49462,1,9,1,0
			49462,1,10,1,0
			49462,1,11,1,0
			49462,1,12,1,0
			49462,1,13,1,0
			49462,1,14,1,0
			49462,1,15,1,0
			49462,1,16,1,0
			49462,1,17,1,0
			49462,1,18,1,0
			49462,1,19,1,0
			49462,1,20,1,0
			49462,1,21,1,0
			49462,1,22,1,0
			49462,1,23,1,0
			49462,1,24,1,0
			49462,1,25,1,0
			49462,1,26,1,0
			49462,1,27,1,0
			49462,1,28,1,0
			49462,1,29,1,0
			49462,1,30,1,0
			49462,1,31,1,0
			49462,1,32,1,0
			49462,1,33,1,0
			49462,1,34,1,0
			49462,1,35,1,0
			49462,1,36,1,0
			49462,1,37,1,0
			49462,1,38,1,0
			49462,1,39,1,0
			49462,1,40,1,0
			49462,1,41,1,0
			49462,1,42,1,0
			49462,1,43,1,0
			49462,1,44,1,0
			49462,1,45,1,0
			49462,1,46,1,0
			49462,1,47,1,0
			49462,1,48,1,0
			49462,1,49,1,0
			49462,1,50,1,0
			49462,1,51,1,0
			49462,1,52,1,0
			49462,1,53,1,0
			49462,1,54,1,0
			49462,1,55,1,0
			49462,1,56,1,0
			49462,1,57,1,0
			49462,1,58,1,0
			49462,1,59,1,0
			49462,1,60,1,0
			49462,1,61,1,0
			49462,1,62,1,0
			49462,1,63,1,0
			49462,1,64,1,0
			49462,1,65,1,0
			49462,1,66,1,0
			49462,1,67,1,0
			49462,1,68,1,0
			49462,1,69,1,0
			49462,1,70,1,0
			49462,1,71,1,0
			49462,1,72,1,0
			49462,1,73,1,0
			49462,1,74,1,0
			49462,1,75,1,0
			49462,1,76,1,0
			49462,1,77,1,0
			49462,1,78,1,0
			49462,1,79,1,0
			49462,1,80,1,0
			49462,1,81,1,0
			49462,1,82,1,0
			49462,1,83,1,0
			49462,1,84,1,0
			49462,1,85,1,0
			49462,1,86,1,0
			49462,1,87,1,0
			49462,1,88,1,0
			49462,1,89,1,0
			49462,1,90,1,0
			49462,1,91,1,0
			49462,1,92,1,0
			49462,1,93,1,0
			49462,1,94,1,0
			49462,1,95,1,0
			49462,1,96,1,0
			48695,1,1,1,0
			48695,1,2,1,0
			48695,1,3,1,0
			48695,1,4,1,0
			48695,1,5,1,0
			48695,1,6,1,0
			48695,1,7,1,0
			48695,1,8,1,0
			48695,1,9,1,0
			48695,1,10,1,0
			48695,1,11,1,0
			48695,1,12,1,0
			48695,1,13,1,0
			48695,1,14,1,0
			48695,1,15,1,0
			48695,1,16,1,0
			48695,1,17,1,0
			48695,1,18,1,0
			48695,1,19,1,0
			48695,1,20,1,0
			48695,1,21,1,0
			48695,1,22,1,0
			48695,1,23,1,0
			48695,1,24,1,0
			48695,1,25,1,0
			48695,1,26,1,0
			48695,1,27,1,0
			48695,1,28,1,0
			48695,1,29,1,0
			48695,1,30,1,0
			48695,1,31,1,0
			48695,1,32,1,0
			48695,1,33,1,0
			48695,1,34,1,0
			48695,1,35,1,0
			48695,1,36,1,0
			48695,1,37,1,0
			48695,1,38,1,0
			48695,1,39,1,0
			48695,1,40,1,0
			48695,1,41,1,0
			48695,1,42,1,0
			48695,1,43,1,0
			48695,1,44,1,0
			48695,1,45,1,0
			48695,1,46,1,0
			48695,1,47,1,0
			48695,1,48,1,0
			48695,1,49,1,0
			48695,1,50,1,0
			48695,1,51,1,0
			48695,1,52,1,0
			48695,1,53,1,0
			48695,1,54,1,0
			48695,1,55,1,0
			48695,1,56,1,0
			48695,1,57,1,0
			48695,1,58,1,0
			48695,1,59,1,0
			48695,1,60,1,0
			48695,1,61,1,0
			48695,1,62,1,0
			48695,1,63,1,0
			48695,1,64,1,0
			48689,1,1,1,Virt Ip 1
			48689,1,2,1,Virt Ip 2
			48689,1,3,1,Virt Ip 3
			48689,1,4,1,Virt Ip 4
			48689,1,5,1,Virt Ip 5
			48689,1,6,1,Virt Ip 6
			48689,1,7,1,Virt Ip 7
			48689,1,8,1,Virt Ip 8
			48689,1,9,1,Virt Ip 9
			48689,1,10,1,Virt Ip 10
			48689,1,11,1,Virt Ip 11
			48689,1,12,1,Virt Ip 12
			48689,1,13,1,Virt Ip 13
			48689,1,14,1,Virt Ip 14
			48689,1,15,1,Virt Ip 15
			48689,1,16,1,Virt Ip 16
			48689,1,17,1,Virt Ip 17
			48689,1,18,1,Virt Ip 18
			48689,1,19,1,Virt Ip 19
			48689,1,20,1,Virt Ip 20
			48689,1,21,1,Virt Ip 21
			48689,1,22,1,Virt Ip 22
			48689,1,23,1,Virt Ip 23
			48689,1,24,1,Virt Ip 24
			48689,1,25,1,Virt Ip 25
			48689,1,26,1,Virt Ip 26
			48689,1,27,1,Virt Ip 27
			48689,1,28,1,Virt Ip 28
			48689,1,29,1,Virt Ip 29
			48689,1,30,1,Virt Ip 30
			48689,1,31,1,Virt Ip 31
			48689,1,32,1,Virt Ip 32
			48689,1,33,1,Virt Ip 33
			48689,1,34,1,Virt Ip 34
			48689,1,35,1,Virt Ip 35
			48689,1,36,1,Virt Ip 36
			48689,1,37,1,Virt Ip 37
			48689,1,38,1,Virt Ip 38
			48689,1,39,1,Virt Ip 39
			48689,1,40,1,Virt Ip 40
			48689,1,41,1,Virt Ip 41
			48689,1,42,1,Virt Ip 42
			48689,1,43,1,Virt Ip 43
			48689,1,44,1,Virt Ip 44
			48689,1,45,1,Virt Ip 45
			48689,1,46,1,Virt Ip 46
			48689,1,47,1,Virt Ip 47
			48689,1,48,1,Virt Ip 48
			48689,1,49,1,Virt Ip 49
			48689,1,50,1,Virt Ip 50
			48689,1,51,1,Virt Ip 51
			48689,1,52,1,Virt Ip 52
			48689,1,53,1,Virt Ip 53
			48689,1,54,1,Virt Ip 54
			48689,1,55,1,Virt Ip 55
			48689,1,56,1,Virt Ip 56
			48689,1,57,1,Virt Ip 57
			48689,1,58,1,Virt Ip 58
			48689,1,59,1,Virt Ip 59
			48689,1,60,1,Virt Ip 60
			48689,1,61,1,Virt Ip 61
			48689,1,62,1,Virt Ip 62
			48689,1,63,1,Virt Ip 63
			48689,1,64,1,Virt Ip 64
			48688,1,1,1,0
			48688,1,2,1,0
			48688,1,3,1,0
			48688,1,4,1,0
			48688,1,5,1,0
			48688,1,6,1,0
			48688,1,7,1,0
			48688,1,8,1,0
			48688,1,9,1,0
			48688,1,10,1,0
			48688,1,11,1,0
			48688,1,12,1,0
			48688,1,13,1,0
			48688,1,14,1,0
			48688,1,15,1,0
			48688,1,16,1,0
			48688,1,17,1,0
			48688,1,18,1,0
			48688,1,19,1,0
			48688,1,20,1,0
			48688,1,21,1,0
			48688,1,22,1,0
			48688,1,23,1,0
			48688,1,24,1,0
			48688,1,25,1,0
			48688,1,26,1,0
			48688,1,27,1,0
			48688,1,28,1,0
			48688,1,29,1,0
			48688,1,30,1,0
			48688,1,31,1,0
			48688,1,32,1,0
			48688,1,33,1,0
			48688,1,34,1,0
			48688,1,35,1,0
			48688,1,36,1,0
			48688,1,37,1,0
			48688,1,38,1,0
			48688,1,39,1,0
			48688,1,40,1,0
			48688,1,41,1,0
			48688,1,42,1,0
			48688,1,43,1,0
			48688,1,44,1,0
			48688,1,45,1,0
			48688,1,46,1,0
			48688,1,47,1,0
			48688,1,48,1,0
			48688,1,49,1,0
			48688,1,50,1,0
			48688,1,51,1,0
			48688,1,52,1,0
			48688,1,53,1,0
			48688,1,54,1,0
			48688,1,55,1,0
			48688,1,56,1,0
			48688,1,57,1,0
			48688,1,58,1,0
			48688,1,59,1,0
			48688,1,60,1,0
			48688,1,61,1,0
			48688,1,62,1,0
			48688,1,63,1,0
			48688,1,64,1,0
			48696,1,1,1,0
			48696,1,2,1,0
			48696,1,3,1,0
			48696,1,4,1,0
			48696,1,5,1,0
			48696,1,6,1,0
			48696,1,7,1,0
			48696,1,8,1,0
			48696,1,9,1,0
			48696,1,10,1,0
			48696,1,11,1,0
			48696,1,12,1,0
			48696,1,13,1,0
			48696,1,14,1,0
			48696,1,15,1,0
			48696,1,16,1,0
			48696,1,17,1,0
			48696,1,18,1,0
			48696,1,19,1,0
			48696,1,20,1,0
			48696,1,21,1,0
			48696,1,22,1,0
			48696,1,23,1,0
			48696,1,24,1,0
			48696,1,25,1,0
			48696,1,26,1,0
			48696,1,27,1,0
			48696,1,28,1,0
			48696,1,29,1,0
			48696,1,30,1,0
			48696,1,31,1,0
			48696,1,32,1,0
			48696,1,33,1,0
			48696,1,34,1,0
			48696,1,35,1,0
			48696,1,36,1,0
			48696,1,37,1,0
			48696,1,38,1,0
			48696,1,39,1,0
			48696,1,40,1,0
			48696,1,41,1,0
			48696,1,42,1,0
			48696,1,43,1,0
			48696,1,44,1,0
			48696,1,45,1,0
			48696,1,46,1,0
			48696,1,47,1,0
			48696,1,48,1,0
			48696,1,49,1,0
			48696,1,50,1,0
			48696,1,51,1,0
			48696,1,52,1,0
			48696,1,53,1,0
			48696,1,54,1,0
			48696,1,55,1,0
			48696,1,56,1,0
			48696,1,57,1,0
			48696,1,58,1,0
			48696,1,59,1,0
			48696,1,60,1,0
			48696,1,61,1,0
			48696,1,62,1,0
			48696,1,63,1,0
			48696,1,64,1,0
			17485,1,1,1,0
			17479,1,1,1,1
			17486,1,1,1,0
			17477,1,1,1,0
			17475,1,1,1,1
			17484,1,1,1,1
			17482,1,1,1,0
			17480,1,1,1,1
			17476,1,1,1,0
			17478,1,1,1,1
			31585,1,1,1,
			31585,1,2,1,
			31585,1,3,1,
			31585,1,4,1,
			31585,1,5,1,
			31585,1,6,1,
			31585,1,7,1,
			31585,1,8,1,
			31585,1,9,1,
			31585,1,10,1,
			31585,1,11,1,
			31585,1,12,1,
			31585,1,13,1,
			31585,1,14,1,
			31585,1,15,1,
			31585,1,16,1,
			31615,1,1,1, 0.00
			31615,1,2,1, 0.00
			31615,1,3,1, 0.00
			31615,1,4,1, 0.00
			31615,1,5,1, 0.00
			31615,1,6,1, 0.00
			31615,1,7,1, 0.00
			31615,1,8,1, 0.00
			31615,1,9,1, 0.00
			31615,1,10,1, 0.00
			31615,1,11,1, 0.00
			31615,1,12,1, 0.00
			31615,1,13,1, 0.00
			31615,1,14,1, 0.00
			31615,1,15,1, 0.00
			31615,1,16,1, 0.00
			31629,1,1,1,0
			31629,1,2,1,0
			31629,1,3,1,0
			31629,1,4,1,0
			31629,1,5,1,0
			31629,1,6,1,0
			31629,1,7,1,0
			31629,1,8,1,0
			31629,1,9,1,0
			31629,1,10,1,0
			31629,1,11,1,0
			31629,1,12,1,0
			31629,1,13,1,0
			31629,1,14,1,0
			31629,1,15,1,0
			31629,1,16,1,0
			31627,1,1,1,0
			31627,1,2,1,0
			31627,1,3,1,0
			31627,1,4,1,0
			31627,1,5,1,0
			31627,1,6,1,0
			31627,1,7,1,0
			31627,1,8,1,0
			31627,1,9,1,0
			31627,1,10,1,0
			31627,1,11,1,0
			31627,1,12,1,0
			31627,1,13,1,0
			31627,1,14,1,0
			31627,1,15,1,0
			31627,1,16,1,0
			31625,1,1,1,0
			31625,1,2,1,0
			31625,1,3,1,0
			31625,1,4,1,0
			31625,1,5,1,0
			31625,1,6,1,0
			31625,1,7,1,0
			31625,1,8,1,0
			31625,1,9,1,0
			31625,1,10,1,0
			31625,1,11,1,0
			31625,1,12,1,0
			31625,1,13,1,0
			31625,1,14,1,0
			31625,1,15,1,0
			31625,1,16,1,0
			31595,1,1,1,
			31595,1,2,1,
			31595,1,3,1,
			31595,1,4,1,
			31595,1,5,1,
			31595,1,6,1,
			31595,1,7,1,
			31595,1,8,1,
			31595,1,9,1,
			31595,1,10,1,
			31595,1,11,1,
			31595,1,12,1,
			31595,1,13,1,
			31595,1,14,1,
			31595,1,15,1,
			31595,1,16,1,
			31605,1,1,1,
			31605,1,2,1,
			31605,1,3,1,
			31605,1,4,1,
			31605,1,5,1,
			31605,1,6,1,
			31605,1,7,1,
			31605,1,8,1,
			31605,1,9,1,
			31605,1,10,1,
			31605,1,11,1,
			31605,1,12,1,
			31605,1,13,1,
			31605,1,14,1,
			31605,1,15,1,
			31605,1,16,1,
			31624,1,1,1,0
			31624,1,2,1,0
			31624,1,3,1,0
			31624,1,4,1,0
			31624,1,5,1,0
			31624,1,6,1,0
			31624,1,7,1,0
			31624,1,8,1,0
			31624,1,9,1,0
			31624,1,10,1,0
			31624,1,11,1,0
			31624,1,12,1,0
			31624,1,13,1,0
			31624,1,14,1,0
			31624,1,15,1,0
			31624,1,16,1,0
			31622,1,1,1,0
			31622,1,2,1,0
			31622,1,3,1,0
			31622,1,4,1,0
			31622,1,5,1,0
			31622,1,6,1,0
			31622,1,7,1,0
			31622,1,8,1,0
			31622,1,9,1,0
			31622,1,10,1,0
			31622,1,11,1,0
			31622,1,12,1,0
			31622,1,13,1,0
			31622,1,14,1,0
			31622,1,15,1,0
			31622,1,16,1,0
			31618,1,1,1,0
			31618,1,2,1,0
			31618,1,3,1,0
			31618,1,4,1,0
			31618,1,5,1,0
			31618,1,6,1,0
			31618,1,7,1,0
			31618,1,8,1,0
			31618,1,9,1,0
			31618,1,10,1,0
			31618,1,11,1,0
			31618,1,12,1,0
			31618,1,13,1,0
			31618,1,14,1,0
			31618,1,15,1,0
			31618,1,16,1,0
			31631,1,1,1, 0.1
			31631,1,2,1, 0.1
			31631,1,3,1, 0.1
			31631,1,4,1, 0.1
			31631,1,5,1, 0.1
			31631,1,6,1, 0.1
			31631,1,7,1, 0.1
			31631,1,8,1, 0.1
			31631,1,9,1, 0.1
			31631,1,10,1, 0.1
			31631,1,11,1, 0.1
			31631,1,12,1, 0.1
			31631,1,13,1, 0.1
			31631,1,14,1, 0.1
			31631,1,15,1, 0.1
			31631,1,16,1, 0.1
			31584,1,1,1,0
			31584,1,2,1,0
			31584,1,3,1,0
			31584,1,4,1,0
			31584,1,5,1,0
			31584,1,6,1,0
			31584,1,7,1,0
			31584,1,8,1,0
			31584,1,9,1,0
			31584,1,10,1,0
			31584,1,11,1,0
			31584,1,12,1,0
			31584,1,13,1,0
			31584,1,14,1,0
			31584,1,15,1,0
			31584,1,16,1,0
			31617,1,1,1,0
			31617,1,2,1,0
			31617,1,3,1,0
			31617,1,4,1,0
			31617,1,5,1,0
			31617,1,6,1,0
			31617,1,7,1,0
			31617,1,8,1,0
			31617,1,9,1,0
			31617,1,10,1,0
			31617,1,11,1,0
			31617,1,12,1,0
			31617,1,13,1,0
			31617,1,14,1,0
			31617,1,15,1,0
			31617,1,16,1,0
			31621,1,1,1,0
			31621,1,2,1,0
			31621,1,3,1,0
			31621,1,4,1,0
			31621,1,5,1,0
			31621,1,6,1,0
			31621,1,7,1,0
			31621,1,8,1,0
			31621,1,9,1,0
			31621,1,10,1,0
			31621,1,11,1,0
			31621,1,12,1,0
			31621,1,13,1,0
			31621,1,14,1,0
			31621,1,15,1,0
			31621,1,16,1,0
			31620,1,1,1,  1.0
			31620,1,2,1,  1.0
			31620,1,3,1,  1.0
			31620,1,4,1,  1.0
			31620,1,5,1,  1.0
			31620,1,6,1,  1.0
			31620,1,7,1,  1.0
			31620,1,8,1,  1.0
			31620,1,9,1,  1.0
			31620,1,10,1,  1.0
			31620,1,11,1,  1.0
			31620,1,12,1,  1.0
			31620,1,13,1,  1.0
			31620,1,14,1,  1.0
			31620,1,15,1,  1.0
			31620,1,16,1,  1.0
			17090,1,1,1,1
			17090,1,2,1,1
			17090,1,3,1,1
			17090,1,4,1,1
			17090,1,5,1,1
			17090,1,6,1,1
			17090,1,7,1,1
			17090,1,8,1,1
			17090,1,9,1,1
			17090,1,10,1,1
			17090,1,11,1,1
			17090,1,12,1,1
			17090,1,13,1,1
			17090,1,14,1,1
			17090,1,15,1,1
			17090,1,16,1,1
			17090,1,17,1,1
			17090,1,18,1,1
			17090,1,19,1,1
			17090,1,20,1,1
			17090,1,21,1,1
			17090,1,22,1,1
			17090,1,23,1,1
			17090,1,24,1,1
			17090,1,25,1,1
			17090,1,26,1,1
			17090,1,27,1,1
			17090,1,28,1,1
			17090,1,29,1,1
			17090,1,30,1,1
			17090,1,31,1,1
			17090,1,32,1,1
			17090,1,33,1,1
			17090,1,34,1,1
			17090,1,35,1,1
			17090,1,36,1,1
			17090,1,37,1,1
			17090,1,38,1,1
			17090,1,39,1,1
			17090,1,40,1,1
			17090,1,41,1,1
			17090,1,42,1,1
			17090,1,43,1,1
			17090,1,44,1,1
			17090,1,45,1,1
			17090,1,46,1,1
			17090,1,47,1,1
			17090,1,48,1,1
			17088,1,1,1,0
			17088,1,2,1,0
			17088,1,3,1,0
			17088,1,4,1,0
			17088,1,5,1,0
			17088,1,6,1,0
			17088,1,7,1,0
			17088,1,8,1,0
			17088,1,9,1,0
			17088,1,10,1,0
			17088,1,11,1,0
			17088,1,12,1,0
			17088,1,13,1,0
			17088,1,14,1,0
			17088,1,15,1,0
			17088,1,16,1,0
			17088,1,17,1,0
			17088,1,18,1,0
			17088,1,19,1,0
			17088,1,20,1,0
			17088,1,21,1,0
			17088,1,22,1,0
			17088,1,23,1,0
			17088,1,24,1,0
			17088,1,25,1,0
			17088,1,26,1,0
			17088,1,27,1,0
			17088,1,28,1,0
			17088,1,29,1,0
			17088,1,30,1,0
			17088,1,31,1,0
			17088,1,32,1,0
			17088,1,33,1,0
			17088,1,34,1,0
			17088,1,35,1,0
			17088,1,36,1,0
			17088,1,37,1,0
			17088,1,38,1,0
			17088,1,39,1,0
			17088,1,40,1,0
			17088,1,41,1,0
			17088,1,42,1,0
			17088,1,43,1,0
			17088,1,44,1,0
			17088,1,45,1,0
			17088,1,46,1,0
			17088,1,47,1,0
			17088,1,48,1,0
			19456,1,1,1,
			19456,1,2,1,
			19456,1,3,1,
			19456,1,4,1,
			19456,1,5,1,
			19456,1,6,1,
			19456,1,7,1,
			19456,1,8,1,
			19456,1,9,1,
			19456,1,10,1,
			19456,1,11,1,
			19456,1,12,1,
			19456,1,13,1,
			19456,1,14,1,
			19456,1,15,1,
			19456,1,16,1,
			19476,1,1,1,    0
			19476,1,1,2,    0
			19476,1,1,3,    0
			19476,1,1,4,    0
			19476,1,1,5,    0
			19476,1,2,1,    0
			19476,1,2,2,    0
			19476,1,2,3,    0
			19476,1,2,4,    0
			19476,1,2,5,    0
			19476,1,3,1,    0
			19476,1,3,2,    0
			19476,1,3,3,    0
			19476,1,3,4,    0
			19476,1,3,5,    0
			19476,1,4,1,    0
			19476,1,4,2,    0
			19476,1,4,3,    0
			19476,1,4,4,    0
			19476,1,4,5,    0
			19476,1,5,1,    0
			19476,1,5,2,    0
			19476,1,5,3,    0
			19476,1,5,4,    0
			19476,1,5,5,    0
			19476,1,6,1,    0
			19476,1,6,2,    0
			19476,1,6,3,    0
			19476,1,6,4,    0
			19476,1,6,5,    0
			19476,1,7,1,    0
			19476,1,7,2,    0
			19476,1,7,3,    0
			19476,1,7,4,    0
			19476,1,7,5,    0
			19476,1,8,1,    0
			19476,1,8,2,    0
			19476,1,8,3,    0
			19476,1,8,4,    0
			19476,1,8,5,    0
			19476,1,9,1,    0
			19476,1,9,2,    0
			19476,1,9,3,    0
			19476,1,9,4,    0
			19476,1,9,5,    0
			19476,1,10,1,    0
			19476,1,10,2,    0
			19476,1,10,3,    0
			19476,1,10,4,    0
			19476,1,10,5,    0
			19476,1,11,1,    0
			19476,1,11,2,    0
			19476,1,11,3,    0
			19476,1,11,4,    0
			19476,1,11,5,    0
			19476,1,12,1,    0
			19476,1,12,2,    0
			19476,1,12,3,    0
			19476,1,12,4,    0
			19476,1,12,5,    0
			19476,1,13,1,    0
			19476,1,13,2,    0
			19476,1,13,3,    0
			19476,1,13,4,    0
			19476,1,13,5,    0
			19476,1,14,1,    0
			19476,1,14,2,    0
			19476,1,14,3,    0
			19476,1,14,4,    0
			19476,1,14,5,    0
			19476,1,15,1,    0
			19476,1,15,2,    0
			19476,1,15,3,    0
			19476,1,15,4,    0
			19476,1,15,5,    0
			19476,1,16,1,    0
			19476,1,16,2,    0
			19476,1,16,3,    0
			19476,1,16,4,    0
			19476,1,16,5,    0
			19466,1,1,1,
			19466,1,2,1,
			19466,1,3,1,
			19466,1,4,1,
			19466,1,5,1,
			19466,1,6,1,
			19466,1,7,1,
			19466,1,8,1,
			19466,1,9,1,
			19466,1,10,1,
			19466,1,11,1,
			19466,1,12,1,
			19466,1,13,1,
			19466,1,14,1,
			19466,1,15,1,
			19466,1,16,1,
			16448,1,1,1,0
			36600,1,1,1,0
			36600,1,2,1,0
			36600,1,3,1,0
			36600,1,4,1,0
			36600,1,5,1,0
			36600,1,6,1,0
			36564,1,1,1,  0.00
			36564,1,2,1,  0.00
			36564,1,3,1,  0.00
			36564,1,4,1,  0.00
			36564,1,5,1,  0.00
			36564,1,6,1,  0.00
			36598,1,1,1,0
			36598,1,2,1,0
			36598,1,3,1,0
			36598,1,4,1,0
			36598,1,5,1,0
			36598,1,6,1,0
			36563,1,1,1,  0.00
			36563,1,2,1,  0.00
			36563,1,3,1,  0.00
			36563,1,4,1,  0.00
			36563,1,5,1,  0.00
			36563,1,6,1,  0.00
			36597,1,1,1,0
			36597,1,2,1,0
			36597,1,3,1,0
			36597,1,4,1,0
			36597,1,5,1,0
			36597,1,6,1,0
			36565,1,1,1,0
			36565,1,1,2,0
			36565,1,1,3,0
			36565,1,1,4,0
			36565,1,1,5,0
			36565,1,1,6,0
			36565,1,1,7,0
			36565,1,1,8,0
			36565,1,1,9,0
			36565,1,1,10,0
			36565,1,1,11,0
			36565,1,1,12,0
			36565,1,1,13,0
			36565,1,1,14,0
			36565,1,1,15,0
			36565,1,1,16,0
			36565,1,2,1,0
			36565,1,2,2,0
			36565,1,2,3,0
			36565,1,2,4,0
			36565,1,2,5,0
			36565,1,2,6,0
			36565,1,2,7,0
			36565,1,2,8,0
			36565,1,2,9,0
			36565,1,2,10,0
			36565,1,2,11,0
			36565,1,2,12,0
			36565,1,2,13,0
			36565,1,2,14,0
			36565,1,2,15,0
			36565,1,2,16,0
			36565,1,3,1,0
			36565,1,3,2,0
			36565,1,3,3,0
			36565,1,3,4,0
			36565,1,3,5,0
			36565,1,3,6,0
			36565,1,3,7,0
			36565,1,3,8,0
			36565,1,3,9,0
			36565,1,3,10,0
			36565,1,3,11,0
			36565,1,3,12,0
			36565,1,3,13,0
			36565,1,3,14,0
			36565,1,3,15,0
			36565,1,3,16,0
			36565,1,4,1,0
			36565,1,4,2,0
			36565,1,4,3,0
			36565,1,4,4,0
			36565,1,4,5,0
			36565,1,4,6,0
			36565,1,4,7,0
			36565,1,4,8,0
			36565,1,4,9,0
			36565,1,4,10,0
			36565,1,4,11,0
			36565,1,4,12,0
			36565,1,4,13,0
			36565,1,4,14,0
			36565,1,4,15,0
			36565,1,4,16,0
			36565,1,5,1,0
			36565,1,5,2,0
			36565,1,5,3,0
			36565,1,5,4,0
			36565,1,5,5,0
			36565,1,5,6,0
			36565,1,5,7,0
			36565,1,5,8,0
			36565,1,5,9,0
			36565,1,5,10,0
			36565,1,5,11,0
			36565,1,5,12,0
			36565,1,5,13,0
			36565,1,5,14,0
			36565,1,5,15,0
			36565,1,5,16,0
			36565,1,6,1,0
			36565,1,6,2,0
			36565,1,6,3,0
			36565,1,6,4,0
			36565,1,6,5,0
			36565,1,6,6,0
			36565,1,6,7,0
			36565,1,6,8,0
			36565,1,6,9,0
			36565,1,6,10,0
			36565,1,6,11,0
			36565,1,6,12,0
			36565,1,6,13,0
			36565,1,6,14,0
			36565,1,6,15,0
			36565,1,6,16,0
			36560,1,1,1,0
			36560,1,2,1,0
			36560,1,3,1,0
			36560,1,4,1,0
			36560,1,5,1,0
			36560,1,6,1,0
			36601,1,1,1,0
			36601,1,2,1,0
			36601,1,3,1,0
			36601,1,4,1,0
			36601,1,5,1,0
			36601,1,6,1,0
			36561,1,1,1,0
			36561,1,2,1,0
			36561,1,3,1,0
			36561,1,4,1,0
			36561,1,5,1,0
			36561,1,6,1,0
			17072,1,1,1,0
			17074,1,1,1,0
			30604,1,1,1,  45
			30604,1,2,1,  45
			30611,1,1,1,0
			30611,1,2,1,0
			30601,1,1,1,0
			30601,1,2,1,0
			30605,1,1,1,  45
			30605,1,2,1,  45
			30607,1,1,1,0
			30607,1,2,1,0
			30606,1,1,1,  20
			30606,1,2,1,  20
			30603,1,1,1,1.10
			30603,1,2,1,1.10
			30600,1,1,1,0
			30600,1,2,1,0
			30612,1,1,1,0
			30612,1,2,1,0
			30609,1,1,1,0
			30609,1,2,1,0
			30602,1,1,1,0.80
			30602,1,2,1,0.80
			56434,1,1,1,1
			56434,1,2,1,1
			56434,1,3,1,1
			56434,1,4,1,1
			56433,1,1,1,0
			56433,1,2,1,0
			56433,1,3,1,0
			56433,1,4,1,0
			56444,1,1,1,0
			56444,1,2,1,0
			56444,1,3,1,0
			56444,1,4,1,0
			56435,1,1,1,10000
			56435,1,2,1,10000
			56435,1,3,1,10000
			56435,1,4,1,10000
			56438,1,1,1,1.00
			56438,1,2,1,1.00
			56438,1,3,1,1.00
			56438,1,4,1,1.00
			56437,1,1,1, 30
			56437,1,2,1, 30
			56437,1,3,1, 30
			56437,1,4,1, 30
			56443,1,1,1,0.70
			56443,1,2,1,0.70
			56443,1,3,1,0.70
			56443,1,4,1,0.70
			56442,1,1,1,0.70
			56442,1,2,1,0.70
			56442,1,3,1,0.70
			56442,1,4,1,0.70
			56432,1,1,1,0
			56432,1,2,1,0
			56432,1,3,1,0
			56432,1,4,1,0
			56448,1,1,1,0.06
			56448,1,2,1,0.06
			56448,1,3,1,0.06
			56448,1,4,1,0.06
			56445,1,1,1,0
			56445,1,2,1,0
			56445,1,3,1,0
			56445,1,4,1,0
			56441,1,1,1,0.30
			56441,1,2,1,0.30
			56441,1,3,1,0.30
			56441,1,4,1,0.30
			56440,1,1,1,0.30
			56440,1,2,1,0.30
			56440,1,3,1,0.30
			56440,1,4,1,0.30
			56439,1,1,1,1
			56439,1,2,1,1
			56439,1,3,1,1
			56439,1,4,1,1
			56446,1,1,1,0
			56446,1,2,1,0
			56446,1,3,1,0
			56446,1,4,1,0
			17797,1,1,1,0
			17797,1,2,1,0
			17797,1,3,1,0
			17797,1,4,1,0
			17795,1,1,1,0
			17795,1,2,1,0
			17795,1,3,1,0
			17795,1,4,1,0
			17792,1,1,1,SRC 1
			17792,1,2,1,SRC 2
			17792,1,3,1,SRC 3
			17792,1,4,1,SRC 4
			17796,1,1,1,0
			17796,1,2,1,0
			17796,1,3,1,0
			17796,1,4,1,0
			17798,1,1,1,0
			17798,1,2,1,0
			17798,1,3,1,0
			17798,1,4,1,0
			16745,1,1,1,0
			16747,1,1,1,  123
			16744,1,1,1,0
			60681,1,1,1,    0
			60681,1,1,2,    0
			60681,1,1,3,    0
			60681,1,1,4,    0
			60681,1,1,5,    0
			60681,1,1,6,    0
			60681,1,1,7,    0
			60681,1,1,8,    0
			60681,1,1,9,    0
			60681,1,1,10,    0
			60681,1,1,11,    0
			60681,1,1,12,    0
			60681,1,1,13,    0
			60681,1,1,14,    0
			60681,1,1,15,    0
			60681,1,1,16,    0
			60681,1,1,17,    0
			60681,1,1,18,    0
			60681,1,1,19,    0
			60681,1,1,20,    0
			60681,1,1,21,    0
			60681,1,1,22,    0
			60681,1,1,23,    0
			60681,1,1,24,    0
			60681,1,1,25,    0
			60681,1,1,26,    0
			60681,1,1,27,    0
			60681,1,1,28,    0
			60681,1,1,29,    0
			60681,1,1,30,    0
			60681,1,1,31,    0
			60681,1,1,32,    0
			60681,1,1,33,    0
			60681,1,1,34,    0
			60681,1,1,35,    0
			60681,1,1,36,    0
			60681,1,1,37,    0
			60681,1,1,38,    0
			60681,1,1,39,    0
			60681,1,1,40,    0
			60681,1,1,41,    0
			60681,1,1,42,    0
			60681,1,1,43,    0
			60681,1,1,44,    0
			60681,1,1,45,    0
			60681,1,1,46,    0
			60681,1,1,47,    0
			60681,1,1,48,    0
			60681,1,1,49,    0
			60681,1,1,50,    0
			60681,1,1,51,    0
			60681,1,1,52,    0
			60681,1,1,53,    0
			60681,1,1,54,    0
			60681,1,1,55,    0
			60681,1,1,56,    0
			60681,1,1,57,    0
			60681,1,1,58,    0
			60681,1,1,59,    0
			60681,1,1,60,    0
			60681,1,1,61,    0
			60681,1,1,62,    0
			60681,1,1,63,    0
			60681,1,1,64,    0
			60681,1,1,65,    0
			60681,1,1,66,    0
			60681,1,1,67,    0
			60681,1,1,68,    0
			60681,1,1,69,    0
			60681,1,1,70,    0
			60681,1,1,71,    0
			60681,1,1,72,    0
			60681,1,1,73,    0
			60681,1,1,74,    0
			60681,1,1,75,    0
			60681,1,1,76,    0
			60681,1,1,77,    0
			60681,1,1,78,    0
			60681,1,1,79,    0
			60681,1,1,80,    0
			60681,1,1,81,    0
			60681,1,1,82,    0
			60681,1,1,83,    0
			60681,1,1,84,    0
			60681,1,1,85,    0
			60681,1,1,86,    0
			60681,1,1,87,    0
			60681,1,1,88,    0
			60681,1,1,89,    0
			60681,1,1,90,    0
			60681,1,1,91,    0
			60681,1,1,92,    0
			60681,1,1,93,    0
			60681,1,1,94,    0
			60681,1,1,95,    0
			60681,1,1,96,    0
			60681,1,1,97,    0
			60681,1,1,98,    0
			60681,1,1,99,    0
			60681,1,1,100,    0
			60681,1,1,101,    0
			60681,1,1,102,    0
			60681,1,1,103,    0
			60681,1,1,104,    0
			60681,1,1,105,    0
			60681,1,1,106,    0
			60681,1,1,107,    0
			60681,1,1,108,    0
			60681,1,1,109,    0
			60681,1,1,110,    0
			60681,1,1,111,    0
			60681,1,1,112,    0
			60681,1,1,113,    0
			60681,1,1,114,    0
			60681,1,1,115,    0
			60681,1,1,116,    0
			60681,1,1,117,    0
			60681,1,1,118,    0
			60681,1,1,119,    0
			60681,1,1,120,    0
			60681,1,1,121,    0
			60681,1,1,122,    0
			60681,1,1,123,    0
			60681,1,1,124,    0
			60681,1,1,125,    0
			60681,1,1,126,    0
			60681,1,1,127,    0
			60681,1,1,128,    0
			60681,1,1,129,    0
			60681,1,1,130,    0
			60681,1,1,131,    0
			60681,1,1,132,    0
			60681,1,1,133,    0
			60681,1,1,134,    0
			60681,1,1,135,    0
			60681,1,1,136,    0
			60681,1,1,137,    0
			60681,1,1,138,    0
			60681,1,1,139,    0
			60681,1,1,140,    0
			60681,1,1,141,    0
			60681,1,1,142,    0
			60681,1,1,143,    0
			60681,1,1,144,    0
			60681,1,1,145,    0
			60681,1,1,146,    0
			60681,1,1,147,    0
			60681,1,1,148,    0
			60681,1,1,149,    0
			60681,1,1,150,    0
			60681,1,1,151,    0
			60681,1,1,152,    0
			60681,1,1,153,    0
			60681,1,1,154,    0
			60681,1,1,155,    0
			60681,1,1,156,    0
			60681,1,1,157,    0
			60681,1,1,158,    0
			60681,1,1,159,    0
			60681,1,1,160,    0
			60681,1,1,161,    0
			60681,1,1,162,    0
			60681,1,1,163,    0
			60681,1,1,164,    0
			60681,1,1,165,    0
			60681,1,1,166,    0
			60681,1,1,167,    0
			60681,1,1,168,    0
			60681,1,1,169,    0
			60681,1,1,170,    0
			60681,1,1,171,    0
			60681,1,1,172,    0
			60681,1,1,173,    0
			60681,1,1,174,    0
			60681,1,1,175,    0
			60681,1,1,176,    0
			60681,1,1,177,    0
			60681,1,1,178,    0
			60681,1,1,179,    0
			60681,1,1,180,    0
			60681,1,1,181,    0
			60681,1,1,182,    0
			60681,1,1,183,    0
			60681,1,1,184,    0
			60681,1,1,185,    0
			60681,1,1,186,    0
			60681,1,1,187,    0
			60681,1,1,188,    0
			60681,1,1,189,    0
			60681,1,1,190,    0
			60681,1,1,191,    0
			60681,1,1,192,    0
			60681,1,1,193,    0
			60681,1,1,194,    0
			60681,1,1,195,    0
			60681,1,1,196,    0
			60681,1,1,197,    0
			60681,1,1,198,    0
			60681,1,1,199,    0
			60681,1,1,200,    0
			60681,1,1,201,    0
			60681,1,1,202,    0
			60681,1,1,203,    0
			60681,1,1,204,    0
			60681,1,1,205,    0
			60681,1,1,206,    0
			60681,1,1,207,    0
			60681,1,1,208,    0
			60681,1,1,209,    0
			60681,1,1,210,    0
			60681,1,1,211,    0
			60681,1,1,212,    0
			60681,1,1,213,    0
			60681,1,1,214,    0
			60681,1,1,215,    0
			60681,1,1,216,    0
			60681,1,1,217,    0
			60681,1,1,218,    0
			60681,1,1,219,    0
			60681,1,1,220,    0
			60681,1,1,221,    0
			60681,1,1,222,    0
			60681,1,1,223,    0
			60681,1,1,224,    0
			60681,1,1,225,    0
			60681,1,1,226,    0
			60681,1,1,227,    0
			60681,1,1,228,    0
			60681,1,1,229,    0
			60681,1,1,230,    0
			60681,1,1,231,    0
			60681,1,1,232,    0
			60681,1,1,233,    0
			60681,1,1,234,    0
			60681,1,1,235,    0
			60681,1,1,236,    0
			60681,1,1,237,    0
			60681,1,1,238,    0
			60681,1,1,239,    0
			60681,1,1,240,    0
			60681,1,1,241,    0
			60681,1,1,242,    0
			60681,1,1,243,    0
			60681,1,1,244,    0
			60681,1,1,245,    0
			60681,1,1,246,    0
			60681,1,1,247,    0
			60681,1,1,248,    0
			60681,1,1,249,    0
			60681,1,1,250,    0
			60681,1,1,251,    0
			60681,1,1,252,    0
			60681,1,1,253,    0
			60681,1,1,254,    0
			60681,1,1,255,    0
			60681,1,1,256,    0
			60681,1,1,257,    0
			60681,1,1,258,    0
			60681,1,1,259,    0
			60681,1,1,260,    0
			60681,1,1,261,    0
			60681,1,1,262,    0
			60681,1,1,263,    0
			60681,1,1,264,    0
			60681,1,1,265,    0
			60681,1,1,266,    0
			60681,1,1,267,    0
			60681,1,1,268,    0
			60681,1,1,269,    0
			60681,1,1,270,    0
			60681,1,1,271,    0
			60681,1,1,272,    0
			60681,1,1,273,    0
			60681,1,1,274,    0
			60681,1,1,275,    0
			60681,1,1,276,    0
			60681,1,1,277,    0
			60681,1,1,278,    0
			60681,1,1,279,    0
			60681,1,1,280,    0
			60681,1,1,281,    0
			60681,1,1,282,    0
			60681,1,1,283,    0
			60681,1,1,284,    0
			60681,1,1,285,    0
			60681,1,1,286,    0
			60681,1,1,287,    0
			60681,1,1,288,    0
			60681,1,1,289,    0
			60681,1,1,290,    0
			60681,1,1,291,    0
			60681,1,1,292,    0
			60681,1,1,293,    0
			60681,1,1,294,    0
			60681,1,1,295,    0
			60681,1,1,296,    0
			60681,1,1,297,    0
			60681,1,1,298,    0
			60681,1,1,299,    0
			60681,1,1,300,    0
			60681,1,1,301,    0
			60681,1,1,302,    0
			60681,1,1,303,    0
			60681,1,1,304,    0
			60681,1,1,305,    0
			60681,1,1,306,    0
			60681,1,1,307,    0
			60681,1,1,308,    0
			60681,1,1,309,    0
			60681,1,1,310,    0
			60681,1,1,311,    0
			60681,1,1,312,    0
			60681,1,1,313,    0
			60681,1,1,314,    0
			60681,1,1,315,    0
			60681,1,1,316,    0
			60681,1,1,317,    0
			60681,1,1,318,    0
			60681,1,1,319,    0
			60681,1,1,320,    0
			60681,1,1,321,    0
			60681,1,1,322,    0
			60681,1,1,323,    0
			60681,1,1,324,    0
			60681,1,1,325,    0
			60681,1,1,326,    0
			60681,1,1,327,    0
			60681,1,1,328,    0
			60681,1,1,329,    0
			60681,1,1,330,    0
			60681,1,1,331,    0
			60681,1,1,332,    0
			60681,1,1,333,    0
			60681,1,1,334,    0
			60681,1,1,335,    0
			60681,1,1,336,    0
			60681,1,1,337,    0
			60681,1,1,338,    0
			60681,1,1,339,    0
			60681,1,1,340,    0
			60681,1,1,341,    0
			60681,1,1,342,    0
			60681,1,1,343,    0
			60681,1,1,344,    0
			60681,1,1,345,    0
			60681,1,1,346,    0
			60681,1,1,347,    0
			60681,1,1,348,    0
			60681,1,1,349,    0
			60681,1,1,350,    0
			60681,1,1,351,    0
			60681,1,1,352,    0
			60681,1,1,353,    0
			60681,1,1,354,    0
			60681,1,1,355,    0
			60681,1,1,356,    0
			60681,1,1,357,    0
			60681,1,1,358,    0
			60681,1,1,359,    0
			60681,1,1,360,    0
			60681,1,1,361,    0
			60681,1,1,362,    0
			60681,1,1,363,    0
			60681,1,1,364,    0
			60681,1,1,365,    0
			60681,1,1,366,    0
			60681,1,1,367,    0
			60681,1,1,368,    0
			60681,1,1,369,    0
			60681,1,1,370,    0
			60681,1,1,371,    0
			60681,1,1,372,    0
			60681,1,1,373,    0
			60681,1,1,374,    0
			60681,1,1,375,    0
			60681,1,1,376,    0
			60681,1,1,377,    0
			60681,1,1,378,    0
			60681,1,1,379,    0
			60681,1,1,380,    0
			60681,1,1,381,    0
			60681,1,1,382,    0
			60681,1,1,383,    0
			60681,1,1,384,    0
			60681,1,1,385,    0
			60681,1,1,386,    0
			60681,1,1,387,    0
			60681,1,1,388,    0
			60681,1,1,389,    0
			60681,1,1,390,    0
			60681,1,1,391,    0
			60681,1,1,392,    0
			60681,1,1,393,    0
			60681,1,1,394,    0
			60681,1,1,395,    0
			60681,1,1,396,    0
			60681,1,1,397,    0
			60681,1,1,398,    0
			60681,1,1,399,    0
			60681,1,1,400,    0
			60681,1,1,401,    0
			60681,1,1,402,    0
			60681,1,1,403,    0
			60681,1,1,404,    0
			60681,1,1,405,    0
			60681,1,1,406,    0
			60681,1,1,407,    0
			60681,1,1,408,    0
			60681,1,1,409,    0
			60681,1,1,410,    0
			60681,1,1,411,    0
			60681,1,1,412,    0
			60681,1,1,413,    0
			60681,1,1,414,    0
			60681,1,1,415,    0
			60681,1,1,416,    0
			60681,1,1,417,    0
			60681,1,1,418,    0
			60681,1,1,419,    0
			60681,1,1,420,    0
			60681,1,1,421,    0
			60681,1,1,422,    0
			60681,1,1,423,    0
			60681,1,1,424,    0
			60681,1,1,425,    0
			60681,1,1,426,    0
			60681,1,1,427,    0
			60681,1,1,428,    0
			60681,1,1,429,    0
			60681,1,1,430,    0
			60681,1,1,431,    0
			60681,1,1,432,    0
			60681,1,1,433,    0
			60681,1,1,434,    0
			60681,1,1,435,    0
			60681,1,1,436,    0
			60681,1,1,437,    0
			60681,1,1,438,    0
			60681,1,1,439,    0
			60681,1,1,440,    0
			60681,1,1,441,    0
			60681,1,1,442,    0
			60681,1,1,443,    0
			60681,1,1,444,    0
			60681,1,1,445,    0
			60681,1,1,446,    0
			60681,1,1,447,    0
			60681,1,1,448,    0
			60681,1,1,449,    0
			60681,1,1,450,    0
			60681,1,1,451,    0
			60681,1,1,452,    0
			60681,1,1,453,    0
			60681,1,1,454,    0
			60681,1,1,455,    0
			60681,1,1,456,    0
			60681,1,1,457,    0
			60681,1,1,458,    0
			60681,1,1,459,    0
			60681,1,1,460,    0
			60681,1,1,461,    0
			60681,1,1,462,    0
			60681,1,1,463,    0
			60681,1,1,464,    0
			60681,1,1,465,    0
			60681,1,1,466,    0
			60681,1,1,467,    0
			60681,1,1,468,    0
			60681,1,1,469,    0
			60681,1,1,470,    0
			60681,1,1,471,    0
			60681,1,1,472,    0
			60681,1,1,473,    0
			60681,1,1,474,    0
			60681,1,1,475,    0
			60681,1,1,476,    0
			60681,1,1,477,    0
			60681,1,1,478,    0
			60681,1,1,479,    0
			60681,1,1,480,    0
			60681,1,1,481,    0
			60681,1,1,482,    0
			60681,1,1,483,    0
			60681,1,1,484,    0
			60681,1,1,485,    0
			60681,1,1,486,    0
			60681,1,1,487,    0
			60681,1,1,488,    0
			60681,1,1,489,    0
			60681,1,1,490,    0
			60681,1,1,491,    0
			60681,1,1,492,    0
			60681,1,1,493,    0
			60681,1,1,494,    0
			60681,1,1,495,    0
			60681,1,1,496,    0
			60681,1,1,497,    0
			60681,1,1,498,    0
			60681,1,1,499,    0
			60681,1,1,500,    0
			60681,1,1,501,    0
			60681,1,1,502,    0
			60681,1,1,503,    0
			60681,1,1,504,    0
			60681,1,1,505,    0
			60681,1,1,506,    0
			60681,1,1,507,    0
			60681,1,1,508,    0
			60681,1,1,509,    0
			60681,1,1,510,    0
			60681,1,1,511,    0
			60681,1,1,512,    0
			60681,1,1,513,    0
			60681,1,1,514,    0
			60681,1,1,515,    0
			60681,1,1,516,    0
			60681,1,1,517,    0
			60681,1,1,518,    0
			60681,1,1,519,    0
			60681,1,1,520,    0
			60681,1,1,521,    0
			60681,1,1,522,    0
			60681,1,1,523,    0
			60681,1,1,524,    0
			60681,1,1,525,    0
			60681,1,1,526,    0
			60681,1,1,527,    0
			60681,1,1,528,    0
			60681,1,1,529,    0
			60681,1,1,530,    0
			60681,1,1,531,    0
			60681,1,1,532,    0
			60681,1,1,533,    0
			60681,1,1,534,    0
			60681,1,1,535,    0
			60681,1,1,536,    0
			60681,1,1,537,    0
			60681,1,1,538,    0
			60681,1,1,539,    0
			60681,1,1,540,    0
			60681,1,1,541,    0
			60681,1,1,542,    0
			60681,1,1,543,    0
			60681,1,1,544,    0
			60681,1,1,545,    0
			60681,1,1,546,    0
			60681,1,1,547,    0
			60681,1,1,548,    0
			60681,1,1,549,    0
			60681,1,1,550,    0
			60681,1,1,551,    0
			60681,1,1,552,    0
			60681,1,1,553,    0
			60681,1,1,554,    0
			60681,1,1,555,    0
			60681,1,1,556,    0
			60681,1,1,557,    0
			60681,1,1,558,    0
			60681,1,1,559,    0
			60681,1,1,560,    0
			60681,1,1,561,    0
			60681,1,1,562,    0
			60681,1,1,563,    0
			60681,1,1,564,    0
			60681,1,1,565,    0
			60681,1,1,566,    0
			60681,1,1,567,    0
			60681,1,1,568,    0
			60681,1,1,569,    0
			60681,1,1,570,    0
			60681,1,1,571,    0
			60681,1,1,572,    0
			60681,1,1,573,    0
			60681,1,1,574,    0
			60681,1,1,575,    0
			60681,1,1,576,    0
			60681,1,1,577,    0
			60681,1,1,578,    0
			60681,1,1,579,    0
			60681,1,1,580,    0
			60681,1,1,581,    0
			60681,1,1,582,    0
			60681,1,1,583,    0
			60681,1,1,584,    0
			60681,1,1,585,    0
			60681,1,1,586,    0
			60681,1,1,587,    0
			60681,1,1,588,    0
			60681,1,1,589,    0
			60681,1,1,590,    0
			60681,1,1,591,    0
			60681,1,1,592,    0
			60681,1,1,593,    0
			60681,1,1,594,    0
			60681,1,1,595,    0
			60681,1,1,596,    0
			60681,1,1,597,    0
			60681,1,1,598,    0
			60681,1,1,599,    0
			60681,1,1,600,    0
			60681,1,1,601,    0
			60681,1,1,602,    0
			60681,1,1,603,    0
			60681,1,1,604,    0
			60681,1,1,605,    0
			60681,1,1,606,    0
			60681,1,1,607,    0
			60681,1,1,608,    0
			60681,1,1,609,    0
			60681,1,1,610,    0
			60681,1,1,611,    0
			60681,1,1,612,    0
			60681,1,1,613,    0
			60681,1,1,614,    0
			60681,1,1,615,    0
			60681,1,1,616,    0
			60681,1,1,617,    0
			60681,1,1,618,    0
			60681,1,1,619,    0
			60681,1,1,620,    0
			60681,1,1,621,    0
			60681,1,1,622,    0
			60681,1,1,623,    0
			60681,1,1,624,    0
			60681,1,1,625,    0
			60681,1,1,626,    0
			60681,1,1,627,    0
			60681,1,1,628,    0
			60681,1,1,629,    0
			60681,1,1,630,    0
			60681,1,1,631,    0
			60681,1,1,632,    0
			60681,1,1,633,    0
			60681,1,1,634,    0
			60681,1,1,635,    0
			60681,1,1,636,    0
			60681,1,1,637,    0
			60681,1,1,638,    0
			60681,1,1,639,    0
			60681,1,1,640,    0
			60681,1,1,641,    0
			60681,1,1,642,    0
			60681,1,1,643,    0
			60681,1,1,644,    0
			60681,1,1,645,    0
			60681,1,1,646,    0
			60681,1,1,647,    0
			60681,1,1,648,    0
			60681,1,1,649,    0
			60681,1,1,650,    0
			60681,1,1,651,    0
			60681,1,1,652,    0
			60681,1,1,653,    0
			60681,1,1,654,    0
			60681,1,1,655,    0
			60681,1,1,656,    0
			60681,1,1,657,    0
			60681,1,1,658,    0
			60681,1,1,659,    0
			60681,1,1,660,    0
			60681,1,1,661,    0
			60681,1,1,662,    0
			60681,1,1,663,    0
			60681,1,1,664,    0
			60681,1,1,665,    0
			60681,1,1,666,    0
			60681,1,1,667,    0
			60681,1,1,668,    0
			60681,1,1,669,    0
			60681,1,1,670,    0
			60681,1,1,671,    0
			60681,1,1,672,    0
			60681,1,1,673,    0
			60681,1,1,674,    0
			60681,1,1,675,    0
			60681,1,1,676,    0
			60681,1,1,677,    0
			60681,1,1,678,    0
			60681,1,1,679,    0
			60681,1,1,680,    0
			60681,1,1,681,    0
			60681,1,1,682,    0
			60681,1,1,683,    0
			60681,1,1,684,    0
			60681,1,1,685,    0
			60681,1,1,686,    0
			60681,1,1,687,    0
			60681,1,1,688,    0
			60681,1,1,689,    0
			60681,1,1,690,    0
			60681,1,1,691,    0
			60681,1,1,692,    0
			60681,1,1,693,    0
			60681,1,1,694,    0
			60681,1,1,695,    0
			60681,1,1,696,    0
			60681,1,1,697,    0
			60681,1,1,698,    0
			60681,1,1,699,    0
			60681,1,1,700,    0
			60681,1,1,701,    0
			60681,1,1,702,    0
			60681,1,1,703,    0
			60681,1,1,704,    0
			60681,1,1,705,    0
			60681,1,1,706,    0
			60681,1,1,707,    0
			60681,1,1,708,    0
			60681,1,1,709,    0
			60681,1,1,710,    0
			60681,1,1,711,    0
			60681,1,1,712,    0
			60681,1,1,713,    0
			60681,1,1,714,    0
			60681,1,1,715,    0
			60681,1,1,716,    0
			60681,1,1,717,    0
			60681,1,1,718,    0
			60681,1,1,719,    0
			60681,1,1,720,    0
			60681,1,1,721,    0
			60681,1,1,722,    0
			60681,1,1,723,    0
			60681,1,1,724,    0
			60681,1,1,725,    0
			60681,1,1,726,    0
			60681,1,1,727,    0
			60681,1,1,728,    0
			60681,1,1,729,    0
			60681,1,1,730,    0
			60681,1,1,731,    0
			60681,1,1,732,    0
			60681,1,1,733,    0
			60681,1,1,734,    0
			60681,1,1,735,    0
			60681,1,1,736,    0
			60681,1,1,737,    0
			60681,1,1,738,    0
			60681,1,1,739,    0
			60681,1,1,740,    0
			60681,1,1,741,    0
			60681,1,1,742,    0
			60681,1,1,743,    0
			60681,1,1,744,    0
			60681,1,1,745,    0
			60681,1,1,746,    0
			60681,1,1,747,    0
			60681,1,1,748,    0
			60681,1,1,749,    0
			60681,1,1,750,    0
			60673,1,1,1,
			24445,1,1,1,0
			24446,1,1,1,0
			24433,1,1,1,0
			24435,1,1,1,0
			24435,1,1,2,0
			24435,1,1,3,0
			24435,1,1,4,0
			24435,1,1,5,0
			24460,1,1,1,
			24460,1,1,2,
			24460,1,1,3,
			24460,1,1,4,
			24460,1,1,5,
			24460,1,1,6,
			26250,1,1,1,0
			26250,2,1,1,0
			26250,3,1,1,0
			26250,4,1,1,0
			26250,5,1,1,0
			26250,6,1,1,0
			26250,1,2,1,0
			26250,2,2,1,0
			26250,3,2,1,0
			26250,4,2,1,0
			26250,5,2,1,0
			26250,6,2,1,0
			26246,1,1,1, 0.100
			26246,2,1,1, 0.100
			26246,3,1,1, 0.100
			26246,4,1,1, 0.100
			26246,5,1,1, 0.100
			26246,6,1,1, 0.100
			26246,1,2,1, 0.100
			26246,2,2,1, 0.100
			26246,3,2,1, 0.100
			26246,4,2,1, 0.100
			26246,5,2,1, 0.100
			26246,6,2,1, 0.100
			26247,1,1,1, 20.00
			26247,2,1,1, 20.00
			26247,3,1,1, 20.00
			26247,4,1,1, 20.00
			26247,5,1,1, 20.00
			26247,6,1,1, 20.00
			26247,1,2,1, 20.00
			26247,2,2,1, 20.00
			26247,3,2,1, 20.00
			26247,4,2,1, 20.00
			26247,5,2,1, 20.00
			26247,6,2,1, 20.00
			26244,1,1,1, 0.100
			26244,2,1,1, 0.100
			26244,3,1,1, 0.100
			26244,4,1,1, 0.100
			26244,5,1,1, 0.100
			26244,6,1,1, 0.100
			26244,1,2,1, 0.100
			26244,2,2,1, 0.100
			26244,3,2,1, 0.100
			26244,4,2,1, 0.100
			26244,5,2,1, 0.100
			26244,6,2,1, 0.100
			26245,1,1,1,  0.50
			26245,2,1,1,  0.50
			26245,3,1,1,  0.50
			26245,4,1,1,  0.50
			26245,5,1,1,  0.50
			26245,6,1,1,  0.50
			26245,1,2,1,  0.50
			26245,2,2,1,  0.50
			26245,3,2,1,  0.50
			26245,4,2,1,  0.50
			26245,5,2,1,  0.50
			26245,6,2,1,  0.50
			26241,1,1,1,0
			26241,2,1,1,0
			26241,3,1,1,0
			26241,4,1,1,0
			26241,5,1,1,0
			26241,6,1,1,0
			26241,1,2,1,0
			26241,2,2,1,0
			26241,3,2,1,0
			26241,4,2,1,0
			26241,5,2,1,0
			26241,6,2,1,0
			26242,1,1,1,  0
			26242,2,1,1,  0
			26242,3,1,1,  0
			26242,4,1,1,  0
			26242,5,1,1,  0
			26242,6,1,1,  0
			26242,1,2,1,  0
			26242,2,2,1,  0
			26242,3,2,1,  0
			26242,4,2,1,  0
			26242,5,2,1,  0
			26242,6,2,1,  0
			26240,1,1,1,0
			26240,2,1,1,0
			26240,3,1,1,0
			26240,4,1,1,0
			26240,5,1,1,0
			26240,6,1,1,0
			26240,1,2,1,0
			26240,2,2,1,0
			26240,3,2,1,0
			26240,4,2,1,0
			26240,5,2,1,0
			26240,6,2,1,0
			26251,1,1,1,0
			26251,2,1,1,0
			26251,3,1,1,0
			26251,4,1,1,0
			26251,5,1,1,0
			26251,6,1,1,0
			26251,1,2,1,0
			26251,2,2,1,0
			26251,3,2,1,0
			26251,4,2,1,0
			26251,5,2,1,0
			26251,6,2,1,0
			26243,1,1,1,0.00
			26243,2,1,1,0.00
			26243,3,1,1,0.00
			26243,4,1,1,0.00
			26243,5,1,1,0.00
			26243,6,1,1,0.00
			26243,1,2,1,0.00
			26243,2,2,1,0.00
			26243,3,2,1,0.00
			26243,4,2,1,0.00
			26243,5,2,1,0.00
			26243,6,2,1,0.00
			26248,1,1,1,0
			26248,2,1,1,0
			26248,3,1,1,0
			26248,4,1,1,0
			26248,5,1,1,0
			26248,6,1,1,0
			26248,1,2,1,0
			26248,2,2,1,0
			26248,3,2,1,0
			26248,4,2,1,0
			26248,5,2,1,0
			26248,6,2,1,0
			41602,1,1,1, 5.0
			41602,1,2,1, 5.0
			41618,1,1,1,0
			41618,1,2,1,0
			41603,1,1,1,0
			41603,1,2,1,0
			41605,1,1,1,0
			41605,1,2,1,0
			41601,1,1,1,7
			41601,1,2,1,7
			41617,1,1,1,0
			41617,1,2,1,0
			41600,1,1,1,0
			41600,1,2,1,0
			41619,1,1,1,0
			41619,1,2,1,0
			41614,1,1,1,0
			41614,1,2,1,0
			41615,1,1,1,0
			41615,1,2,1,0
			41612,1,1,1,0
			41612,1,2,1,0
			41610,1,1,1,0
			41610,1,2,1,0
			41608,1,1,1,0
			41608,1,2,1,0
			41606,1,1,1,0
			41606,1,2,1,0
			9544,1,1,1,0
			9544,1,2,1,0
			9544,1,3,1,0
			9544,1,4,1,0
			9544,1,5,1,0
			9545,1,1,1,4
			9545,1,2,1,4
			9545,1,3,1,4
			9545,1,4,1,4
			9545,1,5,1,4
			2323,1,1,1,0
			2323,1,2,1,0
			2323,1,3,1,0
			2323,1,4,1,0
			2323,1,5,1,0
			2323,1,6,1,0
			2323,1,7,1,0
			2323,1,8,1,0
			2323,1,9,1,0
			2323,1,10,1,0
			2323,1,11,1,0
			2323,1,12,1,0
			2323,1,13,1,0
			2323,1,14,1,0
			2323,1,15,1,0
			2323,1,16,1,0
			2323,1,17,1,0
			2323,1,18,1,0
			2323,1,19,1,0
			2323,1,20,1,0
			2323,1,21,1,0
			2323,1,22,1,0
			2323,1,23,1,0
			2323,1,24,1,0
			2323,1,25,1,0
			2323,1,26,1,0
			2323,1,27,1,0
			2323,1,28,1,0
			2323,1,29,1,0
			2323,1,30,1,0
			2323,1,31,1,0
			2323,1,32,1,0
			2323,1,33,1,0
			2323,1,34,1,0
			2323,1,35,1,0
			2323,1,36,1,0
			2323,1,37,1,0
			2323,1,38,1,0
			2323,1,39,1,0
			2323,1,40,1,0
			2323,1,41,1,0
			2323,1,42,1,0
			2323,1,43,1,0
			2323,1,44,1,0
			2323,1,45,1,0
			2323,1,46,1,0
			2323,1,47,1,0
			2323,1,48,1,0
			2323,1,49,1,0
			2323,1,50,1,0
			2323,1,51,1,0
			2323,1,52,1,0
			2323,1,53,1,0
			2323,1,54,1,0
			2323,1,55,1,0
			2323,1,56,1,0
			2323,1,57,1,0
			2323,1,58,1,0
			2323,1,59,1,0
			2323,1,60,1,0
			2323,1,61,1,0
			2323,1,62,1,0
			2323,1,63,1,0
			2323,1,64,1,0
			2323,1,65,1,0
			2323,1,66,1,0
			2323,1,67,1,0
			2323,1,68,1,0
			2323,1,69,1,0
			2323,1,70,1,0
			2323,1,71,1,0
			2323,1,72,1,0
			2323,1,73,1,0
			2323,1,74,1,0
			2323,1,75,1,0
			2323,1,76,1,0
			2323,1,77,1,0
			2323,1,78,1,0
			2323,1,79,1,0
			2323,1,80,1,0
			2323,1,81,1,0
			2323,1,82,1,0
			2323,1,83,1,0
			2323,1,84,1,0
			2323,1,85,1,0
			2323,1,86,1,0
			2323,1,87,1,0
			2323,1,88,1,0
			2323,1,89,1,0
			2323,1,90,1,0
			2323,1,91,1,0
			2323,1,92,1,0
			2323,1,93,1,0
			2323,1,94,1,0
			2323,1,95,1,0
			2323,1,96,1,0
			2323,1,97,1,0
			2323,1,98,1,0
			2323,1,99,1,0
			2323,1,100,1,0
			2323,1,101,1,0
			2323,1,102,1,0
			2323,1,103,1,0
			2323,1,104,1,0
			2323,1,105,1,0
			2323,1,106,1,0
			2323,1,107,1,0
			2323,1,108,1,0
			2323,1,109,1,0
			2323,1,110,1,0
			2323,1,111,1,0
			2323,1,112,1,0
			2323,1,113,1,0
			2323,1,114,1,0
			2323,1,115,1,0
			2323,1,116,1,0
			2323,1,117,1,0
			2323,1,118,1,0
			2323,1,119,1,0
			2323,1,120,1,0
			2323,1,121,1,0
			2323,1,122,1,0
			2323,1,123,1,0
			2323,1,124,1,0
			2323,1,125,1,0
			2323,1,126,1,0
			2323,1,127,1,0
			2323,1,128,1,0
			2322,1,1,1,0
			2322,1,2,1,0
			2322,1,3,1,0
			2322,1,4,1,0
			2322,1,5,1,0
			2322,1,6,1,0
			2322,1,7,1,0
			2322,1,8,1,0
			2322,1,9,1,0
			2322,1,10,1,0
			2322,1,11,1,0
			2322,1,12,1,0
			2322,1,13,1,0
			2322,1,14,1,0
			2322,1,15,1,0
			2322,1,16,1,0
			2322,1,17,1,0
			2322,1,18,1,0
			2322,1,19,1,0
			2322,1,20,1,0
			2322,1,21,1,0
			2322,1,22,1,0
			2322,1,23,1,0
			2322,1,24,1,0
			2322,1,25,1,0
			2322,1,26,1,0
			2322,1,27,1,0
			2322,1,28,1,0
			2322,1,29,1,0
			2322,1,30,1,0
			2322,1,31,1,0
			2322,1,32,1,0
			2322,1,33,1,0
			2322,1,34,1,0
			2322,1,35,1,0
			2322,1,36,1,0
			2322,1,37,1,0
			2322,1,38,1,0
			2322,1,39,1,0
			2322,1,40,1,0
			2322,1,41,1,0
			2322,1,42,1,0
			2322,1,43,1,0
			2322,1,44,1,0
			2322,1,45,1,0
			2322,1,46,1,0
			2322,1,47,1,0
			2322,1,48,1,0
			2322,1,49,1,0
			2322,1,50,1,0
			2322,1,51,1,0
			2322,1,52,1,0
			2322,1,53,1,0
			2322,1,54,1,0
			2322,1,55,1,0
			2322,1,56,1,0
			2322,1,57,1,0
			2322,1,58,1,0
			2322,1,59,1,0
			2322,1,60,1,0
			2322,1,61,1,0
			2322,1,62,1,0
			2322,1,63,1,0
			2322,1,64,1,0
			2322,1,65,1,0
			2322,1,66,1,0
			2322,1,67,1,0
			2322,1,68,1,0
			2322,1,69,1,0
			2322,1,70,1,0
			2322,1,71,1,0
			2322,1,72,1,0
			2322,1,73,1,0
			2322,1,74,1,0
			2322,1,75,1,0
			2322,1,76,1,0
			2322,1,77,1,0
			2322,1,78,1,0
			2322,1,79,1,0
			2322,1,80,1,0
			2322,1,81,1,0
			2322,1,82,1,0
			2322,1,83,1,0
			2322,1,84,1,0
			2322,1,85,1,0
			2322,1,86,1,0
			2322,1,87,1,0
			2322,1,88,1,0
			2322,1,89,1,0
			2322,1,90,1,0
			2322,1,91,1,0
			2322,1,92,1,0
			2322,1,93,1,0
			2322,1,94,1,0
			2322,1,95,1,0
			2322,1,96,1,0
			2322,1,97,1,0
			2322,1,98,1,0
			2322,1,99,1,0
			2322,1,100,1,0
			2322,1,101,1,0
			2322,1,102,1,0
			2322,1,103,1,0
			2322,1,104,1,0
			2322,1,105,1,0
			2322,1,106,1,0
			2322,1,107,1,0
			2322,1,108,1,0
			2322,1,109,1,0
			2322,1,110,1,0
			2322,1,111,1,0
			2322,1,112,1,0
			2322,1,113,1,0
			2322,1,114,1,0
			2322,1,115,1,0
			2322,1,116,1,0
			2322,1,117,1,0
			2322,1,118,1,0
			2322,1,119,1,0
			2322,1,120,1,0
			2322,1,121,1,0
			2322,1,122,1,0
			2322,1,123,1,0
			2322,1,124,1,0
			2322,1,125,1,0
			2322,1,126,1,0
			2322,1,127,1,0
			2322,1,128,1,0
			51024,1,1,1,0
			14168,1,1,1,    0
			14168,1,2,1,    0
			14168,1,3,1,    0
			14167,1,1,1,    0
			14167,1,2,1,    0
			14167,1,3,1,    0
			14166,1,1,1,0
			14166,1,2,1,0
			14166,1,3,1,0
			14162,1,1,1,4
			14163,1,1,1,   0
			14160,1,1,1,0
			14161,1,1,1,  0
			288,1,1,1,0
			16470,1,1,1,1.0
			16468,1,1,1,   30
			16467,1,1,1,0
			16463,1,1,1,0
			16464,1,1,1, 1.0
			16465,1,1,1,300
			16466,1,1,1,0
			16469,1,1,1,0.020
			17921,1,1,1,0
			17920,1,1,1,60
			17923,1,1,1,1
			17922,1,1,1,0
			59954,1,1,1,0
			59954,1,2,1,0
			59954,1,3,1,0
			59954,1,4,1,0
			59954,1,5,1,0
			59954,1,6,1,0
			28680,1,1,1,0
			28680,2,1,1,0
			28680,3,1,1,0
			28680,4,1,1,0
			28680,5,1,1,0
			28680,6,1,1,0
			28680,1,2,1,0
			28680,2,2,1,0
			28680,3,2,1,0
			28680,4,2,1,0
			28680,5,2,1,0
			28680,6,2,1,0
			28673,1,1,1,0
			28673,2,1,1,0
			28673,3,1,1,0
			28673,4,1,1,0
			28673,5,1,1,0
			28673,6,1,1,0
			28673,1,2,1,0
			28673,2,2,1,0
			28673,3,2,1,0
			28673,4,2,1,0
			28673,5,2,1,0
			28673,6,2,1,0
			28674,1,1,1,1.000
			28674,2,1,1,1.000
			28674,3,1,1,1.000
			28674,4,1,1,1.000
			28674,5,1,1,1.000
			28674,6,1,1,1.000
			28674,1,2,1,1.000
			28674,2,2,1,1.000
			28674,3,2,1,1.000
			28674,4,2,1,1.000
			28674,5,2,1,1.000
			28674,6,2,1,1.000
			28682,1,1,1,0
			28682,2,1,1,0
			28682,3,1,1,0
			28682,4,1,1,0
			28682,5,1,1,0
			28682,6,1,1,0
			28682,1,2,1,0
			28682,2,2,1,0
			28682,3,2,1,0
			28682,4,2,1,0
			28682,5,2,1,0
			28682,6,2,1,0
			28677,1,1,1,0.100
			28677,2,1,1,0.100
			28677,3,1,1,0.100
			28677,4,1,1,0.100
			28677,5,1,1,0.100
			28677,6,1,1,0.100
			28677,1,2,1,0.100
			28677,2,2,1,0.100
			28677,3,2,1,0.100
			28677,4,2,1,0.100
			28677,5,2,1,0.100
			28677,6,2,1,0.100
			28672,1,1,1,0
			28672,2,1,1,0
			28672,3,1,1,0
			28672,4,1,1,0
			28672,5,1,1,0
			28672,6,1,1,0
			28672,1,2,1,0
			28672,2,2,1,0
			28672,3,2,1,0
			28672,4,2,1,0
			28672,5,2,1,0
			28672,6,2,1,0
			28681,1,1,1,0
			28681,2,1,1,0
			28681,3,1,1,0
			28681,4,1,1,0
			28681,5,1,1,0
			28681,6,1,1,0
			28681,1,2,1,0
			28681,2,2,1,0
			28681,3,2,1,0
			28681,4,2,1,0
			28681,5,2,1,0
			28681,6,2,1,0
			28676,1,1,1,  1.00
			28676,2,1,1,  1.00
			28676,3,1,1,  1.00
			28676,4,1,1,  1.00
			28676,5,1,1,  1.00
			28676,6,1,1,  1.00
			28676,1,2,1,  1.00
			28676,2,2,1,  1.00
			28676,3,2,1,  1.00
			28676,4,2,1,  1.00
			28676,5,2,1,  1.00
			28676,6,2,1,  1.00
			28675,1,1,1,0
			28675,2,1,1,0
			28675,3,1,1,0
			28675,4,1,1,0
			28675,5,1,1,0
			28675,6,1,1,0
			28675,1,2,1,0
			28675,2,2,1,0
			28675,3,2,1,0
			28675,4,2,1,0
			28675,5,2,1,0
			28675,6,2,1,0
			28678,1,1,1,0
			28678,2,1,1,0
			28678,3,1,1,0
			28678,4,1,1,0
			28678,5,1,1,0
			28678,6,1,1,0
			28678,1,2,1,0
			28678,2,2,1,0
			28678,3,2,1,0
			28678,4,2,1,0
			28678,5,2,1,0
			28678,6,2,1,0
			22791,1,1,1,0
			22791,2,1,1,0
			22791,3,1,1,0
			22791,4,1,1,0
			22791,5,1,1,0
			22791,6,1,1,0
			22791,1,2,1,0
			22791,2,2,1,0
			22791,3,2,1,0
			22791,4,2,1,0
			22791,5,2,1,0
			22791,6,2,1,0
			22799,1,1,1,0
			22799,2,1,1,0
			22799,3,1,1,0
			22799,4,1,1,0
			22799,5,1,1,0
			22799,6,1,1,0
			22799,1,2,1,0
			22799,2,2,1,0
			22799,3,2,1,0
			22799,4,2,1,0
			22799,5,2,1,0
			22799,6,2,1,0
			22785,1,1,1,0
			22785,2,1,1,0
			22785,3,1,1,0
			22785,4,1,1,0
			22785,5,1,1,0
			22785,6,1,1,0
			22785,1,2,1,0
			22785,2,2,1,0
			22785,3,2,1,0
			22785,4,2,1,0
			22785,5,2,1,0
			22785,6,2,1,0
			22790,1,1,1,0
			22790,2,1,1,0
			22790,3,1,1,0
			22790,4,1,1,0
			22790,5,1,1,0
			22790,6,1,1,0
			22790,1,2,1,0
			22790,2,2,1,0
			22790,3,2,1,0
			22790,4,2,1,0
			22790,5,2,1,0
			22790,6,2,1,0
			22787,1,1,1, 1.000
			22787,2,1,1, 1.000
			22787,3,1,1, 1.000
			22787,4,1,1, 1.000
			22787,5,1,1, 1.000
			22787,6,1,1, 1.000
			22787,1,2,1, 1.000
			22787,2,2,1, 1.000
			22787,3,2,1, 1.000
			22787,4,2,1, 1.000
			22787,5,2,1, 1.000
			22787,6,2,1, 1.000
			22789,1,1,1,  1.00
			22789,2,1,1,  1.00
			22789,3,1,1,  1.00
			22789,4,1,1,  1.00
			22789,5,1,1,  1.00
			22789,6,1,1,  1.00
			22789,1,2,1,  1.00
			22789,2,2,1,  1.00
			22789,3,2,1,  1.00
			22789,4,2,1,  1.00
			22789,5,2,1,  1.00
			22789,6,2,1,  1.00
			22786,1,1,1,0
			22786,2,1,1,0
			22786,3,1,1,0
			22786,4,1,1,0
			22786,5,1,1,0
			22786,6,1,1,0
			22786,1,2,1,0
			22786,2,2,1,0
			22786,3,2,1,0
			22786,4,2,1,0
			22786,5,2,1,0
			22786,6,2,1,0
			22784,1,1,1,0
			22784,2,1,1,0
			22784,3,1,1,0
			22784,4,1,1,0
			22784,5,1,1,0
			22784,6,1,1,0
			22784,1,2,1,0
			22784,2,2,1,0
			22784,3,2,1,0
			22784,4,2,1,0
			22784,5,2,1,0
			22784,6,2,1,0
			22800,1,1,1,0
			22800,2,1,1,0
			22800,3,1,1,0
			22800,4,1,1,0
			22800,5,1,1,0
			22800,6,1,1,0
			22800,1,2,1,0
			22800,2,2,1,0
			22800,3,2,1,0
			22800,4,2,1,0
			22800,5,2,1,0
			22800,6,2,1,0
			22788,1,1,1,0
			22788,2,1,1,0
			22788,3,1,1,0
			22788,4,1,1,0
			22788,5,1,1,0
			22788,6,1,1,0
			22788,1,2,1,0
			22788,2,2,1,0
			22788,3,2,1,0
			22788,4,2,1,0
			22788,5,2,1,0
			22788,6,2,1,0
			22792,1,1,1,0
			22792,2,1,1,0
			22792,3,1,1,0
			22792,4,1,1,0
			22792,5,1,1,0
			22792,6,1,1,0
			22792,1,1,2,0
			22792,2,1,2,0
			22792,3,1,2,0
			22792,4,1,2,0
			22792,5,1,2,0
			22792,6,1,2,0
			22792,1,1,3,0
			22792,2,1,3,0
			22792,3,1,3,0
			22792,4,1,3,0
			22792,5,1,3,0
			22792,6,1,3,0
			22792,1,2,1,0
			22792,2,2,1,0
			22792,3,2,1,0
			22792,4,2,1,0
			22792,5,2,1,0
			22792,6,2,1,0
			22792,1,2,2,0
			22792,2,2,2,0
			22792,3,2,2,0
			22792,4,2,2,0
			22792,5,2,2,0
			22792,6,2,2,0
			22792,1,2,3,0
			22792,2,2,3,0
			22792,3,2,3,0
			22792,4,2,3,0
			22792,5,2,3,0
			22792,6,2,3,0
			28743,1,1,1,0
			28743,2,1,1,0
			28743,3,1,1,0
			28743,4,1,1,0
			28743,5,1,1,0
			28743,6,1,1,0
			28743,1,2,1,0
			28743,2,2,1,0
			28743,3,2,1,0
			28743,4,2,1,0
			28743,5,2,1,0
			28743,6,2,1,0
			28743,1,3,1,0
			28743,2,3,1,0
			28743,3,3,1,0
			28743,4,3,1,0
			28743,5,3,1,0
			28743,6,3,1,0
			28737,1,1,1,0
			28737,2,1,1,0
			28737,3,1,1,0
			28737,4,1,1,0
			28737,5,1,1,0
			28737,6,1,1,0
			28737,1,2,1,0
			28737,2,2,1,0
			28737,3,2,1,0
			28737,4,2,1,0
			28737,5,2,1,0
			28737,6,2,1,0
			28737,1,3,1,0
			28737,2,3,1,0
			28737,3,3,1,0
			28737,4,3,1,0
			28737,5,3,1,0
			28737,6,3,1,0
			28740,1,1,1,  1.00
			28740,2,1,1,  1.00
			28740,3,1,1,  1.00
			28740,4,1,1,  1.00
			28740,5,1,1,  1.00
			28740,6,1,1,  1.00
			28740,1,2,1,  1.00
			28740,2,2,1,  1.00
			28740,3,2,1,  1.00
			28740,4,2,1,  1.00
			28740,5,2,1,  1.00
			28740,6,2,1,  1.00
			28740,1,3,1,  1.00
			28740,2,3,1,  1.00
			28740,3,3,1,  1.00
			28740,4,3,1,  1.00
			28740,5,3,1,  1.00
			28740,6,3,1,  1.00
			28738,1,1,1,1.000
			28738,2,1,1,1.000
			28738,3,1,1,1.000
			28738,4,1,1,1.000
			28738,5,1,1,1.000
			28738,6,1,1,1.000
			28738,1,2,1,1.000
			28738,2,2,1,1.000
			28738,3,2,1,1.000
			28738,4,2,1,1.000
			28738,5,2,1,1.000
			28738,6,2,1,1.000
			28738,1,3,1,1.000
			28738,2,3,1,1.000
			28738,3,3,1,1.000
			28738,4,3,1,1.000
			28738,5,3,1,1.000
			28738,6,3,1,1.000
			28736,1,1,1,0
			28736,2,1,1,0
			28736,3,1,1,0
			28736,4,1,1,0
			28736,5,1,1,0
			28736,6,1,1,0
			28736,1,2,1,0
			28736,2,2,1,0
			28736,3,2,1,0
			28736,4,2,1,0
			28736,5,2,1,0
			28736,6,2,1,0
			28736,1,3,1,0
			28736,2,3,1,0
			28736,3,3,1,0
			28736,4,3,1,0
			28736,5,3,1,0
			28736,6,3,1,0
			28744,1,1,1,0
			28744,2,1,1,0
			28744,3,1,1,0
			28744,4,1,1,0
			28744,5,1,1,0
			28744,6,1,1,0
			28744,1,2,1,0
			28744,2,2,1,0
			28744,3,2,1,0
			28744,4,2,1,0
			28744,5,2,1,0
			28744,6,2,1,0
			28744,1,3,1,0
			28744,2,3,1,0
			28744,3,3,1,0
			28744,4,3,1,0
			28744,5,3,1,0
			28744,6,3,1,0
			28739,1,1,1,  1.00
			28739,2,1,1,  1.00
			28739,3,1,1,  1.00
			28739,4,1,1,  1.00
			28739,5,1,1,  1.00
			28739,6,1,1,  1.00
			28739,1,2,1,  1.00
			28739,2,2,1,  1.00
			28739,3,2,1,  1.00
			28739,4,2,1,  1.00
			28739,5,2,1,  1.00
			28739,6,2,1,  1.00
			28739,1,3,1,  1.00
			28739,2,3,1,  1.00
			28739,3,3,1,  1.00
			28739,4,3,1,  1.00
			28739,5,3,1,  1.00
			28739,6,3,1,  1.00
			28741,1,1,1,0
			28741,2,1,1,0
			28741,3,1,1,0
			28741,4,1,1,0
			28741,5,1,1,0
			28741,6,1,1,0
			28741,1,2,1,0
			28741,2,2,1,0
			28741,3,2,1,0
			28741,4,2,1,0
			28741,5,2,1,0
			28741,6,2,1,0
			28741,1,3,1,0
			28741,2,3,1,0
			28741,3,3,1,0
			28741,4,3,1,0
			28741,5,3,1,0
			28741,6,3,1,0
			23051,1,1,1,0
			23051,2,1,1,0
			23051,3,1,1,0
			23051,4,1,1,0
			23051,5,1,1,0
			23051,6,1,1,0
			23051,1,2,1,0
			23051,2,2,1,0
			23051,3,2,1,0
			23051,4,2,1,0
			23051,5,2,1,0
			23051,6,2,1,0
			23051,1,3,1,0
			23051,2,3,1,0
			23051,3,3,1,0
			23051,4,3,1,0
			23051,5,3,1,0
			23051,6,3,1,0
			23051,1,4,1,0
			23051,2,4,1,0
			23051,3,4,1,0
			23051,4,4,1,0
			23051,5,4,1,0
			23051,6,4,1,0
			23041,1,1,1,0
			23041,2,1,1,0
			23041,3,1,1,0
			23041,4,1,1,0
			23041,5,1,1,0
			23041,6,1,1,0
			23041,1,2,1,0
			23041,2,2,1,0
			23041,3,2,1,0
			23041,4,2,1,0
			23041,5,2,1,0
			23041,6,2,1,0
			23041,1,3,1,0
			23041,2,3,1,0
			23041,3,3,1,0
			23041,4,3,1,0
			23041,5,3,1,0
			23041,6,3,1,0
			23041,1,4,1,0
			23041,2,4,1,0
			23041,3,4,1,0
			23041,4,4,1,0
			23041,5,4,1,0
			23041,6,4,1,0
			23044,1,1,1,  0.00
			23044,2,1,1,  0.00
			23044,3,1,1,  0.00
			23044,4,1,1,  0.00
			23044,5,1,1,  0.00
			23044,6,1,1,  0.00
			23044,1,2,1,  0.00
			23044,2,2,1,  0.00
			23044,3,2,1,  0.00
			23044,4,2,1,  0.00
			23044,5,2,1,  0.00
			23044,6,2,1,  0.00
			23044,1,3,1,  0.00
			23044,2,3,1,  0.00
			23044,3,3,1,  0.00
			23044,4,3,1,  0.00
			23044,5,3,1,  0.00
			23044,6,3,1,  0.00
			23044,1,4,1,  0.00
			23044,2,4,1,  0.00
			23044,3,4,1,  0.00
			23044,4,4,1,  0.00
			23044,5,4,1,  0.00
			23044,6,4,1,  0.00
			23042,1,1,1, 1.000
			23042,2,1,1, 1.000
			23042,3,1,1, 1.000
			23042,4,1,1, 1.000
			23042,5,1,1, 1.000
			23042,6,1,1, 1.000
			23042,1,2,1, 1.000
			23042,2,2,1, 1.000
			23042,3,2,1, 1.000
			23042,4,2,1, 1.000
			23042,5,2,1, 1.000
			23042,6,2,1, 1.000
			23042,1,3,1, 1.000
			23042,2,3,1, 1.000
			23042,3,3,1, 1.000
			23042,4,3,1, 1.000
			23042,5,3,1, 1.000
			23042,6,3,1, 1.000
			23042,1,4,1, 1.000
			23042,2,4,1, 1.000
			23042,3,4,1, 1.000
			23042,4,4,1, 1.000
			23042,5,4,1, 1.000
			23042,6,4,1, 1.000
			23040,1,1,1,0
			23040,2,1,1,0
			23040,3,1,1,0
			23040,4,1,1,0
			23040,5,1,1,0
			23040,6,1,1,0
			23040,1,2,1,0
			23040,2,2,1,0
			23040,3,2,1,0
			23040,4,2,1,0
			23040,5,2,1,0
			23040,6,2,1,0
			23040,1,3,1,0
			23040,2,3,1,0
			23040,3,3,1,0
			23040,4,3,1,0
			23040,5,3,1,0
			23040,6,3,1,0
			23040,1,4,1,0
			23040,2,4,1,0
			23040,3,4,1,0
			23040,4,4,1,0
			23040,5,4,1,0
			23040,6,4,1,0
			23052,1,1,1,0
			23052,2,1,1,0
			23052,3,1,1,0
			23052,4,1,1,0
			23052,5,1,1,0
			23052,6,1,1,0
			23052,1,2,1,0
			23052,2,2,1,0
			23052,3,2,1,0
			23052,4,2,1,0
			23052,5,2,1,0
			23052,6,2,1,0
			23052,1,3,1,0
			23052,2,3,1,0
			23052,3,3,1,0
			23052,4,3,1,0
			23052,5,3,1,0
			23052,6,3,1,0
			23052,1,4,1,0
			23052,2,4,1,0
			23052,3,4,1,0
			23052,4,4,1,0
			23052,5,4,1,0
			23052,6,4,1,0
			23043,1,1,1,  0.00
			23043,2,1,1,  0.00
			23043,3,1,1,  0.00
			23043,4,1,1,  0.00
			23043,5,1,1,  0.00
			23043,6,1,1,  0.00
			23043,1,2,1,  0.00
			23043,2,2,1,  0.00
			23043,3,2,1,  0.00
			23043,4,2,1,  0.00
			23043,5,2,1,  0.00
			23043,6,2,1,  0.00
			23043,1,3,1,  0.00
			23043,2,3,1,  0.00
			23043,3,3,1,  0.00
			23043,4,3,1,  0.00
			23043,5,3,1,  0.00
			23043,6,3,1,  0.00
			23043,1,4,1,  0.00
			23043,2,4,1,  0.00
			23043,3,4,1,  0.00
			23043,4,4,1,  0.00
			23043,5,4,1,  0.00
			23043,6,4,1,  0.00
			23045,1,1,1,0
			23045,2,1,1,0
			23045,3,1,1,0
			23045,4,1,1,0
			23045,5,1,1,0
			23045,6,1,1,0
			23045,1,1,2,0
			23045,2,1,2,0
			23045,3,1,2,0
			23045,4,1,2,0
			23045,5,1,2,0
			23045,6,1,2,0
			23045,1,1,3,0
			23045,2,1,3,0
			23045,3,1,3,0
			23045,4,1,3,0
			23045,5,1,3,0
			23045,6,1,3,0
			23045,1,2,1,0
			23045,2,2,1,0
			23045,3,2,1,0
			23045,4,2,1,0
			23045,5,2,1,0
			23045,6,2,1,0
			23045,1,2,2,0
			23045,2,2,2,0
			23045,3,2,2,0
			23045,4,2,2,0
			23045,5,2,2,0
			23045,6,2,2,0
			23045,1,2,3,0
			23045,2,2,3,0
			23045,3,2,3,0
			23045,4,2,3,0
			23045,5,2,3,0
			23045,6,2,3,0
			23045,1,3,1,0
			23045,2,3,1,0
			23045,3,3,1,0
			23045,4,3,1,0
			23045,5,3,1,0
			23045,6,3,1,0
			23045,1,3,2,0
			23045,2,3,2,0
			23045,3,3,2,0
			23045,4,3,2,0
			23045,5,3,2,0
			23045,6,3,2,0
			23045,1,3,3,0
			23045,2,3,3,0
			23045,3,3,3,0
			23045,4,3,3,0
			23045,5,3,3,0
			23045,6,3,3,0
			23045,1,4,1,0
			23045,2,4,1,0
			23045,3,4,1,0
			23045,4,4,1,0
			23045,5,4,1,0
			23045,6,4,1,0
			23045,1,4,2,0
			23045,2,4,2,0
			23045,3,4,2,0
			23045,4,4,2,0
			23045,5,4,2,0
			23045,6,4,2,0
			23045,1,4,3,0
			23045,2,4,3,0
			23045,3,4,3,0
			23045,4,4,3,0
			23045,5,4,3,0
			23045,6,4,3,0
			16427,1,1,1, 30
			16433,1,1,1,1
			16429,1,1,1, 5
			16430,1,1,1,0
			16431,1,1,1,1
			16428,1,1,1,3
			16426,1,1,1,  5
			16435,1,1,1, 30
			16835,1,1,1,0
			16834,1,1,1, 50
			16833,1,1,1,0
			16832,1,1,1,15
			16896,1,1,1,0
			16896,1,1,2,0
			16896,1,1,3,0
			16896,1,1,4,0
			16896,1,1,5,0
			16896,1,1,6,0
			16896,1,1,7,0
			16896,1,1,8,0
			16896,1,1,9,0
			16896,1,1,10,0
			16896,1,1,11,0
			16896,1,1,12,0
			16896,1,1,13,0
			16896,1,1,14,0
			16896,1,1,15,0
			16896,1,1,16,0
			16896,1,1,17,0
			16896,1,1,18,0
			16896,1,1,19,0
			16896,1,1,20,0
			16896,1,1,21,0
			16896,1,1,22,0
			16896,1,1,23,0
			16896,1,1,24,0
			16896,1,1,25,0
			16896,1,1,26,0
			16896,1,1,27,0
			16896,1,1,28,0
			16896,1,1,29,0
			16896,1,1,30,0
			16896,1,1,31,0
			16896,1,1,32,0
			16896,1,1,33,0
			16896,1,1,34,0
			16896,1,1,35,0
			16896,1,1,36,0
			16896,1,1,37,0
			16896,1,1,38,0
			16896,1,1,39,0
			16896,1,1,40,0
			16896,1,1,41,0
			16896,1,1,42,0
			16896,1,1,43,0
			16896,1,1,44,0
			16896,1,1,45,0
			16896,1,1,46,0
			16896,1,1,47,0
			16896,1,1,48,0
			16896,1,1,49,0
			16896,1,1,50,0
			16896,1,1,51,0
			16896,1,1,52,0
			16896,1,1,53,0
			16896,1,1,54,0
			16896,1,1,55,0
			16896,1,1,56,0
			16896,1,1,57,0
			16896,1,1,58,0
			16896,1,1,59,0
			16896,1,1,60,0
			16896,1,1,61,0
			16896,1,1,62,0
			16896,1,1,63,0
			16848,1,1,1,0
			16848,1,1,2,0
			16848,1,1,3,0
			16848,1,1,4,0
			16848,1,1,5,0
			16848,1,1,6,0
			16848,1,1,7,0
			16848,1,1,8,0
			16848,1,1,9,0
			16848,1,1,10,0
			16848,1,1,11,0
			16848,1,1,12,0
			16848,1,1,13,0
			16848,1,1,14,0
			16848,1,1,15,0
			16848,1,1,16,0
			16837,1,1,1,2
			24651,1,1,1,0
			24651,2,1,1,0
			24651,3,1,1,0
			24651,4,1,1,0
			24651,5,1,1,0
			24651,6,1,1,0
			24652,1,1,1,0
			24652,2,1,1,0
			24652,3,1,1,0
			24652,4,1,1,0
			24652,5,1,1,0
			24652,6,1,1,0
			24655,1,1,1,0
			24655,2,1,1,0
			24655,3,1,1,0
			24655,4,1,1,0
			24655,5,1,1,0
			24655,6,1,1,0
			24654,1,1,1, 0.100
			24654,2,1,1, 0.100
			24654,3,1,1, 0.100
			24654,4,1,1, 0.100
			24654,5,1,1, 0.100
			24654,6,1,1, 0.100
			24653,1,1,1, 0.060
			24653,2,1,1, 0.060
			24653,3,1,1, 0.060
			24653,4,1,1, 0.060
			24653,5,1,1, 0.060
			24653,6,1,1, 0.060
			24640,1,1,1,0
			24640,2,1,1,0
			24640,3,1,1,0
			24640,4,1,1,0
			24640,5,1,1,0
			24640,6,1,1,0
			24656,1,1,1,0
			24656,2,1,1,0
			24656,3,1,1,0
			24656,4,1,1,0
			24656,5,1,1,0
			24656,6,1,1,0
			24649,1,1,1,0
			24649,2,1,1,0
			24649,3,1,1,0
			24649,4,1,1,0
			24649,5,1,1,0
			24649,6,1,1,0
			24650,1,1,1, 0.20
			24650,2,1,1, 0.20
			24650,3,1,1, 0.20
			24650,4,1,1, 0.20
			24650,5,1,1, 0.20
			24650,6,1,1, 0.20
			24647,1,1,1,0
			24647,2,1,1,0
			24647,3,1,1,0
			24647,4,1,1,0
			24647,5,1,1,0
			24647,6,1,1,0
			24657,1,1,1,0
			24657,2,1,1,0
			24657,3,1,1,0
			24657,4,1,1,0
			24657,5,1,1,0
			24657,6,1,1,0
			24641,1,1,1,0
			24641,2,1,1,0
			24641,3,1,1,0
			24641,4,1,1,0
			24641,5,1,1,0
			24641,6,1,1,0
			24645,1,1,1,0
			24645,2,1,1,0
			24645,3,1,1,0
			24645,4,1,1,0
			24645,5,1,1,0
			24645,6,1,1,0
			24643,1,1,1,0
			24643,2,1,1,0
			24643,3,1,1,0
			24643,4,1,1,0
			24643,5,1,1,0
			24643,6,1,1,0
			42753,1,1,1,0
			42753,1,2,1,0
			42753,1,3,1,0
			42753,1,4,1,0
			42753,1,5,1,0
			42753,1,6,1,0
			42753,1,7,1,0
			42753,1,8,1,0
			42753,1,9,1,0
			42753,1,10,1,0
			42753,1,11,1,0
			42753,1,12,1,0
			42753,1,13,1,0
			42753,1,14,1,0
			42753,1,15,1,0
			42753,1,16,1,0
			42758,1,1,1,0
			42758,1,2,1,0
			42758,1,3,1,0
			42758,1,4,1,0
			42758,1,5,1,0
			42758,1,6,1,0
			42758,1,7,1,0
			42758,1,8,1,0
			42758,1,9,1,0
			42758,1,10,1,0
			42758,1,11,1,0
			42758,1,12,1,0
			42758,1,13,1,0
			42758,1,14,1,0
			42758,1,15,1,0
			42758,1,16,1,0
			42754,1,1,1,0
			42754,1,2,1,0
			42754,1,3,1,0
			42754,1,4,1,0
			42754,1,5,1,0
			42754,1,6,1,0
			42754,1,7,1,0
			42754,1,8,1,0
			42754,1,9,1,0
			42754,1,10,1,0
			42754,1,11,1,0
			42754,1,12,1,0
			42754,1,13,1,0
			42754,1,14,1,0
			42754,1,15,1,0
			42754,1,16,1,0
			42756,1,1,1,0
			42756,1,2,1,0
			42756,1,3,1,0
			42756,1,4,1,0
			42756,1,5,1,0
			42756,1,6,1,0
			42756,1,7,1,0
			42756,1,8,1,0
			42756,1,9,1,0
			42756,1,10,1,0
			42756,1,11,1,0
			42756,1,12,1,0
			42756,1,13,1,0
			42756,1,14,1,0
			42756,1,15,1,0
			42756,1,16,1,0
			42752,1,1,1,0
			42752,1,2,1,0
			42752,1,3,1,0
			42752,1,4,1,0
			42752,1,5,1,0
			42752,1,6,1,0
			42752,1,7,1,0
			42752,1,8,1,0
			42752,1,9,1,0
			42752,1,10,1,0
			42752,1,11,1,0
			42752,1,12,1,0
			42752,1,13,1,0
			42752,1,14,1,0
			42752,1,15,1,0
			42752,1,16,1,0
			42759,1,1,1,0
			42759,1,2,1,0
			42759,1,3,1,0
			42759,1,4,1,0
			42759,1,5,1,0
			42759,1,6,1,0
			42759,1,7,1,0
			42759,1,8,1,0
			42759,1,9,1,0
			42759,1,10,1,0
			42759,1,11,1,0
			42759,1,12,1,0
			42759,1,13,1,0
			42759,1,14,1,0
			42759,1,15,1,0
			42759,1,16,1,0
			23305,1,1,1,0
			23305,2,1,1,0
			23305,3,1,1,0
			23305,4,1,1,0
			23305,5,1,1,0
			23305,6,1,1,0
			23305,1,2,1,0
			23305,2,2,1,0
			23305,3,2,1,0
			23305,4,2,1,0
			23305,5,2,1,0
			23305,6,2,1,0
			23297,1,1,1,0
			23297,2,1,1,0
			23297,3,1,1,0
			23297,4,1,1,0
			23297,5,1,1,0
			23297,6,1,1,0
			23297,1,2,1,0
			23297,2,2,1,0
			23297,3,2,1,0
			23297,4,2,1,0
			23297,5,2,1,0
			23297,6,2,1,0
			23302,1,1,1,0
			23302,2,1,1,0
			23302,3,1,1,0
			23302,4,1,1,0
			23302,5,1,1,0
			23302,6,1,1,0
			23302,1,2,1,0
			23302,2,2,1,0
			23302,3,2,1,0
			23302,4,2,1,0
			23302,5,2,1,0
			23302,6,2,1,0
			23299,1,1,1, 1.000
			23299,2,1,1, 1.000
			23299,3,1,1, 1.000
			23299,4,1,1, 1.000
			23299,5,1,1, 1.000
			23299,6,1,1, 1.000
			23299,1,2,1, 1.000
			23299,2,2,1, 1.000
			23299,3,2,1, 1.000
			23299,4,2,1, 1.000
			23299,5,2,1, 1.000
			23299,6,2,1, 1.000
			23301,1,1,1,  1.00
			23301,2,1,1,  1.00
			23301,3,1,1,  1.00
			23301,4,1,1,  1.00
			23301,5,1,1,  1.00
			23301,6,1,1,  1.00
			23301,1,2,1,  1.00
			23301,2,2,1,  1.00
			23301,3,2,1,  1.00
			23301,4,2,1,  1.00
			23301,5,2,1,  1.00
			23301,6,2,1,  1.00
			23298,1,1,1,0
			23298,2,1,1,0
			23298,3,1,1,0
			23298,4,1,1,0
			23298,5,1,1,0
			23298,6,1,1,0
			23298,1,2,1,0
			23298,2,2,1,0
			23298,3,2,1,0
			23298,4,2,1,0
			23298,5,2,1,0
			23298,6,2,1,0
			23296,1,1,1,0
			23296,2,1,1,0
			23296,3,1,1,0
			23296,4,1,1,0
			23296,5,1,1,0
			23296,6,1,1,0
			23296,1,2,1,0
			23296,2,2,1,0
			23296,3,2,1,0
			23296,4,2,1,0
			23296,5,2,1,0
			23296,6,2,1,0
			23306,1,1,1,0
			23306,2,1,1,0
			23306,3,1,1,0
			23306,4,1,1,0
			23306,5,1,1,0
			23306,6,1,1,0
			23306,1,2,1,0
			23306,2,2,1,0
			23306,3,2,1,0
			23306,4,2,1,0
			23306,5,2,1,0
			23306,6,2,1,0
			23300,1,1,1,0
			23300,2,1,1,0
			23300,3,1,1,0
			23300,4,1,1,0
			23300,5,1,1,0
			23300,6,1,1,0
			23300,1,2,1,0
			23300,2,2,1,0
			23300,3,2,1,0
			23300,4,2,1,0
			23300,5,2,1,0
			23300,6,2,1,0
			23303,1,1,1,0
			23303,2,1,1,0
			23303,3,1,1,0
			23303,4,1,1,0
			23303,5,1,1,0
			23303,6,1,1,0
			23303,1,2,1,0
			23303,2,2,1,0
			23303,3,2,1,0
			23303,4,2,1,0
			23303,5,2,1,0
			23303,6,2,1,0
			32519,1,1,1,0
			32519,2,1,1,0
			32519,3,1,1,0
			32519,4,1,1,0
			32519,5,1,1,0
			32519,6,1,1,0
			32519,1,2,1,0
			32519,2,2,1,0
			32519,3,2,1,0
			32519,4,2,1,0
			32519,5,2,1,0
			32519,6,2,1,0
			32513,1,1,1,0
			32513,2,1,1,0
			32513,3,1,1,0
			32513,4,1,1,0
			32513,5,1,1,0
			32513,6,1,1,0
			32513,1,2,1,0
			32513,2,2,1,0
			32513,3,2,1,0
			32513,4,2,1,0
			32513,5,2,1,0
			32513,6,2,1,0
			32516,1,1,1,  1.00
			32516,2,1,1,  1.00
			32516,3,1,1,  1.00
			32516,4,1,1,  1.00
			32516,5,1,1,  1.00
			32516,6,1,1,  1.00
			32516,1,2,1,  1.00
			32516,2,2,1,  1.00
			32516,3,2,1,  1.00
			32516,4,2,1,  1.00
			32516,5,2,1,  1.00
			32516,6,2,1,  1.00
			32515,1,1,1,  1.00
			32515,2,1,1,  1.00
			32515,3,1,1,  1.00
			32515,4,1,1,  1.00
			32515,5,1,1,  1.00
			32515,6,1,1,  1.00
			32515,1,2,1,  1.00
			32515,2,2,1,  1.00
			32515,3,2,1,  1.00
			32515,4,2,1,  1.00
			32515,5,2,1,  1.00
			32515,6,2,1,  1.00
			32514,1,1,1,0.300
			32514,2,1,1,0.300
			32514,3,1,1,0.300
			32514,4,1,1,0.300
			32514,5,1,1,0.300
			32514,6,1,1,0.300
			32514,1,2,1,0.300
			32514,2,2,1,0.300
			32514,3,2,1,0.300
			32514,4,2,1,0.300
			32514,5,2,1,0.300
			32514,6,2,1,0.300
			32512,1,1,1,0
			32512,2,1,1,0
			32512,3,1,1,0
			32512,4,1,1,0
			32512,5,1,1,0
			32512,6,1,1,0
			32512,1,2,1,0
			32512,2,2,1,0
			32512,3,2,1,0
			32512,4,2,1,0
			32512,5,2,1,0
			32512,6,2,1,0
			32520,1,1,1,0
			32520,2,1,1,0
			32520,3,1,1,0
			32520,4,1,1,0
			32520,5,1,1,0
			32520,6,1,1,0
			32520,1,2,1,0
			32520,2,2,1,0
			32520,3,2,1,0
			32520,4,2,1,0
			32520,5,2,1,0
			32520,6,2,1,0
			32521,1,1,1,0
			32521,2,1,1,0
			32521,3,1,1,0
			32521,4,1,1,0
			32521,5,1,1,0
			32521,6,1,1,0
			32521,1,2,1,0
			32521,2,2,1,0
			32521,3,2,1,0
			32521,4,2,1,0
			32521,5,2,1,0
			32521,6,2,1,0
			32517,1,1,1,0
			32517,2,1,1,0
			32517,3,1,1,0
			32517,4,1,1,0
			32517,5,1,1,0
			32517,6,1,1,0
			32517,1,2,1,0
			32517,2,2,1,0
			32517,3,2,1,0
			32517,4,2,1,0
			32517,5,2,1,0
			32517,6,2,1,0
			23559,1,1,1,0
			23559,2,1,1,0
			23559,3,1,1,0
			23559,4,1,1,0
			23559,5,1,1,0
			23559,6,1,1,0
			23559,1,2,1,0
			23559,2,2,1,0
			23559,3,2,1,0
			23559,4,2,1,0
			23559,5,2,1,0
			23559,6,2,1,0
			23559,1,3,1,0
			23559,2,3,1,0
			23559,3,3,1,0
			23559,4,3,1,0
			23559,5,3,1,0
			23559,6,3,1,0
			23559,1,4,1,0
			23559,2,4,1,0
			23559,3,4,1,0
			23559,4,4,1,0
			23559,5,4,1,0
			23559,6,4,1,0
			23553,1,1,1,0
			23553,2,1,1,0
			23553,3,1,1,0
			23553,4,1,1,0
			23553,5,1,1,0
			23553,6,1,1,0
			23553,1,2,1,0
			23553,2,2,1,0
			23553,3,2,1,0
			23553,4,2,1,0
			23553,5,2,1,0
			23553,6,2,1,0
			23553,1,3,1,0
			23553,2,3,1,0
			23553,3,3,1,0
			23553,4,3,1,0
			23553,5,3,1,0
			23553,6,3,1,0
			23553,1,4,1,0
			23553,2,4,1,0
			23553,3,4,1,0
			23553,4,4,1,0
			23553,5,4,1,0
			23553,6,4,1,0
			23556,1,1,1,  0.00
			23556,2,1,1,  0.00
			23556,3,1,1,  0.00
			23556,4,1,1,  0.00
			23556,5,1,1,  0.00
			23556,6,1,1,  0.00
			23556,1,2,1,  0.00
			23556,2,2,1,  0.00
			23556,3,2,1,  0.00
			23556,4,2,1,  0.00
			23556,5,2,1,  0.00
			23556,6,2,1,  0.00
			23556,1,3,1,  0.00
			23556,2,3,1,  0.00
			23556,3,3,1,  0.00
			23556,4,3,1,  0.00
			23556,5,3,1,  0.00
			23556,6,3,1,  0.00
			23556,1,4,1,  0.00
			23556,2,4,1,  0.00
			23556,3,4,1,  0.00
			23556,4,4,1,  0.00
			23556,5,4,1,  0.00
			23556,6,4,1,  0.00
			23554,1,1,1, 1.000
			23554,2,1,1, 1.000
			23554,3,1,1, 1.000
			23554,4,1,1, 1.000
			23554,5,1,1, 1.000
			23554,6,1,1, 1.000
			23554,1,2,1, 1.000
			23554,2,2,1, 1.000
			23554,3,2,1, 1.000
			23554,4,2,1, 1.000
			23554,5,2,1, 1.000
			23554,6,2,1, 1.000
			23554,1,3,1, 1.000
			23554,2,3,1, 1.000
			23554,3,3,1, 1.000
			23554,4,3,1, 1.000
			23554,5,3,1, 1.000
			23554,6,3,1, 1.000
			23554,1,4,1, 1.000
			23554,2,4,1, 1.000
			23554,3,4,1, 1.000
			23554,4,4,1, 1.000
			23554,5,4,1, 1.000
			23554,6,4,1, 1.000
			23552,1,1,1,0
			23552,2,1,1,0
			23552,3,1,1,0
			23552,4,1,1,0
			23552,5,1,1,0
			23552,6,1,1,0
			23552,1,2,1,0
			23552,2,2,1,0
			23552,3,2,1,0
			23552,4,2,1,0
			23552,5,2,1,0
			23552,6,2,1,0
			23552,1,3,1,0
			23552,2,3,1,0
			23552,3,3,1,0
			23552,4,3,1,0
			23552,5,3,1,0
			23552,6,3,1,0
			23552,1,4,1,0
			23552,2,4,1,0
			23552,3,4,1,0
			23552,4,4,1,0
			23552,5,4,1,0
			23552,6,4,1,0
			23560,1,1,1,0
			23560,2,1,1,0
			23560,3,1,1,0
			23560,4,1,1,0
			23560,5,1,1,0
			23560,6,1,1,0
			23560,1,2,1,0
			23560,2,2,1,0
			23560,3,2,1,0
			23560,4,2,1,0
			23560,5,2,1,0
			23560,6,2,1,0
			23560,1,3,1,0
			23560,2,3,1,0
			23560,3,3,1,0
			23560,4,3,1,0
			23560,5,3,1,0
			23560,6,3,1,0
			23560,1,4,1,0
			23560,2,4,1,0
			23560,3,4,1,0
			23560,4,4,1,0
			23560,5,4,1,0
			23560,6,4,1,0
			23555,1,1,1,  0.00
			23555,2,1,1,  0.00
			23555,3,1,1,  0.00
			23555,4,1,1,  0.00
			23555,5,1,1,  0.00
			23555,6,1,1,  0.00
			23555,1,2,1,  0.00
			23555,2,2,1,  0.00
			23555,3,2,1,  0.00
			23555,4,2,1,  0.00
			23555,5,2,1,  0.00
			23555,6,2,1,  0.00
			23555,1,3,1,  0.00
			23555,2,3,1,  0.00
			23555,3,3,1,  0.00
			23555,4,3,1,  0.00
			23555,5,3,1,  0.00
			23555,6,3,1,  0.00
			23555,1,4,1,  0.00
			23555,2,4,1,  0.00
			23555,3,4,1,  0.00
			23555,4,4,1,  0.00
			23555,5,4,1,  0.00
			23555,6,4,1,  0.00
			23557,1,1,1,0
			23557,2,1,1,0
			23557,3,1,1,0
			23557,4,1,1,0
			23557,5,1,1,0
			23557,6,1,1,0
			23557,1,2,1,0
			23557,2,2,1,0
			23557,3,2,1,0
			23557,4,2,1,0
			23557,5,2,1,0
			23557,6,2,1,0
			23557,1,3,1,0
			23557,2,3,1,0
			23557,3,3,1,0
			23557,4,3,1,0
			23557,5,3,1,0
			23557,6,3,1,0
			23557,1,4,1,0
			23557,2,4,1,0
			23557,3,4,1,0
			23557,4,4,1,0
			23557,5,4,1,0
			23557,6,4,1,0
			18944,1,1,1,    0
			18944,1,1,2,    0
			18944,1,1,3,    0
			18944,1,1,4,    0
			18944,1,1,5,    0
			18944,1,1,6,    0
			18944,1,1,7,    0
			18944,1,1,8,    0
			18944,1,1,9,    0
			18944,1,1,10,    0
			18944,1,1,11,    0
			18944,1,1,12,    0
			18944,1,1,13,    0
			18944,1,1,14,    0
			18944,1,1,15,    0
			18944,1,1,16,    0
			18944,1,1,17,    0
			18944,1,1,18,    0
			18944,1,1,19,    0
			18944,1,1,20,    0
			18944,1,1,21,    0
			18944,1,1,22,    0
			18944,1,1,23,    0
			18944,1,1,24,    0
			18944,1,1,25,    0
			18944,1,1,26,    0
			18944,1,1,27,    0
			18944,1,1,28,    0
			18944,1,1,29,    0
			18944,1,1,30,    0
			18944,1,1,31,    0
			18944,1,1,32,    0
			18944,1,1,33,    0
			18944,1,1,34,    0
			18944,1,1,35,    0
			18944,1,1,36,    0
			18944,1,1,37,    0
			18944,1,1,38,    0
			18944,1,1,39,    0
			18944,1,1,40,    0
			18944,1,1,41,    0
			18944,1,1,42,    0
			18944,1,1,43,    0
			18944,1,1,44,    0
			18944,1,1,45,    0
			18944,1,1,46,    0
			18944,1,1,47,    0
			18944,1,1,48,    0
			18944,1,1,49,    0
			18944,1,1,50,    0
			18944,1,1,51,    0
			18944,1,1,52,    0
			18944,1,1,53,    0
			18944,1,1,54,    0
			18944,1,1,55,    0
			18944,1,1,56,    0
			18944,1,1,57,    0
			18944,1,1,58,    0
			18944,1,1,59,    0
			18944,1,1,60,    0
			18944,1,1,61,    0
			18944,1,1,62,    0
			18944,1,1,63,    0
			18944,1,1,64,    0
			18944,1,1,65,    0
			18944,1,1,66,    0
			18944,1,1,67,    0
			18944,1,1,68,    0
			18944,1,1,69,    0
			18944,1,1,70,    0
			18944,1,1,71,    0
			18944,1,1,72,    0
			18944,1,1,73,    0
			18944,1,1,74,    0
			18944,1,1,75,    0
			18944,1,1,76,    0
			18944,1,1,77,    0
			18944,1,1,78,    0
			18944,1,1,79,    0
			18944,1,1,80,    0
			18944,1,1,81,    0
			18944,1,1,82,    0
			18944,1,1,83,    0
			18944,1,1,84,    0
			18944,1,1,85,    0
			18944,1,1,86,    0
			18944,1,1,87,    0
			18944,1,1,88,    0
			18944,1,1,89,    0
			18944,1,1,90,    0
			18944,1,1,91,    0
			18944,1,1,92,    0
			18944,1,1,93,    0
			18944,1,1,94,    0
			18944,1,1,95,    0
			18944,1,1,96,    0
			18944,1,1,97,    0
			18944,1,1,98,    0
			18944,1,1,99,    0
			18944,1,1,100,    0
			18944,1,1,101,    0
			18944,1,1,102,    0
			18944,1,1,103,    0
			18944,1,1,104,    0
			18944,1,1,105,    0
			18944,1,1,106,    0
			18944,1,1,107,    0
			18944,1,1,108,    0
			18944,1,1,109,    0
			18944,1,1,110,    0
			18944,1,1,111,    0
			18944,1,1,112,    0
			18944,1,1,113,    0
			18944,1,1,114,    0
			18944,1,1,115,    0
			18944,1,1,116,    0
			18944,1,1,117,    0
			18944,1,1,118,    0
			18944,1,1,119,    0
			18944,1,1,120,    0
			18944,1,1,121,    0
			18944,1,1,122,    0
			18944,1,1,123,    0
			18944,1,1,124,    0
			18944,1,1,125,    0
			18944,1,1,126,    0
			18944,1,1,127,    0
			18944,1,1,128,    0
			18944,1,1,129,    0
			18944,1,1,130,    0
			18944,1,1,131,    0
			18944,1,1,132,    0
			18944,1,1,133,    0
			18944,1,1,134,    0
			18944,1,1,135,    0
			18944,1,1,136,    0
			18944,1,1,137,    0
			18944,1,1,138,    0
			18944,1,1,139,    0
			18944,1,1,140,    0
			18944,1,1,141,    0
			18944,1,1,142,    0
			18944,1,1,143,    0
			18944,1,1,144,    0
			18944,1,1,145,    0
			18944,1,1,146,    0
			18944,1,1,147,    0
			18944,1,1,148,    0
			18944,1,1,149,    0
			18944,1,1,150,    0
			18944,1,1,151,    0
			18944,1,1,152,    0
			18944,1,1,153,    0
			18944,1,1,154,    0
			18944,1,1,155,    0
			18944,1,1,156,    0
			18944,1,1,157,    0
			18944,1,1,158,    0
			18944,1,1,159,    0
			18944,1,1,160,    0
			18944,1,1,161,    0
			18944,1,1,162,    0
			18944,1,1,163,    0
			18944,1,1,164,    0
			18944,1,1,165,    0
			18944,1,1,166,    0
			18944,1,1,167,    0
			18944,1,1,168,    0
			18944,1,1,169,    0
			18944,1,1,170,    0
			18944,1,1,171,    0
			18944,1,1,172,    0
			18944,1,1,173,    0
			18944,1,1,174,    0
			18944,1,1,175,    0
			18944,1,1,176,    0
			18944,1,1,177,    0
			18944,1,1,178,    0
			18944,1,1,179,    0
			18944,1,1,180,    0
			18944,1,1,181,    0
			18944,1,1,182,    0
			18944,1,1,183,    0
			18944,1,1,184,    0
			18944,1,1,185,    0
			18944,1,1,186,    0
			18944,1,1,187,    0
			18944,1,1,188,    0
			18944,1,1,189,    0
			18944,1,1,190,    0
			18944,1,1,191,    0
			18944,1,1,192,    0
			18944,1,1,193,    0
			18944,1,1,194,    0
			18944,1,1,195,    0
			18944,1,1,196,    0
			18944,1,1,197,    0
			18944,1,1,198,    0
			18944,1,1,199,    0
			18944,1,1,200,    0
			18944,1,1,201,    0
			18944,1,1,202,    0
			18944,1,1,203,    0
			18944,1,1,204,    0
			18944,1,1,205,    0
			18944,1,1,206,    0
			18944,1,1,207,    0
			18944,1,1,208,    0
			18944,1,1,209,    0
			18944,1,1,210,    0
			18944,1,1,211,    0
			18944,1,1,212,    0
			18944,1,1,213,    0
			18944,1,1,214,    0
			18944,1,1,215,    0
			18944,1,1,216,    0
			18944,1,1,217,    0
			18944,1,1,218,    0
			18944,1,1,219,    0
			18944,1,1,220,    0
			18944,1,1,221,    0
			18944,1,1,222,    0
			18944,1,1,223,    0
			18944,1,1,224,    0
			18944,1,1,225,    0
			18944,1,1,226,    0
			18944,1,1,227,    0
			18944,1,1,228,    0
			18944,1,1,229,    0
			18944,1,1,230,    0
			18944,1,1,231,    0
			18944,1,1,232,    0
			18944,1,1,233,    0
			18944,1,1,234,    0
			18944,1,1,235,    0
			18944,1,1,236,    0
			18944,1,1,237,    0
			18944,1,1,238,    0
			18944,1,1,239,    0
			18944,1,1,240,    0
			18944,1,1,241,    0
			18944,1,1,242,    0
			18944,1,1,243,    0
			18944,1,1,244,    0
			18944,1,1,245,    0
			18944,1,1,246,    0
			18944,1,1,247,    0
			18944,1,1,248,    0
			18944,1,1,249,    0
			18944,1,1,250,    0
			18944,1,1,251,    0
			18944,1,1,252,    0
			18944,1,1,253,    0
			18944,1,1,254,    0
			18944,1,1,255,    0
			18944,1,1,256,    0
			16456,1,1,1,0
			16457,1,1,1,0
			17266,1,1,1,56554706
			17266,1,2,1,56554706
			17266,1,3,1,56554706
			17266,1,4,1,56554706
			17266,1,5,1,56554706
			17266,1,6,1,56554706
			17268,1,1,1,56554706
			17268,1,2,1,56554706
			17268,1,3,1,56554706
			17268,1,4,1,56554706
			17268,1,5,1,56554706
			17268,1,6,1,56554706
			17264,1,1,1,56554706
			17264,1,2,1,56554706
			17264,1,3,1,56554706
			17264,1,4,1,56554706
			17264,1,5,1,56554706
			17264,1,6,1,56554706
			17376,1,1,1,0
			17377,1,1,1,Relay-1
			45938,1,1,1,1
			45938,1,2,1,1
			45938,1,3,1,1
			45938,1,4,1,1
			45938,1,5,1,1
			45938,1,6,1,1
			45938,1,7,1,1
			45938,1,8,1,1
			45940,1,1,1,1
			45940,1,2,1,1
			45940,1,3,1,1
			45940,1,4,1,1
			45940,1,5,1,1
			45940,1,6,1,1
			45940,1,7,1,1
			45940,1,8,1,1
			45936,1,1,1,0
			45936,1,2,1,0
			45936,1,3,1,0
			45936,1,4,1,0
			45936,1,5,1,0
			45936,1,6,1,0
			45936,1,7,1,0
			45936,1,8,1,0
			43776,1,1,1,0
			43776,1,2,1,0
			43776,1,3,1,0
			43776,1,4,1,0
			43776,1,5,1,0
			43776,1,6,1,0
			43780,1,1,1,0
			43780,1,2,1,0
			43780,1,3,1,0
			43780,1,4,1,0
			43780,1,5,1,0
			43780,1,6,1,0
			43782,1,1,1,0
			43782,1,2,1,0
			43782,1,3,1,0
			43782,1,4,1,0
			43782,1,5,1,0
			43782,1,6,1,0
			43778,1,1,1,0
			43778,1,2,1,0
			43778,1,3,1,0
			43778,1,4,1,0
			43778,1,5,1,0
			43778,1,6,1,0
			45164,1,1,1,  102
			45165,1,1,1,0
			43523,1,1,1,
			43523,1,2,1,
			43523,1,3,1,
			43523,1,4,1,
			43523,1,5,1,
			43523,1,6,1,
			43523,1,7,1,
			43523,1,8,1,
			43523,1,9,1,
			43523,1,10,1,
			43523,1,11,1,
			43523,1,12,1,
			43523,1,13,1,
			43523,1,14,1,
			43523,1,15,1,
			43523,1,16,1,
			43523,1,17,1,
			43523,1,18,1,
			43523,1,19,1,
			43523,1,20,1,
			43523,1,21,1,
			43523,1,22,1,
			43523,1,23,1,
			43523,1,24,1,
			43523,1,25,1,
			43523,1,26,1,
			43523,1,27,1,
			43523,1,28,1,
			43523,1,29,1,
			43523,1,30,1,
			43523,1,31,1,
			43523,1,32,1,
			43525,1,1,1,1.000
			43525,1,2,1,1.000
			43525,1,3,1,1.000
			43525,1,4,1,1.000
			43525,1,5,1,1.000
			43525,1,6,1,1.000
			43525,1,7,1,1.000
			43525,1,8,1,1.000
			43525,1,9,1,1.000
			43525,1,10,1,1.000
			43525,1,11,1,1.000
			43525,1,12,1,1.000
			43525,1,13,1,1.000
			43525,1,14,1,1.000
			43525,1,15,1,1.000
			43525,1,16,1,1.000
			43525,1,17,1,1.000
			43525,1,18,1,1.000
			43525,1,19,1,1.000
			43525,1,20,1,1.000
			43525,1,21,1,1.000
			43525,1,22,1,1.000
			43525,1,23,1,1.000
			43525,1,24,1,1.000
			43525,1,25,1,1.000
			43525,1,26,1,1.000
			43525,1,27,1,1.000
			43525,1,28,1,1.000
			43525,1,29,1,1.000
			43525,1,30,1,1.000
			43525,1,31,1,1.000
			43525,1,32,1,1.000
			43522,1,1,1,0
			43522,1,2,1,0
			43522,1,3,1,0
			43522,1,4,1,0
			43522,1,5,1,0
			43522,1,6,1,0
			43522,1,7,1,0
			43522,1,8,1,0
			43522,1,9,1,0
			43522,1,10,1,0
			43522,1,11,1,0
			43522,1,12,1,0
			43522,1,13,1,0
			43522,1,14,1,0
			43522,1,15,1,0
			43522,1,16,1,0
			43522,1,17,1,0
			43522,1,18,1,0
			43522,1,19,1,0
			43522,1,20,1,0
			43522,1,21,1,0
			43522,1,22,1,0
			43522,1,23,1,0
			43522,1,24,1,0
			43522,1,25,1,0
			43522,1,26,1,0
			43522,1,27,1,0
			43522,1,28,1,0
			43522,1,29,1,0
			43522,1,30,1,0
			43522,1,31,1,0
			43522,1,32,1,0
			43520,1,1,1,1000.000
			43520,1,2,1,1000.000
			43520,1,3,1,1000.000
			43520,1,4,1,1000.000
			43520,1,5,1,1000.000
			43520,1,6,1,1000.000
			43520,1,7,1,1000.000
			43520,1,8,1,1000.000
			43520,1,9,1,1000.000
			43520,1,10,1,1000.000
			43520,1,11,1,1000.000
			43520,1,12,1,1000.000
			43520,1,13,1,1000.000
			43520,1,14,1,1000.000
			43520,1,15,1,1000.000
			43520,1,16,1,1000.000
			43520,1,17,1,1000.000
			43520,1,18,1,1000.000
			43520,1,19,1,1000.000
			43520,1,20,1,1000.000
			43520,1,21,1,1000.000
			43520,1,22,1,1000.000
			43520,1,23,1,1000.000
			43520,1,24,1,1000.000
			43520,1,25,1,1000.000
			43520,1,26,1,1000.000
			43520,1,27,1,1000.000
			43520,1,28,1,1000.000
			43520,1,29,1,1000.000
			43520,1,30,1,1000.000
			43520,1,31,1,1000.000
			43520,1,32,1,1000.000
			44816,1,1,1,0
			44816,1,2,1,0
			44816,1,3,1,0
			44816,1,4,1,0
			44816,1,5,1,0
			44816,1,6,1,0
			44816,1,7,1,0
			44816,1,8,1,0
			44816,1,9,1,0
			44816,1,10,1,0
			44816,1,11,1,0
			44816,1,12,1,0
			44816,1,13,1,0
			44816,1,14,1,0
			44816,1,15,1,0
			44816,1,16,1,0
			44816,1,17,1,0
			44816,1,18,1,0
			44816,1,19,1,0
			44816,1,20,1,0
			44816,1,21,1,0
			44816,1,22,1,0
			44816,1,23,1,0
			44816,1,24,1,0
			44816,1,25,1,0
			44816,1,26,1,0
			44816,1,27,1,0
			44816,1,28,1,0
			44816,1,29,1,0
			44816,1,30,1,0
			44816,1,31,1,0
			44816,1,32,1,0
			44819,1,1,1,0.000
			44819,1,2,1,0.000
			44819,1,3,1,0.000
			44819,1,4,1,0.000
			44819,1,5,1,0.000
			44819,1,6,1,0.000
			44819,1,7,1,0.000
			44819,1,8,1,0.000
			44819,1,9,1,0.000
			44819,1,10,1,0.000
			44819,1,11,1,0.000
			44819,1,12,1,0.000
			44819,1,13,1,0.000
			44819,1,14,1,0.000
			44819,1,15,1,0.000
			44819,1,16,1,0.000
			44819,1,17,1,0.000
			44819,1,18,1,0.000
			44819,1,19,1,0.000
			44819,1,20,1,0.000
			44819,1,21,1,0.000
			44819,1,22,1,0.000
			44819,1,23,1,0.000
			44819,1,24,1,0.000
			44819,1,25,1,0.000
			44819,1,26,1,0.000
			44819,1,27,1,0.000
			44819,1,28,1,0.000
			44819,1,29,1,0.000
			44819,1,30,1,0.000
			44819,1,31,1,0.000
			44819,1,32,1,0.000
			44821,1,1,1,1000000.000
			44821,1,2,1,1000000.000
			44821,1,3,1,1000000.000
			44821,1,4,1,1000000.000
			44821,1,5,1,1000000.000
			44821,1,6,1,1000000.000
			44821,1,7,1,1000000.000
			44821,1,8,1,1000000.000
			44821,1,9,1,1000000.000
			44821,1,10,1,1000000.000
			44821,1,11,1,1000000.000
			44821,1,12,1,1000000.000
			44821,1,13,1,1000000.000
			44821,1,14,1,1000000.000
			44821,1,15,1,1000000.000
			44821,1,16,1,1000000.000
			44821,1,17,1,1000000.000
			44821,1,18,1,1000000.000
			44821,1,19,1,1000000.000
			44821,1,20,1,1000000.000
			44821,1,21,1,1000000.000
			44821,1,22,1,1000000.000
			44821,1,23,1,1000000.000
			44821,1,24,1,1000000.000
			44821,1,25,1,1000000.000
			44821,1,26,1,1000000.000
			44821,1,27,1,1000000.000
			44821,1,28,1,1000000.000
			44821,1,29,1,1000000.000
			44821,1,30,1,1000000.000
			44821,1,31,1,1000000.000
			44821,1,32,1,1000000.000
			44817,1,1,1, 10000
			44817,1,2,1, 10000
			44817,1,3,1, 10000
			44817,1,4,1, 10000
			44817,1,5,1, 10000
			44817,1,6,1, 10000
			44817,1,7,1, 10000
			44817,1,8,1, 10000
			44817,1,9,1, 10000
			44817,1,10,1, 10000
			44817,1,11,1, 10000
			44817,1,12,1, 10000
			44817,1,13,1, 10000
			44817,1,14,1, 10000
			44817,1,15,1, 10000
			44817,1,16,1, 10000
			44817,1,17,1, 10000
			44817,1,18,1, 10000
			44817,1,19,1, 10000
			44817,1,20,1, 10000
			44817,1,21,1, 10000
			44817,1,22,1, 10000
			44817,1,23,1, 10000
			44817,1,24,1, 10000
			44817,1,25,1, 10000
			44817,1,26,1, 10000
			44817,1,27,1, 10000
			44817,1,28,1, 10000
			44817,1,29,1, 10000
			44817,1,30,1, 10000
			44817,1,31,1, 10000
			44817,1,32,1, 10000
			54048,1,1,1,1
			54048,1,2,1,1
			54048,1,3,1,1
			54048,1,4,1,1
			54048,1,5,1,1
			54048,1,6,1,1
			54048,1,7,1,1
			54048,1,8,1,1
			54048,1,9,1,1
			54048,1,10,1,1
			54048,1,11,1,1
			54048,1,12,1,1
			54048,1,13,1,1
			54048,1,14,1,1
			54048,1,15,1,1
			54048,1,16,1,1
			54048,1,17,1,1
			54048,1,18,1,1
			54048,1,19,1,1
			54048,1,20,1,1
			54048,1,21,1,1
			54048,1,22,1,1
			54048,1,23,1,1
			54048,1,24,1,1
			54048,1,25,1,1
			54048,1,26,1,1
			54048,1,27,1,1
			54048,1,28,1,1
			54048,1,29,1,1
			54048,1,30,1,1
			54048,1,31,1,1
			54048,1,32,1,1
			54048,1,33,1,1
			54048,1,34,1,1
			54048,1,35,1,1
			54048,1,36,1,1
			54048,1,37,1,1
			54048,1,38,1,1
			54048,1,39,1,1
			54048,1,40,1,1
			54048,1,41,1,1
			54048,1,42,1,1
			54048,1,43,1,1
			54048,1,44,1,1
			54048,1,45,1,1
			54048,1,46,1,1
			54048,1,47,1,1
			54048,1,48,1,1
			54048,1,49,1,1
			54048,1,50,1,1
			54048,1,51,1,1
			54048,1,52,1,1
			54048,1,53,1,1
			54048,1,54,1,1
			54048,1,55,1,1
			54048,1,56,1,1
			54048,1,57,1,1
			54048,1,58,1,1
			54048,1,59,1,1
			54048,1,60,1,1
			54048,1,61,1,1
			54048,1,62,1,1
			54048,1,63,1,1
			54048,1,64,1,1
			46080,1,1,1,  8
			46082,1,1,1,0
			46082,1,1,2,0
			46082,1,1,3,0
			46082,1,1,4,0
			46082,1,1,5,0
			46082,1,1,6,0
			46082,1,1,7,0
			46082,1,1,8,0
			46082,1,1,9,0
			46082,1,1,10,0
			46082,1,1,11,0
			46082,1,1,12,0
			46082,1,1,13,0
			46082,1,1,14,0
			46082,1,1,15,0
			46082,1,1,16,0
			46082,1,1,17,0
			46082,1,1,18,0
			46082,1,1,19,0
			46082,1,1,20,0
			46082,1,1,21,0
			46082,1,1,22,0
			46082,1,1,23,0
			46082,1,1,24,0
			46082,1,1,25,0
			46082,1,1,26,0
			46082,1,1,27,0
			46082,1,1,28,0
			46082,1,1,29,0
			46082,1,1,30,0
			46082,1,1,31,0
			46082,1,1,32,0
			46082,1,1,33,0
			46082,1,1,34,0
			46082,1,1,35,0
			46082,1,1,36,0
			46082,1,1,37,0
			46082,1,1,38,0
			46082,1,1,39,0
			46082,1,1,40,0
			46082,1,1,41,0
			46082,1,1,42,0
			46082,1,1,43,0
			46082,1,1,44,0
			46082,1,1,45,0
			46082,1,1,46,0
			46082,1,1,47,0
			46082,1,1,48,0
			46082,1,1,49,0
			46082,1,1,50,0
			46082,1,1,51,0
			46082,1,1,52,0
			46082,1,1,53,0
			46082,1,1,54,0
			46082,1,1,55,0
			46082,1,1,56,0
			46082,1,1,57,0
			46082,1,1,58,0
			46082,1,1,59,0
			46082,1,1,60,0
			46082,1,1,61,0
			46082,1,1,62,0
			46082,1,1,63,0
			46082,1,1,64,0
			46082,1,1,65,0
			46082,1,1,66,0
			46082,1,1,67,0
			46082,1,1,68,0
			46082,1,1,69,0
			46082,1,1,70,0
			46082,1,1,71,0
			46082,1,1,72,0
			46082,1,1,73,0
			46082,1,1,74,0
			46082,1,1,75,0
			46082,1,1,76,0
			46082,1,1,77,0
			46082,1,1,78,0
			46082,1,1,79,0
			46082,1,1,80,0
			46082,1,1,81,0
			46082,1,1,82,0
			46082,1,1,83,0
			46082,1,1,84,0
			46082,1,1,85,0
			46082,1,1,86,0
			46082,1,1,87,0
			46082,1,1,88,0
			46082,1,1,89,0
			46082,1,1,90,0
			46082,1,1,91,0
			46082,1,1,92,0
			46082,1,1,93,0
			46082,1,1,94,0
			46082,1,1,95,0
			46082,1,1,96,0
			46082,1,1,97,0
			46082,1,1,98,0
			46082,1,1,99,0
			46082,1,1,100,0
			46082,1,1,101,0
			46082,1,1,102,0
			46082,1,1,103,0
			46082,1,1,104,0
			46082,1,1,105,0
			46082,1,1,106,0
			46082,1,1,107,0
			46082,1,1,108,0
			46082,1,1,109,0
			46082,1,1,110,0
			46082,1,1,111,0
			46082,1,1,112,0
			46082,1,1,113,0
			46082,1,1,114,0
			46082,1,1,115,0
			46082,1,1,116,0
			46082,1,1,117,0
			46082,1,1,118,0
			46082,1,1,119,0
			46082,1,1,120,0
			46082,1,1,121,0
			46082,1,1,122,0
			46082,1,1,123,0
			46082,1,1,124,0
			46082,1,1,125,0
			46082,1,1,126,0
			46082,1,1,127,0
			46082,1,1,128,0
			47360,1,1,1,0
			47360,1,1,2,0
			47360,1,1,3,0
			47360,1,1,4,0
			47360,1,1,5,0
			47360,1,1,6,0
			47360,1,1,7,0
			47360,1,1,8,0
			47360,1,1,9,0
			47360,1,1,10,0
			47360,1,1,11,0
			47360,1,1,12,0
			47360,1,1,13,0
			47360,1,1,14,0
			47360,1,1,15,0
			47360,1,1,16,0
			47360,1,1,17,0
			47360,1,1,18,0
			47360,1,1,19,0
			47360,1,1,20,0
			47360,1,1,21,0
			47360,1,1,22,0
			47360,1,1,23,0
			47360,1,1,24,0
			47360,1,1,25,0
			47360,1,1,26,0
			47360,1,1,27,0
			47360,1,1,28,0
			47360,1,1,29,0
			47360,1,1,30,0
			47360,1,1,31,0
			47360,1,1,32,0
			47360,1,2,1,0
			47360,1,2,2,0
			47360,1,2,3,0
			47360,1,2,4,0
			47360,1,2,5,0
			47360,1,2,6,0
			47360,1,2,7,0
			47360,1,2,8,0
			47360,1,2,9,0
			47360,1,2,10,0
			47360,1,2,11,0
			47360,1,2,12,0
			47360,1,2,13,0
			47360,1,2,14,0
			47360,1,2,15,0
			47360,1,2,16,0
			47360,1,2,17,0
			47360,1,2,18,0
			47360,1,2,19,0
			47360,1,2,20,0
			47360,1,2,21,0
			47360,1,2,22,0
			47360,1,2,23,0
			47360,1,2,24,0
			47360,1,2,25,0
			47360,1,2,26,0
			47360,1,2,27,0
			47360,1,2,28,0
			47360,1,2,29,0
			47360,1,2,30,0
			47360,1,2,31,0
			47360,1,2,32,0
			47360,1,3,1,0
			47360,1,3,2,0
			47360,1,3,3,0
			47360,1,3,4,0
			47360,1,3,5,0
			47360,1,3,6,0
			47360,1,3,7,0
			47360,1,3,8,0
			47360,1,3,9,0
			47360,1,3,10,0
			47360,1,3,11,0
			47360,1,3,12,0
			47360,1,3,13,0
			47360,1,3,14,0
			47360,1,3,15,0
			47360,1,3,16,0
			47360,1,3,17,0
			47360,1,3,18,0
			47360,1,3,19,0
			47360,1,3,20,0
			47360,1,3,21,0
			47360,1,3,22,0
			47360,1,3,23,0
			47360,1,3,24,0
			47360,1,3,25,0
			47360,1,3,26,0
			47360,1,3,27,0
			47360,1,3,28,0
			47360,1,3,29,0
			47360,1,3,30,0
			47360,1,3,31,0
			47360,1,3,32,0
			47360,1,4,1,0
			47360,1,4,2,0
			47360,1,4,3,0
			47360,1,4,4,0
			47360,1,4,5,0
			47360,1,4,6,0
			47360,1,4,7,0
			47360,1,4,8,0
			47360,1,4,9,0
			47360,1,4,10,0
			47360,1,4,11,0
			47360,1,4,12,0
			47360,1,4,13,0
			47360,1,4,14,0
			47360,1,4,15,0
			47360,1,4,16,0
			47360,1,4,17,0
			47360,1,4,18,0
			47360,1,4,19,0
			47360,1,4,20,0
			47360,1,4,21,0
			47360,1,4,22,0
			47360,1,4,23,0
			47360,1,4,24,0
			47360,1,4,25,0
			47360,1,4,26,0
			47360,1,4,27,0
			47360,1,4,28,0
			47360,1,4,29,0
			47360,1,4,30,0
			47360,1,4,31,0
			47360,1,4,32,0
			47360,1,5,1,0
			47360,1,5,2,0
			47360,1,5,3,0
			47360,1,5,4,0
			47360,1,5,5,0
			47360,1,5,6,0
			47360,1,5,7,0
			47360,1,5,8,0
			47360,1,5,9,0
			47360,1,5,10,0
			47360,1,5,11,0
			47360,1,5,12,0
			47360,1,5,13,0
			47360,1,5,14,0
			47360,1,5,15,0
			47360,1,5,16,0
			47360,1,5,17,0
			47360,1,5,18,0
			47360,1,5,19,0
			47360,1,5,20,0
			47360,1,5,21,0
			47360,1,5,22,0
			47360,1,5,23,0
			47360,1,5,24,0
			47360,1,5,25,0
			47360,1,5,26,0
			47360,1,5,27,0
			47360,1,5,28,0
			47360,1,5,29,0
			47360,1,5,30,0
			47360,1,5,31,0
			47360,1,5,32,0
			47360,1,6,1,0
			47360,1,6,2,0
			47360,1,6,3,0
			47360,1,6,4,0
			47360,1,6,5,0
			47360,1,6,6,0
			47360,1,6,7,0
			47360,1,6,8,0
			47360,1,6,9,0
			47360,1,6,10,0
			47360,1,6,11,0
			47360,1,6,12,0
			47360,1,6,13,0
			47360,1,6,14,0
			47360,1,6,15,0
			47360,1,6,16,0
			47360,1,6,17,0
			47360,1,6,18,0
			47360,1,6,19,0
			47360,1,6,20,0
			47360,1,6,21,0
			47360,1,6,22,0
			47360,1,6,23,0
			47360,1,6,24,0
			47360,1,6,25,0
			47360,1,6,26,0
			47360,1,6,27,0
			47360,1,6,28,0
			47360,1,6,29,0
			47360,1,6,30,0
			47360,1,6,31,0
			47360,1,6,32,0
			47360,1,7,1,0
			47360,1,7,2,0
			47360,1,7,3,0
			47360,1,7,4,0
			47360,1,7,5,0
			47360,1,7,6,0
			47360,1,7,7,0
			47360,1,7,8,0
			47360,1,7,9,0
			47360,1,7,10,0
			47360,1,7,11,0
			47360,1,7,12,0
			47360,1,7,13,0
			47360,1,7,14,0
			47360,1,7,15,0
			47360,1,7,16,0
			47360,1,7,17,0
			47360,1,7,18,0
			47360,1,7,19,0
			47360,1,7,20,0
			47360,1,7,21,0
			47360,1,7,22,0
			47360,1,7,23,0
			47360,1,7,24,0
			47360,1,7,25,0
			47360,1,7,26,0
			47360,1,7,27,0
			47360,1,7,28,0
			47360,1,7,29,0
			47360,1,7,30,0
			47360,1,7,31,0
			47360,1,7,32,0
			47360,1,8,1,0
			47360,1,8,2,0
			47360,1,8,3,0
			47360,1,8,4,0
			47360,1,8,5,0
			47360,1,8,6,0
			47360,1,8,7,0
			47360,1,8,8,0
			47360,1,8,9,0
			47360,1,8,10,0
			47360,1,8,11,0
			47360,1,8,12,0
			47360,1,8,13,0
			47360,1,8,14,0
			47360,1,8,15,0
			47360,1,8,16,0
			47360,1,8,17,0
			47360,1,8,18,0
			47360,1,8,19,0
			47360,1,8,20,0
			47360,1,8,21,0
			47360,1,8,22,0
			47360,1,8,23,0
			47360,1,8,24,0
			47360,1,8,25,0
			47360,1,8,26,0
			47360,1,8,27,0
			47360,1,8,28,0
			47360,1,8,29,0
			47360,1,8,30,0
			47360,1,8,31,0
			47360,1,8,32,0
			47360,1,9,1,0
			47360,1,9,2,0
			47360,1,9,3,0
			47360,1,9,4,0
			47360,1,9,5,0
			47360,1,9,6,0
			47360,1,9,7,0
			47360,1,9,8,0
			47360,1,9,9,0
			47360,1,9,10,0
			47360,1,9,11,0
			47360,1,9,12,0
			47360,1,9,13,0
			47360,1,9,14,0
			47360,1,9,15,0
			47360,1,9,16,0
			47360,1,9,17,0
			47360,1,9,18,0
			47360,1,9,19,0
			47360,1,9,20,0
			47360,1,9,21,0
			47360,1,9,22,0
			47360,1,9,23,0
			47360,1,9,24,0
			47360,1,9,25,0
			47360,1,9,26,0
			47360,1,9,27,0
			47360,1,9,28,0
			47360,1,9,29,0
			47360,1,9,30,0
			47360,1,9,31,0
			47360,1,9,32,0
			47360,1,10,1,0
			47360,1,10,2,0
			47360,1,10,3,0
			47360,1,10,4,0
			47360,1,10,5,0
			47360,1,10,6,0
			47360,1,10,7,0
			47360,1,10,8,0
			47360,1,10,9,0
			47360,1,10,10,0
			47360,1,10,11,0
			47360,1,10,12,0
			47360,1,10,13,0
			47360,1,10,14,0
			47360,1,10,15,0
			47360,1,10,16,0
			47360,1,10,17,0
			47360,1,10,18,0
			47360,1,10,19,0
			47360,1,10,20,0
			47360,1,10,21,0
			47360,1,10,22,0
			47360,1,10,23,0
			47360,1,10,24,0
			47360,1,10,25,0
			47360,1,10,26,0
			47360,1,10,27,0
			47360,1,10,28,0
			47360,1,10,29,0
			47360,1,10,30,0
			47360,1,10,31,0
			47360,1,10,32,0
			47360,1,11,1,0
			47360,1,11,2,0
			47360,1,11,3,0
			47360,1,11,4,0
			47360,1,11,5,0
			47360,1,11,6,0
			47360,1,11,7,0
			47360,1,11,8,0
			47360,1,11,9,0
			47360,1,11,10,0
			47360,1,11,11,0
			47360,1,11,12,0
			47360,1,11,13,0
			47360,1,11,14,0
			47360,1,11,15,0
			47360,1,11,16,0
			47360,1,11,17,0
			47360,1,11,18,0
			47360,1,11,19,0
			47360,1,11,20,0
			47360,1,11,21,0
			47360,1,11,22,0
			47360,1,11,23,0
			47360,1,11,24,0
			47360,1,11,25,0
			47360,1,11,26,0
			47360,1,11,27,0
			47360,1,11,28,0
			47360,1,11,29,0
			47360,1,11,30,0
			47360,1,11,31,0
			47360,1,11,32,0
			47360,1,12,1,0
			47360,1,12,2,0
			47360,1,12,3,0
			47360,1,12,4,0
			47360,1,12,5,0
			47360,1,12,6,0
			47360,1,12,7,0
			47360,1,12,8,0
			47360,1,12,9,0
			47360,1,12,10,0
			47360,1,12,11,0
			47360,1,12,12,0
			47360,1,12,13,0
			47360,1,12,14,0
			47360,1,12,15,0
			47360,1,12,16,0
			47360,1,12,17,0
			47360,1,12,18,0
			47360,1,12,19,0
			47360,1,12,20,0
			47360,1,12,21,0
			47360,1,12,22,0
			47360,1,12,23,0
			47360,1,12,24,0
			47360,1,12,25,0
			47360,1,12,26,0
			47360,1,12,27,0
			47360,1,12,28,0
			47360,1,12,29,0
			47360,1,12,30,0
			47360,1,12,31,0
			47360,1,12,32,0
			47360,1,13,1,0
			47360,1,13,2,0
			47360,1,13,3,0
			47360,1,13,4,0
			47360,1,13,5,0
			47360,1,13,6,0
			47360,1,13,7,0
			47360,1,13,8,0
			47360,1,13,9,0
			47360,1,13,10,0
			47360,1,13,11,0
			47360,1,13,12,0
			47360,1,13,13,0
			47360,1,13,14,0
			47360,1,13,15,0
			47360,1,13,16,0
			47360,1,13,17,0
			47360,1,13,18,0
			47360,1,13,19,0
			47360,1,13,20,0
			47360,1,13,21,0
			47360,1,13,22,0
			47360,1,13,23,0
			47360,1,13,24,0
			47360,1,13,25,0
			47360,1,13,26,0
			47360,1,13,27,0
			47360,1,13,28,0
			47360,1,13,29,0
			47360,1,13,30,0
			47360,1,13,31,0
			47360,1,13,32,0
			47360,1,14,1,0
			47360,1,14,2,0
			47360,1,14,3,0
			47360,1,14,4,0
			47360,1,14,5,0
			47360,1,14,6,0
			47360,1,14,7,0
			47360,1,14,8,0
			47360,1,14,9,0
			47360,1,14,10,0
			47360,1,14,11,0
			47360,1,14,12,0
			47360,1,14,13,0
			47360,1,14,14,0
			47360,1,14,15,0
			47360,1,14,16,0
			47360,1,14,17,0
			47360,1,14,18,0
			47360,1,14,19,0
			47360,1,14,20,0
			47360,1,14,21,0
			47360,1,14,22,0
			47360,1,14,23,0
			47360,1,14,24,0
			47360,1,14,25,0
			47360,1,14,26,0
			47360,1,14,27,0
			47360,1,14,28,0
			47360,1,14,29,0
			47360,1,14,30,0
			47360,1,14,31,0
			47360,1,14,32,0
			47360,1,15,1,0
			47360,1,15,2,0
			47360,1,15,3,0
			47360,1,15,4,0
			47360,1,15,5,0
			47360,1,15,6,0
			47360,1,15,7,0
			47360,1,15,8,0
			47360,1,15,9,0
			47360,1,15,10,0
			47360,1,15,11,0
			47360,1,15,12,0
			47360,1,15,13,0
			47360,1,15,14,0
			47360,1,15,15,0
			47360,1,15,16,0
			47360,1,15,17,0
			47360,1,15,18,0
			47360,1,15,19,0
			47360,1,15,20,0
			47360,1,15,21,0
			47360,1,15,22,0
			47360,1,15,23,0
			47360,1,15,24,0
			47360,1,15,25,0
			47360,1,15,26,0
			47360,1,15,27,0
			47360,1,15,28,0
			47360,1,15,29,0
			47360,1,15,30,0
			47360,1,15,31,0
			47360,1,15,32,0
			47360,1,16,1,0
			47360,1,16,2,0
			47360,1,16,3,0
			47360,1,16,4,0
			47360,1,16,5,0
			47360,1,16,6,0
			47360,1,16,7,0
			47360,1,16,8,0
			47360,1,16,9,0
			47360,1,16,10,0
			47360,1,16,11,0
			47360,1,16,12,0
			47360,1,16,13,0
			47360,1,16,14,0
			47360,1,16,15,0
			47360,1,16,16,0
			47360,1,16,17,0
			47360,1,16,18,0
			47360,1,16,19,0
			47360,1,16,20,0
			47360,1,16,21,0
			47360,1,16,22,0
			47360,1,16,23,0
			47360,1,16,24,0
			47360,1,16,25,0
			47360,1,16,26,0
			47360,1,16,27,0
			47360,1,16,28,0
			47360,1,16,29,0
			47360,1,16,30,0
			47360,1,16,31,0
			47360,1,16,32,0
			23817,1,1,1,0
			23817,2,1,1,0
			23817,3,1,1,0
			23817,4,1,1,0
			23817,5,1,1,0
			23817,6,1,1,0
			23817,1,2,1,0
			23817,2,2,1,0
			23817,3,2,1,0
			23817,4,2,1,0
			23817,5,2,1,0
			23817,6,2,1,0
			23809,1,1,1,0
			23809,2,1,1,0
			23809,3,1,1,0
			23809,4,1,1,0
			23809,5,1,1,0
			23809,6,1,1,0
			23809,1,2,1,0
			23809,2,2,1,0
			23809,3,2,1,0
			23809,4,2,1,0
			23809,5,2,1,0
			23809,6,2,1,0
			23814,1,1,1,0
			23814,2,1,1,0
			23814,3,1,1,0
			23814,4,1,1,0
			23814,5,1,1,0
			23814,6,1,1,0
			23814,1,2,1,0
			23814,2,2,1,0
			23814,3,2,1,0
			23814,4,2,1,0
			23814,5,2,1,0
			23814,6,2,1,0
			23811,1,1,1, 1.000
			23811,2,1,1, 1.000
			23811,3,1,1, 1.000
			23811,4,1,1, 1.000
			23811,5,1,1, 1.000
			23811,6,1,1, 1.000
			23811,1,2,1, 1.000
			23811,2,2,1, 1.000
			23811,3,2,1, 1.000
			23811,4,2,1, 1.000
			23811,5,2,1, 1.000
			23811,6,2,1, 1.000
			23813,1,1,1,  1.00
			23813,2,1,1,  1.00
			23813,3,1,1,  1.00
			23813,4,1,1,  1.00
			23813,5,1,1,  1.00
			23813,6,1,1,  1.00
			23813,1,2,1,  1.00
			23813,2,2,1,  1.00
			23813,3,2,1,  1.00
			23813,4,2,1,  1.00
			23813,5,2,1,  1.00
			23813,6,2,1,  1.00
			23810,1,1,1,0
			23810,2,1,1,0
			23810,3,1,1,0
			23810,4,1,1,0
			23810,5,1,1,0
			23810,6,1,1,0
			23810,1,2,1,0
			23810,2,2,1,0
			23810,3,2,1,0
			23810,4,2,1,0
			23810,5,2,1,0
			23810,6,2,1,0
			23808,1,1,1,0
			23808,2,1,1,0
			23808,3,1,1,0
			23808,4,1,1,0
			23808,5,1,1,0
			23808,6,1,1,0
			23808,1,2,1,0
			23808,2,2,1,0
			23808,3,2,1,0
			23808,4,2,1,0
			23808,5,2,1,0
			23808,6,2,1,0
			23818,1,1,1,0
			23818,2,1,1,0
			23818,3,1,1,0
			23818,4,1,1,0
			23818,5,1,1,0
			23818,6,1,1,0
			23818,1,2,1,0
			23818,2,2,1,0
			23818,3,2,1,0
			23818,4,2,1,0
			23818,5,2,1,0
			23818,6,2,1,0
			23812,1,1,1,0
			23812,2,1,1,0
			23812,3,1,1,0
			23812,4,1,1,0
			23812,5,1,1,0
			23812,6,1,1,0
			23812,1,2,1,0
			23812,2,2,1,0
			23812,3,2,1,0
			23812,4,2,1,0
			23812,5,2,1,0
			23812,6,2,1,0
			23815,1,1,1,0
			23815,2,1,1,0
			23815,3,1,1,0
			23815,4,1,1,0
			23815,5,1,1,0
			23815,6,1,1,0
			23815,1,2,1,0
			23815,2,2,1,0
			23815,3,2,1,0
			23815,4,2,1,0
			23815,5,2,1,0
			23815,6,2,1,0
			23975,1,1,1,0
			23975,2,1,1,0
			23975,3,1,1,0
			23975,4,1,1,0
			23975,5,1,1,0
			23975,6,1,1,0
			23975,1,2,1,0
			23975,2,2,1,0
			23975,3,2,1,0
			23975,4,2,1,0
			23975,5,2,1,0
			23975,6,2,1,0
			23975,1,3,1,0
			23975,2,3,1,0
			23975,3,3,1,0
			23975,4,3,1,0
			23975,5,3,1,0
			23975,6,3,1,0
			23975,1,4,1,0
			23975,2,4,1,0
			23975,3,4,1,0
			23975,4,4,1,0
			23975,5,4,1,0
			23975,6,4,1,0
			23969,1,1,1,0
			23969,2,1,1,0
			23969,3,1,1,0
			23969,4,1,1,0
			23969,5,1,1,0
			23969,6,1,1,0
			23969,1,2,1,0
			23969,2,2,1,0
			23969,3,2,1,0
			23969,4,2,1,0
			23969,5,2,1,0
			23969,6,2,1,0
			23969,1,3,1,0
			23969,2,3,1,0
			23969,3,3,1,0
			23969,4,3,1,0
			23969,5,3,1,0
			23969,6,3,1,0
			23969,1,4,1,0
			23969,2,4,1,0
			23969,3,4,1,0
			23969,4,4,1,0
			23969,5,4,1,0
			23969,6,4,1,0
			23972,1,1,1,  0.00
			23972,2,1,1,  0.00
			23972,3,1,1,  0.00
			23972,4,1,1,  0.00
			23972,5,1,1,  0.00
			23972,6,1,1,  0.00
			23972,1,2,1,  0.00
			23972,2,2,1,  0.00
			23972,3,2,1,  0.00
			23972,4,2,1,  0.00
			23972,5,2,1,  0.00
			23972,6,2,1,  0.00
			23972,1,3,1,  0.00
			23972,2,3,1,  0.00
			23972,3,3,1,  0.00
			23972,4,3,1,  0.00
			23972,5,3,1,  0.00
			23972,6,3,1,  0.00
			23972,1,4,1,  0.00
			23972,2,4,1,  0.00
			23972,3,4,1,  0.00
			23972,4,4,1,  0.00
			23972,5,4,1,  0.00
			23972,6,4,1,  0.00
			23970,1,1,1, 1.000
			23970,2,1,1, 1.000
			23970,3,1,1, 1.000
			23970,4,1,1, 1.000
			23970,5,1,1, 1.000
			23970,6,1,1, 1.000
			23970,1,2,1, 1.000
			23970,2,2,1, 1.000
			23970,3,2,1, 1.000
			23970,4,2,1, 1.000
			23970,5,2,1, 1.000
			23970,6,2,1, 1.000
			23970,1,3,1, 1.000
			23970,2,3,1, 1.000
			23970,3,3,1, 1.000
			23970,4,3,1, 1.000
			23970,5,3,1, 1.000
			23970,6,3,1, 1.000
			23970,1,4,1, 1.000
			23970,2,4,1, 1.000
			23970,3,4,1, 1.000
			23970,4,4,1, 1.000
			23970,5,4,1, 1.000
			23970,6,4,1, 1.000
			23968,1,1,1,0
			23968,2,1,1,0
			23968,3,1,1,0
			23968,4,1,1,0
			23968,5,1,1,0
			23968,6,1,1,0
			23968,1,2,1,0
			23968,2,2,1,0
			23968,3,2,1,0
			23968,4,2,1,0
			23968,5,2,1,0
			23968,6,2,1,0
			23968,1,3,1,0
			23968,2,3,1,0
			23968,3,3,1,0
			23968,4,3,1,0
			23968,5,3,1,0
			23968,6,3,1,0
			23968,1,4,1,0
			23968,2,4,1,0
			23968,3,4,1,0
			23968,4,4,1,0
			23968,5,4,1,0
			23968,6,4,1,0
			23976,1,1,1,0
			23976,2,1,1,0
			23976,3,1,1,0
			23976,4,1,1,0
			23976,5,1,1,0
			23976,6,1,1,0
			23976,1,2,1,0
			23976,2,2,1,0
			23976,3,2,1,0
			23976,4,2,1,0
			23976,5,2,1,0
			23976,6,2,1,0
			23976,1,3,1,0
			23976,2,3,1,0
			23976,3,3,1,0
			23976,4,3,1,0
			23976,5,3,1,0
			23976,6,3,1,0
			23976,1,4,1,0
			23976,2,4,1,0
			23976,3,4,1,0
			23976,4,4,1,0
			23976,5,4,1,0
			23976,6,4,1,0
			23971,1,1,1,  0.00
			23971,2,1,1,  0.00
			23971,3,1,1,  0.00
			23971,4,1,1,  0.00
			23971,5,1,1,  0.00
			23971,6,1,1,  0.00
			23971,1,2,1,  0.00
			23971,2,2,1,  0.00
			23971,3,2,1,  0.00
			23971,4,2,1,  0.00
			23971,5,2,1,  0.00
			23971,6,2,1,  0.00
			23971,1,3,1,  0.00
			23971,2,3,1,  0.00
			23971,3,3,1,  0.00
			23971,4,3,1,  0.00
			23971,5,3,1,  0.00
			23971,6,3,1,  0.00
			23971,1,4,1,  0.00
			23971,2,4,1,  0.00
			23971,3,4,1,  0.00
			23971,4,4,1,  0.00
			23971,5,4,1,  0.00
			23971,6,4,1,  0.00
			23973,1,1,1,0
			23973,2,1,1,0
			23973,3,1,1,0
			23973,4,1,1,0
			23973,5,1,1,0
			23973,6,1,1,0
			23973,1,2,1,0
			23973,2,2,1,0
			23973,3,2,1,0
			23973,4,2,1,0
			23973,5,2,1,0
			23973,6,2,1,0
			23973,1,3,1,0
			23973,2,3,1,0
			23973,3,3,1,0
			23973,4,3,1,0
			23973,5,3,1,0
			23973,6,3,1,0
			23973,1,4,1,0
			23973,2,4,1,0
			23973,3,4,1,0
			23973,4,4,1,0
			23973,5,4,1,0
			23973,6,4,1,0
			34816,1,1,1,0
			34816,1,1,2,0
			34816,1,1,3,0
			34816,1,1,4,0
			34816,1,1,5,0
			34816,1,1,6,0
			34816,1,1,7,0
			34816,1,1,8,0
			34816,1,1,9,0
			34816,1,1,10,0
			34816,1,1,11,0
			34816,1,1,12,0
			34816,1,1,13,0
			34816,1,1,14,0
			34816,1,1,15,0
			34816,1,1,16,0
			34816,1,1,17,0
			34816,1,1,18,0
			34816,1,1,19,0
			34816,1,1,20,0
			34816,1,1,21,0
			34816,1,1,22,0
			34816,1,1,23,0
			34816,1,1,24,0
			34816,1,1,25,0
			34816,1,1,26,0
			34816,1,1,27,0
			34816,1,1,28,0
			34816,1,1,29,0
			34816,1,1,30,0
			34816,1,1,31,0
			34816,1,1,32,0
			34816,1,1,33,0
			34816,1,1,34,0
			34816,1,1,35,0
			34816,1,1,36,0
			34816,1,1,37,0
			34816,1,1,38,0
			34816,1,1,39,0
			34816,1,1,40,0
			34816,1,1,41,0
			34816,1,1,42,0
			34816,1,1,43,0
			34816,1,1,44,0
			34816,1,1,45,0
			34816,1,1,46,0
			34816,1,1,47,0
			34816,1,1,48,0
			34816,1,1,49,0
			34816,1,1,50,0
			34816,1,1,51,0
			34816,1,1,52,0
			34816,1,1,53,0
			34816,1,1,54,0
			34816,1,1,55,0
			34816,1,1,56,0
			34816,1,1,57,0
			34816,1,1,58,0
			34816,1,1,59,0
			34816,1,1,60,0
			34816,1,1,61,0
			34816,1,1,62,0
			34816,1,1,63,0
			34816,1,1,64,0
			34816,1,1,65,0
			34816,1,1,66,0
			34816,1,1,67,0
			34816,1,1,68,0
			34816,1,1,69,0
			34816,1,1,70,0
			34816,1,1,71,0
			34816,1,1,72,0
			34816,1,1,73,0
			34816,1,1,74,0
			34816,1,1,75,0
			34816,1,1,76,0
			34816,1,1,77,0
			34816,1,1,78,0
			34816,1,1,79,0
			34816,1,1,80,0
			34816,1,1,81,0
			34816,1,1,82,0
			34816,1,1,83,0
			34816,1,1,84,0
			34816,1,1,85,0
			34816,1,1,86,0
			34816,1,1,87,0
			34816,1,1,88,0
			34816,1,1,89,0
			34816,1,1,90,0
			34816,1,1,91,0
			34816,1,1,92,0
			34816,1,1,93,0
			34816,1,1,94,0
			34816,1,1,95,0
			34816,1,1,96,0
			34816,1,1,97,0
			34816,1,1,98,0
			34816,1,1,99,0
			34816,1,1,100,0
			34816,1,1,101,0
			34816,1,1,102,0
			34816,1,1,103,0
			34816,1,1,104,0
			34816,1,1,105,0
			34816,1,1,106,0
			34816,1,1,107,0
			34816,1,1,108,0
			34816,1,1,109,0
			34816,1,1,110,0
			34816,1,1,111,0
			34816,1,1,112,0
			34816,1,1,113,0
			34816,1,1,114,0
			34816,1,1,115,0
			34816,1,1,116,0
			34816,1,1,117,0
			34816,1,1,118,0
			34816,1,1,119,0
			34816,1,1,120,0
			34816,1,1,121,0
			34816,1,1,122,0
			34816,1,1,123,0
			34816,1,1,124,0
			34816,1,1,125,0
			34816,1,1,126,0
			34816,1,1,127,0
			34816,1,1,128,0
			34816,1,1,129,0
			34816,1,1,130,0
			34816,1,1,131,0
			34816,1,1,132,0
			34816,1,1,133,0
			34816,1,1,134,0
			34816,1,1,135,0
			34816,1,1,136,0
			34816,1,1,137,0
			34816,1,1,138,0
			34816,1,1,139,0
			34816,1,1,140,0
			34816,1,1,141,0
			34816,1,1,142,0
			34816,1,1,143,0
			34816,1,1,144,0
			34816,1,1,145,0
			34816,1,1,146,0
			34816,1,1,147,0
			34816,1,1,148,0
			34816,1,1,149,0
			34816,1,1,150,0
			34816,1,1,151,0
			34816,1,1,152,0
			34816,1,1,153,0
			34816,1,1,154,0
			34816,1,1,155,0
			34816,1,1,156,0
			34816,1,1,157,0
			34816,1,1,158,0
			34816,1,1,159,0
			34816,1,1,160,0
			34816,1,1,161,0
			34816,1,1,162,0
			34816,1,1,163,0
			34816,1,1,164,0
			34816,1,1,165,0
			34816,1,1,166,0
			34816,1,1,167,0
			34816,1,1,168,0
			34816,1,1,169,0
			34816,1,1,170,0
			34816,1,1,171,0
			34816,1,1,172,0
			34816,1,1,173,0
			34816,1,1,174,0
			34816,1,1,175,0
			34816,1,1,176,0
			34816,1,1,177,0
			34816,1,1,178,0
			34816,1,1,179,0
			34816,1,1,180,0
			34816,1,1,181,0
			34816,1,1,182,0
			34816,1,1,183,0
			34816,1,1,184,0
			34816,1,1,185,0
			34816,1,1,186,0
			34816,1,1,187,0
			34816,1,1,188,0
			34816,1,1,189,0
			34816,1,1,190,0
			34816,1,1,191,0
			34816,1,1,192,0
			34816,1,1,193,0
			34816,1,1,194,0
			34816,1,1,195,0
			34816,1,1,196,0
			34816,1,1,197,0
			34816,1,1,198,0
			34816,1,1,199,0
			34816,1,1,200,0
			34816,1,1,201,0
			34816,1,1,202,0
			34816,1,1,203,0
			34816,1,1,204,0
			34816,1,1,205,0
			34816,1,1,206,0
			34816,1,1,207,0
			34816,1,1,208,0
			34816,1,1,209,0
			34816,1,1,210,0
			34816,1,1,211,0
			34816,1,1,212,0
			34816,1,1,213,0
			34816,1,1,214,0
			34816,1,1,215,0
			34816,1,1,216,0
			34816,1,1,217,0
			34816,1,1,218,0
			34816,1,1,219,0
			34816,1,1,220,0
			34816,1,1,221,0
			34816,1,1,222,0
			34816,1,1,223,0
			34816,1,1,224,0
			34816,1,1,225,0
			34816,1,1,226,0
			34816,1,1,227,0
			34816,1,1,228,0
			34816,1,1,229,0
			34816,1,1,230,0
			34816,1,1,231,0
			34816,1,1,232,0
			34816,1,1,233,0
			34816,1,1,234,0
			34816,1,1,235,0
			34816,1,1,236,0
			34816,1,1,237,0
			34816,1,1,238,0
			34816,1,1,239,0
			34816,1,1,240,0
			34816,1,1,241,0
			34816,1,1,242,0
			34816,1,1,243,0
			34816,1,1,244,0
			34816,1,1,245,0
			34816,1,1,246,0
			34816,1,1,247,0
			34816,1,1,248,0
			34816,1,1,249,0
			34816,1,1,250,0
			34816,1,1,251,0
			34816,1,1,252,0
			34816,1,1,253,0
			34816,1,1,254,0
			34816,1,1,255,0
			34816,1,1,256,0
			22528,1,1,1,0
			22528,1,2,1,0
			22528,1,3,1,0
			22528,1,4,1,0
			22528,1,5,1,0
			22528,1,6,1,0
			22528,1,7,1,0
			22528,1,8,1,0
			22528,1,9,1,0
			22528,1,10,1,0
			22528,1,11,1,0
			22528,1,12,1,0
			22528,1,13,1,0
			22528,1,14,1,0
			22528,1,15,1,0
			22528,1,16,1,0
			22528,1,17,1,0
			22528,1,18,1,0
			22528,1,19,1,0
			22528,1,20,1,0
			22528,1,21,1,0
			22528,1,22,1,0
			22528,1,23,1,0
			22528,1,24,1,0
			22528,1,25,1,0
			22528,1,26,1,0
			22528,1,27,1,0
			22528,1,28,1,0
			22528,1,29,1,0
			22528,1,30,1,0
			22528,1,31,1,0
			22528,1,32,1,0
			22529,1,1,1,    0
			22529,1,2,1,    0
			22529,1,3,1,    0
			22529,1,4,1,    0
			22529,1,5,1,    0
			22529,1,6,1,    0
			22529,1,7,1,    0
			22529,1,8,1,    0
			22529,1,9,1,    0
			22529,1,10,1,    0
			22529,1,11,1,    0
			22529,1,12,1,    0
			22529,1,13,1,    0
			22529,1,14,1,    0
			22529,1,15,1,    0
			22529,1,16,1,    0
			22529,1,17,1,    0
			22529,1,18,1,    0
			22529,1,19,1,    0
			22529,1,20,1,    0
			22529,1,21,1,    0
			22529,1,22,1,    0
			22529,1,23,1,    0
			22529,1,24,1,    0
			22529,1,25,1,    0
			22529,1,26,1,    0
			22529,1,27,1,    0
			22529,1,28,1,    0
			22529,1,29,1,    0
			22529,1,30,1,    0
			22529,1,31,1,    0
			22529,1,32,1,    0
			22530,1,1,1,    0
			22530,1,2,1,    0
			22530,1,3,1,    0
			22530,1,4,1,    0
			22530,1,5,1,    0
			22530,1,6,1,    0
			22530,1,7,1,    0
			22530,1,8,1,    0
			22530,1,9,1,    0
			22530,1,10,1,    0
			22530,1,11,1,    0
			22530,1,12,1,    0
			22530,1,13,1,    0
			22530,1,14,1,    0
			22530,1,15,1,    0
			22530,1,16,1, 